/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.net.SocketFactory;

public class LdapSSLSocketFactory
extends SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(LdapSSLSocketFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static final LdapSSLSocketFactory defaultFactory = new LdapSSLSocketFactory();

    private LdapSSLSocketFactory() {
        try {
            Properties ldapProperties = SecurityObjectLocator.getSecurityConfig().getUserRegistry("LDAP").getProperties();
            final String LdapSslAlias = (String)ldapProperties.get("security.registry.ldap.SSLAlias");
            String host = (String)ldapProperties.get("com.ibm.ssl.remoteHost");
            String port = (String)ldapProperties.get("com.ibm.ssl.remotePort");
            final HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.endPointName", "LDAP");
            if (host != null && !host.equals("")) {
                connectionInfo.put("com.ibm.ssl.remoteHost", host);
            }
            if (port != null && !port.equals("")) {
                connectionInfo.put("com.ibm.ssl.remotePort", port);
            }
            try {
                this.props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(LdapSslAlias, connectionInfo, null);
                    }
                });
                this.default_constructor = false;
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapSSLSocketFactory.<init>", "68", (Object)this);
            Tr.error(tc, "security.registry.ldap.initerror", e.getMessage());
        }
    }

    public static SocketFactory getDefault() {
        return defaultFactory;
    }

    public static Properties getDefaultConfig() {
        return defaultFactory.getConfig();
    }

    public Properties getConfig() {
        return this.props;
    }
}

