/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import java.util.Vector;

public class Filter {
    static final String delimiters = " \t\r\n";
    private Vector expression = new Vector(3);
    private String filterString = null;

    public Filter(String filter) {
        this.filterString = filter;
        int idx = 0;
        while (idx != -1 && idx < filter.length()) {
            int begin = idx;
            if ((idx = filter.indexOf("%v", idx)) != -1) {
                this.expression.addElement(filter.substring(begin, idx));
                SubExpr tok = new SubExpr();
                this.expression.addElement(tok);
                idx += 2;
                int digit = 0;
                while (idx < filter.length() && Character.isDigit(filter.charAt(idx))) {
                    digit = 10 * digit + Character.digit(filter.charAt(idx), 10);
                    ++idx;
                }
                if (digit != 0) {
                    tok.end = --digit;
                }
                tok.start = digit;
                if (idx >= filter.length() || filter.charAt(idx) != '-') continue;
                tok.end = -1;
                ++idx;
                digit = 0;
                while (idx < filter.length() && Character.isDigit(filter.charAt(idx))) {
                    digit = 10 * digit + Character.digit(filter.charAt(idx), 10);
                    ++idx;
                }
                if (digit == 0) continue;
                tok.end = digit - 1;
                continue;
            }
            this.expression.addElement(filter.substring(begin));
        }
    }

    public String prepare(String toks) {
        Vector<SubExpr> tokens = new Vector<SubExpr>();
        int idx = 0;
        while (idx != -1 && (idx = this.skipDelimiters(toks, idx)) != -1) {
            SubExpr se = new SubExpr();
            se.start = idx;
            tokens.addElement(se);
            idx = this.skipNonDelimiters(toks, idx);
            if (idx == -1) {
                idx = toks.length();
            }
            se.end = idx;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.expression.size(); ++i) {
            Object o = this.expression.elementAt(i);
            if (o instanceof SubExpr) {
                SubExpr t = (SubExpr)o;
                if (t.start >= tokens.size()) continue;
                int endIdx = t.end;
                if (endIdx == -1 || endIdx >= tokens.size()) {
                    endIdx = tokens.size() - 1;
                }
                SubExpr begin = (SubExpr)tokens.elementAt(t.start);
                SubExpr end = (SubExpr)tokens.elementAt(endIdx);
                sb.append(toks.substring(begin.start, end.end));
                continue;
            }
            sb.append(o);
        }
        return sb.toString();
    }

    private int skipDelimiters(String token, int idx) {
        int len = token.length();
        while (idx < token.length() && delimiters.indexOf(token.charAt(idx)) >= 0) {
            ++idx;
        }
        if (idx == len) {
            idx = -1;
        }
        return idx;
    }

    private int skipNonDelimiters(String token, int idx) {
        int len = token.length();
        while (idx < token.length() && delimiters.indexOf(token.charAt(idx)) < 0) {
            ++idx;
        }
        if (idx == len) {
            idx = -1;
        }
        return idx;
    }

    public String toString() {
        return this.filterString;
    }

    static class SubExpr {
        static final int ALL = -1;
        public int start = 0;
        public int end = -1;

        SubExpr() {
        }
    }
}

