/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ws.security.registry.RegistryUtil;
import java.net.URLDecoder;
import javax.naming.CompositeName;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class EntryEnumeration
implements NamingEnumeration {
    protected String baseDn = null;
    protected NamingEnumeration namingEnum;

    public EntryEnumeration(String baseDn, NamingEnumeration ne) {
        if (baseDn != null && baseDn.length() > 0) {
            this.baseDn = baseDn;
        }
        this.namingEnum = ne;
    }

    public boolean hasMoreElements() {
        return this.namingEnum.hasMoreElements();
    }

    public Object nextElement() {
        NameClassPair ncp = (NameClassPair)this.namingEnum.nextElement();
        String retVal = ncp.getName();
        if (retVal != null && retVal.length() > 0 && ncp.isRelative()) {
            try {
                retVal = new CompositeName(retVal).get(0);
            }
            catch (Exception ce) {
                // empty catch block
            }
            if (retVal.charAt(0) == '\"') {
                retVal = retVal.substring(1, retVal.length() - 1);
            }
            if (this.baseDn != null && this.baseDn.trim().length() > 0) {
                retVal = retVal + "," + this.baseDn;
            }
        }
        if (!ncp.isRelative() && retVal != null && retVal.length() > 0) {
            int j = retVal.indexOf(47, 9);
            if (j > -1 && retVal.length() > j + 1) {
                try {
                    retVal = URLDecoder.decode(retVal, "UTF8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                retVal = retVal.substring(j + 1);
            } else {
                retVal = "";
            }
        }
        if (retVal == null || retVal.length() == 0) {
            retVal = this.baseDn;
        }
        retVal = RegistryUtil.removeDNSpace(retVal, 0);
        return retVal;
    }

    public void close() throws NamingException {
        this.namingEnum.close();
    }

    public boolean hasMore() throws NamingException {
        return this.namingEnum.hasMore();
    }

    public Object next() throws NamingException {
        return this.namingEnum.next();
    }
}

