/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class UserRegistryProxy {
    private static final TraceComponent tc = Tr.register(UserRegistryProxy.class, null, "com.ibm.ejs.resources.security");
    private Method getUserSecurityNameMethod = null;
    private Method getGroupSecurityNameMethod = null;
    private Object reg = null;

    public UserRegistryProxy(Properties props) throws Exception {
        try {
            Class<?> c = Class.forName("com.ibm.ws.security.registry.UserRegistryImpl");
            Constructor<?> ct = c.getConstructor(new Class[0]);
            this.reg = ct.newInstance(new Object[0]);
            Method m = c.getMethod("initialize", Properties.class);
            this.getGroupSecurityNameMethod = c.getMethod("getGroupSecurityName", String.class);
            this.getUserSecurityNameMethod = c.getMethod("getUserSecurityName", String.class);
            m.invoke(this.reg, props);
        }
        catch (InvocationTargetException ite) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InvocationTargetException");
            }
            throw ite;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "General Exception");
            }
            throw e;
        }
    }

    public String getUserSecurityName(String accessId) {
        try {
            return (String)this.getUserSecurityNameMethod.invoke(this.reg, accessId);
        }
        catch (IllegalAccessException iae) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IllegalAccessException during getUserSecurityName method invocation");
            }
            return null;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getUserSecurityName method invocation");
            }
            return null;
        }
    }

    public String getGroupSecurityName(String accessId) {
        try {
            return (String)this.getGroupSecurityNameMethod.invoke(this.reg, accessId);
        }
        catch (IllegalAccessException iae) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getGroupSecurityName method invocation");
            }
            return null;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getGroupSecurityName method invocation");
            }
            return null;
        }
    }
}

