/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl;
import com.ibm.ws.security.registry.zOS.SAFRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.stat.impl.SecurityAuthenticationModuleImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class UserRegistryImpl
extends PortableRemoteObject
implements UserRegistry {
    private static TraceComponent tc = Tr.register(UserRegistryImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static String CUSTOM_PREFIX = "Custom_";
    private static String CUSTOM_REALM = "customRealm";
    private UserRegistry custImpl;
    private String realm = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString = RegistryUtil.nullString;
    protected static final String[] nullStringArray = RegistryUtil.nullStringArray;
    protected static final byte[] nullByteArray = RegistryUtil.nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private static RoleBasedAuthorizer authorizer = null;
    private boolean isLDAP = false;
    private boolean isSAF = false;
    private boolean isWindows = false;
    private boolean isLocalOrDomain = false;
    private String useDisplayName = null;
    private String useLoggedInSecName = null;
    private Properties supportedRegistries = new Properties();
    private SecurityAuthenticationModuleImpl authModule;

    public UserRegistryImpl() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void initialize(Properties props) throws CustomRegistryException, RemoteException {
        String custImplClassName;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            custImplClassName = null;
            if (props != null) {
                String useTAM;
                this.useDisplayName = props.getProperty("WAS_UseDisplayName");
                this.useLoggedInSecName = props.getProperty("com.ibm.websphere.security.useLoggedSecurityName");
                custImplClassName = (String)props.get("CustUserRegImplClass");
                if ("com.ibm.ws.security.registry.ldap.LdapRegistryImpl".equals(custImplClassName) && "true".equalsIgnoreCase(useTAM = (String)props.get("com.ibm.websphere.security.registry.UseTAM"))) {
                    custImplClassName = "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl";
                }
            }
            if (custImplClassName == null) {
                try {
                    this.supportedRegistries.load(this.getClass().getResourceAsStream("wsregistries.properties"));
                }
                catch (Throwable e) {
                    Tr.error(tc, "security.registry.loadproperr", new Object[]{e});
                    FFDCFilter.processException(e, "com.ibm.ws.security.registry.UserRegistryImpl.initialize", "193", this);
                    throw new CustomRegistryException(e.getMessage(), e);
                }
                String type = System.getProperty("os.name");
                if (type.startsWith("Windows")) {
                    type = "Windows";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registry type", type);
                }
                custImplClassName = this.supportedRegistries.getProperty(type);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registry implementation", custImplClassName);
                }
            }
            if (custImplClassName == null) {
                Tr.error(tc, "security.registry.noclassname");
                throw new CustomRegistryException("CustomUserRegistryImplementation Class name is null");
            }
            try {
                ExtClassLoader contextCL = ExtClassLoader.getInstance();
                Class<?> wrapperClass = Class.forName(custImplClassName, true, contextCL);
                Object wrapperObj = wrapperClass.newInstance();
                if (wrapperObj instanceof UserRegistry) {
                    String useLocalOrDomain;
                    this.custImpl = (UserRegistry)wrapperObj;
                    this.isLDAP = wrapperObj instanceof LdapRegistryImpl;
                    this.isWindows = wrapperObj instanceof NTLocalDomainRegistryImpl;
                    this.isSAF = wrapperObj instanceof SAFRegistryImpl;
                    if (this.isWindows && props != null && ("Domain".equalsIgnoreCase(useLocalOrDomain = props.getProperty("com.ibm.websphere.registry.UseRegistry")) || "Local".equalsIgnoreCase(useLocalOrDomain))) {
                        this.isLocalOrDomain = true;
                    }
                    break block27;
                }
                Tr.error(tc, "security.registry.unsupportedclass", new Object[]{custImplClassName});
                throw new CustomRegistryException("The implementation file for the custom registry: " + custImplClassName + " is not supported");
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.security.registry.UserRegistryImpl.initialize", "252", this);
                Tr.error(tc, "security.registry.loadclass", new Object[]{custImplClassName, t});
                throw new CustomRegistryException(t.getMessage(), t);
            }
        }
        try {
            this.custImpl.initialize(props);
            this.realm = this.custImpl.getRealm();
            if (this.realm == null || this.realm.length() == 0) {
                this.realm = CUSTOM_REALM;
            }
        }
        catch (CustomRegistryException cre) {
            Tr.error(tc, "security.registry.initerr", new Object[]{custImplClassName, cre});
            FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.registry.UserRegistryImpl.initialize", "270", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", cre);
            }
            throw cre;
        }
        if (StatsFactory.isPMIEnabled()) {
            this.authModule = SecurityAuthenticationModuleImpl.getInstance("Security Authentication");
        }
        String realmFromProp = props.getProperty("WAS_Realm");
        String useRegistryRealm = props.getProperty("WAS_UseRegistryRealm");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "realmFromProperty = " + realmFromProp + " useRegistryRealm = " + useRegistryRealm);
        }
        String user_defined_realm = null;
        if (useRegistryRealm != null && useRegistryRealm.equalsIgnoreCase("false") && realmFromProp != null && realmFromProp.length() > 0) {
            user_defined_realm = realmFromProp;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "a user-defined realm is provided. " + realmFromProp);
            }
        }
        if (user_defined_realm != null && user_defined_realm.length() > 0) {
            this.realm = user_defined_realm;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reset user registry realm to its user-defined value of: " + user_defined_realm);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using registry realm. " + this.realm);
        }
        Tr.audit(tc, "security.custom.registry.initialized", new Object[]{custImplClassName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this);
        }
    }

    public String checkPassword(String userId, String password) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
        String name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", new Object[]{userId, password == null ? null : "****"});
        }
        if ((name = this.custImpl.checkPassword(userId, password)) == null || name.trim().length() <= 0) {
            Tr.error(tc, "security.registry.checkpass.failed", new Object[]{userId});
            throw new PasswordCheckFailedException("checkPassword for: " + userId + " failed to return a user: " + name);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checkPassword", name);
        }
        return name;
    }

    public String mapCertificate(X509Certificate[] certChain) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate", certChain);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "mapCertificate")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        String name = this.custImpl.mapCertificate(certChain);
        if (name == null) {
            Tr.error(tc, "security.registry.mapcertfail");
            throw new CertificateMapFailedException("could not map the certificate to a user");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", name);
        }
        return name;
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new Object[]{pattern, new Integer(limit)});
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsers")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getUsers(pattern, limit);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", result);
        }
        return result;
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", securityName);
        }
        if ((name = this.custImpl.getUserDisplayName(securityName)) == null) {
            name = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName", name);
        }
        return name;
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueUserId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        String name = RegistryUtil.appendRealm(USERTYPE, this.custImpl.getUniqueUserId(securityName), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", name);
        }
        return name;
    }

    public String getUserSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", privilegeAttributeId);
        }
        String userSecurityName = this.custImpl.getUserSecurityName(privilegeAttributeId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName", userSecurityName);
        }
        return userSecurityName;
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", securityName);
        }
        boolean isValid = this.custImpl.isValidUser(securityName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser", new Boolean(isValid));
        }
        return isValid;
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new Object[]{pattern, new Integer(limit)});
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroups")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getGroups(pattern, limit);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", result);
        }
        return result;
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", securityName);
        }
        if ((name = this.custImpl.getGroupDisplayName(securityName)) == null) {
            name = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName", name);
        }
        return name;
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", securityName);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        String name = RegistryUtil.appendRealm(GROUPTYPE, this.custImpl.getUniqueGroupId(securityName), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", name);
        }
        return name;
    }

    public String getGroupSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", privilegeAttributeId);
        }
        String groupSecurityName = this.custImpl.getGroupSecurityName(privilegeAttributeId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName", groupSecurityName);
        }
        return groupSecurityName;
    }

    public boolean isValidGroup(String securityName) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", securityName);
        }
        boolean isValid = this.custImpl.isValidGroup(securityName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup", new Boolean(isValid));
        }
        return isValid;
    }

    public List getGroupsForUser(String securityName) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", securityName);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroupsForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        List usrList = this.custImpl.getGroupsForUser(securityName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", String.valueOf(usrList.size()));
        }
        return usrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSCredential createCredential(String name) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        WSCredential wSCredential;
        long endTime;
        long startTime;
        block29: {
            startTime = 0L;
            endTime = 0L;
            if (StatsFactory.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredential", name);
            }
            if (authorizer == null || authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "createCredential")) break block29;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            WSCredential wSCredential2 = null;
            Object var19_6 = null;
            if (StatsFactory.isPMIEnabled()) {
                endTime = System.currentTimeMillis();
                if (this.authModule == null) {
                    this.authModule = SecurityAuthenticationModuleImpl.getInstance("Security Authentication");
                }
                this.authModule.onCredentialCreationTime(endTime - startTime);
            }
            return wSCredential2;
        }
        try {
            if (name == null || name.length() == 0) {
                throw new EntryNotFoundException("SecurityName is null");
            }
            WSCredential cred = null;
            if (this.isLDAP || this.isSAF) {
                cred = this.custImpl.createCredential(name);
            } else {
                String displayName = null;
                if ("true".equalsIgnoreCase(this.useDisplayName)) {
                    try {
                        displayName = this.getUserDisplayName(name);
                        if (NONE.equals(displayName)) {
                            displayName = null;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    int i;
                    final String uniqueUserId = this.custImpl.getUniqueUserId(name);
                    final String realm = this.getRealm();
                    final String accessId = RegistryUtil.appendRealm(USERTYPE, uniqueUserId, realm);
                    final ArrayList<String> groupList = new ArrayList<String>();
                    List grpList = this.custImpl.getUniqueGroupIds(uniqueUserId);
                    String primaryGroup = null;
                    if (grpList != null && grpList.size() > 0) {
                        String[] groupIds = grpList.toArray(new String[grpList.size()]);
                        for (int i2 = 0; i2 < groupIds.length; ++i2) {
                            if (i2 == 0) {
                                primaryGroup = RegistryUtil.appendRealm(GROUPTYPE, groupIds[i2], realm);
                            }
                            groupList.add(RegistryUtil.appendRealm(GROUPTYPE, groupIds[i2], realm));
                        }
                    }
                    String string = name = displayName != null ? displayName : name;
                    if (this.isWindows && !this.isLocalOrDomain && (i = name.indexOf("\\")) != -1) {
                        name = name.substring(i + 1);
                    }
                    String secName = null;
                    secName = "true".equalsIgnoreCase(this.useLoggedInSecName) ? name : this.custImpl.getUserSecurityName(uniqueUserId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "securityName used in the credential is: ", secName);
                    }
                    final String securityName = secName;
                    final String primaryGroupId = primaryGroup != null ? primaryGroup : NONE;
                    try {
                        cred = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new WSCredentialImpl(realm, securityName, uniqueUserId, primaryGroupId, accessId, null, groupList);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                }
                catch (CustomRegistryException e) {
                    Tr.debug(tc, "CustomRegistryException creating credential: " + e.getMessage());
                    Tr.error(tc, "security.registry.createcredential.error", new Object[]{name, e});
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "836", this);
                    throw new CustomRegistryException(e.getMessage(), e);
                }
                catch (Exception e) {
                    Tr.debug(tc, "Exception creating credential.", new Object[]{e});
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.UserRegistryImpl.createCredential", "842", this);
                    throw new RemoteException(e.getMessage(), e);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCredential", cred);
            }
            wSCredential = cred;
            Object var19_7 = null;
        }
        catch (Throwable throwable) {
            block31: {
                Object var19_8 = null;
                if (!StatsFactory.isPMIEnabled()) break block31;
                endTime = System.currentTimeMillis();
                if (this.authModule == null) {
                    this.authModule = SecurityAuthenticationModuleImpl.getInstance("Security Authentication");
                }
                this.authModule.onCredentialCreationTime(endTime - startTime);
            }
            throw throwable;
        }
        if (StatsFactory.isPMIEnabled()) {
            endTime = System.currentTimeMillis();
            if (this.authModule == null) {
                this.authModule = SecurityAuthenticationModuleImpl.getInstance("Security Authentication");
            }
            this.authModule.onCredentialCreationTime(endTime - startTime);
        }
        return wSCredential;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (this.realm == null) {
            String realmName = this.custImpl.getRealm();
            if (realmName == null || realmName.length() == 0) {
                realmName = CUSTOM_REALM;
            }
            this.realm = realmName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public List getUniqueGroupIds(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", uniqueUserId);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        List grpIdList = this.custImpl.getUniqueGroupIds(uniqueUserId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", grpIdList);
        }
        return grpIdList;
    }

    public Result getUsersForGroup(String securityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", securityName);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsersForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAccess failed", new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getUsersForGroup(securityName, limit);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup", result);
        }
        return result;
    }

    public void setConfigurator(RoleBasedConfigurator rbc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigurator", rbc);
        }
        if (authorizer == null && rbc != null) {
            try {
                authorizer = rbc.getRoleBasedAuthorizer("admin-authz", "domain");
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught retrieving RoleBasedAuthorizer", ex);
                }
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.UserRegistryImpl.setConfigurator", "979", this);
                Tr.error(tc, "security.init.roleauthz.geterr", new Object[]{ex});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigurator");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(";").append("impl=").append(this.custImpl.toString());
        sb.append(";").append("realm=").append(this.realm);
        return sb.toString();
    }
}

