/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.ipc.ssl.KeyReference;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.CrossRealmUtil;
import com.ibm.ws.security.ltpa.KeyEncryptor;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UnsupportedEntryTypeException;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.spec.SecretKeySpec;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public final class LTPAServerObject {
    private static final TraceComponent tc = Tr.register(LTPAServerObject.class, "Security", "com.ibm.ejs.resources.security");
    private static final String NONE = "";
    private static final String USERTYPE = "user:";
    private static final String GROUPTYPE = "group:";
    private static final String SERVERTYPE = "server:";
    private static final String ROLETYPE = "role";
    private static final String[] supportedTypes = new String[]{"group:", "user:", "server:"};
    private static final int GROUP = 0;
    private static final int USER = 1;
    private static final int SERVER = 2;
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";
    private static final String tokenFactorySeparator = "|";
    private String realm = null;
    private static long expirationLimit;
    private byte[] adminPassword = null;
    private byte[] new_adminPassword = null;
    protected static LTPAPublicKey ltpaPubKey;
    protected static LTPAPrivateKey ltpaPrivKey;
    protected static byte[] sharedKey;
    private static LTPAPublicKey new_ltpaPubKey;
    private static LTPAPrivateKey new_ltpaPrivKey;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] new_sharedKey;
    private byte[] new_privateKey;
    private byte[] new_publicKey;
    private byte[] encryptedPrivateKey;
    private byte[] encryptedSharedKey;
    private byte[] new_encryptedPrivateKey;
    private byte[] new_encryptedSharedKey;
    private static String CURRENT_LTPA_VERSION;
    public static final String SHARED_KEY_PROPERTY = "com.ibm.websphere.ltpa.3DESKey";
    public static final String PUBLIC_KEY_PROPERTY = "com.ibm.websphere.ltpa.PublicKey";
    public static final String PRIVATE_KEY_PROPERTY = "com.ibm.websphere.ltpa.PrivateKey";
    public static final String LTPA_VERSION_PROPERTY = "com.ibm.websphere.ltpa.version";
    public static final String CREATION_DATE_PROPERTY = "com.ibm.websphere.CreationDate";
    public static final String CREATION_HOST_PROPERTY = "com.ibm.websphere.CreationHost";
    public static final String LDAP_REALM_PROPERTY = "com.ibm.websphere.ltpa.Realm";
    static boolean _useFIPS;
    static boolean _forceSoftwareJCEProviderForLTPA;
    static String _defaultJCEProvider;
    private String _domainId = null;
    private static SecurityConfigManager scm;
    private static ConcurrentHashMap instanceCache;
    private ArrayList primaryTokenFactoryList = new ArrayList();
    protected static HashMap primaryTokenFactoryMap;
    private ArrayList secondaryTokenFactoryList = new ArrayList();
    private static HashMap secondaryTokenFactoryMap;
    private String ltpaKeySetGroupName = null;
    private Map generationKeys = null;
    private Map validationKeys = null;
    private ObjectName objName = null;
    private static final WebSphereRuntimePermission ACCESS_LTPA_SERVER_OBJECT;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL;
    private static final HashMap tokenFactoryPredictionMap;

    public static LTPAServerObject getLTPAServer() throws LTPAConfigException {
        LTPAServerObject inst;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAServer");
        }
        Object server = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getLTPAServer performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "getLTPAServer expecting : " + ACCESS_LTPA_SERVER_OBJECT.toString());
            }
            sm.checkPermission(ACCESS_LTPA_SERVER_OBJECT);
        }
        String domainId = null;
        if (scm == null) {
            scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (scm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getLTPAServer SecurityConfigManager instance " + scm);
            }
            domainId = scm.getDomainId();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLTPAServer no SecurityConfigManager instance");
        }
        if (domainId == null) {
            domainId = "Admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLTPAServer using domainId " + domainId);
        }
        if ((inst = (LTPAServerObject)instanceCache.get(domainId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getLTPAServer did not find LTPAServerObject in cache");
            }
            if ((inst = LTPAServerObject.initLTPAServer()) != null) {
                inst.setDomainId(domainId);
                instanceCache.put(domainId, inst);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getLTPAServer found LTPAServerObject in cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAServer " + inst);
        }
        return inst;
    }

    public static void releaseLTPAServer() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLTPAServer");
        }
        String domainId = null;
        if (scm == null) {
            scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (scm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseLTPAServer SecurityConfigManager instance " + scm);
            }
            domainId = scm.getDomainId();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseLTPAServer no SecurityConfigManager instance");
        }
        if (domainId == null) {
            domainId = "Admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseLTPAServer using domainId " + domainId);
        }
        instanceCache.remove(domainId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLTPAServer");
        }
    }

    public static LTPAServerObject getInstance() {
        LTPAServerObject inst;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInstance");
            }
            inst = null;
            try {
                inst = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.ltpa", "353");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getInstance exception getting LTPA server object.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance " + inst);
        }
        return inst;
    }

    private static LTPAServerObject initLTPAServer() throws LTPAConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initLTPAServer");
        }
        LTPAServerObject server = null;
        AuthMechanismConfig am = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism();
        boolean forwardableMech = am.getBoolean("isCredentialForwardable");
        if (am.getType().equals("LTPA") && forwardableMech || am.getType().equals("KRB5")) {
            try {
                String forceSoftwareJCEProviderForLTPAString;
                String password = am.getString("password");
                Long expTime = am.getLong("timeout");
                String privateKey = am.getString(PRIVATE_KEY_PROPERTY);
                String publicKey = am.getString(PUBLIC_KEY_PROPERTY);
                String sharedKey = am.getString(SHARED_KEY_PROPERTY);
                if (expTime == null) {
                    Tr.error(tc, "security.secsrv.badltpconfig", new Object[]{expTime != null ? expTime.toString() : null});
                    String msg = "Required LTPA configuration data is unavailable.  Initialization failed.";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Required LTPA configuration data is unavailable.  Initialization failed.");
                    }
                    throw new LTPAConfigException("Required LTPA configuration data is unavailable.  Initialization failed.");
                }
                long expirationTime = expTime;
                byte[] pwBytes = null;
                if (password != null) {
                    pwBytes = password.getBytes("UTF8");
                }
                server = new LTPAServerObject(expirationTime, pwBytes, publicKey, privateKey, sharedKey);
                Boolean use_FIPS = Boolean.valueOf(SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.security.useFIPS"));
                if (use_FIPS.booleanValue()) {
                    _useFIPS = true;
                    _defaultJCEProvider = Security.getProperty("DEFAULT_JCE_PROVIDER");
                }
                if ((forceSoftwareJCEProviderForLTPAString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.ws.security.ltpa.forceSoftwareJCEProviderForLTPA")) != null && forceSoftwareJCEProviderForLTPAString.equalsIgnoreCase("true")) {
                    _forceSoftwareJCEProviderForLTPA = true;
                }
            }
            catch (LTPAConfigException lexc) {
                FFDCFilter.processException(lexc, "com.ibm.ws.security.ltpa.LTPAServerObject.initLTPAServer", "420");
                throw lexc;
            }
            catch (Exception exc) {
                FFDCFilter.processException(exc, "com.ibm.ws.security.ltpa.LTPAServerObject.initLTPAServer", "425");
                Tr.error(tc, "security.secsrv.ltpaconfigerr", new Object[]{exc});
                throw new LTPAConfigException(exc.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initLTPAServer " + server);
        }
        return server;
    }

    private LTPAServerObject(long expirationTime, byte[] password, String ltpaPubKey, String encLtpaPrivKey, String encSharedKey) throws LTPAConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        expirationLimit = expirationTime;
        this.adminPassword = password;
        if (ltpaPubKey != null && encLtpaPrivKey != null && encSharedKey != null) {
            try {
                this.encryptedSharedKey = Base64Coder.base64Decode(encSharedKey.getBytes("UTF8"));
                this.encryptedPrivateKey = Base64Coder.base64Decode(encLtpaPrivKey.getBytes("UTF8"));
                this.publicKey = Base64Coder.base64Decode(ltpaPubKey.getBytes("UTF8"));
                LTPAServerObject.ltpaPubKey = new LTPAPublicKey(this.publicKey);
                ltpaPrivKey = new LTPAPrivateKey(this.getPrivateKey(password, this.encryptedPrivateKey));
                sharedKey = this.getSharedKey(password, this.encryptedSharedKey);
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", sharedKey);
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", LTPAServerObject.ltpaPubKey);
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", ltpaPrivKey);
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", "465", this);
                Tr.error(tc, "security.ltpa.init.error", new Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "LTPAServerObject", e);
                }
                throw new LTPAConfigException(e.getMessage());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", "472", this);
                Tr.error(tc, "security.ltpa.init.error", new Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "LTPAServerObject", e);
                }
                throw new LTPAConfigException(e.getMessage());
            }
        }
        try {
            this.initializeKeySetGroupKeys();
        }
        catch (KeyException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.<init>", "496", this);
            Tr.error(tc, "security.ltpa.init.error", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject", e);
            }
            throw new LTPAConfigException(e.getMessage());
        }
        try {
            String tokenFactoryString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.wsspi.security.ltpa.tokenFactory");
            StringTokenizer st = new StringTokenizer(tokenFactoryString, tokenFactorySeparator);
            while (st.hasMoreTokens()) {
                String factoryClass = st.nextToken();
                this.findFactory(factoryClass, this.primaryTokenFactoryList, true);
                this.findFactory(factoryClass, this.secondaryTokenFactoryList, false);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", "516", this);
            Tr.error(tc, "security.ltpa.init.error", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject", e);
            }
            throw new LTPAConfigException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public LTPAServerObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public TokenFactory findFactory(String factoryClass, List factoryList, boolean primary) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findFactory", new Object[]{factoryClass, new Boolean(primary)});
        }
        TokenFactory factory = null;
        TokenFactory[] factories = factoryList.toArray(new TokenFactory[0]);
        if (factories.length > 0) {
            for (int i = 0; i < factories.length; ++i) {
                if (!factories[i].getClass().getName().equals(factoryClass)) continue;
                factory = factories[i];
            }
        }
        if (factory == null) {
            try {
                Class<?> tokenFactoryClass = Class.forName(factoryClass);
                Object tokenFactoryObj = tokenFactoryClass.newInstance();
                factory = (TokenFactory)tokenFactoryObj;
                if (primary) {
                    factory.initialize(primaryTokenFactoryMap);
                } else {
                    factory.initialize(secondaryTokenFactoryMap);
                }
                factoryList.add(factory);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.findPrimaryFactory", "575", this);
                Tr.error(tc, "security.ltpa.factory.init.error", new Object[]{factoryClass, e});
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findFactory", factory);
        }
        return factory;
    }

    /*
     * Unable to fully structure code
     */
    public void refreshTokenFactories() throws LTPAConfigException {
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.entry(LTPAServerObject.tc, "refreshTokenFactories");
        }
        if (LTPAServerObject.sharedKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPubKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPrivKey != null) {
            if (LTPAServerObject.tc.isDebugEnabled()) {
                Tr.debug(LTPAServerObject.tc, "Refreshing using old key location.");
            }
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(LTPAServerObject.expirationLimit));
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", LTPAServerObject.sharedKey);
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", LTPAServerObject.ltpaPubKey);
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", LTPAServerObject.ltpaPrivKey);
        } else lbl-1000:
        // 3 sources

        {
            try {
                this.initializeKeySetGroupKeys();
            }
            catch (KeyException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.refreshTokenFactories", "608", this);
                if (LTPAServerObject.tc.isEntryEnabled()) {
                    Tr.exit(LTPAServerObject.tc, "refreshTokenFactories", new Object[]{e});
                }
                throw new LTPAConfigException(e.getMessage());
            }
            primaryFactories = this.primaryTokenFactoryList.toArray(new TokenFactory[0]);
            if (primaryFactories.length > 0) {
                for (i = 0; i < primaryFactories.length; ++i) {
                    if (LTPAServerObject.tc.isDebugEnabled()) {
                        Tr.debug(LTPAServerObject.tc, "Refreshing primary tokenFactory keys for: " + primaryFactories[i].getClass().getName());
                    }
                    primaryFactories[i].initialize(LTPAServerObject.primaryTokenFactoryMap);
                }
            }
            if ((secondaryFactories = this.secondaryTokenFactoryList.toArray(new TokenFactory[0])).length > 0) {
                for (i = 0; i < secondaryFactories.length; ++i) {
                    if (LTPAServerObject.tc.isDebugEnabled()) {
                        Tr.debug(LTPAServerObject.tc, "Refreshing secondary tokenFactory keys for: " + secondaryFactories[i].getClass().getName());
                    }
                    secondaryFactories[i].initialize(LTPAServerObject.secondaryTokenFactoryMap);
                }
            }
        }
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.exit(LTPAServerObject.tc, "refreshTokenFactories");
        }
    }

    public void initializeKeySetGroupKeys() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySetGroupKeys");
        }
        LTPAPublicKey tempLTPAPubKey = null;
        LTPAPrivateKey tempLTPAPrivKey = null;
        byte[] tempSharedKey = null;
        this.ltpaKeySetGroupName = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("keySetGroup");
        KeySetGroupManager ksgm = KeySetGroupManager.getInstance();
        if (!ksgm.isInitialized()) {
            ksgm.initializeKeySetGroups(SecurityObjectLocator.getSecurityConfig().getSCO(), true);
        }
        this.generationKeys = ksgm.getKeySetGroup(this.ltpaKeySetGroupName).getLatestKeys();
        this.traceKeyMap(this.generationKeys);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Latest keys: " + this.generationKeys);
        }
        if (this.generationKeys != null) {
            for (String keyAlias : this.generationKeys.keySet()) {
                Object key = this.generationKeys.get(keyAlias);
                if (key instanceof Key) {
                    tempSharedKey = ((Key)key).getEncoded();
                    continue;
                }
                if (!(key instanceof KeyPair)) continue;
                Key publicKeyAsSecret = ((KeyPair)key).getPublicKey();
                tempLTPAPubKey = new LTPAPublicKey(publicKeyAsSecret.getEncoded());
                Key privateKeyAsSecret = ((KeyPair)key).getPrivateKey();
                tempLTPAPrivKey = new LTPAPrivateKey(privateKeyAsSecret.getEncoded());
            }
            primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
            if (tempSharedKey != null) {
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", tempSharedKey);
            }
            if (tempLTPAPubKey != null) {
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", tempLTPAPubKey);
            }
            if (tempLTPAPrivKey != null) {
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", tempLTPAPrivKey);
            }
            this.validationKeys = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName).getAllKeysByVersion();
            this.traceValidationKeys(this.validationKeys);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All keys: " + this.validationKeys);
            }
        } else {
            throw new KeyException("Could not generateLTPAKeys from the KeySet name: " + this.ltpaKeySetGroupName);
        }
        secondaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
        secondaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_validation_keys", this.validationKeys);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySetGroupKeys");
        }
    }

    public Token createLTPAToken(String securityName, String factoryClass) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLTPAToken", new Object[]{securityName, factoryClass});
        }
        if (factoryClass == null) {
            throw new WSLoginFailedException("TokenFactory is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            sm.checkPermission(MAP_CREDENTIAL);
        }
        Token token = null;
        try {
            if (LTPAServerObject.getUserRegistry() != null) {
                String accessID = null;
                accessID = securityName.startsWith(supportedTypes[1]) || securityName.startsWith(supportedTypes[2]) ? securityName : LTPAServerObject.getUserRegistry().getUniqueUserId(securityName);
                if (accessID == null) {
                    Tr.error(tc, "security.ltpa.credmap.failed.nullaccessid");
                    throw new WSLoginFailedException("Cannot create token since accessID is null");
                }
                TokenFactory factory = this.findFactory(factoryClass, this.primaryTokenFactoryList, true);
                if (factory == null) {
                    Tr.error(tc, "security.ltpa.factory.null.error", new Object[]{factoryClass});
                    throw new WSLoginFailedException("TokenFactory is null");
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("com.ibm.wsspi.security.cred.uniqueId", accessID);
                token = factory.createToken(map);
                if (token == null) {
                    Tr.error(tc, "security.ltpa.validate.nulltoken");
                    throw new WSLoginFailedException("Token is null");
                }
            }
        }
        catch (WSLoginFailedException wslfe) {
            FFDCFilter.processException((Throwable)wslfe, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "809", this);
            throw wslfe;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "814", this);
            Tr.error(tc, "security.ltpa.factory.tokencreate.error", new Object[]{factoryClass, e});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLTPAToken", token);
        }
        return token;
    }

    public WSCredential createLTPAToken(final WSCredential cred) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLTPAToken", cred);
        }
        Token token = null;
        String factoryClass = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
        try {
            String accessID = cred.getAccessId();
            if (accessID == null) {
                Tr.error(tc, "security.ltpa.credmap.failed.nullaccessid");
                throw new TokenCreationFailedException("Cannot create token since accessID is null");
            }
            TokenFactory factory = this.findFactory(factoryClass, this.primaryTokenFactoryList, true);
            if (factory == null) {
                Tr.error(tc, "security.ltpa.factory.null.error", new Object[]{factoryClass});
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("com.ibm.wsspi.security.cred.uniqueId", accessID);
            token = factory.createToken(map);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "854", this);
            Tr.error(tc, "security.ltpa.factory.tokencreate.error", new Object[]{factoryClass, e});
            throw new TokenCreationFailedException(e.getMessage());
        }
        WSCredential wsCred = null;
        final Token privToken = token;
        try {
            wsCred = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new WSCredentialImpl(cred, "oid:1.3.18.0.2.30.2", privToken, true, privToken.getExpiration());
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{ex});
            }
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "880", this);
            String message = ex != null ? ex.getMessage() : "Exception occurred creating new WS cred.";
            throw new TokenCreationFailedException(message);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLTPAToken", wsCred);
        }
        return wsCred;
    }

    public WSCredential authenticate(BasicAuthData authData) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate");
        }
        WSCredential cred = null;
        try {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (LTPAServerObject.getUserRegistry() == null) {
                cred = ctxMgr.getUnauthenticatedCredential();
            }
            if (cred == null) {
                String realm = authData.getRealm();
                if (realm == null) {
                    realm = ctxMgr.getDefaultRealm();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realm from basicAuth  = " + realm);
                }
                UserRegistryImpl userRegistry = LTPAServerObject.getUserRegistry(realm);
                String user = userRegistry.checkPassword(authData.getUserid(), authData.getPassword());
                cred = userRegistry.createCredential(user);
            }
            if (cred == null) {
                throw new WSLoginFailedException("Credential returned by createCredential is null");
            }
            cred = this.createLTPAToken(cred);
        }
        catch (WSLoginFailedException e) {
            throw e;
        }
        catch (TokenCreationFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", "932", this);
            Tr.error(tc, "security.ltpa.authenticate", new Object[]{e.getMessage()});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", "938", this);
            Tr.error(tc, "security.ltpa.authenticate", new Object[]{e.getMessage()});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate", cred);
        }
        return cred;
    }

    public WSCredential authenticateLoginToken(byte[] encrTok) throws WSLoginFailedException, RemoteException {
        throw new WSLoginFailedException("LTPAServerObject: authenticateLoginToken not implemented");
    }

    public Token validateTokenAndRealm(byte[] credTok) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenAndRealm(byte[])", credTok);
        }
        Token token = this.validateToken(credTok, false);
        this.realmsMatch(token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenAndRealm(byte[])");
        }
        return token;
    }

    public Token validateToken(byte[] credTok) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[])", credTok);
        }
        Token token = this.validateToken(credTok, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken(byte[])");
        }
        return token;
    }

    public Token validateToken(byte[] credTok, boolean refreshIfExpired) throws WSLoginFailedException {
        Throwable rootException;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[], boolean)", "credTok = " + credTok + ", refreshIfExpired = " + refreshIfExpired);
        }
        if (credTok == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validate failed");
            }
            Tr.error(tc, "security.ltpa.validate.nulltoken");
            throw new WSLoginFailedException("LTPAServerObject: token passed in is null.");
        }
        if (LTPAServerObject.getUserRegistry() == null) {
            return null;
        }
        Token token = null;
        WSLoginFailedException primaryExceptionList = null;
        WSLoginFailedException secondaryExceptionList = null;
        try {
            token = this.validateToken(credTok, this.primaryTokenFactoryList, true, refreshIfExpired);
        }
        catch (WSLoginFailedException e) {
            rootException = e.getCause();
            if (rootException instanceof TokenExpiredException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateToken: token is expired.");
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validateToken", "1061", this);
                throw e;
            }
            primaryExceptionList = e;
        }
        if (token == null && this.secondaryTokenFactoryList != null) {
            try {
                token = this.validateToken(credTok, this.secondaryTokenFactoryList, false, refreshIfExpired);
            }
            catch (WSLoginFailedException e) {
                rootException = e.getCause();
                if (rootException instanceof TokenExpiredException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateToken: token is expired.");
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validateToken", "1083", this);
                    throw e;
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validateToken", "1087", this);
                secondaryExceptionList = e;
            }
        }
        if (token == null) {
            Tr.debug(tc, "security.ltpa.validate.verifytoken.failed");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject: LTPATokenFactory.validateToken error due to invalid keys or token type.");
            }
            if (secondaryExceptionList != null) {
                throw secondaryExceptionList;
            }
            if (primaryExceptionList != null) {
                throw primaryExceptionList;
            }
            throw new WSLoginFailedException("Validation of LTPA token failed due to invalid keys or token type.");
        }
        this.realmsMatch(token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken(byte[],boolean)");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token validateToken(byte[] credTok, List tokenFactoryList, boolean primary, boolean refreshIfExpired) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[],List,boolean,boolean)", new Object[]{credTok, "tokenFactoryList=" + tokenFactoryList, "primary=" + primary, "refreshIfExpired=" + refreshIfExpired});
        }
        WSLoginFailedException exceptionList = null;
        Token token = null;
        TokenFactory[] tokenFactoryArray = tokenFactoryList.toArray(new TokenFactory[0]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BEGIN VALIDATING TOKEN: some errors may occur, look for SUCCESS:");
        }
        try {
            Integer key = new Integer(credTok.length);
            FactoryPrediction fp = (FactoryPrediction)tokenFactoryPredictionMap.get(key);
            if (fp == null) {
                HashMap hashMap = tokenFactoryPredictionMap;
                synchronized (hashMap) {
                    fp = new FactoryPrediction();
                    tokenFactoryPredictionMap.put(key, fp);
                }
            }
            int prediction = fp.getFactoryNumber();
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < tokenFactoryArray.length; ++i) {
                    if ((k != 0 || i != prediction) && (k != 1 || i == prediction)) continue;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling tokenFactory[" + i + "].validateTokenBytes() -> " + tokenFactoryArray[i].getClass().getName());
                        }
                        if ((token = tokenFactoryArray[i].validateTokenBytes(credTok)) == null || !token.isValid()) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "validateToken(byte[],List,boolean,boolean) -> SUCCESS: validated using tokenFactoryArray[" + i + "]: " + tokenFactoryArray[i].getClass().getName());
                        }
                        fp.addResult(credTok.length, i);
                        if (prediction == i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Prediction successful:token:" + tokenFactoryArray[i].getClass().getName() + "::" + credTok.length);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Prediction failed:token:" + tokenFactoryArray[i].getClass().getName() + "::" + credTok.length);
                        }
                        return token;
                    }
                    catch (InvalidTokenException e) {
                        if (i < tokenFactoryArray.length) {
                            if (exceptionList == null) {
                                exceptionList = new WSLoginFailedException(e.getMessage(), e);
                                continue;
                            }
                            exceptionList.addException(e);
                            continue;
                        }
                        exceptionList.addException(e);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{exceptionList});
                        }
                        throw exceptionList;
                    }
                    catch (TokenExpiredException e) {
                        if (refreshIfExpired) {
                            token = (Token)token.clone();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The Token has been cloned, the expiration time is set to " + new Date(token.getExpiration()));
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "validateToken(byte[],List,boolean,boolean) -> SUCCESS: validated using tokenFactoryArray[" + i + "]: " + tokenFactoryArray[i].getClass().getName());
                            }
                            return token;
                        }
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1199", this);
                        Tr.warning(tc, "security.ltpa.validate.tokenexpired", new Object[]{e.getMessage()});
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                    catch (Exception e) {
                        if (i < tokenFactoryArray.length) {
                            if (exceptionList == null) {
                                exceptionList = new WSLoginFailedException(e.getMessage(), e);
                                continue;
                            }
                            exceptionList.addException(e);
                            continue;
                        }
                        exceptionList.addException(e);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{exceptionList});
                        }
                        throw exceptionList;
                    }
                }
            }
        }
        catch (WSLoginFailedException wslfe) {
            ArrayList exceptionListExceptions = wslfe.getExceptions();
            for (int j = 0; j < exceptionListExceptions.size(); ++j) {
                Throwable exception = (Throwable)exceptionListExceptions.get(j);
                FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1232", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{exception});
            }
            throw wslfe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken -> FAILED for " + (primary ? "primary." : "secondary."));
        }
        return null;
    }

    public Token validateTokenAndRealm(byte[] credTok, String factoryClass) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenAndRealm(byte[], String)", credTok);
        }
        Token token = this.validateToken(credTok, factoryClass, false);
        this.realmsMatch(token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenAndRealm(byte[], String)");
        }
        return token;
    }

    public Token validateToken(byte[] credTok, String factoryClass, boolean refreshIfExpired) throws WSLoginFailedException {
        Throwable rootException;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[],String,boolean)", new Object[]{credTok, "factoryClass=" + factoryClass, "refreshIfExpired=" + refreshIfExpired});
        }
        if (factoryClass == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "factoryClass is null");
            }
            throw new WSLoginFailedException("LTPAServerObject: factoryClass String is null.");
        }
        if (credTok == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validate failed");
            }
            Tr.error(tc, "security.ltpa.validate.nulltoken");
            throw new WSLoginFailedException("LTPAServerObject: token passed in is null.");
        }
        if (LTPAServerObject.getUserRegistry() == null) {
            return null;
        }
        Token token = null;
        WSLoginFailedException primaryExceptionList = null;
        WSLoginFailedException secondaryExceptionList = null;
        TokenFactory factory = this.findFactory(factoryClass, this.primaryTokenFactoryList, true);
        try {
            if (factory == null) {
                Tr.error(tc, "security.ltpa.factory.null.error", new Object[]{factoryClass});
                WSLoginFailedException ex = new WSLoginFailedException("Primary TokenFactory is null");
                FFDCFilter.processException(ex, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1286");
                throw ex;
            }
            token = this.validateToken(credTok, factory, refreshIfExpired);
        }
        catch (WSLoginFailedException e) {
            rootException = e.getCause();
            if (rootException instanceof TokenExpiredException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateToken (Primary): token is expired.");
                }
                throw e;
            }
            primaryExceptionList = e;
        }
        if (token == null && this.secondaryTokenFactoryList != null) {
            factory = this.findFactory(factoryClass, this.secondaryTokenFactoryList, false);
            try {
                if (factory == null) {
                    Tr.error(tc, "security.ltpa.factory.null.error", new Object[]{factoryClass});
                    WSLoginFailedException ex = new WSLoginFailedException("Secondary TokenFactory is null");
                    FFDCFilter.processException(ex, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1315");
                    throw ex;
                }
                token = this.validateToken(credTok, factory, refreshIfExpired);
            }
            catch (WSLoginFailedException e) {
                rootException = e.getCause();
                if (rootException instanceof TokenExpiredException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateToken (Secondary): token is expired.");
                    }
                    throw e;
                }
                secondaryExceptionList = e;
            }
        }
        if (token == null) {
            Tr.debug(tc, "security.ltpa.validate.verifytoken.failed");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject: LTPATokenFactory.validateToken error due to invalid keys or token type.");
            }
            if (secondaryExceptionList != null) {
                throw secondaryExceptionList;
            }
            if (primaryExceptionList != null) {
                throw primaryExceptionList;
            }
            throw new WSLoginFailedException("Validation of LTPA token failed due to invalid keys or token type.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken with factoryClass");
        }
        return token;
    }

    public Token validateToken(byte[] credTok, TokenFactory tokenFactory, boolean refreshIfExpired) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken(byte[],TokenFactory,boolean)", new Object[]{credTok, "tokenFactory=" + tokenFactory, "refreshIfExpired=" + refreshIfExpired});
        }
        Token token = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BEGIN VALIDATING TOKEN: with specific TokenFactory, look for SUCCESS:");
        }
        if (tokenFactory == null) {
            Tr.error(tc, "security.ltpa.factory.null.error");
            WSLoginFailedException ex = new WSLoginFailedException("TokenFactory is null");
            FFDCFilter.processException(ex, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1368");
            throw ex;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling tokenFactory.validateTokenBytes() -> " + tokenFactory.getClass().getName());
            }
            if ((token = tokenFactory.validateTokenBytes(credTok)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateToken(byte[],TokenFactory,boolean) -> SUCCESS: validated using specified TokenFactory");
                }
                return token;
            }
        }
        catch (InvalidTokenException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{e});
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        catch (TokenExpiredException e) {
            if (refreshIfExpired) {
                token = (Token)token.clone();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Token has been cloned, the expiration time is set to " + new Date(token.getExpiration()));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateToken(byte[],TokenFactory,boolean) -> SUCCESS: validated using specified tokenFactory (cloned)");
                }
                return token;
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1399", this);
            Tr.warning(tc, "security.ltpa.validate.tokenexpired", new Object[]{e.getMessage()});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        catch (Exception e) {
            WSLoginFailedException ex = new WSLoginFailedException(e.getMessage(), e);
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1407", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{ex});
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken -> FAILED.");
        }
        return null;
    }

    public WSCredential validate(byte[] credTok) throws WSLoginFailedException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((token = this.validateToken(credTok)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate (bytes)");
            }
            return this.validate(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Problem validating token, returning null.");
        }
        throw new WSLoginFailedException("Problem validating LTPA token.");
    }

    public WSCredential validate(Token token) throws WSLoginFailedException {
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (LTPAServerObject.getUserRegistry() == null || token == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Bootstrap mode: returning unauthenticated cred.");
            }
            try {
                WSCredential tmpCred = ctxMgr.getUnauthenticatedCredential();
                return tmpCred;
            }
            catch (WSSecurityException e) {
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validation successful - to create credential");
        }
        String securityName = null;
        try {
            WSCredential regCred = null;
            String[] accessID = token.getAttributes("u");
            boolean userFromThisRealm = false;
            boolean userFromTrustedRealm = false;
            userFromThisRealm = CrossRealmUtil.isUserFromThisRealm(accessID[0]);
            if (!userFromThisRealm) {
                userFromTrustedRealm = CrossRealmUtil.isUserFromTrustedForeignRealm(accessID[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user: " + accessID[0] + " is not from this realm: is user from trusted foreign relam: " + new Boolean(userFromTrustedRealm));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user: " + accessID[0] + " is from this realm");
            }
            if (userFromTrustedRealm) {
                regCred = CrossRealmUtil.getCredForForeignUser(accessID[0]);
                securityName = accessID[0];
            }
            if (userFromThisRealm || !userFromTrustedRealm) {
                securityName = this.getSecurityName(accessID[0]);
            }
            if (SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("com.ibm.websphere.security.registry.UseTAM") && !RegistryUtil.checkValidUserifTAM(securityName, LTPAServerObject.getUserRegistry())) {
                throw new WSLoginFailedException("User is not valid in Access Manager");
            }
            String internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
            if (internalServerId != null && ctxMgr.isInternalServerId(securityName)) {
                regCred = ctxMgr.getServerCredential();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate: returning server cred " + regCred);
                }
                return regCred;
            }
            if (regCred == null && userFromThisRealm) {
                regCred = LTPAServerObject.getUserRegistry().createCredential(securityName);
            }
            final WSCredential retCred = regCred;
            WSCredential wsCred = null;
            final Token privToken = token;
            try {
                wsCred = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(retCred, "oid:1.3.18.0.2.30.2", privToken, true, privToken.getExpiration());
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
                }
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "1539", this);
                Exception ex = e.getException();
                String message = ex != null ? ex.getMessage() : "Exception occurred creating new WS cred.";
                throw new WSLoginFailedException(message, ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
            return wsCred;
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1550", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validation failed", e);
            }
            Tr.error(tc, "security.ltpa.validate.createcredential.failed", new Object[]{securityName, e});
            throw e;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1557", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validation failed", exc);
            }
            Tr.error(tc, "security.ltpa.validate.createcredential.failed", new Object[]{securityName, exc});
            throw new WSLoginFailedException(exc.getMessage(), exc);
        }
    }

    public String validateGetUser(byte[] credTok) {
        String retUser;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateGetUser", credTok);
            }
            retUser = null;
            Token token = null;
            try {
                token = this.validateToken(credTok);
                if (token == null || !token.isValid()) {
                    Tr.error(tc, "security.ltpa.validate.tokenexpired");
                }
                String[] tmpArray = token.getAttributes("u");
                retUser = this.getSecurityName(tmpArray[0]);
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "validateGetUser: LTPA token is not valid", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateGetUser", retUser);
        }
        return retUser;
    }

    public long getExpiration(byte[] tokenBytes) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpiration", tokenBytes);
        }
        if (tokenBytes == null) {
            throw new InvalidTokenException();
        }
        long timestamp = 0L;
        Token token = null;
        try {
            token = this.validateToken(tokenBytes);
            if (token != null && token.isValid()) {
                timestamp = token.getExpiration();
            }
        }
        catch (Exception e) {
            throw new TokenExpiredException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpiration", new Long(timestamp));
        }
        return timestamp;
    }

    private String getSecurityName(String fqPrivilegeAttributeId) throws CustomRegistryException, EntryNotFoundException, UnsupportedEntryTypeException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName", fqPrivilegeAttributeId);
        }
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        String internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
        if (internalServerId != null && ctxMgr.isInternalServerId(fqPrivilegeAttributeId)) {
            return internalServerId;
        }
        String retVal = null;
        String privilegeAttributeId = null;
        privilegeAttributeId = this.getRelativeName(fqPrivilegeAttributeId);
        if (fqPrivilegeAttributeId.startsWith(supportedTypes[1])) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling userRegistry.getUserSecName");
            }
            retVal = LTPAServerObject.getUserRegistry().getUserSecurityName(privilegeAttributeId);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Back from  userRegistry.getUserSecName");
            }
        } else if (fqPrivilegeAttributeId.startsWith(supportedTypes[0])) {
            retVal = LTPAServerObject.getUserRegistry().getGroupSecurityName(privilegeAttributeId);
        } else {
            UnsupportedEntryTypeException ex = new UnsupportedEntryTypeException("not USER or GROUP");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityName", ex);
            }
            Tr.error(tc, "security.ltpa.badtype", new Object[]{ex});
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", retVal);
        }
        return retVal;
    }

    private String getRelativeName(String name) throws CustomRegistryException, RemoteException {
        int realmIdx = name.indexOf(realmSeparator);
        String retVal = name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelativeName", name);
        }
        this.realm = LTPAServerObject.getUserRegistry().getRealm();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "realm from userRegistry.getRealm(): " + this.realm + "\n realm length: " + this.realm.length());
            Tr.debug(tc, "realmIndex: " + realmIdx);
        }
        if (realmIdx >= 0) {
            int typeIdx = name.indexOf(typeSeparator);
            if (realmIdx - typeIdx - 1 == this.realm.length() && name.startsWith(this.realm, typeIdx + 1)) {
                retVal = name.substring(realmIdx + 1);
            } else {
                Tr.error(tc, "security.ltpa.realm_mismatch");
                throw new CustomRegistryException("The realm in the token: " + name.substring(typeIdx + 1, realmIdx) + " does not match the current realm: " + this.realm);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelativeName", retVal);
        }
        return retVal;
    }

    private byte[] getPrivateKey(byte[] password, byte[] encryptedPrivateKey) {
        KeyEncryptor encryptor = new KeyEncryptor(password);
        return encryptor.decrypt((byte[])encryptedPrivateKey.clone());
    }

    private byte[] getSharedKey(byte[] password, byte[] encryptedSharedKey) {
        KeyEncryptor encryptor = new KeyEncryptor(password);
        return encryptor.decrypt((byte[])encryptedSharedKey.clone());
    }

    private byte[] getPublicKey() throws RemoteException {
        return this.publicKey;
    }

    private byte[] getEncPrivateKey() throws RemoteException {
        return this.encryptedPrivateKey;
    }

    private byte[] getEncSharedKey() throws RemoteException {
        return this.encryptedSharedKey;
    }

    public void updateLTPAKeysFromMap(Map keyMap) throws RemoteException {
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateLTPAKeysFromMap", new Object[]{keyMap});
            }
            LTPAPublicKey tempLTPAPubKey = null;
            LTPAPrivateKey tempLTPAPrivKey = null;
            byte[] tempSharedKey = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Latest keys: " + keyMap);
            }
            if (keyMap != null) {
                TokenFactory[] primaryFactories;
                for (String keyAlias : keyMap.keySet()) {
                    Object key = keyMap.get(keyAlias);
                    if (key instanceof Key) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found secret key from Map.");
                        }
                        tempSharedKey = ((Key)key).getEncoded();
                        continue;
                    }
                    if (!(key instanceof KeyPair)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found key pair from Map.");
                    }
                    Key publicKeyAsSecret = ((KeyPair)key).getPublicKey();
                    tempLTPAPubKey = new LTPAPublicKey(publicKeyAsSecret.getEncoded());
                    Key privateKeyAsSecret = ((KeyPair)key).getPrivateKey();
                    tempLTPAPrivKey = new LTPAPrivateKey(privateKeyAsSecret.getEncoded());
                }
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
                if (tempSharedKey != null) {
                    primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", tempSharedKey);
                }
                if (tempLTPAPubKey != null) {
                    primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", tempLTPAPubKey);
                }
                if (tempLTPAPrivKey != null) {
                    primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", tempLTPAPrivKey);
                }
                if ((primaryFactories = this.primaryTokenFactoryList.toArray(new TokenFactory[0])).length > 0) {
                    for (int i = 0; i < primaryFactories.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Refreshing primary tokenFactory keys for: " + primaryFactories[i].getClass().getName());
                        }
                        primaryFactories[i].initialize(primaryTokenFactoryMap);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The keys passed in are null, not updating keys.");
            }
            try {
                ContextManagerFactory.getInstance().refreshServerSubject();
                LTPACrypto.rsaKeysMap.clear();
                LTPACrypto.verifyKeysMap.clear();
                LTPACrypto.cryptoKeysMap.clear();
            }
            catch (WSSecurityException e) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Exception refreshing server Subject after key generation.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateLTPAKeysFromMap");
        }
    }

    public Map generateKeysForKeySetGroup(Session session, Boolean updateRuntime) throws RemoteException {
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeysForKeySetGroup", new Object[]{session, updateRuntime});
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Boolean saveConfig = Boolean.FALSE;
        if (session == null) {
            session = new Session();
            saveConfig = Boolean.TRUE;
        }
        if ((type = ManagementScopeManager.getInstance().getProcessType()) != null && (type.equals("DeploymentManager") || type.equals("UnManagedProcess") || type.equals("JobManager") || type.equals("AdminAgent"))) {
            try {
                this.ltpaKeySetGroupName = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("keySetGroup");
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getUserCmd = commandMgr.createCommand("generateKeyForKeySetGroup");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter("keySetGroupName", this.ltpaKeySetGroupName);
                if (type.equals("DeploymentManager")) {
                    getUserCmd.setParameter("keySetGroupScope", ManagementScopeManager.getInstance().getCellScopeName());
                } else {
                    getUserCmd.setParameter("keySetGroupScope", ManagementScopeManager.getInstance().getNodeScopeName());
                }
                getUserCmd.setParameter("keySetGroupUpdateRuntime", updateRuntime);
                getUserCmd.setParameter("keySetGroupSaveConfig", Boolean.FALSE);
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    Map newKeys = (Map)cmdResult.getResult();
                    if (saveConfig == Boolean.TRUE) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " Saving the security.xml changes.");
                        }
                        cs.save(session, true);
                        cs.discard(session);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "generateKeysForKeySetGroup (success)");
                    }
                    return newKeys;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateKeysForKeySetGroup: command task result is failure.", new Object[]{cmdResult.getException()});
                }
                throw new RemoteException(cmdResult.getException().getMessage());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.generateKeysForKeySetGroup", "1922", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem generating SSO keys.  Using old keys still.");
                }
                Tr.error(tc, "security.ltpa.importkeys", new Object[]{e});
                throw new RemoteException("Problem generating SSO keys. Using original values. The exception is " + e.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Only generate keys in the AdminAgent, JobManager, BASE, UnManagedProcess, or DeploymentManager processes, current process type: " + ManagementScopeManager.getInstance().getProcessType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKeysForKeySetGroup (null)");
        }
        return null;
    }

    public synchronized Map importSSOPropertiesToKeySetGroup(Properties ssoProps, byte[] password, Session session, Boolean updateRuntime) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importSSOProperties");
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        String type = ManagementScopeManager.getInstance().getProcessType();
        if (type != null && (type.equals("DeploymentManager") || type.equals("UnManagedProcess") || type.equals("JobManager") || type.equals("AdminAgent"))) {
            Boolean saveConfig = Boolean.FALSE;
            if (session == null) {
                session = new Session();
                saveConfig = Boolean.TRUE;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Executing importSSOProperties");
            }
            String sharedKeyString = ssoProps.getProperty(SHARED_KEY_PROPERTY);
            String privateKeyString = ssoProps.getProperty(PRIVATE_KEY_PROPERTY);
            String publicKeyString = ssoProps.getProperty(PUBLIC_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Shared key: " + sharedKeyString);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Private key: " + privateKeyString);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Public key: " + publicKeyString);
            }
            SecretKeySpec key = null;
            KeyPair pair = null;
            HashMap<String, Serializable> keyMap = new HashMap<String, Serializable>();
            try {
                this.ltpaKeySetGroupName = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("keySetGroup");
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getUserCmd = commandMgr.createCommand("getKeySetGroup");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter("name", this.ltpaKeySetGroupName);
                if (type.equals("DeploymentManager")) {
                    getUserCmd.setParameter("scopeName", ManagementScopeManager.getInstance().getCellScopeName());
                } else {
                    getUserCmd.setParameter("scopeName", ManagementScopeManager.getInstance().getNodeScopeName());
                }
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    AttributeList keySetGroupAttrList = (AttributeList)cmdResult.getResult();
                    List keySetList = (List)ConfigServiceHelper.getAttributeValue(keySetGroupAttrList, CommandConstants.KEY_SET);
                    for (int i = 0; i < keySetList.size(); ++i) {
                        ObjectName refObjName = (ObjectName)keySetList.get(i);
                        KeySet ref = (KeySet)MOFUtil.convertToEObject((Session)session, (ObjectName)refObjName);
                        String keySetName = ref.getName();
                        String keySetScope = ref.getManagementScope().getScopeName();
                        boolean isKeyPair = ref.isIsKeyPair();
                        WSKeyStore wsks = new WSKeyStore(ref.getKeyStore());
                        WSKeySet wskset = new WSKeySet(ref);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating new KeyReference for KeySet: " + keySetName);
                        }
                        commandMgr = CommandMgr.getCommandMgr();
                        getUserCmd = commandMgr.createCommand("createKeyReference");
                        getUserCmd.setConfigSession(session);
                        getUserCmd.setParameter("keySetName", keySetName);
                        getUserCmd.setParameter("keySetScope", keySetScope);
                        getUserCmd.setParameter("keyReferenceSaveConfig", Boolean.FALSE);
                        getUserCmd.execute();
                        cmdResult = getUserCmd.getCommandResult();
                        if (cmdResult.isSuccessful()) {
                            ObjectName keyRefObject = (ObjectName)cmdResult.getResult();
                            KeyReference keyRef = (KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)keyRefObject);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "New KeyReference version: " + keyRef.getVersion());
                            }
                            if (isKeyPair) {
                                byte[] encryptedPrivateKey = Base64Coder.base64Decode(privateKeyString.getBytes("UTF8"));
                                byte[] publicKeyBytes = Base64Coder.base64Decode(publicKeyString.getBytes("UTF8"));
                                LTPAPublicKey publicKey = new LTPAPublicKey(publicKeyBytes);
                                byte[] privateKeyBytes = this.getPrivateKey(password, encryptedPrivateKey);
                                LTPAPrivateKey privateKey = new LTPAPrivateKey(privateKeyBytes);
                                pair = new KeyPair(publicKey, (Key)privateKey);
                                WSKeyPairReference pairRef = new WSKeyPairReference(keyRef, pair, wskset, wsks);
                                wskset.addKeyReference(pairRef);
                                int version = keyRef.getVersion();
                                String aliasPrefix = wskset.getAliasPrefix();
                                keyMap.put(aliasPrefix + "_" + version, pair);
                                continue;
                            }
                            byte[] encryptedSharedKey = Base64Coder.base64Decode(sharedKeyString.getBytes("UTF8"));
                            byte[] sharedKey = this.getSharedKey(password, encryptedSharedKey);
                            key = new SecretKeySpec(sharedKey, 0, 24, "3DES");
                            WSKeyReference wsKeyRef = new WSKeyReference(keyRef, (Key)key, wskset, wsks);
                            wskset.addKeyReference(wsKeyRef);
                            int version = keyRef.getVersion();
                            String aliasPrefix = wskset.getAliasPrefix();
                            keyMap.put(aliasPrefix + "_" + version, key);
                            continue;
                        }
                        throw new RemoteException(cmdResult.getException().getMessage());
                    }
                } else {
                    throw new RemoteException(cmdResult.getException().getMessage());
                }
                if (updateRuntime != null && updateRuntime.booleanValue()) {
                    this.objName = this.getMBean();
                    ObjectName on = new ObjectName("WebSphere:type=SecurityAdmin,*");
                    Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                    while (it.hasNext()) {
                        try {
                            on = (ObjectName)it.next();
                            if (this.objName.equals(on)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " SecurityAdmin object name = " + on);
                            }
                            AdminServiceFactory.getAdminService().invoke(on, "updateRuntimeKeys", new Object[]{keyMap}, new String[]{"java.util.Map"});
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.beforeStepsExecuted", "2087", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception on MBean call.", new Object[]{ex});
                            }
                            throw ex;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " SecurityAdmin object name (self) = " + this.objName);
                    }
                    AdminServiceFactory.getAdminService().invoke(this.objName, "updateRuntimeKeys", new Object[]{keyMap}, new String[]{"java.util.Map"});
                }
                if (saveConfig == Boolean.TRUE) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " Saving the security.xml changes.");
                    }
                    cs.save(session, true);
                    cs.discard(session);
                }
                this.traceKeyMap(keyMap);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importSSOProperties (success)");
                }
                return keyMap;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.importSSOPropertiesToKeySetGroup", "2112", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem importing SSO keys.  Using old keys still.");
                }
                Tr.error(tc, "security.ltpa.importkeys", new Object[]{e});
                throw new Exception("Problem importing SSO keys. Using original values. The exception is " + e.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Only import properties in the AdminAgent, JobManager, BASE, UnManagedProcess, or DeploymentManager processes, current process type: " + ManagementScopeManager.getInstance().getProcessType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importSSOProperties (null)");
        }
        return null;
    }

    private ObjectName getMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean");
        }
        if (this.objName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting MBean");
            }
            try {
                String processName = AdminServiceFactory.getAdminService().getProcessName();
                this.objName = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                Iterator it = AdminServiceFactory.getAdminService().queryNames(this.objName, null).iterator();
                if (!it.hasNext()) {
                    Tr.error(tc, "security.ctr.nombean.error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean");
                    }
                    throw new Exception("No SecurityAdmin MBean found: returning null");
                }
                this.objName = (ObjectName)it.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SecurityAdmin object name = " + this.objName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean");
                }
                return this.objName;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.ltpa.LTPAServerObject.getMBean", "2152", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{ex});
                }
                throw ex;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return this.objName;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void generateKeys(byte[] password) throws RemoteException {
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.entry(LTPAServerObject.tc, "generateKeys");
        }
        this.adminPassword = password;
        if (LTPAServerObject.sharedKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPubKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPrivKey != null) {
            encryptor = new KeyEncryptor(this.adminPassword);
            pair = LTPADigSignature.generateLTPAKeyPair();
            this.publicKey = pair.getPublic().getEncoded();
            this.privateKey = pair.getPrivate().getEncoded();
            LTPAServerObject.ltpaPubKey = new LTPAPublicKey(this.publicKey);
            LTPAServerObject.ltpaPrivKey = new LTPAPrivateKey(this.privateKey);
            this.encryptedPrivateKey = encryptor.encrypt((byte[])this.privateKey.clone());
            new LTPACrypto();
            LTPAServerObject.sharedKey = LTPACrypto.generate3DESKey();
            this.encryptedSharedKey = encryptor.encrypt((byte[])LTPAServerObject.sharedKey.clone());
            this.refreshTokenFactories();
        } else lbl-1000:
        // 3 sources

        {
            this.generateKeysForKeySetGroup(null, Boolean.TRUE);
        }
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.exit(LTPAServerObject.tc, "generateKeys");
        }
    }

    public Properties genKeys(byte[] password) throws Exception {
        Properties expProps;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "genKeys");
            }
            KeyEncryptor encryptor = new KeyEncryptor(password);
            byte[] publicKey = null;
            byte[] privateKey = null;
            LTPAKeyPair pair = LTPADigSignature.generateLTPAKeyPair();
            publicKey = pair.getPublic().getEncoded();
            privateKey = pair.getPrivate().getEncoded();
            byte[] encryptedPrivateKey = encryptor.encrypt((byte[])privateKey.clone());
            new LTPACrypto();
            byte[] sharedKey = LTPACrypto.generate3DESKey();
            byte[] encryptedSharedKey = encryptor.encrypt((byte[])sharedKey.clone());
            byte[] tmpShared = Base64Coder.base64Encode(encryptedSharedKey);
            byte[] tmpPrivate = Base64Coder.base64Encode(encryptedPrivateKey);
            byte[] tmpPublic = Base64Coder.base64Encode(publicKey);
            expProps = new Properties();
            try {
                String principalName;
                expProps.put(SHARED_KEY_PROPERTY, new String(tmpShared, "UTF8"));
                expProps.put(PRIVATE_KEY_PROPERTY, new String(tmpPrivate, "UTF8"));
                expProps.put(PUBLIC_KEY_PROPERTY, new String(tmpPublic, "UTF8"));
                expProps.put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
                expProps.put(CREATION_DATE_PROPERTY, new Date().toString());
                String myString = InetAddress.getLocalHost().getHostName();
                expProps.put(CREATION_HOST_PROPERTY, myString);
                ORB orb = EJSORB.getORBInstance();
                if (orb != null && (principalName = orb.getProperty("com.ibm.CORBA.principalName")) != null && principalName.length() > 0) {
                    expProps.put(LDAP_REALM_PROPERTY, principalName.substring(0, principalName.indexOf(realmSeparator)));
                }
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.genKeys", "2249", this);
                Tr.error(tc, "security.ltpa.exportkeys", new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported encoding: UTF8");
                }
                throw new Exception(e.getMessage());
            }
            catch (UnknownHostException e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unknown host exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genKeys");
        }
        return expProps;
    }

    public void checkImportSSOProperties(Properties ssoProps, byte[] password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkImportSSOProperties");
        }
        String sharedKeyString = ssoProps.getProperty(SHARED_KEY_PROPERTY);
        String privateKeyString = ssoProps.getProperty(PRIVATE_KEY_PROPERTY);
        String publicKeyString = ssoProps.getProperty(PUBLIC_KEY_PROPERTY);
        try {
            byte[] new_encryptedSharedKey_1 = Base64Coder.base64Decode(sharedKeyString.getBytes("UTF8"));
            byte[] new_encryptedPrivateKey_1 = Base64Coder.base64Decode(privateKeyString.getBytes("UTF8"));
            byte[] new_publicKey_1 = Base64Coder.base64Decode(publicKeyString.getBytes("UTF8"));
            LTPAPublicKey new_ltpaPubKey_1 = new LTPAPublicKey(new_publicKey_1);
            byte[] new_privateKey_1 = this.getPrivateKey(password, new_encryptedPrivateKey_1);
            LTPAPrivateKey new_ltpaPrivKey_1 = new LTPAPrivateKey(new_privateKey_1);
            byte[] new_sharedKey_1 = this.getSharedKey(password, new_encryptedSharedKey_1);
        }
        catch (NullPointerException npe) {
            FFDCFilter.processException((Throwable)npe, "com.ibm.ws.security.ltpa.LTPAServerObject.checkImportSSOProperties", "2285", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem importingSSO keys. Using original values. Make sure that the password is correct.");
            }
            Tr.error(tc, "security.ltpa.checkimportltpakeys", new Object[]{npe});
            throw new Exception("Problem importingSSO keys. Using original values. Make sure the password is correct.");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.checkImportSSOProperties", "2292", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem importingSSO keys. Using original values.");
            }
            Tr.error(tc, "security.ltpa.checkimportltpakeys", new Object[]{e});
            throw new Exception("Problem importingSSO keys. Using original values. Check the Password. The exception is " + e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void importSSOProperties(Properties ssoProps, byte[] password) throws Exception {
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.entry(LTPAServerObject.tc, "importSSOProperties");
        }
        this.new_adminPassword = password;
        sharedKeyString = ssoProps.getProperty("com.ibm.websphere.ltpa.3DESKey");
        privateKeyString = ssoProps.getProperty("com.ibm.websphere.ltpa.PrivateKey");
        publicKeyString = ssoProps.getProperty("com.ibm.websphere.ltpa.PublicKey");
        try {
            this.new_encryptedSharedKey = Base64Coder.base64Decode(sharedKeyString.getBytes("UTF8"));
            this.new_encryptedPrivateKey = Base64Coder.base64Decode(privateKeyString.getBytes("UTF8"));
            this.new_publicKey = Base64Coder.base64Decode(publicKeyString.getBytes("UTF8"));
            LTPAServerObject.new_ltpaPubKey = new LTPAPublicKey(this.new_publicKey);
            this.new_privateKey = this.getPrivateKey(password, this.new_encryptedPrivateKey);
            LTPAServerObject.new_ltpaPrivKey = new LTPAPrivateKey(this.new_privateKey);
            this.new_sharedKey = this.getSharedKey(password, this.new_encryptedSharedKey);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.importSSOProperties", "2330", this);
            if (LTPAServerObject.tc.isDebugEnabled()) {
                Tr.debug(LTPAServerObject.tc, "Problem importingSSO keys. Using original values.");
            }
            Tr.error(LTPAServerObject.tc, "security.ltpa.importkeys", new Object[]{e});
            throw new Exception("Problem importingSSO keys. Using original values. The exception is " + e.getMessage());
        }
        if (LTPAServerObject.sharedKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPubKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPrivKey != null) {
            this.adminPassword = this.new_adminPassword;
            this.encryptedSharedKey = this.new_encryptedSharedKey;
            this.encryptedPrivateKey = this.new_encryptedPrivateKey;
            this.publicKey = this.new_publicKey;
            this.privateKey = this.new_privateKey;
            LTPAServerObject.ltpaPubKey = LTPAServerObject.new_ltpaPubKey;
            LTPAServerObject.ltpaPrivKey = LTPAServerObject.new_ltpaPrivKey;
            LTPAServerObject.sharedKey = this.new_sharedKey;
            this.refreshTokenFactories();
        } else lbl-1000:
        // 3 sources

        {
            this.importSSOPropertiesToKeySetGroup(ssoProps, password, null, Boolean.TRUE);
        }
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.exit(LTPAServerObject.tc, "importSSOProperties");
        }
    }

    public Properties exportSSOProperties(byte[] password) throws Exception {
        Properties expProps;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "exportSSOProperties");
            }
            KeyEncryptor encryptor = null;
            encryptor = password != null ? new KeyEncryptor(password) : new KeyEncryptor(this.adminPassword);
            byte[] tmpShared = null;
            byte[] tmpPrivate = null;
            byte[] tmpPublic = null;
            if (this.encryptedSharedKey != null && this.encryptedPrivateKey != null && this.publicKey != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exporting the old-style keys.");
                }
                tmpShared = Base64Coder.base64Encode(this.encryptedSharedKey);
                tmpPrivate = Base64Coder.base64Encode(this.encryptedPrivateKey);
                tmpPublic = Base64Coder.base64Encode(this.publicKey);
            } else if (this.generationKeys == null) {
                this.initializeKeySetGroupKeys();
            } else {
                this.generationKeys = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName).getLatestKeys();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Latest keys: " + this.generationKeys);
                }
            }
            if (this.generationKeys != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exporting the latest keys from the KeySetGroup.");
                }
                LTPAPublicKey tempLTPAPubKey = null;
                LTPAPrivateKey tempLTPAPrivKey = null;
                byte[] tempSharedKey = null;
                for (String keyAlias : this.generationKeys.keySet()) {
                    Object key = this.generationKeys.get(keyAlias);
                    if (key instanceof Key) {
                        tempSharedKey = ((Key)key).getEncoded();
                        tmpShared = Base64Coder.base64Encode(encryptor.encrypt((byte[])tempSharedKey.clone()));
                        continue;
                    }
                    if (!(key instanceof KeyPair)) continue;
                    Key publicKeyAsSecret = ((KeyPair)key).getPublicKey();
                    tempLTPAPubKey = new LTPAPublicKey(publicKeyAsSecret.getEncoded());
                    Key privateKeyAsSecret = ((KeyPair)key).getPrivateKey();
                    tempLTPAPrivKey = new LTPAPrivateKey(privateKeyAsSecret.getEncoded());
                    byte[] publicKey = tempLTPAPubKey.getEncoded();
                    byte[] privateKey = tempLTPAPrivKey.getEncoded();
                    byte[] encryptedPrivateKey = encryptor.encrypt((byte[])privateKey.clone());
                    tmpPrivate = Base64Coder.base64Encode(encryptedPrivateKey);
                    tmpPublic = Base64Coder.base64Encode(publicKey);
                }
            } else {
                Exception e = new Exception("Keys do not exist. Make sure the LTPA configuration is setup");
                Tr.error(tc, "security.ltpa.importkeys", new Object[]{e});
                throw e;
            }
            expProps = new Properties();
            try {
                String principalName;
                expProps.put(SHARED_KEY_PROPERTY, new String(tmpShared, "UTF8"));
                expProps.put(PRIVATE_KEY_PROPERTY, new String(tmpPrivate, "UTF8"));
                expProps.put(PUBLIC_KEY_PROPERTY, new String(tmpPublic, "UTF8"));
                expProps.put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
                expProps.put(CREATION_DATE_PROPERTY, new Date().toString());
                String myString = InetAddress.getLocalHost().getHostName();
                expProps.put(CREATION_HOST_PROPERTY, myString);
                ORB orb = EJSORB.getORBInstance();
                if (orb != null && (principalName = orb.getProperty("com.ibm.CORBA.principalName")) != null && principalName.length() > 0) {
                    expProps.put(LDAP_REALM_PROPERTY, principalName.substring(0, principalName.indexOf(realmSeparator)));
                }
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.exportSSOProperties", "2472", this);
                Tr.error(tc, "security.ltpa.exportkeys", new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported encoding: UTF8");
                }
                throw new Exception(e.getMessage());
            }
            catch (UnknownHostException e) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Unknown host exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportSSOProperties");
        }
        return expProps;
    }

    public byte[] issueLoginToken(BasicAuthData data) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "issueLoginToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "issueLoginToken");
        }
        throw new RemoteException("issueLoginToken not implemented");
    }

    private static byte[] toBytes(String str) {
        byte[] b = null;
        try {
            b = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Tr.debug(tc, "to UTF8 bytes =" + uee.toString());
        }
        return b;
    }

    static UserRegistryImpl getUserRegistry() {
        return (UserRegistryImpl)SecurityServerImpl.getRegistryImpl();
    }

    static UserRegistryImpl getUserRegistry(String realm) {
        return (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(realm);
    }

    static boolean useFIPS() {
        return _useFIPS;
    }

    static boolean forceSoftwareJCEProviderForLTPA() {
        return _forceSoftwareJCEProviderForLTPA;
    }

    static String defaultJCEProvider() {
        return _defaultJCEProvider;
    }

    public synchronized Map importLTPAKeysToKeySetGroup(String privateKeyString, String publicKeyString, String sharedKeyString, byte[] password, Session session, com.ibm.websphere.models.config.security.Security security2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importLTPAKeysToKeySetGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "privateKeyString: " + privateKeyString);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "publicKeyString: " + publicKeyString);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sharedKeyString: " + sharedKeyString);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "password: " + password);
        }
        Boolean saveConfig = Boolean.FALSE;
        if (session == null) {
            session = new Session();
            saveConfig = Boolean.TRUE;
        }
        SecretKeySpec key = null;
        KeyPair pair = null;
        HashMap<String, Serializable> keyMap = new HashMap<String, Serializable>();
        try {
            WSKeySetGroup keySetGroup;
            EList keyStoreEntries = security2.getKeyStores();
            if (keyStoreEntries != null) {
                for (KeyStore entry : keyStoreEntries) {
                    String name = entry.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key store Name:" + name);
                    }
                    if (!name.endsWith("LTPAKeys")) continue;
                    String location = KeyStoreManager.getInstance().expand(entry.getLocation());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key store location:" + location);
                    }
                    entry.setLocation(location);
                }
            }
            for (Object o : security2.getAuthMechanisms()) {
                LTPA ltpa;
                if (!(o instanceof LTPA) || (ltpa = (LTPA)o) == null) continue;
                KeyStoreManager.getInstance().loadKeyStores(security2);
                KeySetManager.getInstance().initializeKeySets(security2, true);
                KeySetGroupManager.getInstance().initializeKeySetGroups(security2, true);
                this.ltpaKeySetGroupName = ((LTPA)security2.getActiveAuthMechanism()).getKeySetGroup().getName();
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaKeySetGroupName:" + this.ltpaKeySetGroupName);
            }
            if ((keySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName)) != null) {
                keySetGroup.getLatestKeys();
            }
            WSKeySet[] keySets = keySetGroup.getAllKeySets();
            for (int i = 0; i < keySets.length; ++i) {
                String keySetName = keySets[i].getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetName:" + keySetName);
                }
                String keySetScope = keySets[i].getManagementScopeName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetScope:" + keySetScope);
                }
                boolean isKeyPair = keySets[i].getIsKeyPair();
                WSKeyStore wsks = keySets[i].getWSKeyStore();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new KeyReference for KeySet: " + keySetName);
                }
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getUserCmd = commandMgr.createCommand("createKeyReference");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter("keySetName", keySetName);
                getUserCmd.setParameter("keySetScope", keySetScope);
                getUserCmd.setParameter("keyReferenceSaveConfig", saveConfig);
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    ObjectName keyRefObject = (ObjectName)cmdResult.getResult();
                    KeyReference keyRef = (KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)keyRefObject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New KeyReference version: " + keyRef.getVersion());
                    }
                    if (isKeyPair) {
                        byte[] encryptedPrivateKey = Base64Coder.base64Decode(privateKeyString.getBytes("UTF8"));
                        byte[] publicKeyBytes = Base64Coder.base64Decode(publicKeyString.getBytes("UTF8"));
                        LTPAPublicKey publicKey = new LTPAPublicKey(publicKeyBytes);
                        byte[] privateKeyBytes = this.getPrivateKey(password, encryptedPrivateKey);
                        LTPAPrivateKey privateKey = new LTPAPrivateKey(privateKeyBytes);
                        pair = new KeyPair(publicKey, (Key)privateKey);
                        WSKeyPairReference pairRef = new WSKeyPairReference(keyRef, pair, keySets[i], wsks);
                        keySets[i].addKeyReference(pairRef);
                        int version = keyRef.getVersion();
                        String aliasPrefix = keySets[i].getAliasPrefix();
                        keyMap.put(aliasPrefix + "_" + version, pair);
                        continue;
                    }
                    byte[] encryptedSharedKey = Base64Coder.base64Decode(sharedKeyString.getBytes("UTF8"));
                    byte[] sharedKey = this.getSharedKey(password, encryptedSharedKey);
                    key = new SecretKeySpec(sharedKey, 0, 24, "3DES");
                    WSKeyReference wsKeyRef = new WSKeyReference(keyRef, (Key)key, keySets[i], wsks);
                    keySets[i].addKeyReference(wsKeyRef);
                    int version = keyRef.getVersion();
                    String aliasPrefix = keySets[i].getAliasPrefix();
                    keyMap.put(aliasPrefix + "_" + version, key);
                    continue;
                }
                throw new RemoteException(cmdResult.getException().getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importLTPAKeysToKeySetGroup (success)");
            }
            return keyMap;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.importLTPAKeysToKeySetGroup", "2690", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem importing previous version keys. ");
            }
            Tr.error(tc, "security.ltpa.importLTPAKeysToKeySetGroup", new Object[]{e});
            throw new Exception("Problem importing previous version keys. The exception is " + e.getMessage());
        }
    }

    private void traceKeyMap(Map generationKeys) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "traceKeyMap using LTPA password \"WebAS\" to produce encrypted key strings.");
            }
            try {
                if (generationKeys != null) {
                    KeyEncryptor encryptor = new KeyEncryptor("WebAS".getBytes("UTF8"));
                    LTPAPublicKey tempLTPAPubKey = null;
                    LTPAPrivateKey tempLTPAPrivKey = null;
                    byte[] tempSharedKey = null;
                    byte[] tmpShared = null;
                    byte[] tmpPrivate = null;
                    byte[] tmpPublic = null;
                    for (String keyAlias : generationKeys.keySet()) {
                        Object key = generationKeys.get(keyAlias);
                        if (key instanceof Key) {
                            tempSharedKey = ((Key)key).getEncoded();
                            tmpShared = Base64Coder.base64Encode(encryptor.encrypt((byte[])tempSharedKey.clone()));
                            continue;
                        }
                        if (!(key instanceof KeyPair)) continue;
                        Key publicKeyAsSecret = ((KeyPair)key).getPublicKey();
                        tempLTPAPubKey = new LTPAPublicKey(publicKeyAsSecret.getEncoded());
                        Key privateKeyAsSecret = ((KeyPair)key).getPrivateKey();
                        tempLTPAPrivKey = new LTPAPrivateKey(privateKeyAsSecret.getEncoded());
                        byte[] publicKey = tempLTPAPubKey.getEncoded();
                        byte[] privateKey = tempLTPAPrivKey.getEncoded();
                        byte[] encryptedPrivateKey = encryptor.encrypt((byte[])privateKey.clone());
                        tmpPrivate = Base64Coder.base64Encode(encryptedPrivateKey);
                        tmpPublic = Base64Coder.base64Encode(publicKey);
                    }
                    String sharedString = new String(tmpShared, "UTF8");
                    String privateString = new String(tmpPrivate, "UTF8");
                    String publicString = new String(tmpPublic, "UTF8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Shared key: " + sharedString);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Public key: " + publicString);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Private key: " + privateString);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keys do not exist. Make sure the LTPA configuration is setup");
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Could not trace keys, received exception.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "traceKeyMap");
        }
    }

    private void traceValidationKeys(Map _validationKeys) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "traceValidationKeys");
        }
        if (_validationKeys != null) {
            for (Map keyMap : _validationKeys.values()) {
                if (keyMap == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validation keyMap: " + keyMap);
                }
                this.traceKeyMap(keyMap);
            }
        }
    }

    public void realmsMatch(Token token) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "realmsMatch");
        }
        boolean userFromThisRealm = false;
        boolean userFromTrustedRealm = false;
        try {
            String[] accessID = token.getAttributes("u");
            if (accessID != null && accessID[0] != null) {
                userFromThisRealm = CrossRealmUtil.isUserFromThisRealm(accessID[0]);
                if (!userFromThisRealm) {
                    userFromTrustedRealm = CrossRealmUtil.isUserFromTrustedForeignRealm(accessID[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "user: " + accessID[0] + " is not from this realm: is user from trusted foreign relam: " + new Boolean(userFromTrustedRealm));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user: " + accessID[0] + " is from this realm");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encountered a null accessID attribute in token");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsMapDefaultInboundLoginModule.login", "2819", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exception checking for realms match.");
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (!userFromThisRealm && !userFromTrustedRealm) {
            throw new WSLoginFailedException("the realms do not match");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "realmsMatch true");
        }
    }

    public WSCredential authenticateAppUser(BasicAuthData authData) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticateAppUser");
        }
        WSCredential cred = null;
        try {
            if (LTPAServerObject.getUserRegistry() == null) {
                ContextManager ctxMgr = ContextManagerFactory.getInstance();
                cred = ctxMgr.getUnauthenticatedCredential();
            }
            if (cred == null) {
                String user = LTPAServerObject.getAppUserRegistry().checkPassword(authData.getUserid(), authData.getPassword());
                cred = LTPAServerObject.getAppUserRegistry().createCredential(user);
            }
            if (cred == null) {
                throw new WSLoginFailedException("Credential returned by createCredential is null");
            }
            cred = this.createLTPAToken(cred);
        }
        catch (WSLoginFailedException e) {
            throw e;
        }
        catch (TokenCreationFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", "2868", this);
            Tr.error(tc, "security.ltpa.authenticate", new Object[]{e.getMessage()});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", "2874", this);
            Tr.error(tc, "security.ltpa.authenticate", new Object[]{e.getMessage()});
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticateAppUser", cred);
        }
        return cred;
    }

    static UserRegistryImpl getAppUserRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppUserRegistry");
        }
        return (UserRegistryImpl)SecurityServerImpl.getAppRegistryImpl(DomainInfo.getAppRealm());
    }

    public String getDomainId() {
        return this._domainId;
    }

    public void setDomainId(String id) {
        this._domainId = id;
    }

    public String toString() {
        return "LTPAServerObject: " + this.hashCode() + " domainId: " + this.getDomainId();
    }

    static {
        CURRENT_LTPA_VERSION = "1.0";
        _useFIPS = false;
        _forceSoftwareJCEProviderForLTPA = false;
        _defaultJCEProvider = "IBMJCE";
        scm = null;
        instanceCache = new ConcurrentHashMap();
        primaryTokenFactoryMap = new HashMap();
        secondaryTokenFactoryMap = new HashMap();
        ACCESS_LTPA_SERVER_OBJECT = new WebSphereRuntimePermission("accessLTPAServerObject");
        MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
        tokenFactoryPredictionMap = new HashMap();
    }

    final class FactoryPrediction {
        int length = 0;
        int factoryNumber = 0;
        long[] statistics;

        public FactoryPrediction() {
            this.statistics = new long[LTPAServerObject.this.primaryTokenFactoryList.size()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void addResult(int length, int factoryNumber) {
            int i;
            if (length == this.length && factoryNumber == this.factoryNumber) {
                return;
            }
            int n = factoryNumber;
            this.statistics[n] = this.statistics[n] + 1L;
            if (this.statistics[factoryNumber] > 1000L) {
                long[] lArray = this.statistics;
                // MONITORENTER : this.statistics
                long min = 1L;
                for (i = 1; i < this.statistics.length; ++i) {
                    if (this.statistics[i] <= 0L || this.statistics[i] >= min) continue;
                    min = this.statistics[i];
                }
                --min;
                i = 0;
                while (i < this.statistics.length) {
                    int n2 = i++;
                    this.statistics[n2] = this.statistics[n2] - min;
                }
                // MONITOREXIT : lArray
            }
            int maxFactoryNumber = 0;
            long max = this.statistics[0];
            i = 1;
            while (true) {
                if (i >= this.statistics.length) {
                    this.factoryNumber = maxFactoryNumber;
                    return;
                }
                if (this.statistics[i] > max) {
                    maxFactoryNumber = i;
                    max = this.statistics[i];
                }
                ++i;
            }
        }

        public int getFactoryNumber() {
            return this.factoryNumber;
        }
    }
}

