/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.util.ByteArray;
import java.security.PrivateKey;

public final class LTPAPrivateKey
implements PrivateKey {
    private byte[][] rawKey;
    private byte[] encodedKey;
    private int eLength = 3;
    private int pLength = 65;
    private int qLength = 65;
    private int privExponentLength;

    public LTPAPrivateKey() {
    }

    LTPAPrivateKey(byte[][] key) {
        this.rawKey = key;
        LTPACrypto.setRSAKey(key);
        this.privExponentLength = key[1].length;
        this.encodedKey = this.encode();
    }

    LTPAPrivateKey(byte[] encKey) {
        this.encodedKey = encKey;
        this.rawKey = this.decode(encKey);
    }

    private byte[][] decode(byte[] encPrivKey) {
        byte[][] tmpPub = new byte[8][];
        if (encPrivKey.length > this.eLength + this.pLength + this.qLength) {
            byte[] lengthBytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                lengthBytes[i] = encPrivKey[i];
            }
            this.privExponentLength = LTPAPrivateKey.toInt(lengthBytes);
            tmpPub[1] = new byte[this.privExponentLength];
            tmpPub[2] = new byte[this.eLength];
            tmpPub[3] = new byte[this.pLength];
            tmpPub[4] = new byte[this.qLength];
            ByteArray.copy(encPrivKey, 4, this.privExponentLength, tmpPub[1], 0);
            ByteArray.copy(encPrivKey, this.privExponentLength + 4, this.eLength, tmpPub[2], 0);
            ByteArray.copy(encPrivKey, this.privExponentLength + this.eLength + 4, this.pLength, tmpPub[3], 0);
            ByteArray.copy(encPrivKey, this.privExponentLength + this.eLength + this.pLength + 4, this.qLength, tmpPub[4], 0);
        } else {
            tmpPub[2] = new byte[this.eLength];
            tmpPub[3] = new byte[this.pLength];
            tmpPub[4] = new byte[this.qLength];
            ByteArray.copy(encPrivKey, 0, this.eLength, tmpPub[2], 0);
            ByteArray.copy(encPrivKey, this.eLength, this.pLength, tmpPub[3], 0);
            ByteArray.copy(encPrivKey, this.eLength + this.pLength, this.qLength, tmpPub[4], 0);
        }
        return tmpPub;
    }

    private byte[] encode() {
        int privLen = this.privExponentLength + this.eLength + this.pLength + this.qLength + 4;
        byte[] encPrivKey = new byte[privLen];
        byte[] lengthBytes = LTPAPrivateKey.toByteArray(this.privExponentLength);
        ByteArray.copy(lengthBytes, 0, 4, encPrivKey, 0);
        ByteArray.copy(this.rawKey[1], 0, this.privExponentLength, encPrivKey, 4);
        ByteArray.copy(this.rawKey[2], 0, this.eLength, encPrivKey, this.privExponentLength + 4);
        ByteArray.copy(this.rawKey[3], 0, this.pLength, encPrivKey, this.privExponentLength + this.eLength + 4);
        ByteArray.copy(this.rawKey[4], 0, this.qLength, encPrivKey, this.privExponentLength + this.pLength + this.eLength + 4);
        this.encodedKey = (byte[])encPrivKey.clone();
        return encPrivKey;
    }

    public boolean equals(Object object) {
        byte[] enc2;
        int len;
        if (this == object) {
            return true;
        }
        if (object instanceof LTPAPrivateKey && (len = this.encodedKey.length) == (enc2 = ((LTPAPrivateKey)object).getEncoded()).length) {
            for (int i = 0; i < len; ++i) {
                if (this.encodedKey[i] == enc2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAlgorithm() {
        return "RSA/SHA-1";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        return this.encode();
    }

    public String getFormat() {
        return "LTPAFormat";
    }

    byte[][] getRawKey() {
        return (byte[][])this.rawKey.clone();
    }

    public static int toInt(byte[] byteVal) {
        int i = byteVal[3] & 0xFF;
        i |= byteVal[2] << 8 & 0xFF00;
        i |= byteVal[1] << 16 & 0xFF0000;
        return i |= byteVal[0] << 24 & 0xFF000000;
    }

    public static byte[] toByteArray(int a) {
        byte[] b = new byte[]{(byte)(a >>> 24 & 0xFF), (byte)(a >>> 16 & 0xFF), (byte)(a >>> 8 & 0xFF), (byte)(a >>> 0 & 0xFF)};
        return b;
    }
}

