/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.UserMappingException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;

public class UserMappingImpl
implements UserMapping {
    private static final TraceComponent tc = Tr.register(UserMappingImpl.class, null, "com.ibm.ejs.resources.security");
    private static UserRegistry registry;
    private UserMapping customMapping;
    public static final String MAPPING_USERS_PROPERTY = "WAS_customUserMappingImpl";

    public String mapCertificateToName(X509Certificate[] cert) throws UserMappingException, NotImplementedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificateToName");
        }
        String name = null;
        boolean isCustom = this.checkCustomMapping();
        if (isCustom) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using customMapping for certificates");
            }
            try {
                name = this.customMapping.mapCertificateToName(cert);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapCertificateToName", name);
                }
                return name;
            }
            catch (NotImplementedException e) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using defaultMapping for certificate mapping");
        }
        if (registry == null) {
            registry = this.getUserRegistry();
        }
        try {
            name = registry.mapCertificate(cert);
        }
        catch (CertificateMapNotSupportedException e) {
            int index1;
            String s;
            int index;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The user registry does not support mapCertificate. Mapping using first name in the certificate");
            }
            name = (index = (s = cert[0].getSubjectDN().getName()).indexOf("=")) == -1 ? s : ((index1 = s.indexOf(",")) == -1 ? s.substring(index + 1) : s.substring(index + 1, index1));
        }
        catch (CertificateMapFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.UserMappingImpl.mapCertificateToName", "87", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception occurred in UserMappingImpl when calling mapCertificate: ", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapCertificateToName");
            }
            throw new UserMappingException(e.getMessage());
        }
        catch (CustomRegistryException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.UserMappingImpl.mapCertificateToName", "92", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception occurred in UserMappingImpl when calling mapCertificate: ", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapCertificateToName");
            }
            throw new UserMappingException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.UserMappingImpl.mapCertificateToName", "97", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception occurred in UserMappingImpl when calling mapCertificate: ", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapCertificateToName");
            }
            throw new UserMappingException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificateToName", name);
        }
        return name;
    }

    public String mapDNToName(String dn) throws UserMappingException, NotImplementedException {
        int index1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapDNToName", dn);
        }
        String name = null;
        boolean isCustom = this.checkCustomMapping();
        if (isCustom) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using customMapping for DN mapping");
            }
            try {
                name = this.customMapping.mapDNToName(dn);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapDNToName", name);
                }
                return name;
            }
            catch (NotImplementedException e) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using defaultMapping for DN mapping");
        }
        if (SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getType().equals("LDAP")) {
            block14: {
                Boolean isEASupported = SecurityObjectLocator.getSecurityConfig().getPropertyBool("com.ibm.websphere.security.expandX500ExtendedAttribute", false);
                if (isEASupported.booleanValue() && dn.indexOf("2.5.4.46=#") != -1) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Convert OID:2.5.4.46 to DNQUALIFIER");
                        }
                        X500Principal tempX500 = new X500Principal(dn);
                        dn = tempX500.toString();
                    }
                    catch (Throwable t) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Fail to Convert OID:2.5.4.46 to DNQUALIFIER, use the original DN.");
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapDNToName", dn);
            }
            return dn;
        }
        int index = dn.indexOf("=");
        name = index == -1 ? dn : ((index1 = dn.indexOf(",")) == -1 ? dn.substring(index + 1) : dn.substring(index + 1, index1));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapDNToName", name);
        }
        return name;
    }

    public String mapPrincipalToName(String principalName) throws UserMappingException, NotImplementedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapPrincipalToName");
        }
        String name = null;
        boolean isCustom = this.checkCustomMapping();
        if (isCustom) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using customMapping for Principal mapping");
            }
            try {
                name = this.customMapping.mapPrincipalToName(principalName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapPrincipalToName", name);
                }
                return name;
            }
            catch (NotImplementedException e) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using defaultMapping for Principal mapping");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapPrincipalToName", principalName);
        }
        return principalName;
    }

    private boolean checkCustomMapping() throws UserMappingException {
        Properties toplevel_props;
        String mappingUsers;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCustomMapping");
        }
        if ((mappingUsers = (String)(toplevel_props = SecurityObjectLocator.getSecurityConfig().getProperties()).get(MAPPING_USERS_PROPERTY)) != null && mappingUsers.trim().length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using custom mapping for certificates: " + mappingUsers);
            }
            try {
                Class<?> wrapperClass = ExtClassLoader.getInstance().loadClass(mappingUsers);
                Object wrapperObj = wrapperClass.newInstance();
                this.customMapping = (UserMapping)wrapperObj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom user mapping: " + mappingUsers + " successfully loaded");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCustomMapping", "true");
                }
                return true;
            }
            catch (Throwable e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.core.UserMappingImpl.mapCertificateToName", "126", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The following exception occurred in UserMappingImpl when loading the custom implementation: ", new Object[]{e});
                }
                throw new UserMappingException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCustomMapping", "false");
        }
        return false;
    }

    private UserRegistry getUserRegistry() throws UserMappingException {
        ContextManager contextMgr;
        Object ic = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UserMapping:getUserRegistry");
        }
        if ((contextMgr = ContextManagerFactory.getInstance()) != null) {
            try {
                registry = contextMgr.getRegistry(contextMgr.getDefaultRealm());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.core.UserMappingImpl.getUserRegistry", "142");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get registry from ContextManager");
                }
                Tr.error(tc, "security.sambean.urerr", new Object[]{e});
                throw new UserMappingException(e.getMessage());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to get ContextManager");
            }
            Tr.error(tc, "security.sambean.nullsecserver");
            throw new UserMappingException("Unable to get ContextManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UserMapping:getUserRegistry");
        }
        return registry;
    }
}

