/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.bind.ApplicationBindingAdapter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.delegation.DelegationFactory;
import com.ibm.ws.security.ejb.BeanPermissionRoleMapTable;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.util.DomainContextHelper;
import com.ibm.ws.security.web.SecurityMetaDataListener;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.WebModule;

public final class ServerSecurityComponentImpl
extends ComponentImpl
implements DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ServerSecurityComponentImpl.class, null, "com.ibm.ejs.resources.security");
    private static final String DENYALL_ROLE_NAME = "DenyAllRole";
    private static boolean svrSecurityEnabled = true;
    private SecurityServer secServer = null;
    Hashtable webModulesMap;
    private MetaDataSlot mmdSlot;
    private MetaDataSlot cmdSlot;
    private static AppInstallNotify appInstallNotify = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", config);
            }
            System.gc();
            if (this.isNodeAgent()) {
                Tr.exit(tc, "initialize");
                return;
            }
            svrSecurityEnabled = SecurityObjectLocator.getSecurityConfig().getBoolean("enabled");
            if (tc.isDebugEnabled()) {
                if (svrSecurityEnabled) {
                    Tr.debug(tc, "serverSecurityEnabled");
                } else {
                    Tr.debug(tc, "serverSecurityDisabled");
                }
            }
            Object repository2 = null;
            try {
                try {
                    this.webModulesMap = new Hashtable();
                    if (svrSecurityEnabled) {
                        List list = null;
                        String resourceName = "server.xml";
                        try {
                            ConfigService service = WsServiceRegistry.getService(this, ConfigService.class);
                            list = service.getDocumentObjects(service.getScope(4), resourceName);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.initialize", "226", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to load resource from process :  ", resourceName);
                            }
                            Object var19_8 = null;
                            if (repository2 != null) {
                                this.releaseService(repository2);
                            }
                            return;
                        }
                        ConfigObject server = (ConfigObject)list.get(0);
                        Properties connectorProps = this.getServerAdminProps(server);
                        SecurityObjectLocator.getSecurityConfig().setObject("process.jmxConnectorProps", connectorProps);
                        VirtualHostMgr vHostMgr = (VirtualHostMgr)this.getService(VirtualHostMgr.class);
                        HashMap<String, Object> vHostMap = new HashMap<String, Object>();
                        VirtualHost vHost = null;
                        VirtualHost[] vHosts = vHostMgr.getVirtualHosts();
                        for (int k = 0; k < vHosts.length; ++k) {
                            vHost = vHosts[k];
                            String vHostName = vHost.getName();
                            Alias[] aliases = vHost.getAliases();
                            ArrayList<String> portList = new ArrayList<String>();
                            for (int i = 0; i < aliases.length; ++i) {
                                Alias hAlias = aliases[i];
                                String sPort = hAlias.getPort();
                                portList.add(sPort);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Adding port " + sPort + " to list for vHost " + vHostName);
                            }
                            vHostMap.put(vHostName, portList.clone());
                        }
                        SecurityObjectLocator.getSecurityConfig().setObject("host.virtualhosts", vHostMap);
                        if (vHostMgr != null) {
                            this.releaseService(vHostMgr);
                        }
                        EndPointMgr endPointMgr = (EndPointMgr)this.getService(EndPointMgr.class);
                        SecurityObjectLocator.getSecurityConfig().setObject("webcontainer.transports", this.updateHTTPTransports(server, endPointMgr));
                        if (endPointMgr != null) {
                            this.releaseService(endPointMgr);
                        }
                    }
                    this.refreshAuthDataEntries();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.initialize", "274", this);
                    Tr.warning(tc, "security.servcomp.init");
                    Object var19_10 = null;
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                    break block21;
                }
                Object var19_9 = null;
                if (repository2 == null) break block21;
            }
            catch (Throwable throwable) {
                Object var19_11 = null;
                if (repository2 != null) {
                    this.releaseService(repository2);
                }
                throw throwable;
            }
            this.releaseService(repository2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws RuntimeError, RuntimeWarning {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "start");
            }
            System.gc();
            if (this.isNodeAgent()) {
                Tr.exit(tc, "start");
                return;
            }
            try {
                Properties p;
                block21: {
                    block20: {
                        if (svrSecurityEnabled) {
                            this.registerListenerWithMetaDataService();
                        }
                        ApplicationMgr appMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
                        PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
                        if (!(appMgr == null || ph.isZOS() && ph.isControlJvm())) {
                            try {
                                appMgr.addDeployedObjectListener(this);
                                Object var4_4 = null;
                                if (appMgr == null) break block20;
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                if (appMgr != null) {
                                    this.releaseService(appMgr);
                                }
                                throw throwable;
                            }
                            this.releaseService(appMgr);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Starting Security Server");
                    }
                    SecurityService secSvc = (SecurityService)this.getService(SecurityService.class);
                    try {
                        secSvc.startSecurity();
                        Object var6_8 = null;
                        if (secSvc == null) break block21;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        if (secSvc != null) {
                            this.releaseService(secSvc);
                        }
                        throw throwable;
                    }
                    this.releaseService(secSvc);
                }
                if (!svrSecurityEnabled) break block22;
                Boolean ssoEnabled = Boolean.FALSE;
                SingleSignonConfig sso = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getSingleSignon();
                if (sso != null) {
                    ssoEnabled = sso.getBoolean("enabled");
                }
                if (ssoEnabled.booleanValue() && WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initializing DistributedMap for security attribute propagation.");
                    }
                    p = new Properties();
                    p.put("com.ibm.ws.cache.CacheConfig.cacheSize", "100");
                    p.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
                    p.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
                    DistributedMapFactory.getMap("WSSecureMap", p);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing DistributedMap for Kerberos.");
                }
                p = new Properties();
                p.put("com.ibm.ws.cache.CacheConfig.cacheSize", "100");
                p.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
                p.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
                DistributedMapFactory.getMap("WSSecureMapNotShared", p);
                if (SecurityObjectLocator.getSecurityConfig().getBoolean("boolDefaultJaccProvider")) {
                    appInstallNotify = AppInstallNotify.getInstance();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.start", "377", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start failed", new Object[]{e});
                }
                throw new RuntimeError(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        TrustAssociationManager taManager = TrustAssociationManager.getInstance();
        if (taManager != null) {
            taManager.cleanTAInterceptors();
        }
    }

    public void stateChanged(DeployedObjectEvent evt) throws RuntimeError, RuntimeWarning {
        DeployedObject dobj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if ((dobj = (DeployedObject)evt.getSource()).getModuleFile().isEARFile()) {
            if (evt.getNewValue() == "STARTING") {
                if (svrSecurityEnabled) {
                    this.install(dobj);
                }
                this.refreshAuthDataEntries();
            } else if (evt.getNewValue() == "STOPPED" && svrSecurityEnabled) {
                this.uninstall(dobj);
            }
        } else if (dobj.getModuleFile().isWARFile()) {
            if (evt.getNewValue() == "STARTING") {
                if (svrSecurityEnabled) {
                    this.installWeb((DeployedModule)dobj);
                }
            } else if (evt.getNewValue() == "STOPPED" && svrSecurityEnabled) {
                this.uninstallWeb((DeployedModule)dobj);
            }
        } else if (dobj.getModuleFile().isEJBJarFile()) {
            if (evt.getNewValue() == "STARTING") {
                if (svrSecurityEnabled) {
                    this.installEJB((DeployedModule)dobj);
                    DelegationFactory.clearDelegationCache();
                }
            } else if (evt.getNewValue() == "STOPPED" && svrSecurityEnabled) {
                this.uninstallEJB((DeployedModule)dobj);
                DelegationFactory.clearDelegationCache();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installWeb(DeployedModule webModuleConfig) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installWeb", webModuleConfig.getName());
        }
        boolean pop = false;
        try {
            String _vHostName;
            String _webContextRoot;
            block13: {
                ConfigObject md2 = webModuleConfig.getModuleDeploymentConfigObject();
                WebModule wm = (WebModule)((EARFile)webModuleConfig.getDeployedApplication().getModuleFile()).getModule(md2.getString("uri", "__null__"), md2.getString("altDD", "__null__"));
                _webContextRoot = wm.getContextRoot();
                _vHostName = ((WebAppBinding)webModuleConfig.getBinding()).getVirtualHostName();
                WebModuleRef webModuleRef = (WebModuleRef)webModuleConfig.getModuleRef();
                String appName = webModuleConfig.getDeployedApplication().getName();
                if (appName == null || appName != null && WSAccessManager.checkIfAdminApp(appName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "installWeb pushing null");
                    }
                    pop = SecurityObjectLocator.pushAdminContext();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "installWeb pushing app name " + appName);
                    }
                    pop = SecurityObjectLocator.pushAppContext(appName);
                }
                if (svrSecurityEnabled && SecurityObjectLocator.getSecurityConfig().getBoolean("boolDefaultJaccProvider") && !WSAccessManager.checkIfAdminApp(appName)) {
                    boolean switched = false;
                    try {
                        try {
                            switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                            appInstallNotify.addWebPermissions(webModuleRef, appName, WSAccessManager.getContextID(appName), false, null);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.installWeb", "488", this);
                            if (!tc.isEntryEnabled()) throw new RuntimeWarning(e);
                            Tr.exit(tc, "installWeb failed", new Object[]{e});
                            throw new RuntimeWarning(e);
                        }
                        Object var12_11 = null;
                        if (!switched) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (!switched) throw throwable;
                        DomainContextHelper.unwindAppDomain(appName);
                        throw throwable;
                    }
                    DomainContextHelper.unwindAppDomain(appName);
                }
            }
            String contextRoot = _vHostName + ":" + _webContextRoot;
            this.webModulesMap.put(webModuleConfig, contextRoot);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "installWeb");
            }
            Object var14_15 = null;
            if (!pop) return;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (!pop) throw throwable;
            SecurityObjectLocator.popContext();
            throw throwable;
        }
        SecurityObjectLocator.popContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uninstallWeb(DeployedModule webModuleConfig) throws RuntimeWarning {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uninstallWeb", webModuleConfig.getName());
            }
            boolean switched = false;
            String appName = null;
            try {
                try {
                    String contextRoot = (String)this.webModulesMap.get(webModuleConfig);
                    appName = webModuleConfig.getDeployedApplication().getName();
                    String moduleName = webModuleConfig.getName();
                    WebModuleRef webModuleRef = (WebModuleRef)webModuleConfig.getModuleRef();
                    if (contextRoot != null) {
                        WebAppCache.removeWebApp(appName, contextRoot);
                        this.webModulesMap.remove(webModuleConfig);
                    }
                    if (svrSecurityEnabled && SecurityObjectLocator.getSecurityConfig().getBoolean("boolDefaultJaccProvider") && !WSAccessManager.checkIfAdminApp(appName)) {
                        switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                        appInstallNotify.deleteModule(webModuleRef, appName, WSAccessManager.getContextID(appName), false);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstallWeb", "543", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "uninstallWeb failed", new Object[]{e});
                    }
                    throw new RuntimeWarning(e);
                }
                Object var8_8 = null;
                if (!switched) break block10;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (switched) {
                    DomainContextHelper.unwindAppDomain(appName);
                }
                throw throwable;
            }
            DomainContextHelper.unwindAppDomain(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallWeb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installEJB(DeployedModule ejbModuleConfig) throws RuntimeWarning {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "installEJB", ejbModuleConfig.getName());
            }
            boolean pop = false;
            try {
                String moduleName;
                String appName;
                block16: {
                    appName = ejbModuleConfig.getDeployedApplication().getName();
                    moduleName = ejbModuleConfig.getName();
                    EJBModuleRef ejbModuleRef = (EJBModuleRef)ejbModuleConfig.getModuleRef();
                    if (appName == null || appName != null && WSAccessManager.checkIfAdminApp(appName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "installEJB pushing null");
                        }
                        pop = SecurityObjectLocator.pushAdminContext();
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "installEJB pushing app name " + appName);
                        }
                        pop = SecurityObjectLocator.pushAppContext(appName);
                    }
                    if (svrSecurityEnabled && SecurityObjectLocator.getSecurityConfig().getBoolean("boolDefaultJaccProvider") && !WSAccessManager.checkIfAdminApp(appName)) {
                        boolean switched = false;
                        try {
                            try {
                                switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                                appInstallNotify.addEJBPermissions(ejbModuleRef, appName, WSAccessManager.getContextID(appName), false, null);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.installEJB", "588", this);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "installEJB failed", new Object[]{e});
                                }
                                throw new RuntimeWarning(e);
                            }
                            Object var9_7 = null;
                            if (!switched) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var9_8 = null;
                            if (switched) {
                                DomainContextHelper.unwindAppDomain(appName);
                            }
                            throw throwable;
                        }
                        DomainContextHelper.unwindAppDomain(appName);
                    }
                }
                BeanPermissionRoleMapTable.addBeanPermissionRoleMap(appName + ":" + moduleName);
                Object var11_11 = null;
                if (!pop) break block17;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (pop) {
                    SecurityObjectLocator.popContext();
                }
                throw throwable;
            }
            SecurityObjectLocator.popContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installEJB");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uninstallEJB(DeployedModule ejbModuleConfig) throws RuntimeWarning {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uninstallEJB", ejbModuleConfig.getName());
            }
            boolean switched = false;
            String appName = null;
            try {
                try {
                    appName = ejbModuleConfig.getDeployedApplication().getName();
                    String moduleName = ejbModuleConfig.getName();
                    EJBModuleRef ejbModuleRef = (EJBModuleRef)ejbModuleConfig.getModuleRef();
                    BeanPermissionRoleMapTable.removeBeanPermissionRoleMap(appName + ":" + moduleName);
                    if (svrSecurityEnabled && SecurityObjectLocator.getSecurityConfig().getBoolean("boolDefaultJaccProvider") && !WSAccessManager.checkIfAdminApp(appName)) {
                        switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                        appInstallNotify.deleteModule(ejbModuleRef, appName, WSAccessManager.getContextID(appName), false);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstallEJB", "631", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "uninstallEJB failed", new Object[]{e});
                    }
                    throw new RuntimeWarning(e);
                }
                Object var7_7 = null;
                if (!switched) break block9;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (switched) {
                    DomainContextHelper.unwindAppDomain(appName);
                }
                throw throwable;
            }
            DomainContextHelper.unwindAppDomain(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallEJB");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void install(DeployedObject appObj) throws RuntimeWarning {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "install", appObj);
            }
            boolean pop = false;
            try {
                try {
                    String contextID;
                    RunAsMap runAsMap;
                    String appName;
                    block28: {
                        block27: {
                            ApplicationBinding binding = (ApplicationBinding)appObj.getBinding();
                            appName = appObj.getName();
                            AuthorizationTable table = null;
                            runAsMap = null;
                            if (!Boolean.getBoolean("com.ibm.ws.security.disableEJB3Bindings")) {
                                ApplicationBindingAdapter adapter = new ApplicationBindingAdapter(appObj);
                                table = adapter.getAuthorizationTable();
                                runAsMap = adapter.getRunAsMap();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, ((Object)adapter).toString());
                                }
                            } else {
                                table = binding.getAuthorizationTable();
                                runAsMap = binding.getRunAsMap();
                            }
                            if (appName == null || appName != null && WSAccessManager.checkIfAdminApp(appName)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "install pushing null");
                                }
                                pop = SecurityObjectLocator.pushAdminContext();
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "install pushing app name " + appName);
                                }
                                pop = SecurityObjectLocator.pushAppContext(appName);
                            }
                            if (!SecurityObjectLocator.getSecurityConfig().getBoolean("boolNativeAuthz")) break block27;
                            if (table != null) {
                                this.removeSubjectsFromDenyAllRole(appName, table);
                                WSAccessManager.addAuthorizationTable(appName, table);
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Authorization Table processed for Application " + appName);
                                }
                                break block28;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Authorization Table Not defined for Application " + appName);
                                }
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Application " + appName + " installed without Authorization Table");
                                }
                            }
                            break block28;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Authorization Table in the binding file is not processed as native authorization is not used.");
                        }
                    }
                    if (runAsMap != null) {
                        RunAsMapTable.addRunAsMap(appName, runAsMap);
                        EList runAsBindings = runAsMap.getRunAsBindings();
                        if (runAsBindings.size() == 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "RunAsMap Not defined properly for Application " + appName);
                            }
                        } else if (tc.isEventEnabled()) {
                            Tr.event(tc, "RunAsMap processed for Application " + appName);
                        }
                    }
                    if (SecurityObjectLocator.getSecurityConfig().getAuthorizationConfig().getBoolean("useJACCProvider") && (contextID = ((DeployedApplication)appObj).getApplicationDeploymentConfigObject().getString("appContextIDForSecurity", "__null__")) != null) {
                        WSAccessManager.storeContextID(appName, contextID);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.install", "731", this);
                    Tr.error(tc, "security.servcomp.init");
                    Tr.debug(tc, "Exception occurred in application install.", new Object[]{e});
                    throw new RuntimeWarning(e.getMessage());
                }
                Object var9_9 = null;
                if (!pop) break block26;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (pop) {
                    SecurityObjectLocator.popContext();
                }
                throw throwable;
            }
            SecurityObjectLocator.popContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    private void uninstall(DeployedObject appObj) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstall", appObj);
        }
        try {
            String appName = appObj.getName();
            if (SecurityObjectLocator.getSecurityConfig().getBoolean("boolNativeAuthz")) {
                WSAccessManager.removeAuthorizationTable(appName);
            }
            RunAsMapTable.removeRunAsMap(appName);
            if (SecurityObjectLocator.getSecurityConfig().getAuthorizationConfig().getBoolean("useJACCProvider")) {
                WSAccessManager.removeContextID(appName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstall", "772", this);
            throw new RuntimeWarning(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstall");
        }
    }

    protected void removeSubjectsFromDenyAllRole(String appName, AuthorizationTable table) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUsersFromDenyAllRole", appName);
        }
        boolean removed = false;
        EList auths = table.getAuthorizations();
        for (int i = 0; i < auths.size(); ++i) {
            RoleAssignment auth = (RoleAssignment)auths.get(i);
            String roleName = auth.getRole().getRoleName();
            if (roleName != null && roleName.equals(DENYALL_ROLE_NAME)) {
                EList specialSubjects;
                EList groups;
                EList users = auth.getUsers();
                if (users != null && users.size() > 0) {
                    auth.getUsers().clear();
                    removed = true;
                }
                if ((groups = auth.getGroups()) != null && groups.size() > 0) {
                    auth.getGroups().clear();
                    removed = true;
                }
                if ((specialSubjects = auth.getSpecialSubjects()) != null && specialSubjects.size() > 0) {
                    auth.getSpecialSubjects().clear();
                    removed = true;
                }
                if (!removed) continue;
                Tr.warning(tc, "security.servcomp.remove.DenyAllRole", new Object[]{appName});
                continue;
            }
            if (roleName != null) continue;
            Tr.debug(tc, "auth.getRole().getRoleName() returns null, there might be a problem in the descriptors.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUsersFromDenyAllRole");
        }
    }

    private void refreshAuthDataEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAuthDataEntries");
        }
        WSDefaultPrincipalMapping.refreshAuthData(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthDataEntries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getServerAdminProps(ConfigObject server) throws Exception {
        Properties p;
        block35: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerAdminProps");
            }
            String thisServerName = null;
            String thisNodeName = null;
            String cellName = null;
            p = new Properties();
            String remoteAdminProtocol = null;
            String canonicalHostName = null;
            String rmiPort = null;
            try {
                ConfigService configService;
                ConfigScope scope;
                String[] nodes;
                String cellNodeServerName;
                StringTokenizer st;
                block37: {
                    block36: {
                        List jmxProperties;
                        p.setProperty("isInternal", "true");
                        List customServices = server.getObjectList("services");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Number of custom services: " + customServices.size());
                        }
                        ConfigObject adminService = null;
                        Class<AdminService> adminServiceClass = AdminService.class;
                        for (ConfigObject obj : customServices) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Custom service: " + obj);
                            }
                            if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "AdminService")) continue;
                            adminService = obj;
                            break;
                        }
                        if (adminService == null) break block36;
                        ConfigObject jmxConnector = adminService.getObject("remoteAdminProtocol");
                        if (jmxConnector != null && jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "SOAPConnector")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "remoteAdminProtocol connector type is SOAP.");
                            }
                            p.setProperty("type", "SOAP");
                            remoteAdminProtocol = "SOAP";
                            jmxProperties = jmxConnector.getObjectList("properties");
                            for (ConfigObject prop : jmxProperties) {
                                if (prop.getString("name", null).equals("sslConfig")) {
                                    Object var23_26;
                                    String sslConfig = prop.getString("value", null);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "SSLConfig alias to use: " + sslConfig);
                                    }
                                    if (sslConfig == null) continue;
                                    SecurityService secSvc = null;
                                    try {
                                        try {
                                            Properties sslProps;
                                            secSvc = (SecurityService)this.getService(SecurityService.class);
                                            if (secSvc != null && (sslProps = secSvc.getSecureSocketLayer(sslConfig)) != null) {
                                                Enumeration<?> sslPropsEnum = sslProps.propertyNames();
                                                while (sslPropsEnum.hasMoreElements()) {
                                                    String name = (String)sslPropsEnum.nextElement();
                                                    String value = sslProps.getProperty(name);
                                                    if (name == null || value == null) continue;
                                                    p.setProperty(name, value);
                                                }
                                            }
                                            var23_26 = null;
                                            if (secSvc == null) continue;
                                        }
                                        catch (Exception e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.getServerAdminProps", "931", this);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Exception occurred getting SSLProps.", new Object[]{e});
                                            }
                                            var23_26 = null;
                                            if (secSvc == null) continue;
                                            this.releaseService(secSvc);
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var23_26 = null;
                                        if (secSvc != null) {
                                            this.releaseService(secSvc);
                                        }
                                        throw throwable;
                                    }
                                    this.releaseService(secSvc);
                                    continue;
                                }
                                p.setProperty(prop.getString("name", null), prop.getString("value", null));
                            }
                            break block37;
                        } else if (jmxConnector != null && (jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "RMIConnector") || jmxConnector.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/adminservice.xmi", "JSR160RMIConnector"))) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "remoteAdminProtocol connector type is RMI or JSR160RMI.");
                            }
                            p.setProperty("type", "RMI");
                            remoteAdminProtocol = "RMI";
                            jmxProperties = jmxConnector.getObjectList("properties");
                            for (ConfigObject prop : jmxProperties) {
                                p.setProperty(prop.getString("name", null), prop.getString("value", null));
                            }
                        }
                        break block37;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Admin service is null.");
                    }
                }
                if ((st = new StringTokenizer(cellNodeServerName = SecurityObjectLocator.getAdminData().getString("process.serverName"), ":")).countTokens() == 3) {
                    cellName = st.nextToken();
                    thisNodeName = st.nextToken();
                    thisServerName = st.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell:node:server = " + cellName + ":" + thisNodeName + ":" + thisServerName);
                    }
                }
                if ((nodes = (scope = (configService = WsServiceRegistry.getService(this, ConfigService.class)).createScope(3)).list(null)) != null) {
                    block10: for (int i = 0; i < nodes.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node name: " + nodes[i]);
                        }
                        if (!nodes[i].equals(thisNodeName)) continue;
                        scope.set(3, nodes[i]);
                        List resource = configService.getDocumentObjects(scope, "serverindex.xml");
                        ConfigObject doc = (ConfigObject)resource.get(0);
                        List servers = doc.getObjectList("serverEntries");
                        for (int j = 0; j < servers.size(); ++j) {
                            String type;
                            ConfigObject s = (ConfigObject)servers.get(j);
                            if (s == null || !(type = s.getString("serverType", null)).equals("APPLICATION_SERVER") || !s.getString("serverName", null).equals(thisServerName)) continue;
                            ConfigObject soapEP = null;
                            ConfigObject rmiEP = null;
                            List endpoints = s.getObjectList("specialEndpoints");
                            for (int k = 0; k < endpoints.size(); ++k) {
                                ConfigObject nep = (ConfigObject)endpoints.get(k);
                                if (nep.getString("endPointName", null).equals("SOAP_CONNECTOR_ADDRESS")) {
                                    soapEP = nep.getObject("endPoint");
                                }
                                if (!nep.getString("endPointName", null).equals("BOOTSTRAP_ADDRESS") || (rmiEP = nep.getObject("endPoint")) == null) continue;
                                rmiPort = new Integer(rmiEP.getInt("port", 0)).toString();
                                canonicalHostName = rmiEP.getString("host", null);
                                p.setProperty("java.naming.provider.url", "corbaloc:iiop:" + canonicalHostName + ":" + rmiPort + "/" + "WsnAdminNameService");
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "PROVIDER_URL: corbaloc:iiop:" + canonicalHostName + ":" + rmiPort);
                            }
                            if (soapEP != null && remoteAdminProtocol.equals("SOAP")) {
                                p.setProperty("port", new Integer(soapEP.getInt("port", 0)).toString());
                                p.setProperty("host", soapEP.getString("host", null));
                                continue block10;
                            }
                            if (rmiEP == null || !remoteAdminProtocol.equals("RMI") && !remoteAdminProtocol.equals("JSR160RMI")) continue block10;
                            p.setProperty("port", new Integer(rmiEP.getInt("port", 0)).toString());
                            p.setProperty("host", rmiEP.getString("host", null));
                            continue block10;
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.getServerAdminProps", "1057", this);
                if (!tc.isDebugEnabled()) break block35;
                Tr.debug(tc, "Exception occurred getting SSLProps.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAdminProps");
        }
        return p;
    }

    private boolean registerListenerWithMetaDataService() {
        boolean retval;
        block6: {
            retval = true;
            SecurityMetaDataListener mdListener = null;
            try {
                MetaDataService metaDataService = (MetaDataService)this.getService(MetaDataService.class);
                if (metaDataService != null) {
                    this.mmdSlot = metaDataService.reserveSlot(ModuleMetaData.class);
                    this.cmdSlot = metaDataService.reserveSlot(ComponentMetaData.class);
                    mdListener = new SecurityMetaDataListener();
                    metaDataService.addMetaDataListener(mdListener);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registered MetaDataListener: " + mdListener);
                    }
                } else {
                    retval = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempt to register MetaDataListener failed: metaDataService is null.");
                    }
                }
            }
            catch (Exception e) {
                retval = false;
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithMetaDataService", "1092", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "attempt to register MetaDataListener failed." + e.getMessage());
            }
        }
        return retval;
    }

    private boolean isNodeAgent() {
        return AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent");
    }

    private ArrayList updateHTTPTransports(ConfigObject server, EndPointMgr endPointMgr) {
        ArrayList<Integer> sslPorts = new ArrayList<Integer>();
        try {
            List comps = server.getObjectList("services");
            if (comps != null && comps.size() > 0) {
                List chains;
                ConfigObject tcs = null;
                for (ConfigObject obj : comps) {
                    if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.xmi", "TransportChannelService")) continue;
                    tcs = obj;
                    break;
                }
                if (tcs != null && (chains = tcs.getObjectList("chains")) != null && chains.size() > 0) {
                    for (ConfigObject chain : chains) {
                        EndPoint sslEndPoint;
                        List channels = chain.getObjectList("transportChannels");
                        if (channels == null || channels.size() <= 0) continue;
                        ConfigObject sslInboundChannel = null;
                        ConfigObject tcpInboundChannel = null;
                        for (ConfigObject obj : channels) {
                            if (obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "SSLInboundChannel")) {
                                sslInboundChannel = obj;
                            }
                            if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel")) continue;
                            tcpInboundChannel = obj;
                        }
                        if (sslInboundChannel == null || tcpInboundChannel == null || (sslEndPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tcpInboundChannel.getString("endPointName", null))) == null) continue;
                        Integer sslPort = new Integer(sslEndPoint.getPort());
                        sslPorts.add(sslPort);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.updateOldHTTPTransports(server, sslPorts);
        return sslPorts;
    }

    private void updateOldHTTPTransports(ConfigObject server, List sslPorts) {
        List httpTransports;
        List comps = server.getObjectList("components");
        ConfigObject appServer = null;
        for (ConfigObject obj : comps) {
            if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
            appServer = obj;
            break;
        }
        List comps1 = appServer.getObjectList("components");
        ConfigObject webContainer = null;
        for (ConfigObject obj : comps1) {
            if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi", "WebContainer")) continue;
            webContainer = obj;
            break;
        }
        if (webContainer != null && (httpTransports = webContainer.getObjectList("transports")) != null && httpTransports.size() > 0) {
            for (ConfigObject httpTransport : httpTransports) {
                ConfigObject sslEndPoint;
                if (httpTransport == null || !httpTransport.getBoolean("sslEnabled", false) || (sslEndPoint = httpTransport.getObject("address")) == null) continue;
                Integer sslPort = new Integer(sslEndPoint.getInt("port", 0));
                sslPorts.add(sslPort);
            }
        }
    }
}

