/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.SecurityMessages;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.List;

public class SecurityManager
extends java.lang.SecurityManager {
    private static final String lineSep = System.getProperty("line.separator");
    private static final TraceComponent _tc = Tr.register(SecurityManager.class, null, "com.ibm.ejs.resources.security");
    private boolean grantAll = false;
    private ExtClassLoader runtimeClassLoader;
    private PermissionCollection filteredPermissions;
    private boolean enableRuntimeFiltering = false;
    private boolean filteredPermissionsEmpty = true;
    private boolean initialized = false;
    private Thread _mainthread;
    private boolean _norethrow = false;
    private boolean _nolog = false;
    private boolean _notracktrace = false;
    private static final String GETCLASSLOADER = "getClassLoader";
    private PrivilegedAction isRuntimeThreadAction = new PrivilegedAction(){

        public Object run() {
            Boolean ret = Boolean.FALSE;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                ret = new Boolean(classLoader.equals(SecurityManager.this.runtimeClassLoader));
            }
            return ret;
        }
    };
    private static final RuntimePermission MODIFYTHREAD_PERM = new RuntimePermission("modifyThread");
    private static final RuntimePermission MODIFYTHREADGROUP_PERM = new RuntimePermission("modifyThreadGroup");

    public SecurityManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SecurityManager()");
        }
        this.init(null);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SecurityManager()");
        }
    }

    SecurityManager(String debugFlag, ExtClassLoader runtimeClassLoader, List filteredPermissionsList, boolean enableRuntimeFiltering) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SecurityManager(" + debugFlag + ", " + runtimeClassLoader + ", " + filteredPermissionsList + ", " + enableRuntimeFiltering + ")");
        }
        this.init(debugFlag);
        this.enableRuntimeFiltering = enableRuntimeFiltering;
        if (this.enableRuntimeFiltering) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "enableRuntimeFiltering = TRUE");
            }
            this.runtimeClassLoader = runtimeClassLoader;
            this.filteredPermissions = new Permissions();
            this.filteredPermissionsEmpty = filteredPermissionsList.isEmpty();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "filteredPermissionsEmpty = " + this.filteredPermissionsEmpty);
            }
            if (!this.filteredPermissionsEmpty) {
                int size = filteredPermissionsList.size();
                for (int i = 0; i < size; ++i) {
                    this.filteredPermissions.add((Permission)filteredPermissionsList.get(i));
                }
            }
            this.filteredPermissions.setReadOnly();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SecurityManager()");
        }
    }

    private boolean isRuntimeThread(Permission perm) {
        boolean ret = false;
        if (this._mainthread != Thread.currentThread()) {
            if (!perm.getName().equals(GETCLASSLOADER)) {
                ret = (Boolean)AccessController.doPrivileged(this.isRuntimeThreadAction);
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public void checkPermission(Permission perm) {
        block16: {
            if (this.enableRuntimeFiltering && !this.filteredPermissionsEmpty && !this.isRuntimeThread(perm) && this.filteredPermissions.implies(perm)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "access denied due to runtime permission filtering on " + perm);
                }
                if (!this._norethrow) {
                    throw new AccessControlException("access denied due to runtime permission filtering on " + perm, perm);
                }
            }
            if (!this.grantAll) {
                try {
                    super.checkPermission(perm);
                }
                catch (SecurityException e) {
                    String stackStr = null;
                    String[] codebaseloc = null;
                    if (this._notracktrace) {
                        stackStr = "Stack trace disabled";
                        codebaseloc = new String[]{"", ""};
                    } else {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        stackStr = sw.toString();
                        try {
                            codebaseloc = this.getCodeBaseLoc(perm);
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityManager", "92", this);
                            StringWriter sw2 = new StringWriter();
                            e2.printStackTrace(new PrintWriter(sw2));
                            String stackStr2 = sw2.toString();
                            Tr.error(_tc, "security.jsecman.exception.codebase", new Object[]{e2.toString() + "(" + e2.getMessage() + ")" + lineSep + lineSep + stackStr2});
                        }
                    }
                    if (codebaseloc != null && codebaseloc[0] != null && codebaseloc[0].equals("_nolog")) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Not printing SecurityException due to ClassLoader handling.", new Object[]{e});
                        }
                        throw e;
                    }
                    String buf1 = SecurityMessages.getMsg("security.jsecman.permdeniedmsg", new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep, lineSep + lineSep + stackStr + lineSep + lineSep, lineSep + lineSep + codebaseloc[1]});
                    String strDebug = "\nJava SecurityException:\n perm.getName<>: " + perm.getName() + "\n e.getMessage<>: " + e.getMessage() + "\nBegin SecurityException\n" + stackStr + "\n" + "Code base location information:\n" + codebaseloc + "\n class ==> : " + codebaseloc[0] + "\nSuggested Action: Verify the attempted operation is permitted by" + " examining all Java 2 security policy files and application code." + " Additional permissions may be required, a doPrivileged API may be needed" + " in some code on the call stack, or the Security Manager properly prevented" + " access to a resource the caller does not have permission to access." + "\nEnd SecurityException\n";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, strDebug);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.security.core.SecurityManager", "180", this, new Object[]{buf1});
                    if (!this._nolog) {
                        ContextManager ctxMgr = ContextManagerFactory.getInstance();
                        if (!ctxMgr.getPlatformHelper().isZOS()) {
                            Tr.warning(_tc, "security.jsecman.permdeniedmsg", new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep, lineSep + lineSep + stackStr + lineSep + lineSep, lineSep + lineSep + codebaseloc[1]});
                        } else {
                            Tr.warning(_tc, "security.zOS.SecurityManager.PermissionFailure1.warning", new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep + codebaseloc[1]});
                            Tr.warning(_tc, "security.zOS.SecurityManager.PermissionFailure2.warning", new Object[]{"\nBegin SecurityException\n" + stackStr + "\nEnd SecurityException\n"});
                        }
                    }
                    if (this._norethrow) break block16;
                    throw e;
                }
            }
        }
    }

    public void checkAccess(Thread t) {
        if (t == null) {
            throw new NullPointerException("thread can't be null!");
        }
        this.checkPermission(MODIFYTHREAD_PERM);
    }

    public void checkAccess(ThreadGroup tgp) {
        if (tgp == null) {
            throw new NullPointerException("thread group can't be null!");
        }
        this.checkPermission(MODIFYTHREADGROUP_PERM);
    }

    public boolean checkTopLevelWindow(Object window) {
        return false;
    }

    private void init(String debugFlag) {
        if (!this.initialized) {
            this._mainthread = Thread.currentThread();
            PermissionCollection pc = Policy.getPolicy().getPermissions(new CodeSource(null, (Certificate[])null));
            this.grantAll = pc.implies(new AllPermission());
            this._norethrow = Boolean.getBoolean("com.ibm.websphere.java2secman.norethrow");
            this._nolog = Boolean.getBoolean("com.ibm.websphere.java2secman.nolog");
            if (_tc.isDebugEnabled()) {
                if (this.grantAll) {
                    Tr.debug(_tc, "grantAll is TRUE");
                } else {
                    Tr.debug(_tc, "grantAll is FALSE");
                }
                if (this._norethrow) {
                    Tr.debug(_tc, "Running with NoRethrow debug");
                } else {
                    Tr.debug(_tc, "Running without NoRethrow debug");
                }
            }
            this._notracktrace = Boolean.getBoolean("com.ibm.websphere.java2secman.nostacktrace");
            if (this._norethrow) {
                Tr.warning(_tc, "security.jsecman.debugnorethrow");
            }
        }
    }

    private String[] getCodeBaseLoc(Permission perm) {
        final Permission in_perm = perm;
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class[] classes = SecurityManager.this.getClassContext();
                StringBuffer sb = new StringBuffer(classes.length * 100);
                sb.append(lineSep);
                String[] retMsg = new String[2];
                for (int i = 0; i < classes.length; ++i) {
                    Class clazz = classes[i];
                    ProtectionDomain pd = clazz.getProtectionDomain();
                    if (classes[i].getName().indexOf("com.ibm.ws.security.core.SecurityManager") != -1) {
                        for (int j = i + 1; j < classes.length; ++j) {
                            if (classes[j].getName().indexOf("java.lang.ClassLoader") != -1) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Not printing AccessError since ClassLoader.getResource returns null per JavaDoc when privileges not there.");
                                }
                                String[] codebaseloc = new String[]{"_nolog", ""};
                                return codebaseloc;
                            }
                            ProtectionDomain pd2 = classes[j].getProtectionDomain();
                            if (classes[j].getName().startsWith("java") || classes[j].getName().indexOf("com.ibm.ws.security.core.SecurityManager") != -1 || classes[j].getName().indexOf("ClassLoader") != -1 || j != classes.length - 1 && classes[j + 1].getName().indexOf("ClassLoader") != -1 || !SecurityManager.this.lackedReqPerm(pd2.getPermissions(), in_perm)) continue;
                            if (pd2 != null) {
                                retMsg[0] = new String(lineSep + lineSep + "     " + classes[j].getName() + "  in  " + "{" + SecurityManager.this.getCodeSource(pd2) + "}" + lineSep + lineSep);
                                break;
                            }
                            retMsg[0] = new String(lineSep + lineSep + "      " + classes[j].getName() + " at {unknown location}" + lineSep + lineSep);
                            break;
                        }
                    }
                    if (pd != null) {
                        CodeSource cs = pd.getCodeSource();
                        String csStr = SecurityManager.this.getCodeSource(pd);
                        sb.append(classes[i].getName()).append(" : ").append(csStr + lineSep);
                        sb.append("  ").append(SecurityManager.this.permissionToString(cs, clazz.getClassLoader(), pd.getPermissions())).append(lineSep);
                        continue;
                    }
                    sb.append(classes[i].getName()).append(" : ").append("Unknown location" + lineSep);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Permission Error Code is " + retMsg[0]);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Code Base Location: is " + sb.toString());
                }
                retMsg[1] = new String("");
                return retMsg;
            }
        });
    }

    private String getCodeSource(ProtectionDomain pd) {
        URL url;
        CodeSource cs = pd.getCodeSource();
        String csStr = null;
        csStr = cs == null ? "null code source" : ((url = cs.getLocation()) == null ? "null code URL" : url.toString());
        return csStr;
    }

    private String permissionToString(CodeSource cs, ClassLoader classloaderClass, PermissionCollection col) {
        StringBuffer buf = new StringBuffer("ClassLoader: ");
        if (classloaderClass == null) {
            buf.append("Primordial Classloader");
        } else {
            buf.append(classloaderClass.getClass().getName());
        }
        buf.append(lineSep);
        buf.append("  Permissions granted to CodeSource ").append(cs).append(lineSep);
        if (col != null) {
            Enumeration<Permission> e = col.elements();
            buf.append("  {").append(lineSep);
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                buf.append("    ").append(p.toString()).append(";").append(lineSep);
            }
            buf.append("  }");
        } else {
            buf.append("  {").append(lineSep).append("  }");
        }
        return buf.toString();
    }

    private boolean lackedReqPerm(PermissionCollection owned, Permission reqPerm) {
        boolean ret = true;
        if (owned != null) {
            ret = !owned.implies(reqPerm);
        }
        return ret;
    }
}

