/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.TokenHolder;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public final class SecurityAdminHelper {
    private static final TraceComponent tc = Tr.register(SecurityAdminHelper.class, null, "com.ibm.ejs.resources.security");
    private static String servantId = null;
    private static final String OBJNAME_PREFIX = "WebSphere:type=SecurityAdminHelper,";
    private static SecurityAdminHelper thisObj;
    private static ObjectName thisMBean;
    private static AdminService adminServ;

    private SecurityAdminHelper() {
    }

    public static boolean initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize SecurityAdminHelper", thisMBean);
        }
        if (thisMBean == null) {
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            adminServ = AdminServiceFactory.getAdminService();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Set the AdminService for this process");
            }
            if (thisObj == null) {
                thisObj = new SecurityAdminHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create an instance of this class if not already in existence");
                }
            }
            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(thisObj, "SecurityAdminHelper");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Register SecurityAdminHelper mbean");
            }
            Properties servantIdProp = new Properties();
            servantIdProp.setProperty("servantId", SecurityAdminHelper.getServantIdentifier());
            try {
                thisMBean = mbeanFactory.activateMBean("SecurityAdminHelper", collab, "SecurityAdminHelper", "com/ibm/ws/management/descriptor/xml/SecurityAdminHelper.xml", servantIdProp);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use servantId as one of the extra property to distinguish each");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.core.SecurityAdminHelper.initialize", "001");
                Tr.error(tc, "security.init.mbeanerror", new Object[]{"SecurityAdminHelper", e});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize returning false", thisMBean);
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize returning true", thisMBean);
        }
        return true;
    }

    public static String getServantIdentifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantIdentifier", servantId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantIdentifier", servantId);
        }
        return servantId;
    }

    public static TokenHolder getOpaqueToken(ByteArray ssoToken, String servantIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpaqueToken(ssoToken, servantId)", new Object[]{ssoToken, servantIdentifier});
        }
        if (servantId.equals(servantIdentifier)) {
            if (thisObj == null && !SecurityAdminHelper.initialize()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning null");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) invoking getOpaqueToken locally", thisObj);
            }
            TokenHolder retval = thisObj.getOpaqueToken(ssoToken);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning", retval);
            }
            return retval;
        }
        ObjectName scope = null;
        TokenHolder retval = null;
        try {
            Set objNames;
            if (adminServ == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) AdminService isn't set", adminServ);
                }
                return null;
            }
            scope = new ObjectName("WebSphere:type=SecurityAdminHelper,servantId=" + servantIdentifier + ",*");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "scope: " + scope);
            }
            if ((objNames = adminServ.queryNames(scope, null)).size() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) one MBean found", String.valueOf(objNames.size()));
                }
                Iterator objNameItr = objNames.iterator();
                ObjectName foundMBean = (ObjectName)objNameItr.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) invoking MBean", foundMBean);
                }
                retval = (TokenHolder)adminServ.invoke(foundMBean, "getOpaqueToken", new Object[]{ssoToken}, new String[]{ByteArray.class.getName()});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning", retval);
                }
            } else {
                if (objNames.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) no MBean found", scope);
                    }
                    return null;
                }
                if (objNames.size() > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) more than one MBean found", String.valueOf(objNames.size()));
                    }
                    Iterator objNameItr = objNames.iterator();
                    ObjectName firstMBean = (ObjectName)objNameItr.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) using MBean", firstMBean);
                        while (objNameItr.hasNext()) {
                            Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) found MBean", objNameItr.next());
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) invoking MBean", firstMBean);
                    }
                    retval = (TokenHolder)adminServ.invoke(firstMBean, "getOpaqueToken", new Object[]{ssoToken}, new String[]{ByteArray.class.getName()});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning", retval);
                    }
                }
            }
            return retval;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.core.SecurityAdminHelper.getOpaqueToken", "002");
            Tr.error(tc, "security.invoke.mbeanerror", new Object[]{"SecurityAdminHelper", e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning null");
            }
            return null;
        }
    }

    public TokenHolder getOpaqueToken(ByteArray ssoToken) {
        TokenHolder th;
        byte[] opaqueToken;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueToken");
            }
            opaqueToken = null;
            th = null;
            try {
                DistributedMap dm = DistributedMapFactory.getMap("WSSecureMap");
                if (dm != null) {
                    opaqueToken = (byte[])dm.get((Object)ssoToken);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdminHelper.getOpaqueToken", "003", this);
                if (!tc.isEntryEnabled()) break block8;
                Tr.exit(tc, "Exception occurred getting opaque token from distributed map.", new Object[]{e});
            }
        }
        if (opaqueToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns opaque token.");
            }
            th = new TokenHolder(opaqueToken, "WS_OPAQUE", 1);
        }
        return th;
    }

    static {
        Class<?> adminServiceImplClass = null;
        Class<?> platformUtilsClass = null;
        Method getPlatformUtilsMethod = null;
        Method getPrintableStokenMethod = null;
        Object adminServiceImplObject = null;
        Object platformUtilsObject = null;
        try {
            adminServiceImplClass = Class.forName("com.ibm.ws.management.AdminServiceImpl");
            if (adminServiceImplClass != null) {
                getPlatformUtilsMethod = adminServiceImplClass.getMethod("getPlatformUtils", new Class[0]);
                adminServiceImplObject = adminServiceImplClass.newInstance();
                if (getPlatformUtilsMethod != null) {
                    platformUtilsClass = Class.forName("com.ibm.ws.management.util.PlatformUtils");
                    platformUtilsObject = getPlatformUtilsMethod.invoke(adminServiceImplClass, new Object[0]);
                    getPrintableStokenMethod = platformUtilsClass.getMethod("getPrintableStoken", new Class[0]);
                    servantId = (String)getPrintableStokenMethod.invoke(platformUtilsObject, new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "servantId:", servantId);
                    }
                }
            }
        }
        catch (Exception e) {
            Tr.error(tc, "exception " + e.toString() + " in SecurityAdminHelper static initializer");
            throw new UndeclaredThrowableException(e);
        }
        thisObj = null;
        thisMBean = null;
        adminServ = null;
    }
}

