/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.ipc.ssl.EmailFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeyReference;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SSLSecurityLevel;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.ipc.ssl.WSCertificateExpirationMonitor;
import com.ibm.websphere.models.config.ipc.ssl.WSNotification;
import com.ibm.websphere.models.config.ipc.ssl.WSSchedule;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.jaaslogin.JAASModuleControlFlag;
import com.ibm.websphere.models.config.jaaslogin.JaasloginFactory;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocolKind;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.SecureAssociationService;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityprotocolFactory;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityprotocolPackage;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportQOP;
import com.ibm.websphere.models.config.properties.DescriptiveProperty;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.CACertificate;
import com.ibm.websphere.models.config.security.CAClient;
import com.ibm.websphere.models.config.security.Certificate;
import com.ibm.websphere.models.config.security.CertificateMapMode;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.DynamicSSLConfigSelection;
import com.ibm.websphere.models.config.security.KRB5;
import com.ibm.websphere.models.config.security.LDAPDirectoryType;
import com.ibm.websphere.models.config.security.LDAPSearchFilter;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.PollingStatusKind;
import com.ibm.websphere.models.config.security.RSAToken;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.SWAMAuthentication;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityFactory;
import com.ibm.websphere.models.config.security.SecurityPackage;
import com.ibm.websphere.models.config.security.SingleSignon;
import com.ibm.websphere.models.config.security.TAInterceptor;
import com.ibm.websphere.models.config.security.TrustAssociation;
import com.ibm.websphere.models.config.security.WIMUserRegistry;
import com.ibm.websphere.models.config.security.WSSecurityScannerMonitor;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.AbstractConfigBuilder;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class SampleSecurityConfigBuilder
extends AbstractConfigBuilder {
    protected SecurityFactory securityFactory;
    protected PropertiesFactory propertiesFactory;
    protected SslFactory sslFactory;
    protected IpcFactory ipcFactory;
    protected JaasloginFactory lf;
    protected SecurityprotocolFactory secProFactory;

    public EList buildRootElements() {
        BasicEList securityExtent = new BasicEList();
        System.out.println("buildRootElements");
        securityExtent.add(this.buildSampleSecurity());
        return securityExtent;
    }

    public Security buildSampleSecurity() {
        System.out.println("buildSampleSecurity");
        Security security2 = this.securityFactory.createSecurity();
        security2.setEnabled(false);
        security2.setAppEnabled(true);
        security2.setUseLocalSecurityServer(true);
        security2.setUseDomainQualifiedUserNames(false);
        security2.setIssuePermissionWarning(true);
        security2.setCacheTimeout(600);
        security2.setActiveProtocol(IIOPSecurityProtocolKind.BOTH_LITERAL);
        security2.setEnforceJava2Security(false);
        security2.setDynamicallyUpdateSSLConfig(false);
        security2.setInternalServerId("serverId");
        security2.setDynamicallyUpdateSSLConfig(true);
        DescriptiveProperty dp1 = this.propertiesFactory.createDescriptiveProperty();
        dp1.setName("com.ibm.wsspi.security.web.webAuthReq");
        dp1.setValue("lazy");
        dp1.setType("String");
        dp1.setDisplayNameKey("");
        dp1.setRange("lazy,persisting,always");
        dp1.setNlsRangeKey("");
        dp1.setInclusive(false);
        dp1.setFirstClass(false);
        dp1.setHoverHelpKey("");
        DescriptiveProperty dp2 = this.propertiesFactory.createDescriptiveProperty();
        dp2.setName("com.ibm.wsspi.security.web.failOverToBasicAuth");
        dp2.setValue("false");
        dp2.setType("boolean");
        dp2.setDisplayNameKey("");
        dp2.setRange("");
        dp2.setNlsRangeKey("");
        dp2.setInclusive(false);
        dp2.setFirstClass(false);
        dp2.setHoverHelpKey("");
        security2.getWebAuthAttrs().add(dp1);
        security2.getWebAuthAttrs().add(dp2);
        KRB5 krb = this.securityFactory.createKRB5();
        krb.setOID("oid:1.2.840.113554.1.2.2");
        krb.setAuthConfig("system.KRB5");
        krb.setSimpleAuthConfig("system.KRB5");
        krb.setAuthValidationConfig("system.KRB5");
        krb.setAuthContextImplClass("com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl");
        krb.setKrb5Spn("WAS101/ks.austin.ibm.com");
        krb.setKrb5Realm("WSSEC.AUSTIN.IBM.COM");
        krb.setKrb5Config("C:\\winnt\\krb5.conf");
        krb.setKrb5Keytab("C:\\winnt\\krb5.keytab");
        krb.setTrimUserName(true);
        krb.setAllowLTPAAuth(true);
        System.out.println("Generated Kerberos authentication mechanism");
        security2.getAuthMechanisms().add(krb);
        SWAMAuthentication am = this.securityFactory.createSWAMAuthentication();
        am.setOID("No OID for this mechanism");
        am.setAuthConfig("system.SWAM");
        am.setSimpleAuthConfig("system.SWAM");
        am.setAuthValidationConfig("system.SWAM");
        am.setAuthContextImplClass("com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContext");
        security2.getAuthMechanisms().add(am);
        LTPA am1 = this.securityFactory.createLTPA();
        am1.setOID("oid:1.3.18.0.2.30.2");
        am1.setAuthConfig("system.LTPA");
        am1.setSimpleAuthConfig("system.LTPA");
        am1.setAuthValidationConfig("system.LTPA");
        am1.setAuthContextImplClass("com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl");
        security2.getAuthMechanisms().add(am);
        TrustAssociation ta = this.securityFactory.createTrustAssociation();
        TAInterceptor tai = this.securityFactory.createTAInterceptor();
        tai.setInterceptorClassName("com.ibm.ws.security.web.WebSealTrustAssociationInterceptor");
        ta.getInterceptors().add(tai);
        ta.setEnabled(false);
        SingleSignon sso = this.securityFactory.createSingleSignon();
        sso.setRequiresSSL(false);
        sso.setEnabled(true);
        sso.setDomainName("");
        System.out.println("added setActiveAuthMechanism");
        LocalOSUserRegistry localOSUserReg = this.securityFactory.createLocalOSUserRegistry();
        localOSUserReg.setServerId("");
        localOSUserReg.setServerPassword("");
        localOSUserReg.setRealm("");
        Resource r = localOSUserReg.eResource();
        if (r instanceof XMIResource) {
            ((XMIResource)r).setID(localOSUserReg, "LocalOSUserRegistry");
        }
        security2.getUserRegistries().add(localOSUserReg);
        CustomUserRegistry reg2 = this.securityFactory.createCustomUserRegistry();
        reg2.setCustomRegistryClassName("com.ibm.websphere.security.FileRegistrySample");
        security2.getUserRegistries().add(reg2);
        LDAPUserRegistry reg1 = this.securityFactory.createLDAPUserRegistry();
        System.out.println("Generated SSL config");
        ManagementScope mscope1 = this.sslFactory.createManagementScope();
        ManagementScope mscope2 = this.sslFactory.createManagementScope();
        mscope1.setScopeName("(cell):$(cell.name)");
        mscope1.setScopeType("cell");
        mscope2.setScopeName("(cell):$(cell.name):(node):$(node.name)");
        mscope2.setScopeType("node");
        security2.getManagementScopes().add(mscope1);
        security2.getManagementScopes().add(mscope2);
        WSCertificateExpirationMonitor cfm1 = this.sslFactory.createWSCertificateExpirationMonitor();
        WSCertificateExpirationMonitor cfm2 = this.sslFactory.createWSCertificateExpirationMonitor();
        WSNotification noti1 = this.sslFactory.createWSNotification();
        WSNotification noti2 = this.sslFactory.createWSNotification();
        WSSchedule sched1 = this.sslFactory.createWSSchedule();
        WSSchedule sched2 = this.sslFactory.createWSSchedule();
        sched1.setName("daily");
        sched1.setFrequency(1);
        sched1.setHour(2);
        sched1.setMinute(30);
        sched1.setNextStartDate(388584832L);
        sched2.setName("weekly");
        sched2.setDayOfWeek(2);
        sched2.setFrequency(7);
        sched2.setHour(4);
        sched2.setMinute(30);
        sched2.setNextStartDate(388584832L);
        security2.getWsSchedules().add(sched1);
        security2.getWsSchedules().add(sched2);
        noti1.setName("mailing");
        noti1.setLogToSystemOut(false);
        noti1.setSendEmail(true);
        noti1.setEmailList("utle@us.ibm.com:pbirk@us.ibm.com:alaine@us.ibm.com");
        noti1.setEmailFormat(EmailFormatKind.HTML_LITERAL);
        noti1.setSendSecure(true);
        noti1.setSslConfig("defaultSSLConfig");
        noti2.setName("logging");
        noti2.setLogToSystemOut(true);
        noti2.setSendEmail(false);
        noti2.setEmailList("");
        noti2.setEmailFormat(EmailFormatKind.TEXT_LITERAL);
        noti2.setSendSecure(false);
        noti2.setSslConfig("defaultSSLConfig");
        security2.getWsNotifications().add(noti1);
        security2.getWsNotifications().add(noti2);
        cfm1.setName("certExp_1");
        cfm1.setAutoReplace(false);
        cfm1.setDeleteOld(true);
        cfm1.setDaysBeforeNotification(30);
        cfm1.setIsEnabled(true);
        cfm1.setCertImplClassToReplaceCert("certImplClass");
        cfm1.setWsNotification(noti1);
        cfm1.setWsSchedule(sched1);
        security2.setWsCertificateExpirationMonitor(cfm1);
        KeyStore keyStore = this.sslFactory.createKeyStore();
        keyStore.setName("DefaultKeyStore");
        keyStore.setPassword("{xor}CDo9Hgw=");
        keyStore.setProvider("IBMJCE");
        keyStore.setLocation("file://${USER_INSTALL_ROOT}/etc/DummyServerKeyFile.jks");
        keyStore.setType("JKS");
        keyStore.setFileBased(true);
        keyStore.setHostList("");
        keyStore.setReadOnly(false);
        keyStore.setInitializeAtStartup(true);
        keyStore.setCustomProviderClass("");
        keyStore.setUseForAcceleration(false);
        keyStore.setManagementScope(mscope1);
        keyStore.setDescription("keyStore description");
        keyStore.setUsage("SSL");
        KeyStore trustStore = this.sslFactory.createKeyStore();
        trustStore.setName("DefaultTrustStore");
        trustStore.setPassword("{xor}CDo9Hgw=");
        trustStore.setProvider("IBMJCE");
        trustStore.setLocation("file://${USER_INSTALL_ROOT}/etc/DummyServerTrustFile.jks");
        trustStore.setType("JKS");
        trustStore.setFileBased(true);
        trustStore.setHostList("");
        trustStore.setReadOnly(false);
        trustStore.setInitializeAtStartup(true);
        trustStore.setCustomProviderClass("");
        trustStore.setUseForAcceleration(false);
        trustStore.setManagementScope(mscope1);
        security2.getKeyStores().add(keyStore);
        security2.getKeyStores().add(trustStore);
        TrustManager tm1 = this.sslFactory.createTrustManager();
        DescriptiveProperty enableCRLDP = this.propertiesFactory.createDescriptiveProperty();
        DescriptiveProperty checkRevocation = this.propertiesFactory.createDescriptiveProperty();
        enableCRLDP.setName("com.ibm.security.enableCRLDP");
        enableCRLDP.setValue("true");
        enableCRLDP.setType("boolean");
        enableCRLDP.setDisplayNameKey("");
        enableCRLDP.setRange("");
        enableCRLDP.setNlsRangeKey("");
        enableCRLDP.setInclusive(false);
        enableCRLDP.setFirstClass(false);
        enableCRLDP.setHoverHelpKey("");
        checkRevocation.setName("com.ibm.jsse2.checkRevocation");
        checkRevocation.setValue("true");
        checkRevocation.setType("boolean");
        checkRevocation.setDisplayNameKey("");
        checkRevocation.setRange("");
        checkRevocation.setNlsRangeKey("");
        checkRevocation.setInclusive(false);
        checkRevocation.setFirstClass(false);
        checkRevocation.setHoverHelpKey("");
        tm1.getAdditionalTrustManagerAttrs().add(enableCRLDP);
        tm1.getAdditionalTrustManagerAttrs().add(checkRevocation);
        tm1.setName("IbmX509");
        tm1.setProvider("IBMJCE");
        tm1.setAlgorithm("IbmX509");
        tm1.setManagementScope(mscope1);
        TrustManager tm2 = this.sslFactory.createTrustManager();
        tm2.setName("IbmPKIX");
        tm2.setProvider("IBMJCE");
        tm2.setAlgorithm("IbmPKIX");
        tm2.setTrustManagerClass("");
        tm2.setManagementScope(mscope1);
        security2.getTrustManagers().add(tm1);
        security2.getTrustManagers().add(tm2);
        KeyManager km1 = this.sslFactory.createKeyManager();
        km1.setName("IbmX509");
        km1.setProvider("IBMJCE");
        km1.setAlgorithm("IbmX509");
        km1.setKeyManagerClass("");
        km1.setManagementScope(mscope1);
        security2.getKeyManagers().add(km1);
        KeyReference kr1 = this.sslFactory.createKeyReference();
        KeyReference kr1a = this.sslFactory.createKeyReference();
        KeyReference kr2 = this.sslFactory.createKeyReference();
        KeyReference kr3 = this.sslFactory.createKeyReference();
        kr1.setKeyAlias("keyAlias");
        kr1.setVersion(1);
        kr1.setPassword("");
        kr1a.setKeyAlias("keyAliasA");
        kr1a.setVersion(1);
        kr1a.setPassword("");
        kr2.setKeyAlias("keyAlias");
        kr2.setVersion(2);
        kr2.setPassword("");
        kr3.setKeyAlias("keyAlias");
        kr3.setVersion(3);
        kr3.setPassword("");
        KeySet kset1 = this.sslFactory.createKeySet();
        kset1.setName("LTPAPublic");
        kset1.setAliasPrefix("LTPA");
        kset1.setPassword("password");
        kset1.setMaxKeyReferences(3);
        kset1.setKeyStore(keyStore);
        kset1.setDeleteOldKeys(true);
        kset1.setKeyGenerationClass("com.ibm.ws.security.ltpa.LTPACrypto");
        kset1.setIsKeyPair(true);
        kset1.getKeyReference().add(kr1);
        kset1.getKeyReference().add(kr1a);
        kset1.setManagementScope(mscope1);
        KeySet kset1a = this.sslFactory.createKeySet();
        kset1a.setName("MYLTPAPublic");
        kset1a.setAliasPrefix("MYLTPA");
        kset1a.setPassword("password");
        kset1a.setMaxKeyReferences(3);
        kset1a.setKeyStore(keyStore);
        kset1a.setDeleteOldKeys(true);
        kset1a.setKeyGenerationClass("com.ibm.ws.security.ltpa.LTPACrypto");
        kset1a.setIsKeyPair(true);
        kset1a.getKeyReference().add(kr2);
        kset1a.setManagementScope(mscope1);
        KeySet kset2 = this.sslFactory.createKeySet();
        kset2.setName("LTPAPrivate");
        kset2.setAliasPrefix("LTPA");
        kset2.setPassword("password");
        kset2.setMaxKeyReferences(6);
        kset2.setKeyStore(keyStore);
        kset2.setDeleteOldKeys(false);
        kset2.setKeyGenerationClass("com.ibm.ws.security.ltpa.LTPACrypto");
        kset2.setIsKeyPair(true);
        kset2.getKeyReference().add(kr3);
        kset2.setManagementScope(mscope2);
        security2.getKeySets().add(kset1);
        security2.getKeySets().add(kset1a);
        security2.getKeySets().add(kset2);
        KeySetGroup kSetG1 = this.sslFactory.createKeySetGroup();
        kSetG1.setName("LTPAPublicSet");
        kSetG1.setAutoGenerate(true);
        kSetG1.setWsSchedule(sched1);
        kSetG1.getKeySet().add(kset1);
        kSetG1.getKeySet().add(kset1a);
        kSetG1.setManagementScope(mscope1);
        KeySetGroup kSetG2 = this.sslFactory.createKeySetGroup();
        kSetG2.setName("LTPAPrivateSet");
        kSetG2.setAutoGenerate(false);
        kSetG2.setWsSchedule(sched2);
        kSetG2.getKeySet().add(kset2);
        kSetG2.setManagementScope(mscope2);
        security2.getKeySetGroups().add(kSetG1);
        security2.getKeySetGroups().add(kSetG2);
        SSLConfig sslcfg1 = this.securityFactory.createSSLConfig();
        SSLConfig sslcfg2 = this.securityFactory.createSSLConfig();
        SecureSocketLayer ssl1 = this.sslFactory.createSecureSocketLayer();
        SecureSocketLayer ssl2 = this.sslFactory.createSecureSocketLayer();
        ssl1.setClientAuthentication(false);
        ssl1.setSecurityLevel(SSLSecurityLevel.HIGH_LITERAL);
        ssl1.setEnableCryptoHardwareSupport(false);
        ssl1.setEnabledCiphers("");
        ssl1.setJsseProvider("IBMJSSE2");
        ssl1.setClientAuthenticationSupported(false);
        ssl1.setSslProtocol("SSL_TLS");
        ssl1.getTrustManager().add(tm1);
        ssl1.setKeyManager(km1);
        ssl1.setKeyStore(keyStore);
        ssl1.setTrustStore(trustStore);
        sslcfg1.setAlias("DefaultSSLConfig");
        sslcfg1.setSetting(ssl1);
        sslcfg1.setManagementScope(mscope1);
        ssl2.setClientAuthentication(true);
        ssl2.setSecurityLevel(SSLSecurityLevel.HIGH_LITERAL);
        ssl2.setEnableCryptoHardwareSupport(false);
        ssl2.setEnabledCiphers("");
        ssl2.setJsseProvider("IBMJSSE2");
        ssl2.setClientAuthenticationSupported(true);
        ssl2.setSslProtocol("SSL_TLS");
        ssl1.getTrustManager().add(tm2);
        ssl1.setKeyManager(km1);
        ssl2.setKeyStore(keyStore);
        ssl2.setTrustStore(trustStore);
        sslcfg2.setAlias("AdminSSL");
        sslcfg2.setSetting(ssl2);
        sslcfg2.setManagementScope(mscope1);
        security2.getRepertoire().add(sslcfg1);
        security2.getRepertoire().add(sslcfg2);
        SSLConfigGroup sslCG1 = this.securityFactory.createSSLConfigGroup();
        SSLConfigGroup sslCG2 = this.securityFactory.createSSLConfigGroup();
        SSLConfigGroup sslCG3 = this.securityFactory.createSSLConfigGroup();
        SSLConfigGroup sslCG4 = this.securityFactory.createSSLConfigGroup();
        sslCG1.setName("CellInbound");
        sslCG1.setDirection("inbound");
        sslCG1.setManagementScope(mscope1);
        sslCG1.setSslConfig(sslcfg1);
        sslCG1.setCertificateAlias("websphere dummy server");
        sslCG2.setName("CellOutbound");
        sslCG2.setDirection("outbound");
        sslCG2.setManagementScope(mscope1);
        sslCG2.setSslConfig(sslcfg1);
        sslCG2.setCertificateAlias("websphere dummy server");
        sslCG3.setName("NodeInbound");
        sslCG3.setDirection("inbound");
        sslCG3.setManagementScope(mscope2);
        sslCG2.setSslConfig(sslcfg2);
        sslCG2.setCertificateAlias("websphere dummy server");
        sslCG4.setName("NodeOutbound");
        sslCG4.setDirection("outbound");
        sslCG4.setManagementScope(mscope2);
        sslCG2.setSslConfig(sslcfg2);
        sslCG4.setCertificateAlias("websphere dummy server");
        security2.getSslConfigGroups().add(sslCG1);
        security2.getSslConfigGroups().add(sslCG2);
        security2.getSslConfigGroups().add(sslCG3);
        security2.getSslConfigGroups().add(sslCG4);
        DynamicSSLConfigSelection dSslCG1 = this.securityFactory.createDynamicSSLConfigSelection();
        dSslCG1.setName("AdminSSLOutbound");
        dSslCG1.setDescription("Uses the AdminSSL configuration for all outbound SOAP calls.");
        dSslCG1.setDynamicSelectionInfo("ADMIN_SOAP,*,*");
        dSslCG1.setCertificateAlias("websphere dummy server");
        dSslCG1.setSslConfig(sslcfg1);
        dSslCG1.setManagementScope(mscope1);
        security2.getDynamicSSLConfigSelections().add(dSslCG1);
        am1.setTrustAssociation(ta);
        am1.setPassword("");
        am1.setTimeout(120L);
        am1.setSingleSignon(sso);
        am1.setKeySetGroup(kSetG1);
        security2.getAuthMechanisms().add(am1);
        security2.setActiveAuthMechanism(am);
        LDAPSearchFilter sf = this.securityFactory.createLDAPSearchFilter();
        sf.setGroupFilter("(&(cn=%v)(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)))");
        sf.setUserFilter("(&(uid=%v)(objectclass=inetOrgPerson))");
        sf.setUserIdMap("inetOrgPerson:uid");
        sf.setGroupIdMap("*:cn");
        sf.setGroupMemberIdMap("groupOfNames:member;groupOfUniqueNames:uniqueMember");
        sf.setCertificateMapMode(CertificateMapMode.EXACT_DN_LITERAL);
        sf.setCertificateFilter("");
        reg1.setSslEnabled(false);
        reg1.setBaseDN("");
        reg1.setBindDN("");
        reg1.setBindPassword("");
        reg1.setType(LDAPDirectoryType.SECUREWAY_LITERAL);
        reg1.setSearchFilter(sf);
        reg1.setSslConfig(sslcfg1.getAlias());
        reg1.setServerId("");
        reg1.setServerPassword("");
        reg1.setIgnoreCase(false);
        reg1.setSearchTimeout(120L);
        reg1.setReuseConnection(true);
        reg1.setUseRegistryServerId(false);
        EndPoint endPt = this.ipcFactory.createEndPoint();
        endPt.setHost("");
        endPt.setPort(389);
        reg1.getHosts().add(endPt);
        reg1.setRealm("");
        security2.getUserRegistries().add(reg1);
        security2.setActiveUserRegistry(localOSUserReg);
        WIMUserRegistry wim = this.securityFactory.createWIMUserRegistry();
        wim.setRegistryClassName("com.ibm.websphere.wim.registry.WIMUserRegistry");
        wim.setServerId("");
        wim.setServerPassword("");
        wim.setRealm("");
        security2.getUserRegistries().add(wim);
        System.out.println("added setActiveUserRegistry");
        JAASConfiguration jcnf1 = this.lf.createJAASConfiguration();
        JAASConfigurationEntry entry1 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule lm1 = this.lf.createJAASLoginModule();
        lm1.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm1.setModuleClassName("com.ibm.ws.security.common.auth.module.WSClientLoginModuleImpl");
        entry1.setAlias("ClientContainer");
        entry1.getLoginModules().add(lm1);
        jcnf1.getEntries().add(entry1);
        JAASConfigurationEntry entry2 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule lm2 = this.lf.createJAASLoginModule();
        lm2.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm2.setModuleClassName("com.ibm.ws.security.common.auth.module.WSLoginModuleImpl");
        entry2.setAlias("WSLogin");
        entry2.getLoginModules().add(lm2);
        jcnf1.getEntries().add(entry2);
        JAASConfigurationEntry entry3 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule lm3 = this.lf.createJAASLoginModule();
        lm3.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm3.setModuleClassName("com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule");
        entry3.setAlias("DefaultPrincipalMapping");
        entry3.getLoginModules().add(lm3);
        jcnf1.getEntries().add(entry3);
        security2.setApplicationLoginConfig(jcnf1);
        System.out.println("added security.setApplicationLoginConfig()");
        JAASConfiguration jcnf2 = this.lf.createJAASConfiguration();
        JAASConfigurationEntry entry24 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule lm24 = this.lf.createJAASLoginModule();
        lm24.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm24.setModuleClassName("com.ibm.ws.security.server.lm.swamLoginModule");
        entry24.setAlias("SWAM");
        entry24.getLoginModules().add(lm24);
        jcnf2.getEntries().add(entry24);
        JAASConfigurationEntry entry25 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule lm25 = this.lf.createJAASLoginModule();
        lm25.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm25.setModuleClassName("com.ibm.ws.security.server.lm.ltpaLoginModule");
        entry25.setAlias("LTPA");
        entry25.getLoginModules().add(lm25);
        jcnf2.getEntries().add(entry25);
        JAASConfigurationEntry entry26 = this.lf.createJAASConfigurationEntry();
        JAASLoginModule lm26 = this.lf.createJAASLoginModule();
        Property prop26 = this.propertiesFactory.createProperty();
        prop26.setName("delegate");
        prop26.setValue("com.ibm.ws.security.web.PreAuthenLoginModule");
        lm26.getOptions().add(prop26);
        lm26.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm26.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        JAASLoginModule lm27 = this.lf.createJAASLoginModule();
        Property prop27 = this.propertiesFactory.createProperty();
        prop27.setName("delegate");
        prop27.setValue("com.ibm.ws.security.web.AuthenLoginModule");
        lm27.getOptions().add(prop27);
        lm27.setAuthenticationStrategy(JAASModuleControlFlag.REQUIRED_LITERAL);
        lm27.setModuleClassName("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy");
        entry26.setAlias("SLTPA");
        entry26.getLoginModules().add(lm26);
        entry26.getLoginModules().add(lm27);
        jcnf2.getEntries().add(entry26);
        security2.setSystemLoginConfig(jcnf2);
        System.out.println("added security.setSystemLoginConfig()");
        IIOPSecurityProtocol csiv2Cfg = this.secProFactory.createIIOPSecurityProtocol();
        CommonSecureInterop claimCSI = this.secProFactory.createCommonSecureInterop();
        r = claimCSI.eResource();
        if (r instanceof XMIResource) {
            ((XMIResource)r).setID(claimCSI, "CSIv2 Inbound Configuration");
        }
        security2.getUserRegistries().add(localOSUserReg);
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        claimCSI.setStateful(csiv2.getBoolean("DefaultClaimStateful"));
        IdentityAssertionLayer csiv2ClaimIDALayer = this.secProFactory.createIdentityAssertionLayer();
        IdentityAssertionQOP csiv2ClaimIDAQOPSupported = this.secProFactory.createIdentityAssertionQOP();
        csiv2ClaimIDAQOPSupported.setEnable(csiv2.getBoolean("DefaultClaimIdentityAssertionSupported"));
        csiv2ClaimIDAQOPSupported.setTrustedId("trustedId");
        csiv2ClaimIDAQOPSupported.setTrustedPassword("trustedPassword");
        csiv2ClaimIDALayer.setSupportedQOP(csiv2ClaimIDAQOPSupported);
        claimCSI.getLayers().add(csiv2ClaimIDALayer);
        MessageLayer csiv2ClaimMessageLayer = this.secProFactory.createMessageLayer();
        csiv2ClaimMessageLayer.setSupportedAuthMechList("Kerberos LTPA BasicAuth Custom");
        MessageQOP csiv2ClaimMessageLayerQOPSupported = this.secProFactory.createMessageQOP();
        csiv2ClaimMessageLayerQOPSupported.setEstablishTrustInClient(csiv2.getBoolean("DefaultClaimClientAuthenticationSupported"));
        csiv2ClaimMessageLayer.setSupportedQOP(csiv2ClaimMessageLayerQOPSupported);
        MessageQOP csiv2ClaimMessageLayerQOPRequired = this.secProFactory.createMessageQOP();
        csiv2ClaimMessageLayerQOPRequired.setEstablishTrustInClient(csiv2.getBoolean("DefaultClaimClientAuthenticationRequired"));
        csiv2ClaimMessageLayer.setRequiredQOP(csiv2ClaimMessageLayerQOPRequired);
        claimCSI.getLayers().add(csiv2ClaimMessageLayer);
        TransportLayer csiv2ClaimIIOPTransportLayer = this.secProFactory.createTransportLayer();
        TransportQOP csiv2ClaimTransportQOPSupported = this.secProFactory.createTransportQOP();
        csiv2ClaimTransportQOPSupported.setEnableProtection(csiv2.getBoolean("DefaultClaimTransportAssocSSLTLSSupported"));
        csiv2ClaimTransportQOPSupported.setEstablishTrustInClient(csiv2.getBoolean("DefaultClaimClientAuthenticationSupported"));
        csiv2ClaimTransportQOPSupported.setIntegrity(csiv2.getBoolean("DefaultClaimMessageIntegritySupported"));
        csiv2ClaimTransportQOPSupported.setConfidentiality(csiv2.getBoolean("DefaultClaimMessageConfidentialitySupported"));
        csiv2ClaimIIOPTransportLayer.setSupportedQOP(csiv2ClaimTransportQOPSupported);
        TransportQOP csiv2ClaimTransportQOPRequired = this.secProFactory.createTransportQOP();
        csiv2ClaimTransportQOPRequired.setEnableProtection(csiv2.getBoolean("DefaultClaimTransportAssocSSLTLSRequired"));
        csiv2ClaimTransportQOPRequired.setEstablishTrustInClient(csiv2.getBoolean("DefaultClaimTLClientAuthenticationRequired"));
        csiv2ClaimTransportQOPRequired.setIntegrity(csiv2.getBoolean("DefaultClaimMessageIntegrityRequired"));
        csiv2ClaimTransportQOPRequired.setConfidentiality(csiv2.getBoolean("DefaultClaimMessageConfidentialityRequired"));
        csiv2ClaimIIOPTransportLayer.setRequiredQOP(csiv2ClaimTransportQOPRequired);
        IIOPTransport csiv2ClaimIIOPTransportSSLServerAuth = this.secProFactory.createIIOPTransport();
        SSLConfig csiv2ClaimSSLConfigServerAuth = sslcfg1;
        csiv2ClaimIIOPTransportSSLServerAuth.setSslConfig(csiv2ClaimSSLConfigServerAuth.getAlias());
        csiv2ClaimIIOPTransportLayer.setServerAuthentication(csiv2ClaimIIOPTransportSSLServerAuth);
        claimCSI.getLayers().add(csiv2ClaimIIOPTransportLayer);
        csiv2Cfg.setClaims(claimCSI);
        CommonSecureInterop performCSI = this.secProFactory.createCommonSecureInterop();
        r = performCSI.eResource();
        if (r instanceof XMIResource) {
            ((XMIResource)r).setID(performCSI, "CSIv2 Outbound Configuration");
        }
        security2.getUserRegistries().add(localOSUserReg);
        performCSI.setStateful(csiv2.getBoolean("DefaultPerformStateful"));
        performCSI.setSessionGCInterval(csiv2.getInteger("DefaultSessionGCinterval"));
        performCSI.setSessionGCIdleTime(csiv2.getInteger("DefaultSessionGCdiscardunused"));
        IdentityAssertionLayer csiv2PerformIDALayer = this.secProFactory.createIdentityAssertionLayer();
        IdentityAssertionQOP csiv2PerformIDAQOPSupported = this.secProFactory.createIdentityAssertionQOP();
        csiv2PerformIDAQOPSupported.setEnable(csiv2.getBoolean("DefaultPerformIdentityAssertionSupported"));
        csiv2PerformIDAQOPSupported.setTrustedId("trustedId");
        csiv2PerformIDAQOPSupported.setTrustedPassword("trustedPassword");
        csiv2PerformIDALayer.setSupportedQOP(csiv2PerformIDAQOPSupported);
        IdentityAssertionQOP csiv2PerformIDAQOPRequired = this.secProFactory.createIdentityAssertionQOP();
        csiv2PerformIDAQOPRequired.setEnable(csiv2.getBoolean("DefaultPerformIdentityAssertionRequired"));
        csiv2PerformIDAQOPRequired.setTrustedId("trustedId");
        csiv2PerformIDAQOPRequired.setTrustedPassword("trustedPassword");
        csiv2PerformIDALayer.setRequiredQOP(csiv2PerformIDAQOPRequired);
        performCSI.getLayers().add(csiv2PerformIDALayer);
        MessageLayer csiv2PerformMessageLayer = this.secProFactory.createMessageLayer();
        csiv2PerformMessageLayer.setAuthenticationLayerRetryCount(csiv2.getInteger("DefaultAuthenticationRetryCount"));
        csiv2PerformMessageLayer.setSupportedAuthMechList("Kerberos LTPA BasicAuth Custom");
        MessageQOP csiv2PerformMessageLayerQOPSupported = this.secProFactory.createMessageQOP();
        csiv2PerformMessageLayerQOPSupported.setEstablishTrustInClient(csiv2.getBoolean("DefaultPerformClientAuthenticationSupported"));
        csiv2PerformMessageLayer.setSupportedQOP(csiv2PerformMessageLayerQOPSupported);
        MessageQOP csiv2PerformMessageLayerQOPRequired = this.secProFactory.createMessageQOP();
        csiv2PerformMessageLayerQOPRequired.setEstablishTrustInClient(csiv2.getBoolean("DefaultPerformClientAuthenticationRequired"));
        csiv2PerformMessageLayer.setRequiredQOP(csiv2PerformMessageLayerQOPRequired);
        performCSI.getLayers().add(csiv2PerformMessageLayer);
        TransportLayer csiv2PerformIIOPTransportLayer = this.secProFactory.createTransportLayer();
        TransportQOP csiv2PerformTransportQOPSupported = this.secProFactory.createTransportQOP();
        csiv2PerformTransportQOPSupported.setEnableProtection(csiv2.getBoolean("DefaultPerformTransportAssocSSLTLSSupported"));
        csiv2PerformTransportQOPSupported.setEstablishTrustInClient(csiv2.getBoolean("DefaultPerformTLClientAuthenticationSupported"));
        csiv2PerformTransportQOPSupported.setIntegrity(csiv2.getBoolean("DefaultPerformMessageIntegritySupported"));
        csiv2PerformTransportQOPSupported.setConfidentiality(csiv2.getBoolean("DefaultPerformMessageConfidentialitySupported"));
        csiv2PerformIIOPTransportLayer.setSupportedQOP(csiv2PerformTransportQOPSupported);
        TransportQOP csiv2PerformTransportQOPRequired = this.secProFactory.createTransportQOP();
        csiv2PerformTransportQOPRequired.setEnableProtection(csiv2.getBoolean("DefaultPerformTransportAssocSSLTLSRequired"));
        csiv2PerformTransportQOPRequired.setEstablishTrustInClient(csiv2.getBoolean("DefaultPerformTLClientAuthenticationRequired"));
        csiv2PerformTransportQOPRequired.setIntegrity(csiv2.getBoolean("DefaultPerformMessageIntegrityRequired"));
        csiv2PerformTransportQOPRequired.setConfidentiality(csiv2.getBoolean("DefaultPerformMessageConfidentialityRequired"));
        csiv2PerformIIOPTransportLayer.setRequiredQOP(csiv2PerformTransportQOPRequired);
        IIOPTransport csiv2PerformIIOPTransportSSLServerAuth = this.secProFactory.createIIOPTransport();
        SSLConfig csiv2PerformSSLConfig = sslcfg1;
        csiv2PerformIIOPTransportSSLServerAuth.setSslConfig(csiv2PerformSSLConfig.getAlias());
        csiv2PerformIIOPTransportLayer.setServerAuthentication(csiv2PerformIIOPTransportSSLServerAuth);
        performCSI.getLayers().add(csiv2PerformIIOPTransportLayer);
        csiv2Cfg.setPerforms(performCSI);
        security2.setCSI(csiv2Cfg);
        System.out.println("Generated CSIv2");
        IIOPSecurityProtocol sas = this.secProFactory.createIIOPSecurityProtocol();
        SecureAssociationService claimSAS = this.secProFactory.createSecureAssociationService();
        TransportLayer sasClaimIIOPTransportLayer = this.secProFactory.createTransportLayer();
        TransportQOP sasClaimTransportQOPSupported = this.secProFactory.createTransportQOP();
        sasClaimTransportQOPSupported.setEnableProtection(true);
        sasClaimTransportQOPSupported.setIntegrity(csiv2.getBoolean("DefaultClaimMessageIntegritySupported"));
        sasClaimTransportQOPSupported.setConfidentiality(csiv2.getBoolean("DefaultClaimMessageConfidentialitySupported"));
        sasClaimIIOPTransportLayer.setSupportedQOP(sasClaimTransportQOPSupported);
        IIOPTransport sasClaimIIOPTransportSSLServerAuth = this.secProFactory.createIIOPTransport();
        SSLConfig sasClaimSSLConfigServerAuth = sslcfg1;
        sasClaimIIOPTransportSSLServerAuth.setSslConfig(sasClaimSSLConfigServerAuth.getAlias());
        sasClaimIIOPTransportLayer.setServerAuthentication(sasClaimIIOPTransportSSLServerAuth);
        claimSAS.getLayers().add(sasClaimIIOPTransportLayer);
        sas.setClaims(claimSAS);
        SecureAssociationService performSAS = this.secProFactory.createSecureAssociationService();
        TransportLayer sasPerformIIOPTransportLayer = this.secProFactory.createTransportLayer();
        TransportQOP sasPerformTransportQOPSupported = this.secProFactory.createTransportQOP();
        sasPerformTransportQOPSupported.setEnableProtection(true);
        sasPerformTransportQOPSupported.setIntegrity(csiv2.getBoolean("DefaultPerformMessageIntegrity"));
        sasPerformTransportQOPSupported.setConfidentiality(csiv2.getBoolean("DefaultPerformMessageConfidentiality"));
        sasPerformIIOPTransportLayer.setSupportedQOP(sasPerformTransportQOPSupported);
        IIOPTransport sasPerformIIOPTransportSSLServerAuth = this.secProFactory.createIIOPTransport();
        SSLConfig sasPerformSSLConfigServerAuth = sslcfg1;
        sasPerformIIOPTransportSSLServerAuth.setSslConfig(sasPerformSSLConfigServerAuth.getAlias());
        sasPerformIIOPTransportLayer.setServerAuthentication(sasPerformIIOPTransportSSLServerAuth);
        performSAS.getLayers().add(sasPerformIIOPTransportLayer);
        sas.setPerforms(performSAS);
        security2.setIBM(sas);
        System.out.println("Generated SAS");
        WSSecurityScannerMonitor ssm = this.securityFactory.createWSSecurityScannerMonitor();
        ssm.setName("scanMonitorOne");
        ssm.setIsEnabled(false);
        ssm.setExtRegFilterListForSchedule("");
        ssm.setExtRegFilterListForStart("");
        ssm.setWsNotification(noti1);
        ssm.setWsSchedule(sched1);
        security2.setWsSecurityScannerMonitor(ssm);
        System.out.println("Generated Scanner Monitor");
        CAClient caC1 = this.securityFactory.createCAClient();
        CAClient caC2 = this.securityFactory.createCAClient();
        CAClient caC3 = this.securityFactory.createCAClient();
        caC1.setName("PKIX");
        caC1.setHost("ks.austin.ibm.com");
        caC1.setPkiClientImplClass("");
        caC1.setUserId("");
        caC1.setPassword("");
        caC1.setBaseDn("");
        caC1.setFrequencyCheck(30);
        caC1.setManagementScope(mscope1);
        caC2.setName("Entrust");
        caC2.setHost("sandpiper.austin.ibm.com");
        caC2.setPkiClientImplClass("");
        caC2.setUserId("");
        caC2.setPassword("");
        caC2.setBaseDn("");
        caC2.setFrequencyCheck(60);
        caC2.setManagementScope(mscope1);
        caC2.getBackupCAs().add(caC1);
        caC3.setName("Custom");
        caC3.setHost("sandpiper.austin.ibm.com");
        caC3.setPkiClientImplClass("");
        caC3.setUserId("");
        caC3.setPassword("");
        caC3.setBaseDn("");
        caC3.setFrequencyCheck(45);
        caC3.setManagementScope(mscope1);
        caC3.getBackupCAs().add(caC1);
        caC3.getBackupCAs().add(caC2);
        CACertificate caCert1 = this.securityFactory.createCACertificate();
        caCert1.setAlias("myAlias1");
        caCert1.setPollingStatus(PollingStatusKind.COMPLETE_LITERAL);
        caCert1.setKeyStore(keyStore);
        caCert1.setCaClient(caC1);
        security2.getCertificates().add(caCert1);
        CACertificate caCert2 = this.securityFactory.createCACertificate();
        caCert2.setAlias("myAlias2");
        caCert2.setPollingStatus(PollingStatusKind.PENDING_LITERAL);
        caCert2.setKeyStore(keyStore);
        caCert2.setCaClient(caC2);
        security2.getCertificates().add(caCert2);
        security2.getCaClients().add(caC1);
        security2.getCaClients().add(caC2);
        security2.getCaClients().add(caC3);
        System.out.println("Generated CA client");
        Certificate cert1 = this.securityFactory.createCertificate();
        Certificate cert2 = this.securityFactory.createCertificate();
        cert1.setAlias("aliasName1");
        cert1.setKeyStore(keyStore);
        cert2.setAlias("aliasName2");
        cert2.setKeyStore(keyStore);
        security2.getCertificates().add(cert1);
        security2.getCertificates().add(cert2);
        System.out.println("Generated certificates");
        RSAToken rsaToken = this.securityFactory.createRSAToken();
        rsaToken.setOID("oid:1.3.18.0.2.30.6");
        rsaToken.setAuthConfig("system.DEFAULT");
        rsaToken.setSimpleAuthConfig("system.DEFAULT");
        rsaToken.setAuthValidationConfig("system.DEFAULT");
        rsaToken.setAuthContextImplClass("com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextrsaTokenImpl");
        rsaToken.setTokenExpiration(600L);
        rsaToken.setNonceCacheTimeout(1200L);
        rsaToken.setAdminCertificate(cert2);
        rsaToken.setAdminCertificateTrustStore(keyStore);
        security2.setAdminPreferredAuthMech(rsaToken);
        security2.getAuthMechanisms().add(rsaToken);
        System.out.println("Generated RSAToken authentication mechanism");
        return security2;
    }

    public String getDocumentName() {
        return "security.xml";
    }

    public void initializeFactories() {
        super.initializeFactories();
        SecurityPackage securitypkg = (SecurityPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi");
        this.securityFactory = securitypkg.getSecurityFactory();
        PropertiesPackage propertiespkg = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propertiesFactory = propertiespkg.getPropertiesFactory();
        IpcPackage ipcpkg = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcpkg.getIpcFactory();
        SslPackage sslpkg = (SslPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.ssl.xmi");
        this.sslFactory = sslpkg.getSslFactory();
        this.lf = (JaasloginFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/jaaslogin.xmi").getEFactoryInstance();
        SecurityprotocolPackage secPropkg = (SecurityprotocolPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi");
        this.secProFactory = secPropkg.getSecurityprotocolFactory();
    }

    public static void main(String[] args) {
        SampleSecurityConfigBuilder builder = new SampleSecurityConfigBuilder();
        builder.write();
    }
}

