/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import java.io.File;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;

public final class SSLConfigValidation {
    static WSPKCSInKeyStoreList pkStoreL = new WSPKCSInKeyStoreList();
    static WSPKCSInKeyStore wspkStore = null;
    private static final TraceComponent tc = Tr.register(SSLConfigValidation.class, null, "com.ibm.ejs.resources.security");

    public static int checkTokenLibFile(String tokenType, String tokenLibFile, String tokenSlot, String tokenPasswordEncoded, String serverAlias, String clientAlias) {
        int status;
        block12: {
            File libFile;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkTokenLibFile");
            }
            String tokenPassword = PasswordUtil.passwordDecode(tokenPasswordEncoded);
            String tokenLib = SSLConfigValidation.resolveInstallRoot(tokenLibFile);
            status = 0;
            String slot = tokenSlot;
            if (slot == null || slot.equals("")) {
                slot = "0";
            }
            if ((libFile = new File(tokenLib)) == null || !libFile.isFile() || !libFile.canRead()) {
                status = 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tokenLib file not found.");
                }
            }
            if (status == 0) {
                try {
                    wspkStore = pkStoreL.insert(tokenType, tokenLib + ":" + slot, tokenPassword, true, false);
                }
                catch (Exception ex) {
                    status = 2;
                    FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkTokenLibFile", "90");
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "invalid password.");
                }
            }
        }
        if (status == 0 && serverAlias != null && !serverAlias.equals("") && !SSLConfigValidation.findTokenAlias(serverAlias)) {
            status = 3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalid serverAlias.");
            }
        }
        if (status == 0 && clientAlias != null && !clientAlias.equals("") && !SSLConfigValidation.findTokenAlias(clientAlias)) {
            status = 4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalid clientAlias.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTokenLibFile");
        }
        return status;
    }

    public static int checkKeyFile(String fileType, String fileName, String filePasswordEncoded, String serverAlias, String clientAlias) {
        boolean found;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyFile");
        }
        String filePassword = PasswordUtil.passwordDecode(filePasswordEncoded);
        String keyFileName = SSLConfigValidation.resolveInstallRoot(fileName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyFilename: ", keyFileName);
        }
        int status = 0;
        boolean not_finished = true;
        int retry_count = 0;
        KeyStore ks = null;
        ArrayList keyStoreTypes = new ArrayList();
        while (not_finished) {
            try {
                ks = KeyStore.getInstance(fileType);
            }
            catch (Exception ex) {
                status = 2;
                FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "176");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid fileType.");
                }
                not_finished = false;
            }
            if (status != 0) continue;
            try {
                ks.load(WSKeyStore.openKeyStore(keyFileName), filePassword == null ? null : filePassword.toCharArray());
                not_finished = false;
            }
            catch (Exception ex) {
                if (ex.getMessage().equalsIgnoreCase("Invalid keystore format") || ex.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (retry_count == 0) {
                        Tr.warning(tc, "security.ssl.config.initialization.warning.invalidkeystoretype");
                        keyStoreTypes = WSKeyStore.getKeyStoreTypes();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Valid keyStore list: " + keyStoreTypes.toString());
                        }
                    }
                    if (retry_count >= keyStoreTypes.size()) {
                        status = 3;
                        FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "206");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "checkKeyFile", ex);
                        }
                        not_finished = false;
                    }
                    fileType = (String)keyStoreTypes.get(retry_count++);
                    continue;
                }
                status = 3;
                FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "219");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkKeyFile", ex);
                }
                not_finished = false;
            }
        }
        WSKeyStore wsks = new WSKeyStore();
        if (status == 0 && serverAlias != null && !serverAlias.equals("")) {
            found = false;
            try {
                found = ks.containsAlias(serverAlias);
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "242");
            }
            if (!found) {
                status = 4;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid serverAlias.");
                }
            }
        }
        if (status == 0 && clientAlias != null && !clientAlias.equals("")) {
            found = false;
            try {
                found = ks.containsAlias(clientAlias);
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "266");
            }
            if (!found) {
                status = 5;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid clientAlias.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile");
        }
        return status;
    }

    public static int checkTrustFile(String fileType, String fileName, String filePasswordEncoded) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTrustFile");
        }
        String filePassword = PasswordUtil.passwordDecode(filePasswordEncoded);
        String trustFileName = SSLConfigValidation.resolveInstallRoot(fileName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustFilename: ", trustFileName);
        }
        int status = 0;
        boolean not_finished = true;
        int retry_count = 0;
        KeyStore ts = null;
        ArrayList<Object> keyStoreTypes = new ArrayList();
        while (not_finished) {
            try {
                ts = KeyStore.getInstance(fileType);
            }
            catch (Exception ex) {
                status = 2;
                FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", "320");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid fileType.");
                }
                not_finished = false;
            }
            if (status != 0) continue;
            try {
                ts.load(WSKeyStore.openKeyStore(trustFileName), filePassword == null ? null : filePassword.toCharArray());
                not_finished = false;
            }
            catch (Exception ex) {
                if (ex.getMessage().equalsIgnoreCase("Invalid keystore format") || ex.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (retry_count == 0) {
                        Tr.warning(tc, "security.ssl.config.initialization.warning.invalidkeystoretype");
                        keyStoreTypes = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Valid keyStore list: " + keyStoreTypes.toString());
                        }
                    }
                    if (retry_count >= keyStoreTypes.size()) {
                        status = 3;
                        FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", "351");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "checkTrustFile", ex);
                        }
                        not_finished = false;
                    }
                    fileType = (String)keyStoreTypes.get(retry_count++);
                    continue;
                }
                status = 3;
                FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", "364");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkTrustFile", ex);
                }
                not_finished = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTrustFile");
        }
        return status;
    }

    private static String resolveInstallRoot(String fileName) {
        String resolvedName = fileName;
        String installRoot = "${USER_INSTALL_ROOT}";
        int len = installRoot.length();
        if (fileName.startsWith(installRoot)) {
            String replace_string = SecurityObjectLocator.getAdminData().getString(installRoot);
            StringBuffer file_buffer = new StringBuffer(fileName);
            file_buffer.replace(0, len, replace_string);
            resolvedName = file_buffer.toString();
        }
        return resolvedName;
    }

    private static boolean findTokenAlias(String alias) {
        KeyStore KS = wspkStore.getKS();
        boolean found = false;
        try {
            found = KS.containsAlias(alias);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.security.core.SSLConfigValidation.findTokenAlias", "380");
        }
        return found;
    }
}

