/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;

public class ContextManagerFactory {
    private static final TraceComponent tc = Tr.register(ContextManagerFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static final String CONTEXT_MGR_IMPL = "com.ibm.ws.security.auth.ContextManagerImpl";
    private static final String CONTEXT_MGR_PLUGIN_KEY = "com.ibm.ws.security.plugin.ContextManager";
    private static final String CONTEXT_MGR_HANDLER_KEY = "com.ibm.ws.security.plugin.ContextManager.InvocationHandler";
    private static final String plugins_list = "/META-INF/plugins.list";
    private static ConcurrentHashMap<String, ContextManager> instanceCache = new ConcurrentHashMap();
    private static SecurityConfigManager scm = null;
    private static Object lockObject = new Object();
    private static boolean isReadyToInitialize = false;
    private static boolean isSingleDomain = false;
    private static ContextManager adminContextManager = null;
    private static ContextManager applicationContextManager = null;
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextManager getInstance() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        ContextManager instance = null;
        SecurityConfigResource currentStackEntry = null;
        boolean setAdminContextManager = false;
        boolean setApplicationContextManager = false;
        boolean setSomeContextManager = false;
        if (isSingleDomain && initialized) {
            return adminContextManager;
        }
        if (scm == null) {
            if (!RasHelper.isServer()) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Executing inside client, setting isSingleDomain to true.");
                }
                isSingleDomain = true;
            } else {
                scm = SecurityObjectLocator.getSecurityConfigManager();
                boolean bl = isSingleDomain = !scm.isAdminAgent() && !scm.isMultiDomainDefined();
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance SecurityConfigManager instance " + scm);
                }
            }
            if (isSingleDomain) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSingleDomain is true, creating one instance");
                }
                adminContextManager = ContextManagerFactory.createInstance();
                adminContextManager.setDomainId("admin");
                initialized = true;
                return adminContextManager;
            }
        }
        if (scm != null && !scm.isAdminAgent()) {
            currentStackEntry = SecurityObjectLocator.peekContext();
            if (currentStackEntry != null) {
                instance = (ContextManager)currentStackEntry.getContextManager();
                if (instance != null) {
                    if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getInstance returning ContextManager from current stack entry", instance);
                    }
                    return instance;
                }
                if (currentStackEntry.isAdmin()) {
                    if (adminContextManager != null) {
                        currentStackEntry.setContextManager(adminContextManager);
                        if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getInstance returning admin ContextManager and setting it in current stack entry, ", adminContextManager);
                        }
                        return adminContextManager;
                    }
                    setAdminContextManager = true;
                    setSomeContextManager = true;
                    if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getInstance admin stack entry, admin ContextManager global null");
                    }
                } else if (currentStackEntry.isApplication()) {
                    if (applicationContextManager != null) {
                        currentStackEntry.setContextManager(applicationContextManager);
                        if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getInstance returning applicationContextManager and setting it in current stack entry, ", applicationContextManager);
                        }
                        return applicationContextManager;
                    }
                    setApplicationContextManager = true;
                    setSomeContextManager = true;
                    if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getInstance application stack entry and applicationContextManager global null");
                    }
                } else if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance current stack entry (type: " + currentStackEntry.getType() + ") ContextManager ref is null, looking up ContextManager object");
                }
            } else {
                if (adminContextManager != null) {
                    if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getInstance returning admin ContextManager, null stack entry", adminContextManager);
                    }
                    return adminContextManager;
                }
                setAdminContextManager = true;
                setSomeContextManager = true;
                if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance null stack entry, admin ContextManager global null");
                }
            }
        }
        String domainId = null;
        if (scm != null) {
            domainId = currentStackEntry != null ? scm.getDomainId(currentStackEntry) : scm.getDomainId();
        } else if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance no SecurityConfigManager instance, assuming admin");
        }
        if (domainId == null) {
            domainId = "admin";
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance using domainId " + domainId);
        }
        if ((instance = instanceCache.get(domainId)) == null) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance did not find ContextManager in cache");
            }
            Object object = lockObject;
            synchronized (object) {
                block52: {
                    instance = instanceCache.get(domainId);
                    if (instance == null && (instance = ContextManagerFactory.createInstance()) != null) {
                        instance.setDomainId(domainId);
                        instanceCache.put(domainId, instance);
                        if (scm.isAdminAgent() || isReadyToInitialize) {
                            try {
                                instance.initialize(null);
                            }
                            catch (Exception e) {
                                if (!isAnyTracingEnabled || !tc.isDebugEnabled()) break block52;
                                Tr.debug(tc, "getInstance unexpected exception initializing non-admin instance", e);
                            }
                        }
                    }
                }
            }
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance found ContextManager in cache");
        }
        if (currentStackEntry != null) {
            if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance setting ContextManager in current stack entry");
            }
            currentStackEntry.setContextManager(instance);
        }
        if (setSomeContextManager) {
            if (setAdminContextManager) {
                if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance setting adminContextManager global");
                }
                adminContextManager = instance;
                SecurityObjectLocator.setAdminContextManager(instance);
            } else if (setApplicationContextManager) {
                if (SecurityConfigGlobals.enableVerbose && isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInstance setting applicationContextManager global");
                }
                applicationContextManager = instance;
                SecurityObjectLocator.setApplicationContextManager(instance);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    private static void releaseByGetDomainId() {
        String domainId = scm.getDomainId();
        if (domainId == null) {
            domainId = "admin";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseByGetDomainId using domainId " + domainId);
        }
        instanceCache.remove(domainId);
    }

    public static void releaseInstance() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance");
        }
        if (scm == null) {
            return;
        }
        if (isSingleDomain) {
            adminContextManager = null;
        } else if (!scm.isAdminAgent()) {
            SecurityConfigResource currentStackEntry = SecurityObjectLocator.peekContext();
            if (currentStackEntry != null) {
                if (currentStackEntry.isAdmin()) {
                    adminContextManager = null;
                } else if (currentStackEntry.isApplication()) {
                    applicationContextManager = null;
                } else {
                    ContextManagerFactory.releaseByGetDomainId();
                }
            }
        } else {
            ContextManagerFactory.releaseByGetDomainId();
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    public static ContextManager getInstance(String domainId) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance " + domainId);
        }
        ContextManager instance = null;
        if (isSingleDomain) {
            if (domainId.equalsIgnoreCase("admin")) {
                instance = adminContextManager;
            } else if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Call to getInstance when isSingleDomain for:" + domainId);
            }
        } else {
            instance = instanceCache.get(domainId);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    public static void releaseInstance(String domainId) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance " + domainId);
        }
        if (isSingleDomain) {
            if (domainId.equalsIgnoreCase("admin")) {
                adminContextManager = null;
            } else if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Call to releaseInstance when isSingleDomain for:" + domainId);
            }
        } else {
            instanceCache.remove(domainId);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    private static ContextManager createInstance() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createInstance");
        }
        ContextManager instance = null;
        String contextMgrImplName = ContextManagerFactory.getContextMgrImplFromPluginList();
        try {
            String contextMgrHandlerName;
            instance = (ContextManager)Class.forName(contextMgrImplName).newInstance();
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "createInstance Loaded ContextManagerImpl class: " + contextMgrImplName);
            }
            if ((contextMgrHandlerName = ContextManagerFactory.getContextMgrHandlerImpl()) != null) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createInstance found contextMgrHandlerName " + contextMgrHandlerName + ", loading InvocationHandler");
                }
                Class<?> handlerClass = Class.forName(contextMgrHandlerName);
                Constructor<?> ctor = handlerClass.getDeclaredConstructor(ContextManager.class);
                InvocationHandler handler = (InvocationHandler)ctor.newInstance(instance);
                instance = (ContextManager)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createInstance ContextManager InvocationHandler loaded", instance);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            Manager.Ffdc.log(cnfe, ContextManagerFactory.class, "com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", "176");
            Tr.error(tc, "createInstance Could not find class: " + contextMgrImplName);
        }
        catch (InstantiationException ie) {
            Manager.Ffdc.log(ie, ContextManagerFactory.class, "com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", "181");
            Tr.error(tc, "createInstance Could not instantiate class: " + contextMgrImplName);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, ContextManagerFactory.class, "com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", "186");
            Tr.error(tc, "createInstance Could not load class: " + contextMgrImplName);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createInstance " + instance);
        }
        return instance;
    }

    private static String getContextMgrImplFromPluginList() {
        String implClassName;
        boolean isAnyTracingEnabled;
        block7: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "getContextManagerImplFromPluginList");
            }
            implClassName = null;
            try {
                InputStream inStream = Class.forName("com.ibm.ws.security.core.ContextManagerFactory").getResourceAsStream(plugins_list);
                if (inStream != null) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("com.ibm.ws.security.plugin.ContextManager=")) continue;
                        int begin_index = line.indexOf(61) + 1;
                        implClassName = line.substring(begin_index);
                    }
                }
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, ContextManagerFactory.class, "com.ibm.ws.security.core.ContextManagerFactory.getContextMgrImplFromPluginList", "221");
                if (!isAnyTracingEnabled || !tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Failed to load context manager impl from plugin list", ex);
            }
        }
        if (implClassName == null) {
            implClassName = CONTEXT_MGR_IMPL;
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextManagerImplFromPluginList", implClassName);
        }
        return implClassName;
    }

    private static String getContextMgrHandlerImpl() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextMgrHandlerImpl");
        }
        String handlerClassName = null;
        try {
            InputStream inStream = Class.forName("com.ibm.ws.security.core.ContextManagerFactory").getResourceAsStream(plugins_list);
            if (inStream != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("com.ibm.ws.security.plugin.ContextManager.InvocationHandler=")) continue;
                    int begin_index = line.indexOf(61) + 1;
                    handlerClassName = line.substring(begin_index);
                }
            }
        }
        catch (Exception ex) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to load context manager handler from plugin list", ex);
            }
            handlerClassName = null;
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextMgrHandlerImpl", handlerClassName);
        }
        return handlerClassName;
    }

    public static void setIsReadyToInitialize(boolean _isReadyToInitialize) {
        isReadyToInitialize = _isReadyToInitialize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug(tc, "Setting isReadyToInitialize to: ", _isReadyToInitialize);
        }
    }
}

