/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.util;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.common.auth.util.WSBasePanel;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class WSLoginPanel
extends WSBasePanel {
    JPanel TopPanel = null;
    JPanel BottomPanel = null;
    JPanel EntryFieldPanel = null;
    JLabel mainlabel = null;
    JLabel id_label = null;
    JLabel cell_label = null;
    JLabel pwd_label = null;
    JTextField id_field = null;
    JTextField cell_field = null;
    JPasswordField pwd_field = null;
    int textfield_length = 15;
    JButton OKButton = null;
    JButton CancelButton = null;
    private boolean firstTimeFocus = true;
    private static final TraceComponent tc = Tr.register(WSLoginPanel.class, null, "com.ibm.ejs.resources.security");
    private static final long serialVersionUID = 7719850876449493457L;

    public WSLoginPanel(String s_name, String r_name, String p_word, int timeout, String namePrompt, String realmPrompt, String passwordPrompt) {
        super(SecurityMessages.getMsgOrUseDefault("WSLoginPanelTitle", "Login at the Target Server"), s_name, r_name, p_word, timeout, namePrompt, realmPrompt, passwordPrompt);
        this.createWindow();
    }

    public void actionPerformed(ActionEvent eve) {
        if (eve.getSource() instanceof JButton) {
            if (eve.getSource() == this.OKButton) {
                this.ok_pressed(this.id_field.getText(), this.cell_field.getText(), new String(this.pwd_field.getPassword()));
            } else if (eve.getSource() == this.CancelButton) {
                this.cancel_pressed();
            }
        }
    }

    private void cancel_pressed() {
        String logMethod = "WSLoginPanel.cancel_pressed";
        Object logMsg = null;
        this.selectionMade = 3;
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "cancel pressed" + logMethod);
        }
        super.setVisible(false);
        this.dispose();
    }

    protected void createWindow() {
        this.TopPanel = new JPanel();
        this.BottomPanel = new JPanel();
        this.EntryFieldPanel = new JPanel();
        this.mainlabel = this.defaultCellName == null || this.defaultCellName.trim().length() == 0 ? new JLabel(SecurityMessages.getMsgOrUseDefault("GenericLoginPrompt", "Enter login information")) : new JLabel(SecurityMessages.getMsgOrUseDefault("LoginPromptForRealm", "Enter login information for") + " " + this.defaultCellName);
        this.cell_label = this.realm_prompt == null || this.realm_prompt.trim().length() == 0 ? new JLabel(SecurityMessages.getMsgOrUseDefault("RealmName", "Realm/Cell Name"), 0) : new JLabel(this.realm_prompt, 0);
        this.id_label = this.id_prompt == null || this.id_prompt.trim().length() == 0 ? new JLabel(SecurityMessages.getMsgOrUseDefault("UserID", "User Identity"), 0) : new JLabel(this.id_prompt, 0);
        this.pwd_label = this.pwd_prompt == null || this.pwd_prompt.trim().length() == 0 ? new JLabel(SecurityMessages.getMsgOrUseDefault("Password", "User Password"), 0) : new JLabel(this.pwd_prompt, 0);
        if (this.defaultUserID != null) {
            this.id_field = new JTextField(this.defaultUserID);
            this.id_field.setColumns(this.defaultUserID.length() / 2 + 1);
        } else {
            this.id_field = new JTextField();
        }
        if (this.defaultCellName != null) {
            this.cell_field = new JTextField(this.defaultCellName);
            this.cell_field.setColumns(this.defaultCellName.length() / 2 + 1);
            this.cell_field.setEnabled(false);
        } else {
            this.cell_field = new JTextField("<default>");
            this.cell_field = new JTextField();
            this.cell_field.setEnabled(false);
        }
        if (this.defaultPassword != null) {
            this.pwd_field = new JPasswordField(this.defaultPassword);
            this.pwd_field.setColumns(this.defaultPassword.length() / 2 + 1);
        } else {
            this.pwd_field = new JPasswordField();
        }
        this.pwd_field.setEchoChar('*');
        this.OKButton = new JButton(SecurityMessages.getMsgOrUseDefault("OK", "OK"));
        this.CancelButton = new JButton(SecurityMessages.getMsgOrUseDefault("Cancel", "Cancel"));
        this.TopPanel.setLayout(new FlowLayout(1));
        this.TopPanel.add(this.mainlabel);
        this.EntryFieldPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.insets = new Insets(3, 6, 3, 6);
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.cell_label, constraints);
        this.EntryFieldPanel.add(this.cell_label);
        constraints.gridx = 0;
        constraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.id_label, constraints);
        this.EntryFieldPanel.add(this.id_label);
        constraints.gridx = 0;
        constraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.pwd_label, constraints);
        this.EntryFieldPanel.add(this.pwd_label);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.ipadx = 120;
        constraints.fill = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.cell_field, constraints);
        this.EntryFieldPanel.add(this.cell_field);
        constraints.gridx = 1;
        constraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.id_field, constraints);
        this.EntryFieldPanel.add(this.id_field);
        constraints.gridx = 1;
        constraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.pwd_field, constraints);
        this.EntryFieldPanel.add(this.pwd_field);
        this.BottomPanel.setLayout(new FlowLayout(1));
        this.BottomPanel.add(this.OKButton);
        this.BottomPanel.add(this.CancelButton);
        this.getContentPane().add("North", this.TopPanel);
        this.getContentPane().add("Center", this.EntryFieldPanel);
        this.getContentPane().add("South", this.BottomPanel);
        this.OKButton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        this.id_field.addKeyListener(this);
        this.cell_field.addKeyListener(this);
        this.pwd_field.addKeyListener(this);
        this.addWindowListener(this);
        this.firstTimeFocus = true;
        super.createWindow();
    }

    public boolean done() {
        return !this.isVisible();
    }

    public String getCell() {
        return this.cellstr;
    }

    public String getId() {
        return this.idstr;
    }

    public String getPassword() {
        return this.pwdstr;
    }

    public void keyPressed(KeyEvent evt) {
        super.keyPressed(evt);
        if (evt.getSource() instanceof Button && evt.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(evt.getSource(), 1001, null));
            evt.consume();
        } else if (evt.getKeyCode() == 27) {
            this.actionPerformed(new ActionEvent(this.CancelButton, 1001, null));
            evt.consume();
        } else if (evt.getKeyCode() == 10) {
            if (this.id_field.getText().length() > 0) {
                this.ok_pressed(this.id_field.getText(), this.cell_field.getText(), new String(this.pwd_field.getPassword()));
            } else {
                this.cancel_pressed();
            }
            evt.consume();
        }
        this.firstTimeFocus = false;
    }

    private void ok_pressed(String idFld, String cellFld, String pwdFld) {
        this.idstr = idFld != null && idFld.length() > 0 ? idFld : null;
        this.cellstr = cellFld != null && cellFld.length() > 0 ? cellFld : null;
        this.pwdstr = pwdFld != null && pwdFld.length() > 0 ? pwdFld : null;
        this.selectionMade = 2;
        this.requestFocus();
        this.hide();
        this.setVisible(false);
        this.dispose();
    }

    public String ret_cellstr() {
        return this.cellstr;
    }

    public String ret_idstr() {
        return this.idstr;
    }

    public String ret_pwdstr() {
        return this.pwdstr;
    }
}

