/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.authorize.MethodConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class URLMap {
    private static TraceComponent tc = Tr.register(URLMap.class, null, "com.ibm.ejs.resources.security");
    StringBuffer newURLPattern;
    HashMap mapMethod;
    ArrayList unchkDataConstraintList = new ArrayList();
    ArrayList finalUnchkDataConstraintList = new ArrayList();
    String unchkUserData = null;
    int unchkCount = 0;
    boolean unqualified = false;
    String[] fixedMethods = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    ArrayList<String> allMethodsList = new ArrayList<String>(Arrays.asList(this.fixedMethods));
    String defaultProtectedString = "!DELETE,GET,HEAD,OPTIONS,POST,PUT,TRACE";

    public URLMap(String url) {
        this.newURLPattern = new StringBuffer(url);
        this.mapMethod = new HashMap();
        for (int i = 0; i < this.fixedMethods.length; ++i) {
            this.mapMethod.put(this.fixedMethods[i], new MethodConstraint());
        }
    }

    public void appendURLPattern(String urlPattern) {
        this.newURLPattern.append(":" + urlPattern);
    }

    public String getURLPattern() {
        return this.newURLPattern.toString();
    }

    public void setExcludedSet(ArrayList mList) {
        for (int i = 0; i < mList.size(); ++i) {
            MethodConstraint mc;
            String httpMethod = ((String)mList.get(i)).toUpperCase();
            if (this.mapMethod.containsKey(httpMethod)) {
                mc = (MethodConstraint)this.mapMethod.get(httpMethod);
                mc.setExcluded();
                continue;
            }
            mc = new MethodConstraint();
            mc.setExcluded();
            this.mapMethod.put(httpMethod, mc);
            this.allMethodsList.add(httpMethod);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Adding extension method to excluded = " + httpMethod);
        }
    }

    public void setUncheckedSet(ArrayList mList) {
        for (int i = 0; i < mList.size(); ++i) {
            MethodConstraint mc;
            String httpMethod = ((String)mList.get(i)).toUpperCase();
            if (this.mapMethod.containsKey(httpMethod)) {
                mc = (MethodConstraint)this.mapMethod.get(httpMethod);
                mc.setUnchecked();
                continue;
            }
            mc = new MethodConstraint();
            mc.setUnchecked();
            this.mapMethod.put(httpMethod, mc);
            this.allMethodsList.add(httpMethod);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Adding extension method to unchecked = " + httpMethod);
        }
    }

    public void setRoleMap(String roleName, ArrayList mList) {
        for (int i = 0; i < mList.size(); ++i) {
            MethodConstraint mc;
            String httpMethod = ((String)mList.get(i)).toUpperCase();
            if (this.mapMethod.containsKey(httpMethod)) {
                mc = (MethodConstraint)this.mapMethod.get(httpMethod);
                mc.setRole(roleName);
                continue;
            }
            mc = new MethodConstraint();
            mc.setRole(roleName);
            this.mapMethod.put(httpMethod, mc);
            this.allMethodsList.add(httpMethod);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Adding roleName: " + roleName + " to extension method:  " + httpMethod);
        }
    }

    public void setUserDataMap(String constraintType, ArrayList mList) {
        int i;
        for (i = 0; i < mList.size(); ++i) {
            MethodConstraint mc = (MethodConstraint)this.mapMethod.get(((String)mList.get(i)).toUpperCase());
            mc.setUserData(constraintType);
        }
        for (i = 0; i < mList.size(); ++i) {
            MethodConstraint mc;
            String httpMethod = ((String)mList.get(i)).toUpperCase();
            if (this.mapMethod.containsKey(httpMethod)) {
                mc = (MethodConstraint)this.mapMethod.get(httpMethod);
                mc.setUserData(constraintType);
                continue;
            }
            mc = new MethodConstraint();
            mc.setUserData(constraintType);
            this.mapMethod.put(httpMethod, mc);
            this.allMethodsList.add(httpMethod);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Adding constraint: " + constraintType + " to extension method: " + httpMethod);
        }
    }

    public String[] getExcludedArray() {
        ArrayList<String> excludedList = new ArrayList<String>();
        for (int i = 0; i < this.allMethodsList.size(); ++i) {
            MethodConstraint mc = (MethodConstraint)this.mapMethod.get(this.allMethodsList.get(i));
            if (!mc.isExcluded()) continue;
            excludedList.add(this.allMethodsList.get(i));
        }
        if (excludedList.size() > 0) {
            return excludedList.toArray(new String[0]);
        }
        return null;
    }

    public String getUncheckedArray() {
        ArrayList<String> uncheckedList = new ArrayList<String>();
        ArrayList finalUncheckedList = new ArrayList();
        for (int i = 0; i < this.allMethodsList.size(); ++i) {
            MethodConstraint mc = (MethodConstraint)this.mapMethod.get(this.allMethodsList.get(i));
            if (mc.isExcluded() || !mc.isUnchecked() && !mc.isRoleSetEmpty()) continue;
            uncheckedList.add(this.allMethodsList.get(i));
        }
        boolean first = true;
        int count = 0;
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < this.allMethodsList.size(); ++k) {
            if (uncheckedList.contains(this.allMethodsList.get(k))) continue;
            if (first) {
                sb.append("!").append(this.allMethodsList.get(k));
                ++count;
            } else {
                sb.append("," + this.allMethodsList.get(k));
                ++count;
            }
            first = false;
        }
        String unchkString = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unchkString = " + unchkString + " number of HTTP Methods = " + count);
        }
        if (count == 7) {
            return this.defaultProtectedString;
        }
        if (unchkString.length() < 1) {
            return null;
        }
        return unchkString;
    }

    public HashMap getRoleMap() {
        HashMap roleToMethodMap = new HashMap();
        for (int i = 0; i < this.allMethodsList.size(); ++i) {
            MethodConstraint mc = (MethodConstraint)this.mapMethod.get(this.allMethodsList.get(i));
            if (mc.isExcluded() || mc.isUnchecked() || mc.isRoleSetEmpty()) continue;
            ArrayList roleList = mc.getRoleList();
            ArrayList<String> methodList = null;
            for (int j = 0; j < roleList.size(); ++j) {
                methodList = (ArrayList<String>)roleToMethodMap.get((String)roleList.get(j));
                if (methodList == null) {
                    methodList = new ArrayList<String>();
                }
                methodList.add(this.allMethodsList.get(i));
                roleToMethodMap.put(roleList.get(j), methodList);
            }
        }
        return roleToMethodMap;
    }

    public String[] getUserDataArray() {
        ArrayList<String> userdataList = new ArrayList<String>();
        for (int i = 0; i < this.allMethodsList.size(); ++i) {
            MethodConstraint mc = (MethodConstraint)this.mapMethod.get(this.allMethodsList.get(i));
            if (mc.isExcluded()) continue;
            String userDataConstraint = mc.getUserData();
            if (userDataConstraint != null && (userDataConstraint.equalsIgnoreCase("INTEGRAL") || userDataConstraint.equalsIgnoreCase("CONFIDENTIAL"))) {
                userdataList.add(this.allMethodsList.get(i));
                continue;
            }
            this.unchkDataConstraintList.add(this.allMethodsList.get(i));
        }
        StringBuffer unchkBuffer = new StringBuffer();
        boolean first = true;
        for (int k = 0; k < this.allMethodsList.size(); ++k) {
            if (this.unchkDataConstraintList.contains(this.allMethodsList.get(k))) continue;
            if (first) {
                unchkBuffer.append("!").append(this.allMethodsList.get(k));
                ++this.unchkCount;
            } else {
                unchkBuffer.append("," + this.allMethodsList.get(k));
                ++this.unchkCount;
            }
            first = false;
        }
        if (unchkBuffer.length() > 0) {
            unchkBuffer.append(":NONE");
        }
        this.unchkUserData = unchkBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " unchkString in user data= " + this.unchkUserData);
        }
        if (userdataList.size() > 0) {
            return userdataList.toArray(new String[0]);
        }
        return null;
    }

    public String getUnchkDataConstraintArray() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unchkuserData = " + this.unchkUserData);
        }
        if (this.unchkCount == 7) {
            return this.defaultProtectedString;
        }
        if (this.unchkUserData.length() < 1) {
            return null;
        }
        return this.unchkUserData;
    }

    public ArrayList getAllMethods() {
        return this.allMethodsList;
    }
}

