/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class RSAToken {
    private static final TraceComponent tc = Tr.register(RSAToken.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    public static final String tokenHeader = "WS_ROLE_TOKEN_HEADER";
    private static final byte[] tokenHeaderBytes = "WS_ROLE_TOKEN_HEADER".getBytes();
    private final int tokenHeaderSize = tokenHeaderBytes.length;
    private final int tokenVersion = 1;
    private final String tokenHeaderLookup = "WS_ROLE_TOKEN_HEADER:1";
    private String realm;
    private String principal;
    private String access_id;
    private List roles;
    private List groups;
    private Properties customProperties;
    private String nonce;
    private long expiration;
    private int version;

    RSAToken() {
    }

    RSAToken(String _realm, String _principal, String _access_id, List _roles, List _groups, Properties _customProperties, String _nonce, long _expiration, int _version) {
        this.realm = _realm;
        this.principal = _principal;
        this.access_id = _access_id;
        this.roles = _roles;
        this.groups = _groups;
        this.customProperties = _customProperties;
        this.nonce = _nonce;
        this.expiration = _expiration;
        this.version = _version;
    }

    RSAToken(byte[] rt) {
        this.readBytes(rt);
    }

    public int getVersion() {
        return this.version;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getAccessId() {
        return this.access_id;
    }

    public List getRoles() {
        return this.roles;
    }

    public List getGroups() {
        return this.groups;
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public String getNonce() {
        return this.nonce;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public byte[] getBytes() {
        return this.writeBytes();
    }

    public void setVersion(int _version) {
        this.version = _version;
    }

    public void setRealm(String _realm) {
        this.realm = _realm;
    }

    public void setPrincipal(String _principal) {
        this.principal = _principal;
    }

    public void setAccessId(String _access_id) {
        this.access_id = _access_id;
    }

    public void setRoles(List _roles) {
        this.roles = _roles;
    }

    public void setGroups(List _groups) {
        this.groups = _groups;
    }

    public void setCustomProperties(Properties _customProperties) {
        this.customProperties = _customProperties;
    }

    public void setNonce(String _nonce) {
        this.nonce = _nonce;
    }

    public void setExpiration(long _expiration) {
        this.expiration = _expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readBytes(byte[] rsa_token_bytes) {
        block30: {
            block33: {
                block27: {
                    block32: {
                        if (RSAToken.tc.isEntryEnabled()) {
                            Tr.entry(RSAToken.tc, "readBytes");
                        }
                        bais = null;
                        dis = null;
                        try {
                            try {
                                bais = new ByteArrayInputStream(rsa_token_bytes);
                                dis = new DataInputStream(bais);
                                isRSAToken = this.checkRSATokenHeader(dis);
                                if (isRSAToken) {
                                    if (RSAToken.tc.isDebugEnabled()) {
                                        Tr.debug(RSAToken.tc, "Found RSA token.");
                                    }
                                    this.version = dis.readInt();
                                    if (RSAToken.tc.isDebugEnabled()) {
                                        Tr.debug(RSAToken.tc, "Token version == " + this.version);
                                    }
                                    if (this.version == 1) {
                                        this.readRSATokenV1Bytes(dis);
                                    }
                                    break block27;
                                }
                                if (RSAToken.tc.isEntryEnabled()) {
                                    Tr.exit(RSAToken.tc, "readBytes (not RSA token)");
                                }
                                var6_6 = null;
                            }
                            catch (Exception e) {
                                if (RSAToken.tc.isDebugEnabled()) {
                                    Tr.debug(RSAToken.tc, "Exception reading RSA token bytes.", new Object[]{e});
                                }
                                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAToken.readBytes", "221", new Object[]{this});
                                var6_8 = null;
                                try {
                                    if (bais != null) {
                                        bais.close();
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    if (dis != null) {
                                        dis.close();
                                    }
                                    break block30;
                                }
                                catch (Exception e) {}
                                break block30;
                            }
                        }
                        catch (Throwable var5_14) {
                            block31: {
                                var6_9 = null;
                                ** try [egrp 2[TRYBLOCK] [5 : 223->234)] { 
lbl48:
                                // 1 sources

                                if (bais != null) {
                                    bais.close();
                                }
                                break block31;
lbl51:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [6 : 236->247)] { 
lbl55:
                            // 1 sources

                            if (dis == null) throw var5_14;
                            dis.close();
                            throw var5_14;
lbl58:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            throw var5_14;
                        }
                        ** try [egrp 2[TRYBLOCK] [5 : 223->234)] { 
lbl63:
                        // 1 sources

                        if (bais != null) {
                            bais.close();
                        }
                        break block32;
lbl66:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [6 : 236->247)] { 
lbl70:
                    // 1 sources

                    if (dis == null) return;
                    dis.close();
                    return;
lbl73:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                var6_7 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 223->234)] { 
lbl79:
                // 1 sources

                if (bais != null) {
                    bais.close();
                }
                break block33;
lbl82:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
            }
            try {}
            catch (Exception e) {}
            if (dis != null) {
                dis.close();
            }
        }
        if (RSAToken.tc.isEntryEnabled() == false) return;
        Tr.exit(RSAToken.tc, "readBytes");
    }

    private void readRSATokenV1Bytes(DataInputStream dis) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRSATokenV1Bytes");
        }
        int nonce_len = dis.readInt();
        byte[] nonce_bytes = new byte[nonce_len];
        dis.read(nonce_bytes, 0, nonce_len);
        this.nonce = new String(nonce_bytes, "UTF-8");
        this.expiration = dis.readLong();
        int realm_len = dis.readInt();
        byte[] realm_bytes = new byte[realm_len];
        dis.read(realm_bytes, 0, realm_len);
        this.realm = new String(realm_bytes, "UTF-8");
        int principal_len = dis.readInt();
        byte[] principal_bytes = new byte[principal_len];
        dis.read(principal_bytes, 0, principal_len);
        this.principal = new String(principal_bytes, "UTF-8");
        int access_id_len = dis.readInt();
        byte[] access_id_bytes = new byte[access_id_len];
        dis.read(access_id_bytes, 0, access_id_len);
        this.access_id = new String(access_id_bytes, "UTF-8");
        int num_roles = dis.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total number of roles to read: " + num_roles);
        }
        if (num_roles > 0) {
            this.roles = new ArrayList(num_roles);
            for (int i = 0; i < num_roles; ++i) {
                int role_len = dis.readInt();
                byte[] role_bytes = new byte[role_len];
                dis.read(role_bytes, 0, role_len);
                String role = new String(role_bytes, "UTF-8");
                if (role == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding role " + role);
                }
                this.roles.add(role);
            }
        }
        int num_groups = dis.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total number of groups to read: " + num_groups);
        }
        if (num_groups > 0) {
            this.groups = new ArrayList(num_groups);
            for (int i = 0; i < num_groups; ++i) {
                int group_len = dis.readInt();
                byte[] group_bytes = new byte[group_len];
                dis.read(group_bytes, 0, group_len);
                String group = new String(group_bytes, "UTF-8");
                if (group == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding group " + group);
                }
                this.groups.add(group);
            }
        }
        try {
            int custom_property_bytes_size = dis.readInt();
            if (custom_property_bytes_size > 0) {
                byte[] custom_property_bytes = new byte[custom_property_bytes_size];
                dis.read(custom_property_bytes, 0, custom_property_bytes_size);
                if (custom_property_bytes != null && custom_property_bytes.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deserializing custom properties.");
                    }
                    this.customProperties = (Properties)this.deserialize_internal(custom_property_bytes);
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred reading customProperties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAToken.readBytes", "344", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readRSATokenV1Bytes");
        }
    }

    private boolean checkRSATokenHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRSATokenHeader");
        }
        try {
            byte[] header = null;
            String headerString = null;
            header = new byte[this.tokenHeaderSize];
            dis.read(header, 0, this.tokenHeaderSize);
            if (header != null) {
                headerString = new String(header, "UTF-8");
                if (headerString.equals(tokenHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkRSATokenHeader (true)");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkRSATokenHeader (invalid header)");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkRSATokenHeader (no header)");
            }
            return false;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception finding RSA token header.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAToken.checkRSATokenHeader", "389", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkRSATokenHeader (exception)");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] writeBytes() {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBytes");
        }
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        baos = new ByteArrayOutputStream(500);
        dos = new DataOutputStream(baos);
        dos.write(tokenHeaderBytes, 0, this.tokenHeaderSize);
        dos.writeInt(this.version);
        byte[] nonce_bytes = this.nonce.getBytes("UTF-8");
        int nonce_len = nonce_bytes.length;
        dos.writeInt(nonce_len);
        dos.write(nonce_bytes, 0, nonce_len);
        dos.writeLong(this.expiration);
        byte[] realm_bytes = this.realm.getBytes("UTF-8");
        int realm_len = realm_bytes.length;
        dos.writeInt(realm_len);
        dos.write(realm_bytes, 0, realm_len);
        byte[] principal_bytes = this.principal.getBytes("UTF-8");
        int principal_len = principal_bytes.length;
        dos.writeInt(principal_len);
        dos.write(principal_bytes, 0, principal_len);
        byte[] access_id_bytes = this.access_id.getBytes("UTF-8");
        int access_id_len = access_id_bytes.length;
        dos.writeInt(access_id_len);
        dos.write(access_id_bytes, 0, access_id_len);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total roles to write: " + (this.roles != null ? this.roles.size() : 0));
        }
        dos.writeInt(this.roles != null ? this.roles.size() : 0);
        if (this.roles != null) {
            for (i = 0; i < this.roles.size(); ++i) {
                String role = null;
                int role_len = 0;
                byte[] role_bytes = null;
                role = (String)this.roles.get(i);
                if (role == null) continue;
                role_bytes = role.getBytes("UTF-8");
                role_len = role_bytes.length;
                dos.writeInt(role_len);
                dos.write(role_bytes, 0, role_len);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total groups to write: " + (this.groups != null ? this.groups.size() : 0));
        }
        dos.writeInt(this.groups != null ? this.groups.size() : 0);
        if (this.groups != null) {
            for (i = 0; i < this.groups.size(); ++i) {
                String group = null;
                int group_len = 0;
                byte[] group_bytes = null;
                group = (String)this.groups.get(i);
                if (group == null) continue;
                group_bytes = group.getBytes("UTF-8");
                group_len = group_bytes.length;
                dos.writeInt(group_len);
                dos.write(group_bytes, 0, group_len);
            }
        }
        if (this.customProperties != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to serialize customProperties.");
            }
            try {
                byte[] custom_property_bytes = this.serialize_internal(this.customProperties);
                if (custom_property_bytes != null) {
                    int custom_property_bytes_len = custom_property_bytes.length;
                    dos.writeInt(custom_property_bytes_len);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing customProperties, length: " + custom_property_bytes_len);
                    }
                    dos.write(custom_property_bytes, 0, custom_property_bytes_len);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred writing customProperties.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAToken.writeBytes", "522", this);
            }
        } else {
            dos.writeInt(-1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total opaque token length: " + baos.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBytes");
        }
        byte[] byArray = baos.toByteArray();
        Object var16_20 = null;
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (dos != null) {
                dos.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return byArray;
        catch (Exception e) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception writing RSA token bytes.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAToken.writeBytes", "538", this);
                Object var16_21 = null;
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception e2) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBytes");
        }
        return null;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Version: ");
        buf.append(this.version);
        buf.append("\n");
        buf.append("Realm: ");
        buf.append(this.realm);
        buf.append("\n");
        buf.append("Principal: ");
        buf.append(this.principal);
        buf.append("\n");
        buf.append("Access_ID: ");
        buf.append(this.access_id);
        buf.append("\n");
        buf.append("Nonce: ");
        buf.append(this.nonce);
        buf.append("\n");
        buf.append("Expiration: ");
        buf.append(this.expiration);
        buf.append("\n");
        if (this.roles != null) {
            for (i = 0; i < this.roles.size(); ++i) {
                buf.append("  Role[ ");
                buf.append(i);
                buf.append("]: ");
                buf.append(this.roles.get(i));
                buf.append("\n");
            }
        }
        if (this.groups != null) {
            for (i = 0; i < this.groups.size(); ++i) {
                buf.append("  Group[ ");
                buf.append(i);
                buf.append("]: ");
                buf.append(this.groups.get(i));
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize_internal(Object src) throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bs);
        byte[] ret = null;
        try {
            try {
                oos.writeObject(src);
                ret = bs.toByteArray();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception serializing object. ", new Object[]{e});
                throw e;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                oos.close();
                bs.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        oos.close();
        bs.close();
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object deserialize_internal(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        WsObjectInputStream ois = new WsObjectInputStream(bais);
        Object ret = null;
        try {
            try {
                ret = ois.readObject();
            }
            catch (Exception e) {
                Tr.warning(tc, "security.sap.warning.deserializing.custom.objects.from.subject");
                if (!tc.isDebugEnabled()) throw e;
                Tr.debug(tc, "Exception deserializing object. ", new Object[]{e});
                throw e;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                ois.close();
                bais.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        ois.close();
        bais.close();
        return ret;
    }

    public static void main(String[] args) {
    }
}

