/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.rsatoken.NonceManager;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationToken;
import com.ibm.ws.security.auth.rsatoken.RSAToken;
import com.ibm.ws.security.auth.rsatoken.SecretKeyToken;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;

public class RSAPropagationManager {
    private static final TraceComponent tc = Tr.register(RSAPropagationManager.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static RSAPropagationManager rpm = null;
    private NonceManager nonceManager = null;
    private SecretKeyToken skt = null;
    private byte[] sktBytes = null;
    private long sktExpiration = 0L;
    X509Certificate admin_certificate = null;
    PrivateKey admin_private_key = null;
    private boolean rsaPropagationEnabled = false;
    private boolean rsaPropagationEnabledSet = false;
    private String adminPreferredAuthContextClass = null;
    private String adminPreferredAuthMechOID = null;
    private String profileUUID = null;
    RSAPropagationToken rpt = null;

    public static synchronized RSAPropagationManager getInstance() {
        if (rpm == null) {
            rpm = new RSAPropagationManager();
        }
        return rpm;
    }

    RSAPropagationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RSAPropagationManager <init>");
        }
        try {
            if (RasHelper.isServer()) {
                this.createSecretKeyToken();
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing the RSAPropagationManager.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.<init>", "99", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RSAPropagationManager <init>");
        }
    }

    public NonceManager getNonceManager() {
        if (this.nonceManager == null) {
            this.nonceManager = new NonceManager(500, SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getLong("rsaTokenNonceCacheTimeout"));
        }
        return this.nonceManager;
    }

    public boolean isRSAPropagationEnabled() {
        if (!RasHelper.isServer()) {
            return false;
        }
        if (!this.rsaPropagationEnabledSet) {
            this.rsaPropagationEnabled = SecurityObjectLocator.getSecurityConfig("security").getAdminPreferredAuthMechanism().getType().equals("RSATOKEN");
        }
        return this.rsaPropagationEnabled;
    }

    public String getAdminPreferredAuthContextClass() {
        if (this.adminPreferredAuthContextClass == null) {
            this.adminPreferredAuthContextClass = SecurityObjectLocator.getSecurityConfig("security").getAdminPreferredAuthMechanism().getString("authContextImplClass");
        }
        return this.adminPreferredAuthContextClass;
    }

    public String getAdminPreferredAuthMechOID() {
        if (this.adminPreferredAuthMechOID == null) {
            this.adminPreferredAuthMechOID = SecurityObjectLocator.getSecurityConfig("security").getAdminPreferredAuthMechanism().getString("OID");
        }
        return this.adminPreferredAuthMechOID;
    }

    public String getOID() {
        return SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getString("OID");
    }

    public String getAdminTrustStoreName() {
        return SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getString("rsaTokenTrustStoreName");
    }

    public X509Certificate getAdminRSAPropagationCertificate() throws CertificateExpiredException, CertificateNotYetValidException {
        Certificate[] admin_certificate_chain = (Certificate[])SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getObject("rsaTokenCertificate");
        try {
            for (int i = 0; i < admin_certificate_chain.length; ++i) {
                X509Certificate cert = (X509Certificate)admin_certificate_chain[i];
                cert.checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception checking the validity of the RSA token ", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.getAdminRSAPropagationCertificate", "173", this);
            throw e;
        }
        catch (CertificateNotYetValidException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception checking the validity of the RSA token ", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.getAdminRSAPropagationCertificate", "179", this);
            throw e;
        }
        return (X509Certificate)admin_certificate_chain[0];
    }

    private PrivateKey getAdminRSAPropagationPrivateKey() {
        return (PrivateKey)SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getObject("rsaTokenPrivateKey");
    }

    private synchronized void createSecretKeyToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSecretKeyToken");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a new secret key token.");
            }
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom");
            byte[] keyBytes = random.generateSeed(16);
            SecretKeySpec sks = new SecretKeySpec(keyBytes, "AES");
            SecretKeyFactory skf = SecretKeyFactory.getInstance("AES");
            SecretKey sk = skf.generateSecret(sks);
            byte[] skBytes = sk.getEncoded();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Secret key byte length: " + skBytes.length);
            }
            this.skt = new SecretKeyToken(skBytes, 128, "AES", "CBC", "PKCS5Padding", 1);
            this.sktBytes = this.skt.getBytes();
            this.sktExpiration = System.currentTimeMillis() + 3600000L;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating a secret key token.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.createSecretKeyToken", "185", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSecretKeyToken");
        }
    }

    public Subject validateRSAPropagationToken(byte[] rsa_propagation_token) throws IllegalArgumentException, WSLoginFailedException, CertificateExpiredException, CertificateNotYetValidException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateRSAPropagationToken");
        }
        if (rsa_propagation_token == null || rsa_propagation_token.length == 0) {
            throw new IllegalArgumentException("RSA propagation token bytes are null.");
        }
        try {
            X509Certificate rsa_cert = this.getAdminRSAPropagationCertificate();
            RSAPropagationToken rpt = new RSAPropagationToken(rsa_cert, this.getAdminRSAPropagationPrivateKey(), rsa_propagation_token);
            if (rpt != null) {
                RSAToken rt = rpt.getRSATokenObject();
                long expiration = rt.getExpiration();
                if (expiration < System.currentTimeMillis()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateRSAPropagationToken (error)");
                    }
                    Tr.error(tc, "security.JSAS0801E", new Object[]{new Date(expiration), new Date(System.currentTimeMillis())});
                    throw new WSLoginFailedException("JSAS0801E:  The received admin RSA token has an expired timestamp of " + new Date(expiration) + " where the current local timestamp is " + new Date(System.currentTimeMillis()) + ".  Check for clock skew issues between servers.");
                }
                boolean uniqueNonce = this.getNonceManager().validate(rt.getNonce());
                if (!uniqueNonce) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateRSAPropagationToken (error)");
                    }
                    Tr.error(tc, "security.JSAS0802E", new Object[]{rt.getNonce()});
                    throw new WSLoginFailedException("JSAS0802E: The received admin RSA token has a nonce value of " + rt.getNonce() + " that has been used recently in this process.  This could indicate a replay attack.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateRSAPropagationToken (creating Subject)");
                }
                return this.createSubjectFromRSAToken(rt, rpt.getSendingX509Certificate());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateRSAPropagationToken (error)");
            }
            throw new WSSecurityException("RSA propagation token is null after validation.");
        }
        catch (Exception e) {
            Tr.error(tc, "security.JSAS0803E", new Object[]{e.getMessage()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception validating RSA token.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.validateRSAPropagationToken", "256", this);
            if (e instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)e;
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public byte[] createRSAPropagationToken(X509Certificate target_certificate, Subject subject) throws IllegalArgumentException, WSSecurityException, CertificateExpiredException, CertificateNotYetValidException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRSAPropagationToken", new Object[]{subject.getPublicCredentials()});
        }
        if (subject == null) {
            throw new IllegalArgumentException("Subject is null.");
        }
        if (target_certificate == null) {
            target_certificate = this.getAdminRSAPropagationCertificate();
        }
        try {
            WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
            List roles = null;
            String securityName = cred.getSecurityName();
            String accessId = cred.getAccessId();
            String realm = cred.getRealmName();
            String nonce = this.getNonceManager().generate();
            ArrayList groups = null;
            if (cred.getGroupIds() != null) {
                groups = cred.getGroupIds();
            }
            Properties customProperties = (Properties)cred.get("customRSAProperties");
            if (this.getProfileUUID() != null) {
                if (customProperties == null) {
                    customProperties = new Properties();
                }
                customProperties.setProperty("sendingProfileUUID", this.getProfileUUID());
            }
            RSAToken rt = new RSAToken(realm, securityName, accessId, roles, groups, customProperties, nonce, System.currentTimeMillis() + Long.valueOf(SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").getLong("rsaTokenExpiration")) * 1000L, 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSAToken creating with the following information.", new Object[]{rt.toString()});
            }
            if (System.currentTimeMillis() > this.sktExpiration) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a new SecretKeyToken.");
                }
                this.createSecretKeyToken();
            }
            RSAPropagationToken rpt = new RSAPropagationToken(this.getAdminRSAPropagationCertificate(), this.getAdminRSAPropagationPrivateKey(), target_certificate, this.sktBytes, rt.getBytes(), 1);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRSAPropagationToken");
            }
            return rpt.writeBytes();
        }
        catch (Exception e) {
            Tr.error(tc, "security.JSAS0804E", new Object[]{target_certificate.getSubjectDN(), e.getMessage()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating RSA token.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationManager.validateRSAPropagationToken", "337", this);
            if (e instanceof WSSecurityException) {
                throw (WSSecurityException)e;
            }
            throw new WSSecurityException(e.getMessage(), e);
        }
    }

    private List getAdminRolesFromSubject(Subject subject, WSCredential cred) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminRolesFromSubject");
        }
        if (subject == null) {
            throw new IllegalArgumentException("null Subject");
        }
        if (cred == null) {
            throw new IllegalArgumentException("null WSCredential");
        }
        if (cred.getRoles() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Admin roles exist in WSCredential.", new Object[]{cred.getRoles()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminRolesFromSubject");
            }
            return cred.getRoles();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminRolesFromSubject (null)");
        }
        return null;
    }

    public Subject createSubjectFromRSAToken(RSAToken rt) throws WSLoginFailedException {
        return this.createSubjectFromRSAToken(rt, null);
    }

    public Subject createSubjectFromRSAToken(RSAToken rt, X509Certificate sending_certificate) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubjectFromRSAToken", new Object[]{rt});
        }
        try {
            List groupList;
            String principal;
            String realm;
            if (rt == null) {
                throw new WSLoginFailedException("RSA token is null");
            }
            ArrayList roles = (ArrayList)rt.getRoles();
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            String accessId = rt.getAccessId();
            if (accessId != null && accessId.length() > 0) {
                table.put("com.ibm.wsspi.security.cred.uniqueId", accessId);
            }
            if ((realm = rt.getRealm()) != null && realm.length() > 0) {
                table.put("com.ibm.wsspi.security.cred.realm", realm);
            }
            if ((principal = rt.getPrincipal()) != null && principal.length() > 0) {
                table.put("com.ibm.wsspi.security.cred.securityName", principal);
            }
            if ((groupList = rt.getGroups()) != null && groupList.size() > 0) {
                table.put("com.ibm.wsspi.security.cred.groups", groupList);
            }
            Subject subject = new Subject();
            subject.getPublicCredentials().add(table);
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            ctxMgr.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            subject = ctxMgr.login(rt.getRealm(), rt.getPrincipal(), "system.DEFAULT", null, null, null, subject);
            WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
            Properties customProperties = rt.getCustomProperties();
            if (customProperties != null) {
                cred.set("customRSAProperties", customProperties);
            }
            if (sending_certificate != null) {
                cred.set("sendingRSACertificate", sending_certificate);
                String profileUUID = this.getUUIDFromCert(sending_certificate);
                if (profileUUID != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sendingProfileUUID: " + profileUUID);
                    }
                    cred.set("sendingProfileUUID", profileUUID);
                } else if (customProperties != null && (profileUUID = customProperties.getProperty("sendingProfileUUID")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sendingProfileUUID from customProperties: " + profileUUID);
                    }
                    cred.set("sendingProfileUUID", profileUUID);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSubjectFromRSAToken");
            }
            return subject;
        }
        catch (WSLoginFailedException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSubjectFromRSAToken");
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectFromRSAToken", "430", this);
            throw e;
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectFromRSAToken", "436", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public boolean verifyCertificate(X509Certificate[] signed_cert) throws Exception {
        if (this.rpt == null) {
            this.rpt = new RSAPropagationToken(this.getAdminRSAPropagationCertificate());
        }
        return this.rpt.verifyCertificate(signed_cert);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("");
        buf.append("\n");
        return buf.toString();
    }

    public String getUUIDFromCert(X509Certificate cert) throws Exception {
        String UUIDString = null;
        try {
            Collection<List<?>> subjectAltNames = cert.getSubjectAlternativeNames();
            if (subjectAltNames != null && subjectAltNames.size() > 0) {
                for (List<?> subjectAltNameList : subjectAltNames) {
                    if (subjectAltNameList == null || subjectAltNameList.size() <= 0) continue;
                    for (int i = 0; i < subjectAltNameList.size(); ++i) {
                        String profileUUID;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Alt name value is: " + subjectAltNameList.get(i));
                        }
                        if (!(profileUUID = subjectAltNameList.get(i).toString()).startsWith("ProfileUUID:")) continue;
                        UUIDString = profileUUID.substring("ProfileUUID:".length());
                        return UUIDString;
                    }
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while checking AltSubjectNames.", new Object[]{e});
            }
            throw e;
        }
        return UUIDString;
    }

    private String getProfileUUID() {
        block4: {
            if (this.profileUUID == null) {
                try {
                    Class<?> cl1 = Class.forName("com.ibm.wsspi.management.profile.ProfileUtility");
                    Method theMethod1 = cl1.getMethod("getUUID", new Class[0]);
                    this.profileUUID = (String)theMethod1.invoke(null, new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieved the following profileUUID for the process: " + this.profileUUID);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Exception creating profileUUID.", new Object[]{e});
                }
            }
        }
        return this.profileUUID;
    }
}

