/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.spnego.HTTPHeaderFilter;
import com.ibm.ws.security.spnego.ServerConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoCommandProviderImpl
extends SimpleCommandProvider {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(SpnegoCommandProviderImpl.class, "SpnegoCommandProviderImpl", "com.ibm.ws.security.auth.kerberos.admintask");
    private ConfigService configService;
    private Session session;
    private String secDomain = null;
    private Boolean enabled = null;
    private Boolean dynamicReload = null;
    private Boolean allowAppAuthMethodFallback = null;
    private String krb5Config = null;
    private String krb5Keytab = null;
    private String hostName = null;
    private String krb5Realm = null;
    private String filterCriteria = null;
    private String filterClass = null;
    private Boolean trimUserName = true;
    private Boolean enabledGssCredDelegate = true;
    private String spnegoNotSupportedPage = null;
    private String ntlmTokenReceivedPage = null;
    private String krb5Auth_krb5Config = null;
    private String krb5Auth_krb5Keytab = null;
    private String krb5Auth_krb5Realm = null;
    public static final String ENABLED = "enabled";
    public static final String DYNAMIC_RELOAD = "dynamicReload";
    public static final String KRB5_CONFIG = "krb5Config";
    public static final String KRB5_KEYTAB = "krb5Keytab";
    public static final String ALLOW_APP_AUTH_METHOD_FALLBACK = "allowAppAuthMethodFallback";
    private static String FILTERS = "filters";
    private static String HOST_NAME = "hostName";
    private static String KRB5_REALM = "krb5Realm";
    private static String FILTER_CRITERIA = "filterCriteria";
    private static String FILTER_CLASS = "filterClass";
    private static String TRIM_USER_NAME = "trimUserName";
    private static String ENABLED_GSS_CRED_DELEGATE = "enabledGssCredDelegate";
    private static String SPNEGO_NOT_SUPPORTED_PAGE = "spnegoNotSupportedPage";
    private static String NTLM_TOKEN_RECEIVED_PAGE = "ntlmTokenReceivedPage";
    private static String DEFAULT_FILTER_CLASS = "com.ibm.ws.security.spnego.HTTPHeaderFilter";

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        return super.loadCommand(cmdData);
    }

    public boolean configureSpnego(AbstractAdminCommand cmd) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureSpnego");
        }
        try {
            this.configService = this.getCommandProviderHelper().getConfigService();
            this.session = cmd.getConfigSession();
            ObjectName securityObj = null;
            this.secDomain = (String)cmd.getParameter("securityDomainName");
            this.enabled = (Boolean)cmd.getParameter(ENABLED);
            this.dynamicReload = (Boolean)cmd.getParameter(DYNAMIC_RELOAD);
            this.allowAppAuthMethodFallback = (Boolean)cmd.getParameter(ALLOW_APP_AUTH_METHOD_FALLBACK);
            this.krb5Config = (String)cmd.getParameter(KRB5_CONFIG);
            this.krb5Keytab = (String)cmd.getParameter(KRB5_KEYTAB);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + this.secDomain);
                Tr.debug(tc, "enabled: " + this.enabled);
                Tr.debug(tc, "dynamicReload: " + this.dynamicReload);
                Tr.debug(tc, "allowAppAuthMethodFallback: " + this.allowAppAuthMethodFallback);
                Tr.debug(tc, "krb5Config: " + this.krb5Config);
                Tr.debug(tc, "krb5Keytab: " + this.krb5Keytab);
            }
            if (this.secDomain != null) {
                securityObj = SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain);
                this.getAuthMechFromGlobalIfNeeded(this.session, this.configService, securityObj);
            } else {
                securityObj = SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
            }
            if (securityObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                throw new CommandValidationException(msg);
            }
            ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO");
            if (spnegoAuthMechObj == null) {
                spnegoAuthMechObj = SpnegoCommandProviderImpl.createDefaultSpnegoAuthMechObj(this.session, this.configService, securityObj);
            }
            ArrayList filters = (ArrayList)this.configService.getAttribute(this.session, spnegoAuthMechObj, FILTERS);
            if (this.enabled.booleanValue() && (filters == null || filters.size() == 0)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot enable SPNEGO Web authentication without defining any SPNEGO Web authentication filters.");
                }
                String msg = this.getMsg(resBundle, "security.admintask.spnego.noFilter.SECJ7781E", null);
                throw new CommandValidationException(msg);
            }
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand getUserCmd = null;
            CommandResult cmdResult = null;
            if (this.enabled.booleanValue()) {
                getUserCmd = commandMgr.createCommand("validateSpnegoConfig");
                getUserCmd.setParameter("securityDomainName", this.secDomain);
                getUserCmd.setParameter(KRB5_CONFIG, this.krb5Config);
                getUserCmd.setParameter(KRB5_KEYTAB, this.krb5Keytab);
                getUserCmd.setConfigSession(this.session);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validate SPNEGO Web configuration failed", new Object[]{e});
                    }
                    throw new CommandValidationException(e.getMessage());
                }
            }
            boolean krb5ConfigMatch = false;
            boolean krb5AuthConfig = this.isKrb5AuthConfig(this.session, this.configService, securityObj);
            if (krb5AuthConfig) {
                krb5ConfigMatch = this.krb5ConfigEquals(this.session, this.configService, securityObj, this.krb5Config, this.krb5Keytab);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "krb5ConfigMatch? " + krb5ConfigMatch);
                }
                if (!krb5ConfigMatch) {
                    getUserCmd = commandMgr.createCommand("validateKrbConfig");
                    getUserCmd.setParameter("securityDomainName", this.secDomain);
                    getUserCmd.setParameter("checkConfigOnly", false);
                    getUserCmd.setParameter("validateKrbRealm", false);
                    getUserCmd.setParameter("useGlobalSecurityConfig", true);
                    getUserCmd.setParameter(KRB5_CONFIG, this.krb5Config);
                    getUserCmd.setParameter(KRB5_KEYTAB, this.krb5Keytab);
                    getUserCmd.setConfigSession(this.session);
                    getUserCmd.execute();
                    cmdResult = getUserCmd.getCommandResult();
                    if (!cmdResult.isSuccessful()) {
                        Throwable e = cmdResult.getException();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Validating Kerberos configuration failed", new Object[]{e});
                        }
                        throw new CommandValidationException(e.getMessage());
                    }
                }
            }
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute(ENABLED, this.enabled));
            attrList.add(new Attribute(ALLOW_APP_AUTH_METHOD_FALLBACK, this.allowAppAuthMethodFallback));
            this.configService.setAttributes(this.session, spnegoAuthMechObj, attrList);
            attrList.clear();
            if (this.dynamicReload.booleanValue()) {
                ArrayList<ObjectName> authReferenceList = new ArrayList<ObjectName>();
                authReferenceList.add(spnegoAuthMechObj);
                attrList.add(new Attribute("authMechanisms", authReferenceList));
            } else {
                attrList.add(new Attribute("authMechanisms", null));
            }
            ObjectName dynamicReloadObj = null;
            AttributeList dynamicReloadAttrs = (AttributeList)this.configService.getAttribute(this.session, securityObj, DYNAMIC_RELOAD);
            if (dynamicReloadAttrs != null && dynamicReloadAttrs.size() != 0) {
                ObjectName[] objs = this.configService.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(dynamicReloadAttrs), null);
                if (objs != null) {
                    dynamicReloadObj = objs[0];
                    this.configService.setAttributes(this.session, dynamicReloadObj, attrList);
                }
            } else {
                dynamicReloadObj = this.configService.createConfigData(this.session, securityObj, DYNAMIC_RELOAD, null, attrList);
            }
            if (!krb5ConfigMatch) {
                attrList.clear();
                attrList.add(new Attribute(KRB5_CONFIG, this.krb5Config));
                attrList.add(new Attribute(KRB5_KEYTAB, this.krb5Keytab));
                ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "KRB5");
                if (krb5AuthMechObj == null) {
                    krb5AuthMechObj = this.configService.createConfigData(this.session, securityObj, "authMechanisms", "KRB5", attrList);
                } else {
                    this.configService.setAttributes(this.session, krb5AuthMechObj, attrList);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.configureSpnego", "274");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configureSpnego caught an unexpected exception.", new Object[]{e});
            }
            throw new CommandException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureSpnego");
        }
        return true;
    }

    public boolean unconfigureSpnego(AbstractAdminCommand cmd) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureSpnego");
        }
        try {
            ObjectName krb5AuthMechObj;
            boolean krb5AuthConfig;
            ObjectName spnegoAuthMechObj;
            ObjectName[] dynamicReloadObj;
            this.configService = this.getCommandProviderHelper().getConfigService();
            this.session = cmd.getConfigSession();
            ObjectName securityObj = null;
            this.secDomain = (String)cmd.getParameter("securityDomainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + this.secDomain);
            }
            if ((securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                throw new CommandValidationException(msg);
            }
            AttributeList dynamicReloadAttrs = (AttributeList)this.configService.getAttribute(this.session, securityObj, DYNAMIC_RELOAD);
            if (dynamicReloadAttrs != null && dynamicReloadAttrs.size() != 0 && (dynamicReloadObj = this.configService.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(dynamicReloadAttrs), null)) != null) {
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("authMechanisms", null));
                this.configService.setAttributes(this.session, dynamicReloadObj[0], attrList);
            }
            if ((spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO")) != null) {
                this.configService.deleteConfigData(this.session, spnegoAuthMechObj);
            }
            if (!(krb5AuthConfig = this.isKrb5AuthConfig(this.session, this.configService, securityObj)) && (krb5AuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "KRB5")) != null) {
                this.configService.deleteConfigData(this.session, krb5AuthMechObj);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.unconfigureSpnego", "342");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unconfigureSpnego caught an unexpected exception.", new Object[]{e});
            }
            throw new CommandException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unconfigureSpnego");
        }
        return true;
    }

    public List showSpnego(AbstractAdminCommand cmd) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showSpnego");
        }
        ArrayList<AttributeList> result = new ArrayList<AttributeList>();
        AttributeList attrList = new AttributeList();
        try {
            ObjectName[] objs;
            this.configService = this.getCommandProviderHelper().getConfigService();
            this.session = cmd.getConfigSession();
            ObjectName securityObj = null;
            this.secDomain = (String)cmd.getParameter("securityDomainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + this.secDomain);
            }
            if ((securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                throw new CommandValidationException(msg);
            }
            ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO");
            if (spnegoAuthMechObj != null) {
                attrList = this.configService.getAttributes(this.session, spnegoAuthMechObj, null, false);
            }
            String krb5Config = null;
            String krb5Keytab = null;
            ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "KRB5");
            if (krb5AuthMechObj != null) {
                krb5Config = (String)this.configService.getAttribute(this.session, krb5AuthMechObj, KRB5_CONFIG, false);
                if (krb5Config != null) {
                    attrList.add(new Attribute(KRB5_CONFIG, krb5Config));
                }
                if ((krb5Keytab = (String)this.configService.getAttribute(this.session, krb5AuthMechObj, KRB5_KEYTAB, false)) != null) {
                    attrList.add(new Attribute(KRB5_KEYTAB, krb5Keytab));
                }
            }
            ObjectName dynamicReloadObj = null;
            AttributeList dynamicReloadAttrs = (AttributeList)this.configService.getAttribute(this.session, securityObj, DYNAMIC_RELOAD);
            Boolean dynamicReload = Boolean.FALSE;
            if (dynamicReloadAttrs != null && dynamicReloadAttrs.size() != 0 && (objs = this.configService.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(dynamicReloadAttrs), null)) != null) {
                dynamicReloadObj = objs[0];
                Boolean allAuths = (Boolean)this.configService.getAttribute(this.session, dynamicReloadObj, "allAuthMechanisms", false);
                if (allAuths != null && allAuths.booleanValue()) {
                    dynamicReload = Boolean.TRUE;
                } else {
                    ArrayList authArrayList = (ArrayList)this.configService.getAttribute(this.session, dynamicReloadObj, "authMechanisms", false);
                    if (authArrayList != null && authArrayList.size() > 0) {
                        for (int i = 0; i < authArrayList.size(); ++i) {
                            ObjectName authMech = (ObjectName)authArrayList.get(i);
                            AttributeList authMechAttrs = this.configService.getAttributes(this.session, authMech, null, true);
                            String mechanism = (String)ConfigServiceHelper.getAttributeValue(authMechAttrs, "_Websphere_Config_Data_Type");
                            if (!mechanism.equals("SPNEGO")) continue;
                            dynamicReload = Boolean.TRUE;
                        }
                    }
                }
            }
            if (dynamicReload.booleanValue()) {
                attrList.add(new Attribute(DYNAMIC_RELOAD, (boolean)dynamicReload));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.showSpnego", "433");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "showSpnego caught an unexpected exception.", new Object[]{e});
            }
            throw new CommandException(e, e.getMessage());
        }
        result.add(attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showSpnego ");
        }
        return result;
    }

    public boolean validateSpnegoConfig(AbstractAdminCommand cmd) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSpnegoConfig");
        }
        boolean result = false;
        try {
            ObjectName spnegoAuthMechObj;
            this.configService = this.getCommandProviderHelper().getConfigService();
            this.session = cmd.getConfigSession();
            ObjectName securityObj = null;
            this.secDomain = (String)cmd.getParameter("securityDomainName");
            this.krb5Config = (String)cmd.getParameter(KRB5_CONFIG);
            this.krb5Keytab = (String)cmd.getParameter(KRB5_KEYTAB);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + this.secDomain);
                Tr.debug(tc, "krb5Config: " + this.krb5Config);
                Tr.debug(tc, "krb5Keytab: " + this.krb5Keytab);
            }
            if ((securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                throw new CommandValidationException(msg);
            }
            if (this.krb5Config == null || this.krb5Config.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Auth.SECJ7771E", new Object[]{KRB5_CONFIG});
                throw new CommandValidationException(msg);
            }
            File config = new File(this.krb5Config);
            if (!config.exists()) {
                String msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Config});
                throw new CommandValidationException(msg);
            }
            if (this.krb5Keytab == null || this.krb5Keytab.length() == 0) {
                String krb5DefaultKeytab = Krb5Utils.getDefaultKeytab(this.krb5Config);
                if (krb5DefaultKeytab == null || krb5DefaultKeytab.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5ConfigAndSecurity", new Object[]{KRB5_KEYTAB, this.krb5Config});
                    throw new CommandValidationException(msg);
                }
                File keytab = new File(krb5DefaultKeytab);
                if (!keytab.exists()) {
                    String msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{krb5DefaultKeytab});
                    throw new CommandValidationException(msg);
                }
            } else {
                File keytab = new File(this.krb5Keytab);
                if (!keytab.exists()) {
                    String msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Keytab});
                    throw new CommandValidationException(msg);
                }
            }
            if ((spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SPNEGO Web authentication object is null, nothing to validate");
                }
                return true;
            }
            ArrayList filters = (ArrayList)this.configService.getAttribute(this.session, spnegoAuthMechObj, FILTERS);
            if (filters == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SPNEGO Web authentication Filter is null, do not validate");
                }
                return true;
            }
            String krb5DefaultRealm = Krb5Utils.getDefaultRealm(this.krb5Config);
            if (krb5DefaultRealm == null) {
                String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Config.SECJ7772E", new Object[]{"default_realm in libdefaults section", this.krb5Config});
                throw new CommandValidationException(msg);
            }
            for (int i = 0; i < filters.size(); ++i) {
                AttributeList filterAttrs = (AttributeList)filters.get(i);
                String host = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, HOST_NAME);
                if (host == null || host.length() == 0) continue;
                String spn = "HTTP@" + host;
                result = this.validateKrb5Spn(spn, this.krb5Keytab);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.validateSpnegoConfig", "564");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateSpnegoConfig caught an unexpected exception.", new Object[]{e});
            }
            throw new CommandException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSpnegoConfig " + result);
        }
        return result;
    }

    public boolean addSpnegoFilter(AbstractAdminCommand cmd) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSpnegoFilter");
        }
        try {
            this.configService = this.getCommandProviderHelper().getConfigService();
            this.session = cmd.getConfigSession();
            ObjectName securityObj = null;
            this.getParameters(cmd);
            securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
            if (securityObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                throw new CommandValidationException(msg);
            }
            boolean spnegoEnabled = false;
            ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO");
            if (spnegoAuthMechObj == null) {
                spnegoAuthMechObj = SpnegoCommandProviderImpl.createDefaultSpnegoAuthMechObj(this.session, this.configService, securityObj);
            } else {
                spnegoEnabled = (Boolean)this.configService.getAttribute(this.session, spnegoAuthMechObj, ENABLED, false);
                if (spnegoEnabled) {
                    String spn = "HTTP@" + this.hostName;
                    boolean result = this.validateKrb5Spn(spn, this.krb5Keytab);
                }
            }
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute(HOST_NAME, this.hostName));
            attrList.add(new Attribute(KRB5_REALM, this.krb5Realm));
            attrList.add(new Attribute(FILTER_CRITERIA, this.filterCriteria));
            attrList.add(new Attribute(FILTER_CLASS, this.filterClass));
            attrList.add(new Attribute(TRIM_USER_NAME, this.trimUserName));
            attrList.add(new Attribute(ENABLED_GSS_CRED_DELEGATE, this.enabledGssCredDelegate));
            attrList.add(new Attribute(SPNEGO_NOT_SUPPORTED_PAGE, this.spnegoNotSupportedPage));
            attrList.add(new Attribute(NTLM_TOKEN_RECEIVED_PAGE, this.ntlmTokenReceivedPage));
            if (SpnegoCommandProviderImpl.isFilterHostExist(this.session, this.configService, spnegoAuthMechObj, this.hostName)) {
                String msg = this.getMsg(resBundle, "security.admintask.SPNEGOFilterExists", new Object[]{this.hostName});
                throw new CommandValidationException(msg);
            }
            this.configService.createConfigData(this.session, spnegoAuthMechObj, FILTERS, null, attrList);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.addSpnegoFilter", "631");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addSpnegoFilter caught an unexpected exception.", new Object[]{e});
            }
            throw new CommandException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSpnegoFilter");
        }
        return true;
    }

    public boolean deleteSpnegoFilter(AbstractAdminCommand cmd) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSpnegoFilter");
        }
        try {
            this.configService = this.getCommandProviderHelper().getConfigService();
            this.session = cmd.getConfigSession();
            ObjectName securityObj = null;
            this.secDomain = (String)cmd.getParameter("securityDomainName");
            this.hostName = (String)cmd.getParameter(HOST_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + this.secDomain);
                Tr.debug(tc, "hostName:  " + this.hostName);
            }
            if ((securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService)) == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                throw new CommandValidationException(msg);
            }
            ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO");
            if (spnegoAuthMechObj != null) {
                boolean spnegoEnabled = (Boolean)this.configService.getAttribute(this.session, spnegoAuthMechObj, ENABLED, false);
                ArrayList filters = (ArrayList)this.configService.getAttribute(this.session, spnegoAuthMechObj, FILTERS);
                if (filters != null && filters.size() != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "spnegoEnabled: " + spnegoEnabled);
                        Tr.debug(tc, "filters.size(): " + filters.size());
                    }
                    for (int i = 0; i < filters.size(); ++i) {
                        AttributeList filterAttrs = (AttributeList)filters.get(i);
                        ObjectName[] matches = this.configService.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(filterAttrs), null);
                        if (matches[0] == null) continue;
                        if (this.hostName != null && this.hostName.length() != 0) {
                            String host = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, HOST_NAME);
                            if (host == null || host.length() == 0 || !host.equals(this.hostName)) continue;
                            if (spnegoEnabled && filters.size() == 1) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Can not delete the last SPNEGO filter because SPNEGO Web authentication is enabled.");
                                }
                                String msg = this.getMsg(resBundle, "security.admintask.spnego.errorDeleteLastFilter.SECJ7798E", null);
                                throw new CommandValidationException(msg);
                            }
                            this.configService.deleteConfigData(this.session, matches[0]);
                            return true;
                        }
                        if (spnegoEnabled) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Can not delete all SPNEGO filters because SPNEGO Web authentication is enabled.");
                            }
                            String msg = this.getMsg(resBundle, "security.admintask.spnego.errorDeleteAllFiters.SECJ7799E", null);
                            throw new CommandValidationException(msg);
                        }
                        this.configService.deleteConfigData(this.session, matches[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.deleteSpnegoFilter", "720");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleteSpnegoFilter caught an unexpected exception.", new Object[]{e});
            }
            throw new CommandException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSpnegoFilter");
        }
        return true;
    }

    public boolean modifySpnegoFilter(AbstractAdminCommand cmd) throws CommandException {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "modifySpnegoFilter");
            }
            try {
                ObjectName filterObj;
                this.configService = this.getCommandProviderHelper().getConfigService();
                this.session = cmd.getConfigSession();
                ObjectName securityObj = null;
                this.getParameters(cmd);
                securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
                if (securityObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
                ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO");
                if (spnegoAuthMechObj == null) break block15;
                AttributeList attrList = new AttributeList();
                if (this.hostName != null) {
                    attrList.add(new Attribute(HOST_NAME, this.hostName));
                }
                if (this.krb5Realm != null) {
                    attrList.add(new Attribute(KRB5_REALM, this.krb5Realm));
                }
                if (this.filterCriteria != null) {
                    attrList.add(new Attribute(FILTER_CRITERIA, this.filterCriteria));
                }
                if (this.filterClass != null) {
                    attrList.add(new Attribute(FILTER_CLASS, this.filterClass));
                }
                if (this.trimUserName != null) {
                    attrList.add(new Attribute(TRIM_USER_NAME, this.trimUserName));
                }
                if (this.enabledGssCredDelegate != null) {
                    attrList.add(new Attribute(ENABLED_GSS_CRED_DELEGATE, this.enabledGssCredDelegate));
                }
                if (this.spnegoNotSupportedPage != null) {
                    attrList.add(new Attribute(SPNEGO_NOT_SUPPORTED_PAGE, this.spnegoNotSupportedPage));
                }
                if (this.ntlmTokenReceivedPage != null) {
                    attrList.add(new Attribute(NTLM_TOKEN_RECEIVED_PAGE, this.ntlmTokenReceivedPage));
                }
                if ((filterObj = SpnegoCommandProviderImpl.getFilterObj(this.session, this.configService, spnegoAuthMechObj, this.hostName)) != null) {
                    this.configService.setAttributes(this.session, filterObj, attrList);
                    break block15;
                }
                throw new CommandValidationException("Filter does not exist for host " + this.hostName);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.modifySpnegoFilter", "791");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modifySpnegoFilter caught an unexpected exception.", new Object[]{e});
                }
                throw new CommandException(e, e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifySpnegoFilter");
        }
        return true;
    }

    public List showSpnegoFilter(AbstractAdminCommand cmd) throws CommandException {
        ArrayList<AttributeList> result;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "showSpnegoFilter");
            }
            result = new ArrayList<AttributeList>();
            try {
                ArrayList filters;
                this.configService = this.getCommandProviderHelper().getConfigService();
                this.session = cmd.getConfigSession();
                ObjectName securityObj = null;
                this.secDomain = (String)cmd.getParameter("securityDomainName");
                this.hostName = (String)cmd.getParameter(HOST_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "securityDomainName name is " + this.secDomain);
                    Tr.debug(tc, "hostName:  " + this.hostName);
                }
                if ((securityObj = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService)) == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
                ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(this.session, this.configService, securityObj, "SPNEGO");
                if (spnegoAuthMechObj == null || (filters = (ArrayList)this.configService.getAttribute(this.session, spnegoAuthMechObj, FILTERS)) == null) break block9;
                for (int i = 0; i < filters.size(); ++i) {
                    AttributeList filterAttrs = (AttributeList)filters.get(i);
                    ObjectName[] matches = this.configService.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(filterAttrs), null);
                    if (matches[0] == null) continue;
                    if (this.hostName != null && this.hostName.length() != 0) {
                        String host = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, HOST_NAME);
                        if (host == null || host.length() == 0 || !host.equals(this.hostName)) continue;
                        result.add(filterAttrs);
                        break;
                    }
                    result.add(filterAttrs);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.admintask.showSpnegoFilter", "864");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "showSpnegoFilter caught an unexpected exception.", new Object[]{e});
                }
                throw new CommandException(e, e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showSpnegoFilter");
        }
        return result;
    }

    public static ObjectName createDefaultSpnegoAuthMechObj(Session session, ConfigService configService, ObjectName securityObj) throws Exception {
        ObjectName spnegoObj;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createDefaultSpnegoAuthMechObj");
            }
            spnegoObj = null;
            try {
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("OID", "oid:1.3.6.1.5.5.2"));
                attrList.add(new Attribute("authContextImplClass", "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl"));
                attrList.add(new Attribute(ENABLED, false));
                attrList.add(new Attribute(ALLOW_APP_AUTH_METHOD_FALLBACK, null));
                spnegoObj = configService.createConfigData(session, securityObj, "authMechanisms", "SPNEGO", attrList);
            }
            catch (InvalidAttributeNameException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "createDefaultSpnegoAuthMechObj caught an unexpected exception.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultSpnegoAuthMechObj " + spnegoObj);
        }
        return spnegoObj;
    }

    public boolean krb5ConfigEquals(Session session, ConfigService configService, ObjectName securityObj, String krb5Config, String krb5Keytab) throws Exception {
        ObjectName krb5AuthMechObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "krb5ConfigEquals");
        }
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "krb5Config: " + krb5Config);
            Tr.debug(tc, "krb5Keytab: " + krb5Keytab);
        }
        if ((krb5AuthMechObj = Krb5Utils.getAuthMechObj(session, configService, securityObj, "KRB5")) != null) {
            String krb5Auth_krb5Config = (String)configService.getAttribute(session, krb5AuthMechObj, KRB5_CONFIG, false);
            String krb5Auth_krb5Keytab = (String)configService.getAttribute(session, krb5AuthMechObj, KRB5_KEYTAB, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "krb5Auth_krb5Config: " + krb5Auth_krb5Config);
                Tr.debug(tc, "krb5Auth_krb5Keytab: " + krb5Auth_krb5Keytab);
            }
            if (krb5Auth_krb5Config != null && krb5Auth_krb5Config.length() != 0 && krb5Auth_krb5Config.equalsIgnoreCase(krb5Config)) {
                if (!(krb5Auth_krb5Keytab != null && krb5Auth_krb5Keytab.length() != 0 || krb5Keytab != null && krb5Keytab.length() != 0)) {
                    result = true;
                } else if (krb5Auth_krb5Keytab != null && krb5Keytab != null && krb5Auth_krb5Keytab.equalsIgnoreCase(krb5Keytab)) {
                    result = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "krb5ConfigEquals " + result);
        }
        return result;
    }

    public boolean isKrb5AuthConfig(Session session, ConfigService configService, ObjectName securityObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKrb5AuthConfig");
        }
        boolean result = false;
        ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(session, configService, securityObj, "KRB5");
        if (krb5AuthMechObj != null) {
            this.krb5Auth_krb5Config = (String)configService.getAttribute(session, krb5AuthMechObj, KRB5_CONFIG, false);
            String authContextImplClass = (String)configService.getAttribute(session, krb5AuthMechObj, "authContextImplClass", false);
            boolean _configured = (Boolean)configService.getAttribute(session, krb5AuthMechObj, "configured", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "krb5Auth_krb5Config: " + this.krb5Auth_krb5Config);
            }
            if (this.krb5Auth_krb5Config != null && this.krb5Auth_krb5Config.length() != 0 && authContextImplClass != null && authContextImplClass.length() != 0 && _configured) {
                result = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKrb5AuthConfig " + result);
        }
        return result;
    }

    public static ObjectName getFilterObj(Session session, ConfigService configService, ObjectName spnegoObj, String filterHost) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilters" + filterHost);
        }
        ObjectName filterObj = null;
        try {
            ArrayList filters = (ArrayList)configService.getAttribute(session, spnegoObj, FILTERS);
            if (filters != null) {
                for (int i = 0; i < filters.size(); ++i) {
                    ObjectName[] matches;
                    AttributeList filterAttrs = (AttributeList)filters.get(i);
                    String host = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, HOST_NAME);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Filter host name:  " + host);
                    }
                    if (!host.equals(filterHost) || (matches = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(filterAttrs), null))[0] == null) continue;
                    filterObj = matches[0];
                }
            }
        }
        catch (InvalidAttributeNameException e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilters");
        }
        return filterObj;
    }

    public static boolean isFilterHostExist(Session session, ConfigService configService, ObjectName spnegoObj, String filterHost) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFilterHostExist " + filterHost);
        }
        boolean result = false;
        ObjectName filterObj = SpnegoCommandProviderImpl.getFilterObj(session, configService, spnegoObj, filterHost);
        if (filterObj != null) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFilterHostExist " + result);
        }
        return result;
    }

    private void getParameters(AbstractAdminCommand cmd) throws CommandValidationException {
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameters");
        }
        this.initializeParameters();
        this.secDomain = (String)cmd.getParameter("securityDomainName");
        this.hostName = (String)cmd.getParameter(HOST_NAME);
        this.krb5Realm = (String)cmd.getParameter(KRB5_REALM);
        this.filterCriteria = (String)cmd.getParameter(FILTER_CRITERIA);
        this.filterClass = (String)cmd.getParameter(FILTER_CLASS);
        this.trimUserName = (Boolean)cmd.getParameter(TRIM_USER_NAME);
        this.enabledGssCredDelegate = (Boolean)cmd.getParameter(ENABLED_GSS_CRED_DELEGATE);
        this.spnegoNotSupportedPage = (String)cmd.getParameter(SPNEGO_NOT_SUPPORTED_PAGE);
        this.ntlmTokenReceivedPage = (String)cmd.getParameter(NTLM_TOKEN_RECEIVED_PAGE);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "securityDomainName name is " + this.secDomain);
            Tr.debug(tc, "hostName:  " + this.hostName);
            Tr.debug(tc, "krb5Realm:  " + this.krb5Realm);
            Tr.debug(tc, "filterCriteria:  " + this.filterCriteria);
            Tr.debug(tc, "filterClass:  " + this.filterClass);
            Tr.debug(tc, "trimUserName:  " + this.trimUserName);
            Tr.debug(tc, "enabledGssCredDelegate:  " + this.enabledGssCredDelegate);
            Tr.debug(tc, "spnegoNotSupportedPage:  " + this.spnegoNotSupportedPage);
            Tr.debug(tc, "ntlmTokenReceivedPage:  " + this.ntlmTokenReceivedPage);
        }
        if (!this.isFilterValid(this.filterCriteria, this.filterClass)) {
            String msg2 = this.getMsg(resBundle, "security.admintask.SPNEGOFilterInvalid", new Object[]{this.filterCriteria});
            throw new CommandValidationException(msg2);
        }
        try {
            if (this.filterClass != null && this.filterClass.length() != 0) {
                ServerConfig serverConfig = new ServerConfig();
                serverConfig.setFilterClass(this.filterClass);
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (this.spnegoNotSupportedPage != null && this.spnegoNotSupportedPage.length() != 0 && !this.isValidURL(this.spnegoNotSupportedPage)) {
            msg = this.getMsg(resBundle, "security.admintask.SPNEGOFilterInvalidURL", new Object[]{this.spnegoNotSupportedPage});
            throw new CommandValidationException(msg);
        }
        if (this.ntlmTokenReceivedPage != null && this.ntlmTokenReceivedPage.length() != 0 && !this.isValidURL(this.ntlmTokenReceivedPage)) {
            msg = this.getMsg(resBundle, "security.admintask.SPNEGOFilterInvalidURL", new Object[]{this.ntlmTokenReceivedPage});
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameters");
        }
    }

    private boolean isFilterValid(String filterCriteria, String filterClass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFilterValid");
        }
        boolean isValid = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filterCriteria" + filterCriteria);
            Tr.debug(tc, "filterClass" + filterClass);
        }
        if (filterCriteria != null && filterCriteria.length() != 0 && (filterClass == null || filterClass.length() == 0 || DEFAULT_FILTER_CLASS.equals(filterClass))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFilterValidfilter=\"" + filterCriteria + "\"");
            }
            isValid = HTTPHeaderFilter.isValid(filterCriteria);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFilterValid ", Boolean.toString(isValid));
        }
        return isValid;
    }

    private boolean isValidURL(String url) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidURL");
        }
        boolean isValid = true;
        try {
            URL res = new URL(url);
        }
        catch (MalformedURLException e) {
            isValid = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidURL ", Boolean.toString(isValid));
        }
        return isValid;
    }

    private void initializeParameters() {
        this.hostName = null;
        this.krb5Realm = null;
        this.filterCriteria = null;
        this.filterClass = null;
        this.trimUserName = null;
        this.enabledGssCredDelegate = null;
        this.spnegoNotSupportedPage = null;
        this.ntlmTokenReceivedPage = null;
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public boolean validateKrb5Spn(String krb5Spn, String krb5Keytab) throws GSSException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateKrb5Spn " + krb5Spn + " krb5Keytab:" + krb5Keytab);
        }
        GSSCredential krb5SpnGSSCred = null;
        boolean result = false;
        Oid krb5MechanismOid = Krb5Utils.getKrb5MechOid();
        Oid spnegoMechanismOid = Krb5Utils.getSpnegoMechOid();
        try {
            Krb5Utils.setKrbKeytabProp(krb5Keytab);
            Krb5Utils.setUseSubjectCredsOnly(false);
            GSSManager mgr = GSSManager.getInstance();
            GSSName gssName = mgr.createName(krb5Spn, GSSName.NT_HOSTBASED_SERVICE, krb5MechanismOid);
            krb5SpnGSSCred = mgr.createCredential(gssName.canonicalize(Krb5Utils.getKrb5MechOid()), Integer.MAX_VALUE, krb5MechanismOid, 2);
            krb5SpnGSSCred.add(gssName.canonicalize(Krb5Utils.getSpnegoMechOid()), Integer.MAX_VALUE, Integer.MAX_VALUE, spnegoMechanismOid, 2);
            Krb5Utils.setUseSubjectCredsOnly(true);
        }
        catch (GSSException exc) {
            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.kerberos.admintask.validateKrb5Spn", "1190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, exc.getMessage(), new Object[]{exc});
            }
            throw exc;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.validateKrb5Spn", "1194", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
            throw e;
        }
        if (krb5SpnGSSCred != null) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateKrb5Spn " + result);
        }
        return result;
    }

    public void getAuthMechFromGlobalIfNeeded(Session session, ConfigService configService, ObjectName domainObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechFromGlobalIfNeeded");
        }
        ArrayList<AttributeList> newMech = new ArrayList<AttributeList>();
        boolean ltpaExists = false;
        boolean spnegoExists = false;
        boolean krb5Exists = false;
        try {
            ArrayList mechanisms = (ArrayList)configService.getAttribute(session, domainObj, "authMechanisms");
            for (AttributeList authMechanism : mechanisms) {
                String mechanism = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (mechanism.equals("LTPA")) {
                    ltpaExists = true;
                }
                if (mechanism.equals("SPNEGO")) {
                    spnegoExists = true;
                }
                if (mechanism.equals("KRB5")) {
                    krb5Exists = true;
                }
                newMech.add(authMechanism);
            }
            if (ltpaExists && spnegoExists && krb5Exists) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getAuthMechFromGlobalIfNeeded - Objects already exist.");
                }
                return;
            }
            ObjectName securityObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            AttributeList globalSecAuthMechs = configService.getAttributes(session, securityObj, new String[]{"authMechanisms"}, true);
            ArrayList globalSecMechanisms = (ArrayList)ConfigServiceHelper.getAttributeValue(globalSecAuthMechs, "authMechanisms");
            Iterator iter = globalSecMechanisms.iterator();
            while (iter.hasNext()) {
                String name;
                Attribute o;
                Iterator iter1;
                AttributeList authMechanism;
                AttributeList attrList = authMechanism = (AttributeList)iter.next();
                String mechanism = (String)ConfigServiceHelper.getAttributeValue(authMechanism, "_Websphere_Config_Data_Type");
                if (mechanism.equals("LTPA") && !ltpaExists) {
                    iter1 = attrList.iterator();
                    while (iter1.hasNext()) {
                        o = (Attribute)iter1.next();
                        name = o.getName();
                        if (name.equals("trustAssociation")) {
                            iter1.remove();
                        }
                        if (name.equals("singleSignon")) {
                            iter1.remove();
                        }
                        if (!name.equals("keySetGroup")) continue;
                        iter1.remove();
                    }
                    newMech.add(attrList);
                    continue;
                }
                if (mechanism.equals("KRB5") && !krb5Exists) {
                    iter1 = attrList.iterator();
                    while (iter1.hasNext()) {
                        o = (Attribute)iter1.next();
                        name = o.getName();
                        if (!name.equals("OID") && !name.equals("authContextImplClass") && !name.equals("authConfig") && !name.equals("simpleAuthConfig") && !name.equals("authValidationConfig") && !name.equals("isCredentialForwardable")) continue;
                        iter1.remove();
                    }
                    newMech.add(attrList);
                    continue;
                }
                if (mechanism.equals("SPNEGO") && !spnegoExists) {
                    newMech.add(attrList);
                    continue;
                }
                iter.remove();
            }
            AttributeList attrs = new AttributeList();
            attrs.add(new Attribute("authMechanisms", newMech));
            configService.setAttributes(session, domainObj, attrs);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.validateKrb5Spn", "1303", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechFromGlobalIfNeeded - Objects created in domain");
        }
    }
}

