/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SetActiveAuthMechanism
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(SetActiveAuthMechanism.class, "SetActiveAuthMechanism", "com.ibm.ws.security.auth.kerberos.admintask");
    static final String krb5Auth = "KRB5";
    static final String ltpaAuth = "LTPA";
    String authMechanismType = null;

    public SetActiveAuthMechanism(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public SetActiveAuthMechanism(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public boolean validAuthMechanism(String authMechanismType) throws CommandValidationException {
        boolean enabledKRBAuth = SecurityObjectLocator.getSecurityConfig("security").getPropertyBool("com.ibm.websphere.security.krb.enabled");
        if (!enabledKRBAuth && authMechanismType.equalsIgnoreCase(krb5Auth)) {
            String msg = "Kerberos authentication mechanism is disabled in this release";
            throw new CommandValidationException(msg);
        }
        return authMechanismType.equalsIgnoreCase(krb5Auth) || authMechanismType.equalsIgnoreCase(ltpaAuth);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.authMechanismType = (String)this.getParameter("authMechanismType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authMechanismType:  " + this.authMechanismType);
        }
        if (!this.validAuthMechanism(this.authMechanismType)) {
            String msg = this.getMsg(resBundle, "security.admintask.invalidAuthMechType", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            ObjectName cellName = cs.resolve(s, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            if (cellName != null) {
                security2 = cs.queryConfigObjects(s, cellName, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ArrayList authMechs = (ArrayList)cs.getAttribute(s, security2, "authMechanisms");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authMechs:  " + authMechs);
            }
            for (int i = 0; i < authMechs.size(); ++i) {
                AttributeList urAttrs = (AttributeList)authMechs.get(i);
                Object urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                if (!urObj.toString().equalsIgnoreCase(this.authMechanismType)) continue;
                ObjectName[] matches = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(urAttrs), null);
                attrList.add(new Attribute("activeAuthMechanism", matches[0]));
            }
            cs.setAttributes(s, security2, attrList);
            result.setResult(new Boolean(true));
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

