/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListKrbAuthMechanism
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKrbAuthMechanism.class, "ListKrbAuthMechanism", "com.ibm.ws.security.auth.kerberos.admintask");
    String authMechanismType = null;
    final String krb5Auth = "KRB5";

    public ListKrbAuthMechanism(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListKrbAuthMechanism(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            security2 = cs.resolve(s, "Cell=:Security=")[0];
            AttributeList attrList = new AttributeList();
            ArrayList authMechs = (ArrayList)cs.getAttribute(s, security2, "authMechanisms");
            ObjectName[] krb5ObjName = null;
            for (int i = 0; i < authMechs.size(); ++i) {
                AttributeList authAttrs = (AttributeList)authMechs.get(i);
                Object authObj = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                if (!authObj.toString().equalsIgnoreCase("KRB5")) continue;
                krb5ObjName = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(authAttrs), null);
            }
            if (krb5ObjName != null) {
                result.setResult(cs.getAttributes(s, (ObjectName)krb5ObjName[0], null, true));
            } else {
                result.setResult(new Boolean(false));
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

