/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.auth.module.Krb5LoginModule;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;

public class Krb5LoginModuleWrapper
extends Krb5LoginModule {
    protected boolean _debug = true;
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private boolean _krb5Login = true;
    private static final TraceComponent tc = Tr.register(Krb5LoginModuleWrapper.class, "Security", "com.ibm.ws.security.auth.kerberos.krbsecurity");
    boolean login_called = false;

    public Krb5LoginModuleWrapper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5LoginModuleWrapper()");
            Tr.exit(tc, "Krb5LoginModuleWrapper()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
            }
            try {
                super.initialize(subject, callbackHandler, sharedState, options);
                this._subject = subject;
                this._callbackHandler = callbackHandler;
                this._sharedState = sharedState;
                this._options = options;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.initialize", "167", (Object)this);
                if (!this._debug && !tc.isDebugEnabled()) break block5;
                Tr.error(tc, "initialize", new Object[]{e});
            }
        }
        this._debug = "true".equalsIgnoreCase((String)this._options.get("debug"));
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Krb5LoginModuleWrapper");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws CredentialExpiredException, FailedLoginException, LoginException {
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        String uid = null;
        String realm = null;
        char[] password = null;
        String authMechOid = null;
        byte[] credToken = null;
        List authzTokenList = null;
        Hashtable customProperties = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Callback[] callbacks = null;
        if (!this._sharedState.containsKey("Callback")) {
            if (this._callbackHandler == null) {
                WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                contextManager.setRootException(e);
                throw e;
            }
            callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSTokenHolderCallback("Authz Token List: "), new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm()), new WSX509CertificateChainCallback("X509Certificate[]: "), new WSAuthMechOidCallbackImpl("AuthMechOid: ")};
            try {
                this._callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "238", (Object)this);
                Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{((Object)((Object)this)).getClass().getName(), e});
                contextManager.setRootException(e);
                throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
            }
            catch (UnsupportedCallbackException uce) {
                FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "243", (Object)this);
                Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{((Object)((Object)this)).getClass().getName(), uce.getCallback().toString(), uce});
                contextManager.setRootException(uce);
                throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
            }
            this._sharedState.put("Callback", callbacks);
        } else {
            callbacks = (Callback[])this._sharedState.get("Callback");
        }
        authMechOid = ((WSAuthMechOidCallbackImpl)callbacks[9]).getAuthMechOid();
        uid = ((NameCallback)callbacks[0]).getName();
        this._krb5Login = Krb5Utils.isKrb5Login(authMechOid, uid);
        if (!this._krb5Login) {
            boolean _succeeded = true;
            return _succeeded;
        }
        char[] tmp = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmp != null) {
            password = new char[tmp.length];
            System.arraycopy(tmp, 0, password, 0, tmp.length);
        }
        realm = ((WSRealmNameCallbackImpl)callbacks[7]).getRealmName();
        byte[] tmpCred = ((WSCredTokenCallbackImpl)callbacks[2]).getCredToken();
        if (tmpCred != null) {
            credToken = CredentialsHelper.copyCredToken(tmpCred);
        }
        authzTokenList = ((WSTokenHolderCallback)callbacks[6]).getTokenHolderList();
        if (customProperties == null) {
            try {
                final Subject subjectPriv = this._subject;
                customProperties = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] list_public = subjectPriv.getPublicCredentials().toArray();
                        if (Krb5LoginModuleWrapper.this._debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < list_public.length; ++i) {
                            if (Krb5LoginModuleWrapper.this._debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in public list: " + list_public[i]);
                            }
                            if (!(list_public[i] instanceof Hashtable) || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.userId") == null || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.password") == null) continue;
                            return list_public[i];
                        }
                        Object[] list_private = subjectPriv.getPrivateCredentials().toArray();
                        Tr.debug(tc, "Looking for custom properties in private cred list.");
                        for (int i = 0; i < list_private.length; ++i) {
                            if (Krb5LoginModuleWrapper.this._debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in private list: " + list_private[i]);
                            }
                            if (!(list_private[i] instanceof Hashtable) || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.userId") == null || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.password") == null) continue;
                            return list_private[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "317", (Object)this);
                contextManager.setRootException(e.getException());
                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
            }
            if (customProperties != null) {
                this._sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", customProperties);
            }
        }
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + uid);
            Tr.debug(tc, "realm = " + realm);
            Tr.debug(tc, "password = " + (password != null ? "<not null>" : "<null>"));
            Tr.debug(tc, "cred token = " + (credToken != null ? "<not null>" : "<null>"));
            Tr.debug(tc, "authz token list = " + authzTokenList);
            Tr.debug(tc, "custom properties = " + customProperties);
            Tr.debug(tc, "authMechOid = " + authMechOid);
        }
        if (customProperties != null) {
            String temp_uid = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
            String temp_password = (String)customProperties.get("com.ibm.wsspi.security.cred.password");
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging in using JAASClient login configuration with user: " + temp_uid);
            }
            if (temp_uid != null && !temp_uid.equals("") && temp_password != null && !temp_password.equals("")) {
                uid = temp_uid;
                password = temp_password.toCharArray();
                String serverRealm = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm");
                String defaultRealm = contextManager.getDefaultRealm();
                if (!(realm.equals(defaultRealm) || realm.equals(serverRealm) || realm.equals("<default>"))) {
                    String exceptionMessage = "The login will be failed because the Kerberos realm name specified in the callback handler, " + realm + ", does not match the Kerberos realm name specified in the server's security configuration: " + serverRealm + " or the default realm name: " + defaultRealm;
                    if (this._debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "login()", exceptionMessage);
                    }
                    throw new WSLoginFailedException(exceptionMessage);
                }
                try {
                    GSSCredential _gssCred;
                    Subject temp_subject;
                    LoginContext lc = new LoginContext("JAASClient", new WSCallbackHandlerImpl(uid, temp_password));
                    lc.login();
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting subject from login context.");
                    }
                    if ((temp_subject = lc.getSubject()) != null && (_gssCred = Krb5Utils.createGSSCredential(temp_subject)) != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                if (!Krb5LoginModuleWrapper.this._subject.getPrivateCredentials().contains(_gssCred)) {
                                    if (Krb5LoginModuleWrapper.this._debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding GSSCredential to Subject.");
                                    }
                                    Krb5LoginModuleWrapper.this._subject.getPrivateCredentials().add(_gssCred);
                                }
                                return null;
                            }
                        });
                    }
                    boolean _succeeded = true;
                    return _succeeded;
                }
                catch (LoginException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "392", (Object)this);
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling JAASClient login context: " + e.toString());
                    }
                    boolean _succeeded = false;
                    return false;
                }
            }
        }
        if (uid != null && password != null) {
            this.login_called = true;
            String serverRealm = SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("KRB5").getString("krb5Realm");
            String defaultRealm = contextManager.getDefaultRealm();
            if (!(realm.equals(defaultRealm) || realm.equals(serverRealm) || realm.equals("<default>"))) {
                String exceptionMessage = "The login failed because the Kerberos realm name specified in the callback handler, " + realm + ", does not match the Kerberos realm name specified in the server's security configuration: " + serverRealm + " or the default realm name: " + defaultRealm;
                if (this._debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", exceptionMessage);
                }
                throw new WSLoginFailedException(exceptionMessage);
            }
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.login() from wrapper with uid/password.");
            }
            boolean result = false;
            try {
                result = super.login();
                Tr.debug(tc, "Result from login: " + result);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "423", (Object)this);
                if (this._debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{e});
                }
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            return result;
        }
        if (credToken != null || uid != null) {
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Credential token or uid with no password has been received. Handling login outside this login module.");
            }
            boolean _succeeded = true;
            return _succeeded;
        }
        this.login_called = true;
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling super.login() from wrapper.");
        }
        boolean result = false;
        try {
            result = super.login();
            return result;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "451", (Object)this);
            if (this._debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "login()", new Object[]{e});
            }
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public boolean commit() throws LoginException {
        if (this.login_called) {
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.commit() from wrapper.");
            }
            return super.commit();
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.login_called) {
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.abort() from wrapper.");
            }
            return super.abort();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.login_called) {
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.logout() from wrapper.");
            }
            return super.logout();
        }
        return true;
    }
}

