/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.IdentityPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AuthData;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.wsspi.security.auth.callback.WSManagedConnectionFactoryCallback;
import com.ibm.wsspi.security.auth.callback.WSMappingPropertiesCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSPrincipalMappingLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(WSPrincipalMappingLoginModule.class, null, "com.ibm.ejs.resources.security");
    private Subject wspm_subject;
    private CallbackHandler wspm_callbackHandler;
    private Map wspm_sharedState;
    private Map wspm_options;
    private boolean wspm_debug = false;
    private boolean wspm_succeeded = false;
    private boolean wspm_commitSucceeded = false;
    private WSPrincipalImpl wspm_principal = null;
    private boolean wspm_useTrustedConnection = false;
    private IdentityPrincipal wspm_identityPrincipal = null;
    private PasswordCredential wspm_passwordCredential = null;
    private Map wspm_properties;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("getPasswordCredential");
    private static boolean isFineGrained = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        this.wspm_subject = subject;
        this.wspm_callbackHandler = callbackHandler;
        this.wspm_sharedState = sharedState;
        this.wspm_options = options;
        this.wspm_debug = "true".equalsIgnoreCase((String)this.wspm_options.get("debug"));
        this.wspm_useTrustedConnection = "true".equalsIgnoreCase((String)this.wspm_options.get("useTrustedConnection"));
        if (tc.isEntryEnabled()) {
            if (this.wspm_useTrustedConnection) {
                Tr.exit(tc, "initialize( TrustedConnectionMapping )");
            } else {
                Tr.exit(tc, "initialize( DefaultPrincipalMapping )");
            }
        }
    }

    public static Properties getAuthData(String alias) throws SecurityException {
        AuthData ad = WSDefaultPrincipalMapping.getAuthDataInt(alias);
        if (ad == null) {
            return null;
        }
        Properties oProps = new Properties();
        oProps.put("username", ad.uid);
        oProps.put("password", ad.psw);
        return oProps;
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if (this.wspm_commitSucceeded) {
            this.logout();
        }
        this.wspm_succeeded = false;
        boolean useCallerIdentity = false;
        boolean propagateSecAttrs = false;
        Callback[] callbacks = new Callback[]{new WSManagedConnectionFactoryCallback("Target ManagedConnectionFactory: "), new WSMappingPropertiesCallback("Mapping Properties (HashMap): ")};
        try {
            this.wspm_callbackHandler.handle(callbacks);
            String userID = null;
            String password = null;
            String alias = null;
            this.wspm_properties = ((WSMappingPropertiesCallback)callbacks[1]).getProperties();
            if (this.wspm_properties == null) {
                Tr.warning(tc, "security.j2c.missingParameter", new Object[]{"properties HashMap"});
            } else {
                alias = (String)this.wspm_properties.get("com.ibm.mapping.authDataAlias");
                if (alias == null) {
                    Tr.warning(tc, "security.j2c.missingParameter", new Object[]{"alias"});
                } else {
                    alias = alias.trim();
                }
            }
            if (alias != null) {
                Properties p;
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    if (!isFineGrained) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                            Tr.debug(tc, "Expecting : " + perm.toString());
                        }
                        sm.checkPermission(perm);
                    } else {
                        WebSphereRuntimePermission fgperm = new WebSphereRuntimePermission("getPasswordCredential." + alias);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing Java 2 Security Permission Check (Fine Grained) ...");
                            Tr.debug(tc, "Expecting : " + fgperm.toString());
                        }
                        sm.checkPermission(fgperm);
                    }
                }
                if ((p = WSPrincipalMappingLoginModule.getAuthData(alias)) != null) {
                    userID = p.getProperty("username");
                    String tmp1 = p.getProperty("password");
                    String tmp2 = PasswordUtil.passwordDecode(tmp1);
                    String string = password = tmp2 == null ? tmp1 : tmp2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, (tmp2 == null ? "Original" : "Decoded") + " version of the password is used");
                    }
                    ManagedConnectionFactory mcf = ((WSManagedConnectionFactoryCallback)callbacks[0]).getManagedConnectionFacotry();
                    this.wspm_passwordCredential = new PasswordCredential(userID, password.toCharArray());
                    this.wspm_passwordCredential.setManagedConnectionFactory(mcf);
                    WSCredential cred = ContextManagerFactory.getInstance().getInvocationCredential();
                    String principal_name = null;
                    if (cred != null && !cred.isUnauthenticated()) {
                        principal_name = cred.getSecurityName();
                    }
                    this.wspm_principal = new WSPrincipalImpl(principal_name);
                    if (this.wspm_useTrustedConnection) {
                        this.wspm_identityPrincipal = WSDefaultPrincipalMapping.getIdentityPrincipal(this.wspm_properties);
                        this.wspm_identityPrincipal.setManagedConnectionFactory(mcf);
                    }
                    this.wspm_succeeded = true;
                }
            }
        }
        catch (UnsupportedCallbackException unsupportedcallbackexception) {
            FFDCFilter.processException((Throwable)unsupportedcallbackexception, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "128", this);
            throw new LoginException("Error: " + unsupportedcallbackexception.getCallback().toString() + " not available to garner authentication " + "information from the user");
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "135", this);
            Tr.warning(tc, "security.j2c.unexpectedIOException", new Object[]{ioe});
            throw new LoginException("Error: " + ioe.toString());
        }
        catch (WSSecurityException wse) {
            FFDCFilter.processException((Throwable)wse, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "164", this);
            throw new LoginException("Error: " + wse.toString());
        }
        catch (ClassNotFoundException cnfe) {
            FFDCFilter.processException((Throwable)cnfe, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "273", this);
            throw new LoginException("Error: " + cnfe.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.wspm_succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (!this.wspm_succeeded) {
            return this.wspm_succeeded;
        }
        if (this.wspm_principal != null) {
            Set<Principal> set = this.wspm_subject.getPrincipals();
            if (!set.contains(this.wspm_principal)) {
                set.add(this.wspm_principal);
            }
            if (this.wspm_identityPrincipal != null && !set.contains(this.wspm_identityPrincipal)) {
                set.add(this.wspm_identityPrincipal);
            }
            if (!this.wspm_subject.getPrivateCredentials().contains(this.wspm_passwordCredential)) {
                this.wspm_subject.getPrivateCredentials().add(this.wspm_passwordCredential);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        this.wspm_commitSucceeded = true;
        return this.wspm_commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (!this.wspm_succeeded) {
            return false;
        }
        if (!this.wspm_commitSucceeded) {
            this.wspm_succeeded = false;
            this.wspm_principal = null;
            this.wspm_passwordCredential = null;
            this.wspm_identityPrincipal = null;
        } else {
            this.logout();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return this.wspm_succeeded;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        Set<Principal> set = this.wspm_subject.getPrincipals();
        set.remove(this.wspm_principal);
        this.wspm_subject.getPrivateCredentials().remove(this.wspm_passwordCredential);
        this.wspm_principal = null;
        this.wspm_passwordCredential = null;
        this.wspm_identityPrincipal = null;
        this.wspm_succeeded = false;
        this.wspm_commitSucceeded = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    static {
        Boolean fine_grained = Boolean.TRUE;
        try {
            fine_grained = SecurityObjectLocator.getSecurityConfig().getBoolean("enforceFineGrainedJCASecurity");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (fine_grained != null) {
            isFineGrained = fine_grained;
        }
        if (tc.isDebugEnabled()) {
            if (isFineGrained) {
                Tr.debug(tc, "Enforce Fine Grained Java 2 Security Permission Check");
            } else {
                Tr.debug(tc, "Enforce Java 2 Security Permission Check");
            }
        }
    }
}

