/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.security.auth.CacheEvictionListener;
import com.ibm.ws.security.auth.CacheException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class Cache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(Cache.class, "Security", "com.ibm.ejs.resources.security");
    private static Long defaultTimeout = null;
    private ConcurrentHashMap<Object, Object> primaryTable;
    private ConcurrentHashMap<Object, Object> secondaryTable;
    private ConcurrentHashMap<Object, Object> tertiaryTable;
    private int minSize = 0;
    private int entryLimit = 500;
    private CacheEvictionListener evictionCallback;
    private Alarm alarm;

    public Cache(int initialSize, int entryLimit, long timeout) {
        this(initialSize, timeout, entryLimit, null);
    }

    public Cache(int initialSize, long timeout, int entryLimit, CacheEvictionListener callback) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Integer(initialSize), new Long(timeout), new Integer(entryLimit), callback});
        }
        this.primaryTable = new ConcurrentHashMap(initialSize);
        this.secondaryTable = new ConcurrentHashMap(initialSize);
        this.tertiaryTable = new ConcurrentHashMap(initialSize);
        this.minSize = initialSize;
        this.entryLimit = entryLimit;
        this.alarm = new Alarm(timeout);
        this.alarm.addAlarmListener(this);
        this.evictionCallback = callback;
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void remove(Object key) throws CacheException {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", key);
        }
        Object value = this.evictionCallback != null ? this.get(key) : null;
        this.primaryTable.remove(key);
        this.secondaryTable.remove(key);
        this.tertiaryTable.remove(key);
        if (this.evictionCallback != null) {
            ArrayList<Object> victims = new ArrayList<Object>();
            victims.add(value);
            this.evictionCallback.evicted(victims);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(Object key) throws CacheException {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "get", key);
        }
        ConcurrentHashMap<Object, Object> tableRef = this.primaryTable;
        Entry curEntry = (Entry)this.primaryTable.get(key);
        if (curEntry == null) {
            tableRef = this.secondaryTable;
            curEntry = (Entry)this.secondaryTable.get(key);
            if (curEntry == null) {
                tableRef = this.tertiaryTable;
                curEntry = (Entry)this.tertiaryTable.get(key);
            }
            if (curEntry == null) {
                tableRef = null;
            }
        }
        if (tableRef != null && tableRef != this.primaryTable) {
            this.primaryTable.put(key, curEntry);
            tableRef.remove(key);
        }
        if (tableRef == null) {
            ConcurrentHashMap<Object, Object> concurrentHashMap = this.primaryTable;
            synchronized (concurrentHashMap) {
                curEntry = (Entry)this.primaryTable.get(key);
                if (curEntry == null) {
                    curEntry = new Entry();
                    this.primaryTable.put(key, curEntry);
                }
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "get", curEntry.value);
        }
        return curEntry.value;
    }

    public synchronized void insert(Object key, Object value) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{key, value});
        }
        while (this.isEvictionRequired() && this.entryLimit > 0 && this.entryLimit < Integer.MAX_VALUE) {
            this.evictStaleEntries();
        }
        Entry curEntry = new Entry(value);
        Entry oldEntry = (Entry)this.primaryTable.put(key, curEntry);
        if (oldEntry != null && oldEntry.value != null && this.evictionCallback != null) {
            ArrayList<Object> victims = new ArrayList<Object>();
            victims.add(oldEntry.value);
            this.evictionCallback.evicted(victims);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    protected boolean isEvictionRequired() {
        int size;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "isEvictionRequired");
        }
        boolean evictionRequired = false;
        if (this.entryLimit != 0 && this.entryLimit != Integer.MAX_VALUE && (size = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size()) > this.entryLimit) {
            Tr.warning(tc, "security.authn.cache.maxsize.reached", new Object[]{size, this.entryLimit});
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "The cache size is " + size + "( " + this.primaryTable.size() + ", " + this.secondaryTable.size() + ", " + this.tertiaryTable.size() + ") which is greater than the cache limit of " + this.entryLimit + ".");
            }
            evictionRequired = true;
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "isEvictionRequired", new Boolean(evictionRequired));
        }
        return evictionRequired;
    }

    protected void evictStaleEntries() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "evictStaleEntries");
        }
        ConcurrentHashMap<Object, Object> victims = this.tertiaryTable;
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new ConcurrentHashMap(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
        if (this.evictionCallback != null) {
            ArrayList<Object> evictedValues = new ArrayList<Object>();
            for (Entry entry : victims.values()) {
                evictedValues.add(entry.value);
            }
            this.evictionCallback.evicted(evictedValues);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "evictStaleEntries");
        }
    }

    public void alarm(Object alarmCtx) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", alarmCtx);
        }
        this.evictStaleEntries();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllEntries() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllEntries");
        }
        ConcurrentHashMap<Object, Object> concurrentHashMap = this.primaryTable;
        synchronized (concurrentHashMap) {
            if (this.evictionCallback != null) {
                this.tertiaryTable.putAll(this.primaryTable);
                this.tertiaryTable.putAll(this.secondaryTable);
            }
            this.primaryTable.clear();
            this.secondaryTable.clear();
            this.evictStaleEntries();
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllEntries");
        }
    }

    public static long getDefaultTimeout() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTimeout");
        }
        long timeout = 0L;
        if (defaultTimeout != null) {
            timeout = defaultTimeout;
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTimeout", new Long(timeout));
        }
        return timeout;
    }

    public static void setDefaultTimeout(long timeout) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultTimeout", new Long(timeout));
        }
        if (defaultTimeout == null) {
            defaultTimeout = new Long(timeout);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultTimeout");
        }
    }

    private static class Alarm
    implements AlarmListener {
        private Vector<AlarmListener> alarms = new Vector();
        private long timeout;

        void addAlarmListener(AlarmListener al) {
            this.alarms.addElement(al);
        }

        Alarm(long to) {
            this.timeout = to / 2L;
            this.alarm(null);
        }

        public void alarm(Object alarmCtx) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                this.alarms.elementAt(i).alarm(alarmCtx);
            }
            AlarmManager.createDeferrable(this.timeout, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }

    public static class Entry {
        public Object value;
        public int timesAccessed;

        public Entry() {
        }

        public Entry(Object value) {
            this.value = value;
        }
    }
}

