/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.CacheObject;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

public class AuthCache
extends Cache
implements SecurityCache {
    private static final TraceComponent tc = Tr.register(AuthCache.class, "Security", "com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static long defaultTimeout = 0L;
    private long cushion = -1L;
    private static ConcurrentHashMap instanceCache = new ConcurrentHashMap();
    private static SecurityConfigManager scm = null;
    private String _domainId = null;
    protected static boolean authCacheEnabled = true;
    protected static boolean allowLookupByBasicAuth = true;
    protected static boolean customCacheKeySupport = true;
    public static final String AUTH_CACHE_ENABLED = "com.ibm.websphere.security.util.authCacheEnabled";
    public static final String AUTH_CACHE_SIZE = "com.ibm.websphere.security.util.authCacheSize";
    public static final String AUTH_CACHE_MAX_SIZE = "com.ibm.websphere.security.util.authCacheMaxSize";
    public static final String AUTH_CACHE_SUPPORT_CUSTOM_KEY = "com.ibm.websphere.security.util.authCacheCustomKeySupport";

    public static synchronized AuthCache getInstance() {
        AuthCache inst;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        String domainId = null;
        if (scm == null) {
            scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (scm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance SecurityConfigManager instance " + scm);
            }
            domainId = scm.getDomainId();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance no SecurityConfigManager instance, using admin config");
            }
            domainId = "admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance using domainId " + domainId);
        }
        if ((inst = (AuthCache)instanceCache.get(domainId)) == null) {
            String authCacheMaxSize;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance did not find AuthCache in cache");
            }
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            int cacheTimeout = security2.getInteger("cacheTimeout");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "security cache timeout is " + cacheTimeout);
            }
            Cache.setDefaultTimeout((long)cacheTimeout * 1000L);
            String authCacheSize = security2.getProperty(AUTH_CACHE_SIZE);
            if (authCacheSize == null || authCacheSize.equals("") || new Integer(authCacheSize) < 0) {
                authCacheSize = "50";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authCacheSize = " + authCacheSize);
            }
            if ((authCacheMaxSize = security2.getProperty(AUTH_CACHE_MAX_SIZE)) == null || authCacheMaxSize.equals("") || new Integer(authCacheMaxSize) < 0) {
                authCacheMaxSize = "25000";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authCacheMaxSize = " + authCacheMaxSize);
            }
            if ((inst = new AuthCache(new Integer(authCacheSize), new Integer(authCacheMaxSize), cacheTimeout * 1000)) != null) {
                inst.setDomainId(domainId);
                instanceCache.put(domainId, inst);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance found AuthCache in instanceCache " + inst);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance " + inst);
        }
        return inst;
    }

    public static void releaseInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance");
        }
        String domainId = null;
        if (scm == null) {
            scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (scm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseInstance SecurityConfigManager instance " + scm);
            }
            domainId = scm.getDomainId();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseInstance no SecurityConfigManager instance, using admin config");
            }
            domainId = "admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseInstance using domainId " + domainId);
        }
        instanceCache.remove(domainId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    private AuthCache(int size, int maxSize, long timeout) {
        super(size, maxSize, timeout);
        String cckSupport;
        SecurityConfig security2;
        String authCacheEnabledProperty;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Integer(size), new Long(timeout)});
        }
        if ((authCacheEnabledProperty = (security2 = SecurityObjectLocator.getSecurityConfig()).getProperty(AUTH_CACHE_ENABLED)) == null) {
            authCacheEnabled = true;
        } else if (authCacheEnabledProperty.equalsIgnoreCase("false") || authCacheEnabledProperty.equalsIgnoreCase("no")) {
            authCacheEnabled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication cache is disabled.");
            }
        } else {
            authCacheEnabled = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authCacheEnabled = " + authCacheEnabled);
        }
        allowLookupByBasicAuth = authCacheEnabledProperty == null || !authCacheEnabledProperty.equalsIgnoreCase("BasicAuthDisabled");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allowLookupByBasicAuth = " + allowLookupByBasicAuth);
        }
        if ((cckSupport = security2.getProperty(AUTH_CACHE_SUPPORT_CUSTOM_KEY)) != null && (cckSupport.equalsIgnoreCase("false") || cckSupport.equalsIgnoreCase("no"))) {
            customCacheKeySupport = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Custom Cache Key support is disabled.");
            }
        } else {
            customCacheKeySupport = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "customCacheKeySupport = " + customCacheKeySupport);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthCache", this);
        }
    }

    public void removeEntry(String realm, String user) throws CacheException {
        String realmuser;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", new Object[]{realm, user});
        }
        if (realm == null) {
            realm = ContextManagerFactory.getInstance().getDefaultRealm();
        }
        if (user != null && (object = this.get(realmuser = realm + ":" + user)) != null && object instanceof CacheObject) {
            this.removeEntry((CacheObject)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry");
        }
    }

    public void removeEntry(Object loginInfo) throws CacheException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", new Object[]{loginInfo});
        }
        if (loginInfo != null && (object = this.get(loginInfo)) != null && object instanceof CacheObject) {
            this.removeEntry((CacheObject)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry");
        }
    }

    public void removeEntry(CacheObject object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", object);
        }
        if (object != null) {
            try {
                Object[] array = object.getKeyArray();
                for (int i = 0; i < array.length; ++i) {
                    this.remove(array[i]);
                    if (!(array[i] instanceof ByteArray)) continue;
                    WSCredentialTokenMapper.getInstance().invalidateDistributedObject((ByteArray)array[i]);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.removeEntry", "345", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception removing credential from cache", e);
                }
                throw new CacheException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry");
        }
    }

    public void removeAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllEntries");
        }
        this.clearAllEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllEntries");
        }
    }

    public Subject getSubject(byte[] credentialToken) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", credentialToken);
        }
        Subject subject = null;
        if (authCacheEnabled) {
            ByteArray credArray = new ByteArray(credentialToken);
            subject = this.getSubject(credArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(Object cacheKey) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", cacheKey);
        }
        Subject subject = null;
        if (authCacheEnabled) {
            if (cacheKey != null && cacheKey instanceof String && ((String)cacheKey).equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cache Key value is null string. Ignore it.");
                }
            } else {
                Object object = null;
                try {
                    object = this.get(cacheKey);
                    if (object != null && object instanceof CacheObject) {
                        subject = ((CacheObject)object).getSubject();
                        Map tokenMap = ((CacheObject)object).getPropTokenMap();
                        if (tokenMap != null) {
                            this.setPropTokenMapOnThread(tokenMap);
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.getSubject", "430", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception trying to get object from cache", e);
                    }
                    throw new CacheException(e.getMessage(), e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(String realm, String id, String password) throws CacheException {
        String realmuser;
        Object cache_obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", new Object[]{realm, id, "xxxxx"});
        }
        if (id == null || password == null || !authCacheEnabled || !allowLookupByBasicAuth) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject", null);
            }
            return null;
        }
        if (realm == null) {
            realm = ContextManagerFactory.getInstance().getDefaultRealm();
        }
        Subject subject = null;
        try {
            byte[] onewayhash_password = null;
            try {
                onewayhash_password = ServerCredSigner.getInstance().getOneWayHash(password);
                if (tc.isDebugEnabled() && onewayhash_password != null) {
                    Tr.debug(tc, "One-way password hash using SHA is: " + new BigInteger(onewayhash_password));
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.getSubject", "475", this);
                Tr.error(tc, "security.sas.encode.error", new Object[]{e});
            }
            onewayhash_password = onewayhash_password != null ? onewayhash_password : password.getBytes();
            BasicAuthCacheData basicAuthData = new BasicAuthCacheData();
            basicAuthData.realm = realm;
            basicAuthData.userId = id;
            basicAuthData.password = onewayhash_password;
            Object object = this.get(basicAuthData);
            if (object != null && object instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)object;
                subject = cacheObject.getSubject();
                Map tokenMap = cacheObject.getPropTokenMap();
                if (tokenMap != null) {
                    this.setPropTokenMapOnThread(tokenMap);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.getSubject", "505", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication failed", e);
            }
            throw new CacheException(e.getMessage(), e);
        }
        if (subject == null && (cache_obj = this.get(realmuser = realm + ":" + id)) != null && cache_obj instanceof CacheObject) {
            this.removeEntry(cache_obj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleared entries from AuthCache for user: " + id);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(String realm, String id) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", new Object[]{realm, id});
        }
        if (!authCacheEnabled || id == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject", null);
            }
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            sm.checkPermission(MAP_CREDENTIAL);
        }
        Subject subject = null;
        if (realm == null) {
            realm = ContextManagerFactory.getInstance().getDefaultRealm();
        }
        try {
            String existingrealmuser = realm + ":" + id;
            Object object = this.get(existingrealmuser);
            if (object != null && object instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)object;
                if (customCacheKeySupport && cacheObject.getRevocationKey()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found following revocation object, replaced by null.", cacheObject.getSubject());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSubject", null);
                    }
                    return null;
                }
                subject = cacheObject.getSubject();
                Map tokenMap = cacheObject.getPropTokenMap();
                if (tokenMap != null) {
                    this.setPropTokenMapOnThread(tokenMap);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.getSubject", "589", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication failed", e);
            }
            throw new CacheException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public void updateEntry(Subject subject, byte[] token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateEntry", new Object[]{subject, token});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntry");
        }
    }

    public void updateEntry(Object cacheKey, Map tokenMap) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateEntry", new Object[]{cacheKey, tokenMap});
            }
            if (!authCacheEnabled || cacheKey == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateEntry (no updates)");
                }
                return;
            }
            try {
                Object object = this.get(cacheKey);
                if (object != null && object instanceof CacheObject) {
                    CacheObject cacheObject = (CacheObject)object;
                    if (tokenMap != null) {
                        Map clonedMap = null;
                        clonedMap = this.clonePropTokenMap(tokenMap);
                        if (clonedMap != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cache entry updated with prop token map.");
                            }
                            cacheObject.setPropTokenMap(clonedMap);
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.updateEntry", "650", this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Updating the propagation tokens into the AuthCache failed.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntry");
        }
    }

    public void insert(Subject subject) {
        this.insert(subject, null, null);
    }

    public void insert(Subject subject, Object[] additional_lookup_keys) {
        this.insert(subject, null, additional_lookup_keys);
    }

    public void insert(Subject subject, String password) {
        this.insert(subject, password, null);
    }

    public void insert(Subject subject, String password, Object[] additional_lookup_keys) {
        this.insert(subject, null, password, additional_lookup_keys);
    }

    public void insert(Subject subject, String loginId, String password, Object[] additional_lookup_keys) {
        block38: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "insert", new Object[]{subject, loginId, password == null ? password : "xxxxx", additional_lookup_keys});
            }
            if (!authCacheEnabled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "insert - No insert happened. AuthCache is disabled");
                }
                return;
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "insert");
                }
                return;
            }
            WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
            CacheObject cache_object = new CacheObject();
            cache_object.setSubject(subject);
            try {
                boolean customKeyFlag = false;
                if (credential != null) {
                    Map tokenMap;
                    String realmlonguser;
                    String login_uid;
                    String cacheKeyString;
                    String realmuser;
                    ByteArray zCacheData;
                    byte[] csiv2SessionData;
                    Object cacheKey;
                    KRBAuthnToken krbAuthToken;
                    SingleSignonToken ssoToken;
                    ContextManager ctxMgr = ContextManagerFactory.getInstance();
                    byte[] byteToken = credential.getCredentialToken();
                    ByteArray array = new ByteArray(byteToken);
                    if (array != null) {
                        cache_object.setKey(array);
                        this.insert(array, cache_object);
                    }
                    if ((ssoToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject)) != null) {
                        ByteArray ssoByteArray = new ByteArray(ssoToken.getBytes());
                        cache_object.setKey(ssoByteArray);
                        this.insert(ssoByteArray, cache_object);
                    }
                    if ((krbAuthToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject)) != null) {
                        String uniqueID = ((AuthenticationToken)((Object)krbAuthToken)).getUniqueID();
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "KRBAuthnToken uniqued ID: " + uniqueID);
                        }
                        cache_object.setKey(uniqueID);
                        this.insert(uniqueID, cache_object);
                    }
                    if ((cacheKey = WSCredentialTokenMapper.getInstance().getCacheKeyFromHashtable(subject)) != null && customCacheKeySupport) {
                        customKeyFlag = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found Custom Cache Key");
                        }
                        cache_object.setKey(cacheKey);
                        this.insert(cacheKey, cache_object);
                    }
                    if ((csiv2SessionData = (byte[])ctxMgr.get("CacheKeyAttribute")) != null) {
                        ByteArray csiv2SessionKey = new ByteArray(csiv2SessionData);
                        cache_object.setKey(csiv2SessionKey);
                        this.insert(csiv2SessionKey, cache_object);
                    }
                    if ((zCacheData = (ByteArray)ctxMgr.get("ZOSCacheKey")) != null) {
                        cache_object.setKey(zCacheData);
                        this.insert(zCacheData, cache_object);
                    }
                    if ((realmuser = credential.getRealmName() + ":" + credential.getSecurityName()) != null) {
                        cache_object.setKey(realmuser);
                        if (customKeyFlag) {
                            cache_object.setRevocationKey(true);
                        }
                        this.insert(realmuser, cache_object);
                    }
                    if (loginId != null && !loginId.equals(credential.getSecurityName())) {
                        realmuser = credential.getRealmName() + ":" + loginId;
                        cache_object.setKey(realmuser);
                        if (customKeyFlag) {
                            cache_object.setRevocationKey(true);
                        }
                        this.insert(realmuser, cache_object);
                    }
                    if ((cacheKeyString = WSCredentialTokenMapper.getInstance().createSubjectUniqueID(subject)) != null) {
                        cache_object.setKey(cacheKeyString);
                        this.insert(cacheKeyString, cache_object);
                    }
                    if ((login_uid = (String)credential.get("security.login_uid")) != null) {
                        login_uid = credential.getRealmName() + ":" + login_uid;
                        cache_object.setKey(login_uid);
                        if (customKeyFlag) {
                            cache_object.setRevocationKey(true);
                        }
                        this.insert(login_uid, cache_object);
                    }
                    if ((realmlonguser = credential.getRealmName() + ":" + credential.getUniqueSecurityName()) != null) {
                        cache_object.setKey(realmlonguser);
                        if (customKeyFlag) {
                            cache_object.setRevocationKey(true);
                        }
                        this.insert(realmlonguser, cache_object);
                    }
                    if (additional_lookup_keys != null && additional_lookup_keys.length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Additional lookup keys size: " + additional_lookup_keys.length);
                        }
                        for (int i = 0; i < additional_lookup_keys.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Additional lookup value: " + additional_lookup_keys[i]);
                            }
                            if (additional_lookup_keys[i] == null) continue;
                            if (additional_lookup_keys[i] instanceof byte[]) {
                                ByteArray newLookup = new ByteArray((byte[])additional_lookup_keys[i]);
                                cache_object.setKey(newLookup);
                                this.insert(newLookup, cache_object);
                                continue;
                            }
                            cache_object.setKey(additional_lookup_keys[i]);
                            this.insert(additional_lookup_keys[i], cache_object);
                        }
                    }
                    if ((tokenMap = ctxMgr.getPropagationTokens()) != null) {
                        Map clonedMap = null;
                        clonedMap = this.clonePropTokenMap(tokenMap);
                        if (clonedMap != null) {
                            cache_object.setPropTokenMap(clonedMap);
                        }
                    }
                }
                if (password == null || customKeyFlag) break block38;
                BasicAuthCacheData basicAuthData = new BasicAuthCacheData();
                basicAuthData.realm = credential.getRealmName();
                if (basicAuthData.realm == null) {
                    basicAuthData.realm = ContextManagerFactory.getInstance().getDefaultRealm();
                }
                basicAuthData.userId = credential.getSecurityName();
                byte[] onewayhash_password = null;
                try {
                    onewayhash_password = ServerCredSigner.getInstance().getOneWayHash(password);
                    if (tc.isDebugEnabled() && onewayhash_password != null) {
                        Tr.debug(tc, "One-way password hash using SHA is: " + new BigInteger(onewayhash_password));
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.insert", "910", this);
                    Tr.error(tc, "security.sas.encode.error", new Object[]{e});
                }
                basicAuthData.password = onewayhash_password != null ? onewayhash_password : password.getBytes();
                cache_object.setKey(basicAuthData);
                this.insert(basicAuthData, cache_object);
                if (loginId != null && !loginId.equals(basicAuthData.userId)) {
                    basicAuthData.userId = loginId;
                    cache_object.setKey(basicAuthData);
                    this.insert(basicAuthData, cache_object);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.util.AuthCache.insert", "930", this);
                if (!tc.isDebugEnabled()) break block38;
                Tr.debug(tc, "Exception inserting Subject into cache: ", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    public long getCushion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCushion");
        }
        if (this.cushion == -1L) {
            long potentialCushion;
            AuthMechanismConfig ltpa;
            long cacheTimeout = Cache.getDefaultTimeout();
            long tokenTimeout = 0L;
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            long minCushion = Long.valueOf(security2.getProperty("com.ibm.ws.security.cacheCushionMin")) * 60L * 1000L - 5000L;
            long maxCushion = Long.valueOf(security2.getProperty("com.ibm.ws.security.cacheCushionMax")) * 60L * 1000L;
            if (maxCushion <= 0L) {
                maxCushion = 600000L;
            }
            if (security2.getActiveAuthMechanism().getBoolean("isCredentialForwardable") && (ltpa = security2.getAuthMechanism("LTPA")) != null) {
                tokenTimeout = ltpa.getLong("timeout") * 60L * 1000L;
            }
            this.cushion = tokenTimeout > 0L ? ((potentialCushion = tokenTimeout / 5L) < minCushion ? minCushion : (potentialCushion > maxCushion ? maxCushion : potentialCushion)) : 0L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCushion", new Long(this.cushion));
        }
        return this.cushion;
    }

    private void setPropTokenMapOnThread(Map tokenMap) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setPropTokenMapOnThread", tokenMap);
            }
            if (tokenMap != null && tokenMap.size() > 0) {
                try {
                    for (String key : tokenMap.keySet()) {
                        PropagationToken propToken = (PropagationToken)tokenMap.get(key);
                        if (propToken == null) continue;
                        ContextManager ctxMgr = ContextManagerFactory.getInstance();
                        if (key.equals("com.ibm.ws.security.token.PropagationTokenImpl:1")) {
                            PropagationToken token = ctxMgr.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                            if (token == null) {
                                ctxMgr.setPropagationToken(key, (PropagationToken)propToken.clone());
                                continue;
                            }
                            Enumeration attributeNames = propToken.getAttributeNames();
                            while (attributeNames.hasMoreElements()) {
                                String[] tokenAttributes;
                                String[] currentAttributes;
                                String attributeKey = (String)attributeNames.nextElement();
                                if (attributeKey == null || attributeKey.equals("com.ibm.wsspi.security.propagation.callers") || attributeKey.equals("com.ibm.wsspi.security.propagation.hosts") || (currentAttributes = WSSecurityHelper.getPropagationAttributes(attributeKey)) != null || (tokenAttributes = propToken.getAttributes(attributeKey)) == null || tokenAttributes.length <= 0) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding attributes for " + attributeKey + " to existing prop token");
                                }
                                for (int i = 0; i < tokenAttributes.length; ++i) {
                                    WSSecurityHelper.addPropagationAttribute(attributeKey, tokenAttributes[i]);
                                }
                            }
                            continue;
                        }
                        ctxMgr.setPropagationToken(key, (PropagationToken)propToken.clone());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.AuthCache.setPropTokenMapOnThread", "1061", this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Exception setting propagation tokens on thread", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropTokenMapOnThread");
        }
    }

    private Map clonePropTokenMap(Map tokenMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clonePropTokenMap", tokenMap);
        }
        HashMap<String, Object> clonedMap = null;
        if (tokenMap != null && tokenMap.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cloning propagation tokens.");
            }
            clonedMap = new HashMap<String, Object>();
            try {
                for (String key : tokenMap.keySet()) {
                    PropagationToken propToken = (PropagationToken)tokenMap.get(key);
                    if (propToken == null) continue;
                    clonedMap.put(key, propToken.clone());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.AuthCache.clonePropTokenMap", "1100", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception cloning propagation tokens.", new Object[]{e});
                }
                clonedMap = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clonePropTokenMap", clonedMap);
        }
        return clonedMap;
    }

    public String getDomainId() {
        return this._domainId;
    }

    public void setDomainId(String id) {
        this._domainId = id;
    }

    public String toString() {
        return "AuthCache: " + this.hashCode() + " domainId: " + this.getDomainId();
    }

    class BasicAuthCacheData {
        public String realm;
        public String userId;
        public byte[] password;

        BasicAuthCacheData() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof BasicAuthCacheData)) {
                return false;
            }
            if (this.realm != null ? !this.realm.equals(((BasicAuthCacheData)o).realm) : ((BasicAuthCacheData)o).realm != null) {
                return false;
            }
            if (this.userId != null ? !this.userId.equals(((BasicAuthCacheData)o).userId) : ((BasicAuthCacheData)o).userId != null) {
                return false;
            }
            return Arrays.equals(this.password, ((BasicAuthCacheData)o).password);
        }

        public int hashCode() {
            return (this.realm + ":" + this.userId).hashCode();
        }

        public String toString() {
            return this.realm + ":" + this.userId;
        }
    }
}

