/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureLDAPUserRegistry
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureLDAPUserRegistry.class, "ConfigureLDAPUserRegistry", "com.ibm.ws.security.admintasks.securityDomain");
    Boolean globalSecEnabled = new Boolean(false);
    private String secDomain = null;
    private String realm = null;
    private String serverid = null;
    private String serveridPassword = null;
    private String primaryAdminId = null;
    private Boolean autoGenServerId = null;
    private String ldapServerType = null;
    private String baseDN = null;
    private String bindDN = null;
    private String bindPassword = null;
    private Long searchTimeout = null;
    private Boolean ignoreCase = null;
    private String customProps = null;
    private String userFilter = null;
    private String groupFilter = null;
    private String userIdMap = null;
    private String groupIdMap = null;
    private String groupMemberIdMap = null;
    private String certificateMapMode = null;
    private String certificateFilter = null;
    private String sslConfig = null;
    private Boolean sslEnabled = null;
    private Boolean verifyRegistry = null;
    private Boolean reuseConnection = null;
    private String ldapHost = null;
    private String ldapPort = null;
    private Boolean nestedGroupSearch = null;
    private String krbUserFilter = null;
    private Boolean useRegistryRealm = Boolean.FALSE;
    private boolean kerberosIsEnabled = false;
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";

    public ConfigureLDAPUserRegistry(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureLDAPUserRegistry(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (!tc.isDebugEnabled()) return;
            Tr.exit(tc, "afterStepsExecuted");
            return;
        }
        ObjectName secObj = null;
        ObjectName globalSecObj = null;
        boolean useRegServerId = true;
        AttributeList attrList = new AttributeList();
        AttributeList filterAttrs = new AttributeList();
        AttributeList hostAttrs = new AttributeList();
        AttributeList searchFilterAttrList = null;
        String commandName = this.getName();
        Properties props = new Properties();
        try {
            String msg;
            ObjectName regObj;
            Session session;
            ConfigService configService;
            block106: {
                block108: {
                    boolean configTypeChanged;
                    block107: {
                        AttributeList configHostAttrs;
                        AttributeList attrs;
                        String authType;
                        ObjectName authMech;
                        configService = this.getConfigService();
                        session = this.getConfigSession();
                        if (commandName.equalsIgnoreCase("configureAdminLDAPUserRegistry")) {
                            this.serverid = (String)this.getParameter("serverId");
                            this.serveridPassword = (String)this.getParameter("serverIdPassword");
                            this.primaryAdminId = (String)this.getParameter("primaryAdminId");
                            this.autoGenServerId = (Boolean)this.getParameter("autoGenerateServerId");
                        } else {
                            this.secDomain = (String)this.getParameter("securityDomainName");
                            this.realm = (String)this.getParameter("realmName");
                        }
                        this.ldapServerType = (String)this.getParameter("ldapServerType");
                        this.baseDN = (String)this.getParameter("baseDN");
                        this.bindDN = (String)this.getParameter("bindDN");
                        this.bindPassword = (String)this.getParameter("bindPassword");
                        this.searchTimeout = (Long)this.getParameter("searchTimeout");
                        this.reuseConnection = (Boolean)this.getParameter("reuseConnection");
                        this.ldapHost = (String)this.getParameter("ldapHost");
                        this.ldapPort = (String)this.getParameter("ldapPort");
                        this.userFilter = (String)this.getParameter("userFilter");
                        this.groupFilter = (String)this.getParameter("groupFilter");
                        this.userIdMap = (String)this.getParameter("userIdMap");
                        this.groupIdMap = (String)this.getParameter("groupIdMap");
                        this.groupMemberIdMap = (String)this.getParameter("groupMemberIdMap");
                        this.certificateMapMode = (String)this.getParameter("certificateMapMode");
                        this.certificateFilter = (String)this.getParameter("certificateFilter");
                        this.ignoreCase = (Boolean)this.getParameter("ignoreCase");
                        this.customProps = (String)this.getParameter("customProperties");
                        this.verifyRegistry = (Boolean)this.getParameter("verifyRegistry");
                        this.sslEnabled = (Boolean)this.getParameter("sslEnabled");
                        this.sslConfig = (String)this.getParameter("sslConfig");
                        this.nestedGroupSearch = (Boolean)this.getParameter("nestedGroupSearch");
                        this.krbUserFilter = (String)this.getParameter("krbUserFilter");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "securityDomainName name is " + this.secDomain);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "serverId name is " + this.serverid);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "primaryAdminId name is " + this.primaryAdminId);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "autoGenerateServerId name is " + this.autoGenServerId);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "realmName name is " + this.realm);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ldapServerType name is " + this.ldapServerType);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "baseDN name is " + this.baseDN);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "bindDN nameis " + this.bindDN);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "searchTimeout name is " + this.searchTimeout);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "reuseConnection name is " + this.reuseConnection);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ldapHost name is " + this.ldapHost);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ldapPort name is " + this.ldapPort);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "userFilter name is " + this.userFilter);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "groupIdMap name is " + this.groupIdMap);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "userIdMap name is " + this.userIdMap);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "groupMemberIdMap name is " + this.groupMemberIdMap);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "certificateMapMode name is " + this.certificateMapMode);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "certificateFilter name is " + this.certificateFilter);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ignoreCase name is " + this.ignoreCase);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "customProperties name is " + this.customProps);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "verifyRegistry name is " + this.verifyRegistry);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sslEnabled is " + this.sslEnabled);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sslConfig is " + this.sslConfig);
                        }
                        if (this.ldapServerType != null && !this.validLdapServerType(this.ldapServerType)) {
                            String msg2 = this.getMsg(resBundle, "security.admintask.InvalidLDAPServerType", null);
                            throw new CommandValidationException(msg2);
                        }
                        if (this.certificateMapMode != null && this.certificateMapMode.length() > 0 && !this.validMode(this.certificateMapMode)) {
                            String msg3 = this.getMsg(resBundle, "security.admintask.modeNotValid.SECJ7734E", null);
                            throw new CommandValidationException(msg3);
                        }
                        if (this.userFilter != null && this.userFilter.length() == 0) {
                            this.userFilter = null;
                        }
                        if (this.groupFilter != null && this.groupFilter.length() == 0) {
                            this.groupFilter = null;
                        }
                        if (this.userIdMap != null && this.userIdMap.length() == 0) {
                            this.userIdMap = null;
                        }
                        if (this.groupIdMap != null && this.groupIdMap.length() == 0) {
                            this.groupIdMap = null;
                        }
                        if (this.groupMemberIdMap != null && this.groupMemberIdMap.length() == 0) {
                            this.groupMemberIdMap = null;
                        }
                        configTypeChanged = false;
                        globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
                        if (this.secDomain != null) {
                            if (this.secDomain.equals("PassThroughToGlobalSecurity")) {
                                String msg4 = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, this.secDomain});
                                throw new CommandValidationException(msg4);
                            }
                            secObj = SecConfigTaskHelper.getSecDomain(session, configService, this.secDomain);
                        } else {
                            secObj = globalSecObj;
                        }
                        if (secObj == null) {
                            String msg5 = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                            throw new CommandValidationException(msg5);
                        }
                        if (commandName.equalsIgnoreCase("configureAdminLDAPUserRegistry") && (authMech = (ObjectName)configService.getAttribute(session, secObj, "activeAuthMechanism")) != null && (authType = (String)ConfigServiceHelper.getAttributeValue(attrs = configService.getAttributes(session, authMech, null, false), "_Websphere_Config_Data_Type")).equals("KRB5")) {
                            this.kerberosIsEnabled = true;
                        }
                        if (this.sslConfig != null && this.sslConfig.length() > 0 && !SecConfigTaskHelper.validSSLConfig(session, configService, globalSecObj, this.sslConfig)) {
                            String msg6 = this.getMsg(resBundle, "security.admintask.sslConfigNotValid.SECJ7711E", null);
                            throw new CommandValidationException(msg6);
                        }
                        regObj = SecConfigTaskHelper.getRegObj(session, configService, secObj, "LDAPUserRegistry");
                        if (regObj == null) break block107;
                        if (commandName.equalsIgnoreCase("configureAdminLDAPUserRegistry")) {
                            attrList.add(new Attribute("serverId", (String)configService.getAttribute(session, regObj, "serverId")));
                            attrList.add(new Attribute("serverPassword", (String)configService.getAttribute(session, regObj, "serverPassword")));
                            attrList.add(new Attribute("primaryAdminId", (String)configService.getAttribute(session, regObj, "primaryAdminId")));
                            attrList.add(new Attribute("useRegistryServerId", (Boolean)configService.getAttribute(session, regObj, "useRegistryServerId")));
                        }
                        String typeFromConfig = (String)configService.getAttribute(session, regObj, "type");
                        if (this.ldapServerType == null || this.ldapServerType != null && this.ldapServerType.length() == 0) {
                            this.ldapServerType = typeFromConfig != null ? typeFromConfig : "IBM_DIRECTORY_SERVER";
                        } else if (typeFromConfig != null && !typeFromConfig.equals(this.ldapServerType)) {
                            configTypeChanged = true;
                        }
                        attrList.add(new Attribute("type", this.ldapServerType));
                        if (this.baseDN == null) {
                            this.baseDN = (String)configService.getAttribute(session, regObj, "baseDN");
                            attrList.add(new Attribute("baseDN", this.baseDN));
                        }
                        if (this.bindDN == null) {
                            this.bindDN = (String)configService.getAttribute(session, regObj, "bindDN");
                            attrList.add(new Attribute("bindDN", this.bindDN));
                        }
                        if (this.bindPassword == null) {
                            this.bindPassword = (String)configService.getAttribute(session, regObj, "bindPassword");
                            attrList.add(new Attribute("bindPassword", this.bindPassword));
                        }
                        if (this.searchTimeout == null) {
                            this.searchTimeout = (Long)configService.getAttribute(session, regObj, "searchTimeout");
                            attrList.add(new Attribute("searchTimeout", this.searchTimeout));
                        }
                        if (this.reuseConnection == null) {
                            this.reuseConnection = (Boolean)configService.getAttribute(session, regObj, "reuseConnection");
                            attrList.add(new Attribute("reuseConnection", this.reuseConnection));
                        }
                        if (this.ignoreCase == null) {
                            this.ignoreCase = (Boolean)configService.getAttribute(session, regObj, "ignoreCase");
                            attrList.add(new Attribute("ignoreCase", this.ignoreCase));
                        }
                        if (this.sslEnabled == null) {
                            this.sslEnabled = (Boolean)configService.getAttribute(session, regObj, "sslEnabled");
                            attrList.add(new Attribute("sslEnabled", this.sslEnabled));
                        }
                        if (this.sslConfig == null) {
                            this.sslConfig = (String)configService.getAttribute(session, regObj, "sslConfig");
                            attrList.add(new Attribute("sslConfig", this.sslConfig));
                        } else if (this.sslConfig != null && this.sslConfig.length() == 0) {
                            attrList.add(new Attribute("sslConfig", this.sslConfig));
                        }
                        if (this.realm == null) {
                            this.useRegistryRealm = (Boolean)configService.getAttribute(session, regObj, "useRegistryRealm");
                            if (!this.useRegistryRealm.booleanValue()) {
                                this.realm = (String)configService.getAttribute(session, regObj, "realm");
                                attrList.add(new Attribute("realm", this.realm));
                            }
                        }
                        filterAttrs = (AttributeList)configService.getAttribute(session, regObj, "searchFilter");
                        searchFilterAttrList = this.getSearchFilterAttrsList(session, configService, filterAttrs, configTypeChanged, this.ldapServerType);
                        props = SecConfigTaskHelper.getCustomPropertiesFromConfig(session, configService, regObj, props);
                        ArrayList hosts = (ArrayList)configService.getAttribute(session, regObj, "hosts");
                        if (hosts.size() > 0 && (configHostAttrs = (AttributeList)hosts.get(0)) != null) {
                            if (this.ldapHost == null || this.ldapHost != null && this.ldapHost.length() == 0) {
                                this.ldapHost = (String)ConfigServiceHelper.getAttributeValue(configHostAttrs, "host");
                                hostAttrs.add(new Attribute("host", this.ldapHost));
                            }
                            if (this.ldapPort == null || this.ldapPort != null && this.ldapHost.length() == 0) {
                                this.ldapPort = ((Integer)ConfigServiceHelper.getAttributeValue(configHostAttrs, "port")).toString();
                                hostAttrs.add(new Attribute("port", this.ldapPort));
                            }
                        }
                        break block108;
                    }
                    if (this.ldapServerType == null) {
                        this.ldapServerType = "IBM_DIRECTORY_SERVER";
                    }
                    searchFilterAttrList = this.getSearchFilterAttrsList(session, configService, null, configTypeChanged, this.ldapServerType);
                }
                if (this.serverid != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "serverId", this.serverid);
                }
                if (this.serveridPassword != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "serverPassword", this.serveridPassword);
                }
                if (this.primaryAdminId != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "primaryAdminId", this.primaryAdminId);
                }
                if (this.ignoreCase == null) {
                    this.ignoreCase = Boolean.TRUE;
                }
                ConfigServiceHelper.setAttributeValue(attrList, "ignoreCase", this.ignoreCase);
                props.setProperty("security.registry.IgnoreCase", this.ignoreCase.toString());
                if (this.realm != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "realm", this.realm);
                }
                if (this.ldapServerType == null) {
                    this.ldapServerType = "IBM_DIRECTORY_SERVER";
                }
                ConfigServiceHelper.setAttributeValue(attrList, "type", this.ldapServerType);
                props.setProperty("dirType", this.ldapServerType);
                if (this.baseDN != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "baseDN", this.baseDN);
                    props.setProperty("ldap.basedn", this.baseDN);
                }
                if (this.bindDN != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "bindDN", this.bindDN);
                    props.setProperty("java.naming.security.principal", this.bindDN);
                }
                if (this.bindPassword != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "bindPassword", this.bindPassword);
                    props.setProperty("java.naming.security.credentials", this.bindPassword);
                }
                if (this.reuseConnection == null) {
                    this.reuseConnection = Boolean.TRUE;
                }
                ConfigServiceHelper.setAttributeValue(attrList, "reuseConnection", this.reuseConnection);
                props.setProperty("security.registry.ldap.reuseConn", this.reuseConnection.toString());
                if (this.searchTimeout == null) {
                    this.searchTimeout = new Long(120L);
                }
                ConfigServiceHelper.setAttributeValue(attrList, "searchTimeout", this.searchTimeout);
                props.setProperty("security.registry.ldap.searchTimeLimit", this.searchTimeout.toString());
                if (this.sslEnabled == null) {
                    this.sslEnabled = Boolean.FALSE;
                }
                ConfigServiceHelper.setAttributeValue(attrList, "sslEnabled", this.sslEnabled);
                props.put("sslEnabled", this.sslEnabled);
                if (this.sslConfig != null) {
                    ConfigServiceHelper.setAttributeValue(attrList, "sslConfig", this.sslConfig);
                }
                if (this.certificateMapMode != null && this.certificateMapMode.equals("CERTIFICATE_FILTER")) {
                    this.certificateMapMode = "filterDescriptorMode";
                    if (this.certificateFilter != null && this.certificateFilter.length() > 0) {
                        props.setProperty("certificate.map.filter", this.certificateFilter);
                        break block106;
                    } else {
                        msg = this.getMsg(resBundle, "security.admintask.noUserReg.SECJ7763E", null);
                        throw new CommandValidationException(msg);
                    }
                }
                this.certificateMapMode = "exactDNMode";
            }
            props.setProperty("certificate.map.mode", this.certificateMapMode);
            if (this.ldapPort == null || this.ldapPort != null && this.ldapPort.length() == 0) {
                this.ldapPort = "389";
            }
            ConfigServiceHelper.setAttributeValue(hostAttrs, "port", new Integer(this.ldapPort));
            if (this.ldapHost != null) {
                ConfigServiceHelper.setAttributeValue(hostAttrs, "host", this.ldapHost);
            }
            if (this.ldapHost != null && this.ldapPort != null) {
                String ldapProtocol = "ldap://";
                StringBuffer ldapUrl = new StringBuffer();
                if (this.ldapHost.indexOf(":") != -1) {
                    ldapUrl.append(ldapProtocol).append("[" + this.ldapHost + "]");
                } else {
                    ldapUrl.append(ldapProtocol).append(this.ldapHost);
                }
                if (this.ldapPort != null && this.ldapPort.length() > 0) {
                    Integer port = new Integer(this.ldapPort);
                    ldapUrl.append(":" + port);
                }
                props.setProperty("java.naming.provider.url", ldapUrl.toString());
            }
            if (this.autoGenServerId != null) {
                useRegServerId = this.autoGenServerId == false;
                ConfigServiceHelper.setAttributeValue(attrList, "useRegistryServerId", new Boolean(useRegServerId));
            }
            if (!searchFilterAttrList.isEmpty()) {
                if (this.kerberosIsEnabled && this.krbUserFilter != null && this.krbUserFilter.length() > 0) {
                    props.setProperty("user.filter", "(|" + this.krbUserFilter + this.userFilter + ")");
                } else {
                    props.setProperty("user.filter", (String)ConfigServiceHelper.getAttributeValue(searchFilterAttrList, "userFilter"));
                }
                props.setProperty("group.filter", (String)ConfigServiceHelper.getAttributeValue(searchFilterAttrList, "groupFilter"));
                props.setProperty("user.idmap", (String)ConfigServiceHelper.getAttributeValue(searchFilterAttrList, "userIdMap"));
                props.setProperty("group.idmap", (String)ConfigServiceHelper.getAttributeValue(searchFilterAttrList, "groupIdMap"));
                props.setProperty("groupmember.idmap", (String)ConfigServiceHelper.getAttributeValue(searchFilterAttrList, "groupMemberIdMap"));
            }
            props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
            props.setProperty("activeRegistry", "LDAP");
            if (this.nestedGroupSearch != null) {
                this.customProps = this.customProps != null && this.customProps.length() > 0 ? this.customProps + ",\"com.ibm.websphere.security.ldap.recursiveSearch=" + this.nestedGroupSearch.toString() + "\"" : "\"com.ibm.websphere.security.ldap.recursiveSearch=" + this.nestedGroupSearch.toString() + "\"";
            }
            props = SecConfigTaskHelper.mergeCustomProperties(this.customProps, props);
            props.setProperty("WAS_UseRegistryRealm", this.useRegistryRealm.toString());
            if (this.realm != null) {
                props.setProperty("WAS_Realm", this.realm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting WAS_UseRegistryRealm: " + this.useRegistryRealm.toString() + " and WAS_Realm: " + this.realm);
            }
            if (this.realm == null || this.realm != null && this.realm.equals("")) {
                this.realm = SecConfigTaskHelper.getDefaultRealm(props);
                if (this.realm == null && this.ldapHost != null) {
                    this.realm = this.ldapHost + ":" + this.ldapPort;
                }
                this.useRegistryRealm = Boolean.TRUE;
                ConfigServiceHelper.setAttributeValue(attrList, "realm", this.realm);
            }
            ConfigServiceHelper.setAttributeValue(attrList, "useRegistryRealm", this.useRegistryRealm);
            props.setProperty("WAS_UseRegistryRealm", this.useRegistryRealm.toString());
            if (this.realm != null) {
                props.setProperty("WAS_Realm", this.realm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting again WAS_UseRegistryRealm: " + this.useRegistryRealm.toString() + " and WAS_Realm: " + this.realm);
            }
            if (this.realm != null) {
                props.setProperty("LDAP.server.realm", this.realm);
            }
            if (this.verifyRegistry != null && this.verifyRegistry.booleanValue()) {
                if (commandName.equalsIgnoreCase("configureAdminLDAPUserRegistry")) {
                    if (!SecConfigTaskHelper.isRegistryGood(session, configService, "LDAPUserRegistry", attrList, props)) {
                        msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                        throw new CommandValidationException(msg);
                    }
                } else if (!SecConfigTaskHelper.isGoodServerId(session, "*", "LDAPUserRegistry", props)) {
                    msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                    throw new CommandValidationException(msg);
                }
            }
            this.addInfoToConfig(session, configService, secObj, regObj, attrList, hostAttrs, searchFilterAttrList, this.customProps);
            return;
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureLDAPUserRegistry", "502");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            result.setException(new CommandValidationException(cse, cse.getMessage()));
            return;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }

    private void addInfoToConfig(Session session, ConfigService configService, ObjectName secObj, ObjectName reg, AttributeList regAttrs, AttributeList hostAttrs, AttributeList searchAttrs, String propString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInfoToConfig");
        }
        ObjectName regObj = reg;
        try {
            if (regObj != null) {
                configService.setAttributes(session, regObj, regAttrs);
                AttributeList searchObjAttrs = (AttributeList)configService.getAttribute(session, regObj, "searchFilter");
                ObjectName search = ConfigServiceHelper.createObjectName(searchObjAttrs);
                if (search != null) {
                    configService.setAttributes(session, search, searchAttrs);
                } else {
                    configService.createConfigData(session, secObj, "searchFilter", null, searchAttrs);
                }
                ArrayList hosts = (ArrayList)configService.getAttribute(session, regObj, "hosts");
                AttributeList hostObjAttrs = (AttributeList)hosts.get(0);
                ObjectName host = ConfigServiceHelper.createObjectName(hostObjAttrs);
                if (host != null) {
                    configService.deleteConfigData(session, host);
                    configService.createConfigData(session, regObj, "hosts", null, hostAttrs);
                } else {
                    configService.createConfigData(session, regObj, "hosts", null, hostAttrs);
                }
            } else {
                regObj = configService.createConfigData(session, secObj, "userRegistries", "LDAPUserRegistry", regAttrs);
                configService.createConfigData(session, regObj, "hosts", null, hostAttrs);
                configService.createConfigData(session, regObj, "searchFilter", null, searchAttrs);
            }
            if (propString != null && propString.length() > 0) {
                SecConfigTaskHelper.addCustomProperties(session, configService, regObj, propString);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.ConfigureLDAPUserRegistry", "556");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInfoToConfig");
        }
    }

    private AttributeList getSearchFilterAttrsList(Session session, ConfigService configService, AttributeList filterAttrs, boolean configTypeChanged, String ldapServerType) throws Exception {
        String fromFilter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSearchFilterAttrsList");
        }
        Properties ldapProps = null;
        AttributeList attrList = new AttributeList();
        try {
            InputStream is = this.getClass().getResourceAsStream(ldapPropsFile);
            ldapProps = new Properties();
            ldapProps.load(is);
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException opening ldapPropsFile");
            }
            throw e;
        }
        if (ldapProps != null) {
            int ldapServerTypeValue = 0;
            if (ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                ldapServerTypeValue = 0;
            } else if (ldapServerType.equalsIgnoreCase("SECUREWAY")) {
                ldapServerTypeValue = 1;
            } else if (ldapServerType.equalsIgnoreCase("IPLANET")) {
                ldapServerTypeValue = 2;
            } else if (ldapServerType.equalsIgnoreCase("NETSCAPE")) {
                ldapServerTypeValue = 3;
            } else if (ldapServerType.equalsIgnoreCase("DOMINO502")) {
                ldapServerTypeValue = 4;
            } else if (ldapServerType.equalsIgnoreCase("NDS")) {
                ldapServerTypeValue = 5;
            } else if (ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                ldapServerTypeValue = 6;
            } else if (ldapServerType.equalsIgnoreCase("CUSTOM")) {
                ldapServerTypeValue = 7;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ldapServerTypeValue = " + ldapServerTypeValue);
            }
            switch (ldapServerTypeValue) {
                case 0: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("ibm_dir_server.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("ibm_dir_server.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("ibm_dir_server.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("ibm_dir_server.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("ibm_dir_server.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("ibm_dir_server.krbuser.filter"));
                    break;
                }
                case 1: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("secureway.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("secureway.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("secureway.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("secureway.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("secureway.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("secureway.krbuser.filter"));
                    break;
                }
                case 2: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("iplanet.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("iplanet.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("iplanet.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("iplanet.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("iplanet.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("iplanet.krbuser.filter"));
                    break;
                }
                case 3: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("netscape.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("netscape.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("netscape.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("netscape.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("netscape.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("netscape.krbuser.filter"));
                    break;
                }
                case 4: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("domino50.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("domino50.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("domino50.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("domino50.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("domino50.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("domino50.krbuser.filter"));
                    break;
                }
                case 6: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("actived.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("actived.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("actived.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("actived.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("actived.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("actived.krbuser.filter"));
                    break;
                }
                case 5: {
                    ConfigServiceHelper.setAttributeValue(attrList, "userFilter", ldapProps.getProperty("edirectory.user.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", ldapProps.getProperty("edirectory.group.filter"));
                    ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", ldapProps.getProperty("edirectory.user.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", ldapProps.getProperty("edirectory.group.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", ldapProps.getProperty("edirectory.groupmember.idmap"));
                    ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", ldapProps.getProperty("edirectory.krbuser.filter"));
                    break;
                }
            }
        }
        if (this.userFilter != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "userFilter", this.userFilter);
        } else if (!configTypeChanged && filterAttrs != null) {
            fromFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "userFilter");
            ConfigServiceHelper.setAttributeValue(attrList, "userFilter", fromFilter);
        }
        if (this.groupFilter != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", this.groupFilter);
        } else if (!configTypeChanged && filterAttrs != null) {
            fromFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "groupFilter");
            ConfigServiceHelper.setAttributeValue(attrList, "groupFilter", fromFilter);
        }
        if (this.userIdMap != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", this.userIdMap);
        } else if (!configTypeChanged && filterAttrs != null) {
            fromFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "userIdMap");
            ConfigServiceHelper.setAttributeValue(attrList, "userIdMap", fromFilter);
        }
        if (this.groupIdMap != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", this.groupIdMap);
        } else if (!configTypeChanged && filterAttrs != null) {
            fromFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "groupIdMap");
            ConfigServiceHelper.setAttributeValue(attrList, "groupIdMap", fromFilter);
        }
        if (this.groupMemberIdMap != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", this.groupMemberIdMap);
        } else if (!configTypeChanged && filterAttrs != null) {
            fromFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "groupMemberIdMap");
            ConfigServiceHelper.setAttributeValue(attrList, "groupMemberIdMap", fromFilter);
        }
        if (this.certificateMapMode != null && this.certificateMapMode.length() > 0) {
            ConfigServiceHelper.setAttributeValue(attrList, "certificateMapMode", this.certificateMapMode);
        } else {
            String mapMode = null;
            if (!configTypeChanged && filterAttrs != null) {
                mapMode = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "certificateMapMode");
                if (mapMode != null) {
                    this.certificateMapMode = mapMode;
                    ConfigServiceHelper.setAttributeValue(attrList, "certificateMapMode", mapMode);
                } else {
                    ConfigServiceHelper.setAttributeValue(attrList, "certificateMapMode", "exactDNMode");
                }
            }
        }
        if (this.certificateFilter != null && this.certificateFilter.length() > 0) {
            ConfigServiceHelper.setAttributeValue(attrList, "certificateFilter", this.certificateFilter);
        } else if (filterAttrs != null) {
            this.certificateFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "certificateFilter");
        }
        if (this.krbUserFilter != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "krbUserFilter", this.krbUserFilter);
        } else if (!configTypeChanged && filterAttrs != null) {
            String krbFilter = (String)ConfigServiceHelper.getAttributeValue(filterAttrs, "krbUserFilter");
            ConfigServiceHelper.setAttributeValue(filterAttrs, "krbUserFilter", krbFilter);
        }
        if (attrList.isEmpty() && !filterAttrs.isEmpty()) {
            attrList = filterAttrs;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSearchFilterAttrsList");
        }
        return attrList;
    }

    public boolean validLdapServerType(String ldapServerType) {
        return ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER") || ldapServerType.equalsIgnoreCase("IPLANET") || ldapServerType.equalsIgnoreCase("NETSCAPE") || ldapServerType.equalsIgnoreCase("NDS") || ldapServerType.equalsIgnoreCase("DOMINO502") || ldapServerType.equalsIgnoreCase("SECUREWAY") || ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY") || ldapServerType.equalsIgnoreCase("CUSTOM");
    }

    private boolean validMode(String ldapServerType) {
        return ldapServerType.equalsIgnoreCase("EXACT_DN") || ldapServerType.equalsIgnoreCase("CERTIFICATE_FILTER");
    }
}

