/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandConstants;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AuditCommandHelper {
    private static TraceComponent tc = Tr.register(AuditCommandHelper.class, "AuditCommandHelper", "com.ibm.ws.ssl.commands");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());

    private static String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public static boolean isValidEventType(String eventType) {
        return eventType.equals(AuditCommandConstants.SECURITY_AUTHN) || eventType.equals(AuditCommandConstants.SECURITY_AUTHN_TERMINATE) || eventType.equals(AuditCommandConstants.SECURITY_AUTHN_MAPPING) || eventType.equals(AuditCommandConstants.SECURITY_AUTHZ) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_POLICY) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_REGISTRY) || eventType.equals(AuditCommandConstants.SECURITY_RUNTIME) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_CONFIG) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_PROVISIONING) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_RESOURCE) || eventType.equals(AuditCommandConstants.SECURITY_RUNTIME_KEY) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_KEY) || eventType.equals(AuditCommandConstants.SECURITY_MGMT_AUDIT) || eventType.equals(AuditCommandConstants.SECURITY_RESOURCE_ACCESS) || eventType.equals(AuditCommandConstants.SECURITY_SIGNING) || eventType.equals(AuditCommandConstants.SECURITY_ENCRYPTION) || eventType.equals(AuditCommandConstants.SECURITY_AUTHN_DELEGATION) || eventType.equals(AuditCommandConstants.SECURITY_AUTHN_CREDS_MODIFY);
    }

    public static boolean isValidOutcome(String outcome) {
        return outcome.equals(AuditCommandConstants.SUCCESS) || outcome.equals(AuditCommandConstants.FAILURE) || outcome.equals(AuditCommandConstants.REDIRECT) || outcome.equals(AuditCommandConstants.ERROR) || outcome.equals(AuditCommandConstants.DENIED) || outcome.equals(AuditCommandConstants.WARNING) || outcome.equals(AuditCommandConstants.INFO);
    }

    public static void addCustomProperties(Session session, ConfigService cs, ObjectName targetObj, String propString) throws Exception {
        if (!AuditCommandHelper.isCustomPropStringGood(propString)) {
            String msg = AuditCommandHelper.getMsg(resBundle, "security.admintask.badCustomProp.SECJ7773E", new Object[]{propString});
            throw new CommandValidationException(msg);
        }
        AuditCommandHelper.addCustomValues(session, cs, targetObj, propString, "properties");
    }

    public static void addCustomValues(Session session, ConfigService cs, ObjectName targetObj, String propString, String customEntName) throws Exception {
        Tr.debug(tc, "propString: ", propString);
        if (propString != null && propString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(propString, "(\"\")+");
            while (tokenizer.hasMoreTokens()) {
                List props = null;
                AttributeList attributeList = cs.getAttributes(session, targetObj, new String[]{customEntName}, false);
                if (attributeList != null) {
                    props = (List)((Attribute)attributeList.get(0)).getValue();
                }
                AttributeList attrList = new AttributeList();
                String entry = tokenizer.nextToken();
                Tr.debug(tc, "entry: " + entry);
                if (entry != null && entry.equals(",")) continue;
                ObjectName property = null;
                int index = entry.indexOf("=");
                if (index <= 0) continue;
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                Tr.debug(tc, "name: " + name + " value: " + value);
                attrList.clear();
                attrList.add(new Attribute("name", name));
                if (value != null && value.equals("''")) {
                    attrList.add(new Attribute("value", ""));
                } else {
                    attrList.add(new Attribute("value", value));
                }
                if (props != null && !props.isEmpty()) {
                    boolean propertySet = false;
                    for (int j = 0; j < props.size(); ++j) {
                        property = (ObjectName)props.get(j);
                        String propName = (String)cs.getAttribute(session, property, "name");
                        if (!propName.equals(name)) continue;
                        Tr.debug(tc, "prop exists, deleting");
                        cs.deleteConfigData(session, property);
                        if (value != null && value.length() > 0) {
                            cs.createConfigData(session, targetObj, customEntName, null, attrList);
                        }
                        Tr.debug(tc, " ... and recreating");
                        propertySet = true;
                        break;
                    }
                    if (propertySet) continue;
                    if (value != null && value.length() > 0) {
                        cs.createConfigData(session, targetObj, customEntName, null, attrList);
                    }
                    Tr.debug(tc, "created new properties");
                    continue;
                }
                Tr.debug(tc, "no prev props existing, creating");
                if (value == null || value.length() <= 0) continue;
                cs.createConfigData(session, targetObj, customEntName, null, attrList);
            }
        }
    }

    public static boolean isCustomPropStringGood(String propString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCustomPropStringGood", propString);
        }
        try {
            if (propString != null && propString.length() > 0) {
                if (!propString.startsWith("\"") && !propString.endsWith("\"")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCustomPropStringGood: false");
                    }
                    return false;
                }
                StringTokenizer tokenizer = new StringTokenizer(propString, "(\"^\"*\")+");
                while (tokenizer.hasMoreTokens()) {
                    String getComma;
                    String token = tokenizer.nextToken();
                    if (token.indexOf("=") < 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isCustomPropStringGood: false");
                        }
                        return false;
                    }
                    if (!tokenizer.hasMoreTokens() || (getComma = tokenizer.nextToken()) != null && getComma.equals(",") && tokenizer.hasMoreTokens()) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCustomPropStringGood: false");
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while tokenizing custom property string " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCustomPropStringGood: true");
        }
        return true;
    }
}

