/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.notification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditNotificationMonitor
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditNotificationMonitor.class, "AUDIT", "com.ibm.ws.security.admintask.audit.notification");
    private String monitorRef = null;
    private String notificationRef = null;
    private Boolean enable = new Boolean(false);
    private boolean modifyEnable = false;
    private boolean retrievedEnabledSetting = false;

    public ModifyAuditNotificationMonitor(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditNotificationMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.monitorRef = (String)this.getParameter("monitorRef");
        if (this.monitorRef == null || this.monitorRef.length() == 0) {
            String msg2 = this.getMsg(resBundle, "security.admintask.InvalidMonitorRef", null);
            throw new CommandValidationException(msg2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "monitorRef: " + this.monitorRef);
        }
        this.enable = (Boolean)this.getParameter("enable");
        if (this.enable != null) {
            this.modifyEnable = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enable: " + this.enable);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enable had no input ");
        }
        this.notificationRef = (String)this.getParameter("notificationRef");
        ObjectName audit = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg3 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                throw new CommandValidationException(msg3);
            }
            AttributeList monitorAttrs = (AttributeList)cs.getAttribute(session, audit, "auditNotificationMonitor");
            if (monitorAttrs == null) {
                String msg4 = this.getMsg(resBundle, "security.admintask.NotificationMonitorNotConfigured", null);
                throw new CommandValidationException(msg4);
            }
            ObjectName monitorObj = ConfigServiceHelper.createObjectName(monitorAttrs);
            Boolean enabledSetting = (Boolean)cs.getAttribute(session, monitorObj, "enabled");
            this.retrievedEnabledSetting = enabledSetting;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.notification.ModifyAuditNotificationMonitor.validate", "%");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg5 = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg5 = msg5.concat(": ");
                msg5 = msg5.concat(e.getMessage());
            }
            throw new CommandValidationException(msg5);
        }
        if ((this.enable != null && this.enable.booleanValue() || this.enable == null && this.retrievedEnabledSetting) && this.notificationRef != null && this.notificationRef.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.CannotDeleteNotification", null);
            throw new CommandValidationException(msg);
        }
        if (!this.modifyEnable && this.notificationRef == null) {
            msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName audit = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList monitorAttrs = (AttributeList)cs.getAttribute(session, audit, "auditNotificationMonitor");
            if (monitorAttrs == null) {
                result.setResult(new Boolean(false));
                return;
            }
            ObjectName monitorObj = ConfigServiceHelper.createObjectName(monitorAttrs);
            String ref = ConfigServiceHelper.getAttributeValue(monitorAttrs, "_Websphere_Config_Data_Id").toString();
            if (this.monitorRef.equals(ref = ref.split("#")[1])) {
                if (this.modifyEnable) {
                    ConfigServiceHelper.setAttributeValue(monitorAttrs, "enabled", this.enable);
                }
                if (this.notificationRef != null) {
                    ObjectName notificationObj = null;
                    boolean foundNotification = false;
                    ArrayList<ObjectName> nList = new ArrayList<ObjectName>();
                    ArrayList notificationArray = (ArrayList)cs.getAttribute(session, audit, "wsNotifications");
                    for (int k = 0; k < notificationArray.size(); ++k) {
                        AttributeList notificationAttrs = (AttributeList)notificationArray.get(k);
                        notificationObj = ConfigServiceHelper.createObjectName(notificationAttrs);
                        String filterR = ConfigServiceHelper.getConfigDataId(notificationObj).toString().split("#")[1];
                        if (!filterR.equals(this.notificationRef)) continue;
                        nList.add(notificationObj);
                        foundNotification = true;
                        break;
                    }
                    if (!foundNotification) {
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
                        result.addWarnings(msg);
                        result.setException(new CommandException(msg));
                        result.setResult(new Boolean(false));
                        return;
                    }
                    ConfigServiceHelper.setAttributeValue(monitorAttrs, "wsNotification", notificationObj);
                }
                cs.setAttributes(session, monitorObj, monitorAttrs);
                result.setResult(new Boolean(true));
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidMonitorRef", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
            }
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.notification.ModifyAuditNotificationMonitor.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.notification.ModifyAuditNotificationMonitor.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

