/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.notification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditNotificationMonitor
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateAuditNotificationMonitor.class, "AUDIT", "com.ibm.ws.security.admintask.audit.notification");
    private String name = null;
    private String notificationRef = null;
    private Boolean enabled = null;

    public CreateAuditNotificationMonitor(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditNotificationMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.name = (String)this.getParameter("monitorName");
        if (this.name == null || this.name.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidMonitorName", null);
            throw new CommandValidationException(msg);
        }
        this.notificationRef = (String)this.getParameter("notificationRef");
        if (this.notificationRef == null || this.notificationRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
            throw new CommandValidationException(msg);
        }
        this.enabled = (Boolean)this.getParameter("enable");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "name: " + this.name);
            Tr.debug(tc, "notificationRef: " + this.notificationRef);
            Tr.debug(tc, "enabled: " + (this.enabled == null ? "null" : this.enabled.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName audit = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList monitor = null;
            monitor = (AttributeList)cs.getAttribute(session, audit, "auditNotificationMonitor");
            if (monitor != null) {
                String msg = this.getMsg(resBundle, "security.admintask.NotificationMonitorConfigured", null);
                throw new CommandValidationException(msg);
            }
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", this.name));
            attrList.add(new Attribute("enabled", this.enabled));
            ObjectName notificationObj = null;
            boolean foundNotification = false;
            ArrayList<ObjectName> nList = new ArrayList<ObjectName>();
            ArrayList notificationArray = (ArrayList)cs.getAttribute(session, audit, "wsNotifications");
            for (int k = 0; k < notificationArray.size(); ++k) {
                AttributeList notificationAttrs = (AttributeList)notificationArray.get(k);
                notificationObj = ConfigServiceHelper.createObjectName(notificationAttrs);
                String filterR = ConfigServiceHelper.getConfigDataId(notificationObj).toString().split("#")[1];
                if (!filterR.equals(this.notificationRef)) continue;
                nList.add(notificationObj);
                foundNotification = true;
                break;
            }
            if (!foundNotification) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                return;
            }
            attrList.add(new Attribute("wsNotification", notificationObj));
            if (attrList != null) {
                ObjectName monitorObj = cs.createConfigData(session, audit, "auditNotificationMonitor", "AuditNotificationMonitor", attrList);
                AttributeList newAttrs = cs.getAttributes(session, monitorObj, null, true);
                String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
                nRef = nRef.split("#")[1];
                if (monitorObj != null) {
                    result.setResult(nRef);
                }
            }
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.notification.CreateAuditNotificationMonitor.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.notification.CreateAuditNotificationMonitor.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

