/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.security.admintask.audit.keyStores.KeyStoreHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyAuditKeyStore.class, "Audit", "com.ibm.ws.security.admintask.audit.keyStores");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private String keyStoreName = null;
    private String keyStoreLocation = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String keyStoreProvider = null;
    private Boolean keyStoreIsFileBased = null;
    private Boolean keyStoreReadOnly = null;
    private Boolean keyStoreInitAtStartup = null;
    private String scopeName = null;
    private String keyStoreDescription = null;
    private ObjectName keyStoreObjName = null;

    public ModifyAuditKeyStore(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName audit = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreLocation = (String)this.getParameter(CommandConstants.KEY_STORE_LOCATION);
            if (this.keyStoreLocation != null && this.keyStoreLocation.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.NoKeyStorePathValue", null);
                throw new CommandValidationException(msg);
            }
            this.keyStoreType = (String)this.getParameter(CommandConstants.KEY_STORE_TYPE);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            if (this.keyStorePassword != null && this.keyStorePassword.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.NoKeyStorePasswordValue", null);
                throw new CommandValidationException(msg);
            }
            this.keyStoreIsFileBased = (Boolean)this.getParameter(CommandConstants.KEY_STORE_IS_FILE_BASED);
            this.keyStoreReadOnly = (Boolean)this.getParameter(CommandConstants.KEY_STORE_READ_ONLY);
            this.keyStoreInitAtStartup = (Boolean)this.getParameter(CommandConstants.KEY_STORE_INIT_AT_STARTUP);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (this.scopeName != null && this.scopeName.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidScopeName", null);
                throw new CommandValidationException(msg);
            }
            this.keyStoreDescription = (String)this.getParameter(CommandConstants.KEY_STORE_DESCRIPTION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreLocation=" + this.keyStoreLocation + " keyStoreType=" + this.keyStoreType + " keyStorePassword=" + this.keyStorePassword + " keyStoreIsFileBased=" + this.keyStoreIsFileBased + " keyStoreReadOnly=" + this.keyStoreReadOnly + " keyStoreInitAtStartup=" + this.keyStoreInitAtStartup + " scopeName=" + this.scopeName + " keyStoreDescription=" + this.keyStoreDescription);
            }
            CommandHelper commandHelper = new CommandHelper();
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            this.keyStoreObjName = commandHelper.getObjectName(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (this.keyStoreObjName != null) {
                if (this.keyStoreIsFileBased == null) {
                    this.keyStoreIsFileBased = (Boolean)cs.getAttribute(session, this.keyStoreObjName, "fileBased");
                }
                if (this.keyStoreReadOnly == null) {
                    this.keyStoreReadOnly = (Boolean)cs.getAttribute(session, this.keyStoreObjName, "readOnly");
                }
                if (this.keyStoreInitAtStartup == null) {
                    this.keyStoreInitAtStartup = (Boolean)cs.getAttribute(session, this.keyStoreObjName, "initializeAtStartup");
                }
            }
            if (this.keyStoreType != null && !this.keyStoreType.equals("")) {
                if (this.keyStoreType.indexOf("(PKCS11)") >= 0) {
                    this.keyStoreType = "PKCS11";
                }
                if (this.keyStoreType.equals("PKCS11") || this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreIsFileBased = Boolean.FALSE;
                }
                if (this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreReadOnly = Boolean.TRUE;
                }
            }
            if (this.keyStoreLocation != null && !this.keyStoreLocation.equals("")) {
                File keyFile;
                String msg;
                if (this.keyStoreIsFileBased.booleanValue()) {
                    File libFile;
                    if (this.keyStoreType == null || this.keyStorePassword == null) {
                        String msg2 = TraceNLSHelper.getInstance().getString("ssl.command.missing.parameters.CWPKI0698E", "Must specify the keyStoreLocation, keyStoreType, and keyStorePassword to change the key store.");
                        throw new CommandValidationException(msg2);
                    }
                    int status = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    if (status == 1 && !(libFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation))).isAbsolute()) {
                        this.keyStoreLocation = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + libFile);
                        status = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    }
                    if (status != 0) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyStoreLocation}, this.keyStoreName + " in the management scope " + this.scopeName + " already exists.");
                        throw new CommandValidationException(msg);
                    }
                } else if (this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    WSKeyStore.loadKeyStore(this.keyStoreLocation, this.keyStoreType, this.keyStorePassword);
                }
                if (!(this.keyStoreType == null || !this.keyStoreType.equalsIgnoreCase("PKCS11") || (keyFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation))) != null && keyFile.isFile() && keyFile.canRead())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key store file \"" + this.keyStoreLocation + "\" does not exist.");
                    }
                    msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.file.CWPKI0673E", new Object[]{this.keyStoreLocation}, "Creating a read only key store object.  File \"" + this.keyStoreLocation + "\" should already exist.");
                    throw new CommandValidationException(msg);
                }
            }
            if (this.keyStoreProvider == null && this.keyStoreType != null) {
                if (this.keyStoreType.equals("CMSKS")) {
                    this.keyStoreProvider = "IBMCMSProvider";
                } else if (this.keyStoreType.equals("IBMi5OSKeyStore")) {
                    this.keyStoreProvider = "IBMi5OSJSSEProvider";
                } else if (this.keyStoreType.equals("PKCS11")) {
                    this.keyStoreProvider = "PKCS11";
                } else if (this.keyStoreType.equals("PKCS12") || this.keyStoreType.equals("JKS") || this.keyStoreType.equals("JCEKS")) {
                    this.keyStoreProvider = "IBMJCE";
                } else if (this.keyStoreType.equals("JCECCAKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreProvider = "IBMJCECCA";
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            ObjectName audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            AttributeList attrList = new AttributeList();
            if (this.keyStoreLocation != null && !this.keyStoreLocation.equals("")) {
                attrList.add(new Attribute("location", this.keyStoreLocation));
                if (this.keyStoreType != null && !this.keyStoreType.equals("")) {
                    attrList.add(new Attribute("type", this.keyStoreType));
                }
                if (this.keyStorePassword != null && !this.keyStorePassword.equals("")) {
                    attrList.add(new Attribute("password", this.keyStorePassword));
                }
                if (this.keyStoreProvider != null && !this.keyStoreProvider.equals("")) {
                    attrList.add(new Attribute("provider", this.keyStoreProvider));
                }
            }
            if (this.keyStoreIsFileBased != null) {
                attrList.add(new Attribute("fileBased", this.keyStoreIsFileBased));
            }
            if (this.keyStoreReadOnly != null) {
                attrList.add(new Attribute("readOnly", this.keyStoreReadOnly));
            }
            if (this.keyStoreInitAtStartup != null) {
                attrList.add(new Attribute("initializeAtStartup", this.keyStoreInitAtStartup));
            }
            if (this.keyStoreDescription != null) {
                attrList.add(new Attribute("description", this.keyStoreDescription));
            }
            cs.setAttributes(session, this.keyStoreObjName, attrList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

