/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.eventfactory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditEventFactory
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditEventFactory.class, "AUDIT", "com.ibm.ws.security.admintask.audit.eventfactory");
    String eventFactoryRef = null;
    String providerRef = null;
    String className = null;
    String filtersRef = null;
    static String prefix = "SECURITY_";
    String customProperties = null;
    String[] customPropName = new String[10];
    String[] customPropValue = new String[10];
    boolean removeAll = false;

    public ModifyAuditEventFactory(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditEventFactory(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.eventFactoryRef = (String)this.getParameter("eventFactoryRef");
        if (this.eventFactoryRef == null || this.eventFactoryRef.length() == 0) {
            String msg2 = this.getMsg(resBundle, "security.admintask.InvalidEventFactory", null);
            throw new CommandValidationException(msg2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "eventFactoryRef: " + this.eventFactoryRef);
        }
        this.providerRef = (String)this.getParameter("provider");
        if (this.providerRef != null && this.providerRef.length() != 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, "providerRef: " + this.providerRef);
        }
        if (this.providerRef != null && this.providerRef.length() == 0) {
            String msg3 = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
            throw new CommandValidationException(msg3);
        }
        this.className = (String)this.getParameter("className");
        if (this.className != null && this.className.length() == 0) {
            String msg4 = this.getMsg(resBundle, "security.admintask.InvalidClassName", null);
            throw new CommandValidationException(msg4);
        }
        if (this.className != null && this.className.length() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "className: " + this.className);
            }
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName audit = null;
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                if (audit == null) {
                    String msg5 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                    throw new CommandValidationException(msg5);
                }
                AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
                ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
                ArrayList factoryList = (ArrayList)cs.getAttribute(session, policyObject, "auditEventFactories");
                boolean found = false;
                for (int i = 0; i < factoryList.size(); ++i) {
                    AttributeList factoryAttrs = (AttributeList)factoryList.get(i);
                    ObjectName auditEventFactory = ConfigServiceHelper.createObjectName(factoryAttrs);
                    String auditEventFactoryRef = ConfigServiceHelper.getAttributeValue(factoryAttrs, "_Websphere_Config_Data_Id").toString();
                    if (!(auditEventFactoryRef = auditEventFactoryRef.split("#")[1]).equals(this.eventFactoryRef)) continue;
                    String clName = (String)cs.getAttribute(session, auditEventFactory, "className");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "class name: " + clName);
                    }
                    if (!clName.equals("com.ibm.ws.security.audit.AuditEventFactoryImpl") || clName.equals(this.className)) continue;
                    String msg6 = this.getMsg(resBundle, "security.admintask.ClassNotDefaultEventFactory", null);
                    throw new CommandValidationException(msg6);
                }
            }
            catch (Exception e) {
                throw new CommandValidationException(e.getMessage());
            }
        }
        this.customProperties = (String)this.getParameter("customProperties");
        if (this.customProperties != null && this.customProperties.length() == 0) {
            this.removeAll = true;
        }
        if (this.customProperties != null && this.customProperties.length() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customProperties: " + this.customProperties);
            }
            if (this.customProperties.indexOf("=") == -1) {
                msg = this.getMsg(resBundle, "security.admintask.InvalidCustomProperty", null);
                throw new CommandValidationException(msg);
            }
            if (this.customProperties.endsWith("=") || this.customProperties.endsWith(",")) {
                msg = this.getMsg(resBundle, "security.admintask.InvalidCustomProperty", null);
                throw new CommandValidationException(msg);
            }
        }
        this.filtersRef = (String)this.getParameter("auditFilters");
        if (this.filtersRef != null && this.filtersRef.length() != 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, "filtersRef: " + this.filtersRef);
        }
        if (this.filtersRef != null && this.filtersRef.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
            throw new CommandValidationException(msg);
        }
        if (this.eventFactoryRef == null && this.providerRef == null && this.className == null && this.filtersRef == null && this.customProperties == null) {
            msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (this.eventFactoryRef != null && this.providerRef == null && this.className == null && this.filtersRef == null && this.customProperties == null) {
            msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        Object s = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList factoryList = (ArrayList)cs.getAttribute(session, policyObject, "auditEventFactories");
            boolean found = false;
            for (int i = 0; i < factoryList.size(); ++i) {
                String[] aList;
                AttributeList factoryAttrs = (AttributeList)factoryList.get(i);
                ObjectName auditEventFactory = ConfigServiceHelper.createObjectName(factoryAttrs);
                String auditEventFactoryRef = ConfigServiceHelper.getAttributeValue(factoryAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(auditEventFactoryRef = auditEventFactoryRef.split("#")[1]).equals(this.eventFactoryRef)) continue;
                found = true;
                if (this.filtersRef != null) {
                    aList = new ArrayList();
                    StringTokenizer st = new StringTokenizer(this.filtersRef, ",; ");
                    boolean index = false;
                    while (st.hasMoreTokens()) {
                        String filter = st.nextToken();
                        boolean foundFilter = false;
                        ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
                        for (int k = 0; k < filterArray.size(); ++k) {
                            AttributeList filterAttrs = (AttributeList)filterArray.get(k);
                            ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                            String filterR = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1];
                            if (!filterR.equals(filter)) continue;
                            foundFilter = true;
                            aList.add(auditSpec);
                            break;
                        }
                        if (foundFilter) continue;
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
                        result.addWarnings(msg);
                        result.setException(new CommandException(msg));
                        result.setResult(new Boolean(false));
                        return;
                    }
                    ArrayList auditSpecs = (ArrayList)cs.getAttribute(session, auditEventFactory, "auditSpecifications");
                    auditSpecs.clear();
                    auditSpecs.addAll(aList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "auditSpecs: " + auditSpecs.toString());
                    }
                    ConfigServiceHelper.setAttributeValue(factoryAttrs, "auditSpecifications", auditSpecs);
                }
                if (this.className != null) {
                    ConfigServiceHelper.setAttributeValue(factoryAttrs, "className", this.className);
                }
                if (this.providerRef != null) {
                    ObjectName providerObj = null;
                    boolean foundProvider = false;
                    ArrayList<ObjectName> pList = new ArrayList<ObjectName>();
                    ArrayList providerArray = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
                    for (int k = 0; k < providerArray.size(); ++k) {
                        String filterR;
                        AttributeList providerAttrs = (AttributeList)providerArray.get(k);
                        providerObj = ConfigServiceHelper.createObjectName(providerAttrs);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "providerObj: " + providerObj);
                        }
                        if (!(filterR = ConfigServiceHelper.getConfigDataId(providerObj).toString().split("#")[1]).equals(this.providerRef)) continue;
                        pList.add(providerObj);
                        foundProvider = true;
                        break;
                    }
                    if (!foundProvider) {
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
                        result.addWarnings(msg);
                        result.setException(new CommandException(msg));
                        result.setResult(new Boolean(false));
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "providerObj: " + providerObj.toString());
                    }
                    ConfigServiceHelper.setAttributeValue(factoryAttrs, "auditServiceProvider", providerObj);
                }
                cs.setAttributes(session, auditEventFactory, factoryAttrs);
                if (this.removeAll) {
                    aList = new String[]{"properties"};
                    cs.unsetAttributes(session, auditEventFactory, aList);
                    continue;
                }
                if (this.customProperties == null) continue;
                AuditCommandHelper.addCustomProperties(session, cs, auditEventFactory, this.customProperties);
            }
            if (!found) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidEventFactory", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                return;
            }
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.eventfactory.ModifyAuditEventFactory.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.eventfactory.ModifyAuditEventFactory.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

