/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.eventfactory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListAuditEventFactories
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ListAuditEventFactories.class, "AUDIT", "com.ibm.ws.security.admintask.audit.eventfactory");

    public ListAuditEventFactories(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListAuditEventFactories(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        ArrayList<AttributeList> referenceList = new ArrayList<AttributeList>();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList factoryList = (ArrayList)cs.getAttribute(session, policyObject, "auditEventFactories");
            for (int i = 0; i < factoryList.size(); ++i) {
                AttributeList factoryAttrs = (AttributeList)factoryList.get(i);
                Iterator it = factoryAttrs.iterator();
                if (tc.isDebugEnabled()) {
                    while (it.hasNext()) {
                        Tr.debug(tc, "ATTRIBUTE: " + it.next().toString());
                    }
                }
                for (int j = 0; j < factoryAttrs.size(); ++j) {
                    String s;
                    Object al;
                    Attribute a = (Attribute)factoryAttrs.get(j);
                    if (a.getName().equals("_Websphere_Config_Data_Id")) {
                        al = a.getValue().toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AL: " + (String)al);
                        }
                        String s2 = ((String)al).split("#")[1];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "s: " + s2);
                        }
                        Attribute auditEventFactoryRef = new Attribute("auditEventFactoryRef", s2);
                        factoryAttrs.add(auditEventFactoryRef);
                    }
                    if (a.getName().equals("auditSpecifications")) {
                        al = (ArrayList)a.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AL: " + ((AbstractCollection)al).toString());
                        }
                        for (int k = 0; k < ((ArrayList)al).size(); ++k) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ELEMENT: " + ((ArrayList)al).get(k).toString());
                            }
                            s = ((ArrayList)al).get(k).toString();
                            int index1 = s.indexOf("_Websphere_Config_Data_Id");
                            String s1 = s.substring(index1, s.length());
                            int index2 = s1.indexOf("#");
                            int index3 = s1.indexOf(",");
                            String s2 = s1.substring(index2 + 1, index3);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "s2: " + s2);
                            }
                            Attribute auditSpecRef = new Attribute("auditSpecRef".concat(new Integer(k + 1).toString()), s2);
                            factoryAttrs.add(auditSpecRef);
                        }
                    }
                    if (a.getName().equals("auditServiceProvider")) {
                        String longRef = a.getValue().toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "longRef: " + longRef);
                        }
                        int index1 = longRef.indexOf("#");
                        s = longRef.substring(index1 + 1, longRef.length());
                        int index2 = s.indexOf(",");
                        String emitterFactoryRef = s.substring(0, index2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "emitterFactoryRef: " + emitterFactoryRef);
                        }
                        Attribute emitterRefAttr = new Attribute("emitterRef", emitterFactoryRef);
                        factoryAttrs.add(emitterRefAttr);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "name: " + a.getName() + " value: " + a.getValue());
                }
                ObjectName auditEventFactory = ConfigServiceHelper.createObjectName(factoryAttrs);
                referenceList.add(factoryAttrs);
            }
            result.setResult(referenceList);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.eventfactory.ListAuditEventFactories.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(referenceList);
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.eventfactory.ListAuditEventFactories.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(referenceList);
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

