/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.encryption;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditEncryptionConfig
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditEncryptionConfig.class, "AUDIT", "com.ibm.ws.security.admintask.audit.encryption");
    private Boolean enable = null;
    private String certAlias = null;
    private String encryptionKeyStoreName = null;
    private String encryptionKeyStoreRef = null;
    private Boolean autogenCert = null;
    private Boolean importCert = null;
    private String certKeyFileName = null;
    private String certKeyFilePath = null;
    private String certKeyFileType = null;
    private String certKeyFilePassword = null;
    private String certAliasToImport = null;
    private String origCertAlias = null;
    String keyFileName = null;
    ObjectName keyStoreCreated = null;
    boolean keyStoreFound = false;
    boolean retrievedEncryptSetting = false;

    public ModifyAuditEncryptionConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditEncryptionConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        String msg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.enable = (Boolean)this.getParameter("enableAuditEncryption");
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        ObjectName matches = null;
        AttributeList settings = new AttributeList();
        Object keystoreObj = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            matches = cs.resolve(session, "Cell=")[0];
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg2 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                throw new CommandValidationException(msg2);
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            Boolean encryptSetting = (Boolean)cs.getAttribute(session, policyObject, "encrypt");
            this.retrievedEncryptSetting = encryptSetting;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.encryption.ModifyAuditEncryptionConfig.validate", "%");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg3 = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg3 = msg3.concat(": ");
                msg3 = msg3.concat(e.getMessage());
            }
            throw new CommandValidationException(msg3);
        }
        this.certAlias = (String)this.getParameter("certAlias");
        if (this.certAlias != null && this.certAlias.length() != 0) {
            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                this.origCertAlias = this.certAlias;
            }
            this.certAlias = this.certAlias.toLowerCase();
        }
        if ((this.enable != null && this.enable.booleanValue() || this.enable == null && this.retrievedEncryptSetting) && this.certAlias != null && this.certAlias.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.CannotDeleteCertAlias", null);
            throw new CommandValidationException(msg);
        }
        this.encryptionKeyStoreRef = (String)this.getParameter("encryptionKeyStoreRef");
        if ((this.enable != null && this.enable.booleanValue() || this.enable == null && this.retrievedEncryptSetting) && this.encryptionKeyStoreRef != null && this.encryptionKeyStoreRef.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.CannotDeleteEncryptionKeyStore", null);
            throw new CommandValidationException(msg);
        }
        this.autogenCert = (Boolean)this.getParameter("autogenCert");
        this.importCert = (Boolean)this.getParameter("importCert");
        if (this.autogenCert != null && this.importCert != null && this.autogenCert.equals(Boolean.TRUE) && this.importCert.equals(Boolean.TRUE)) {
            msg = this.getMsg(resBundle, "security.admintask.MustSpecifyCertGenMethod", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFileName = (String)this.getParameter("certKeyFileName");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFileName == null || this.certKeyFileName.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFileNameValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFilePath = (String)this.getParameter("certKeyFilePath");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFilePath == null || this.certKeyFilePath.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFilePathValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFileType = (String)this.getParameter("certKeyFileType");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFileType == null || this.certKeyFileType.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFileTypeValue", null);
            throw new CommandValidationException(msg);
        }
        this.certKeyFilePassword = (String)this.getParameter("certKeyFilePassword");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certKeyFilePassword == null || this.certKeyFilePassword.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertKeyFilePasswordValue", null);
            throw new CommandValidationException(msg);
        }
        this.certAliasToImport = (String)this.getParameter("certAliasToImport");
        if (this.importCert != null && this.importCert.booleanValue() && (this.certAliasToImport == null || this.certAliasToImport.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.NoCertAliasToImport", null);
            throw new CommandValidationException(msg);
        }
        if (this.certAliasToImport != null && this.certAliasToImport.length() != 0) {
            this.certAliasToImport = this.certAliasToImport.toLowerCase();
        }
        if (!(this.enable != null || this.autogenCert != null || this.importCert != null || this.certAlias != null && this.certAlias.length() != 0 || this.encryptionKeyStoreRef != null && this.encryptionKeyStoreRef.length() != 0 || this.certKeyFileName != null && this.certKeyFileName.length() != 0 || this.certKeyFilePath != null && this.certKeyFilePath.length() != 0 || this.certKeyFilePassword != null && this.certKeyFilePassword.length() != 0 || this.certKeyFileType != null && this.certKeyFileType.length() != 0 || this.certAliasToImport != null && this.certAliasToImport.length() != 0)) {
            msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isDebugEnabled()) {
            if (this.enable != null) {
                Tr.debug(tc, "enable: " + this.enable.toString());
            }
            if (this.certAlias != null) {
                Tr.debug(tc, "certAlias: " + this.certAlias);
            }
            if (this.autogenCert != null) {
                Tr.debug(tc, "autogenCert: " + this.autogenCert);
            }
            if (this.importCert != null) {
                Tr.debug(tc, "importCert: " + this.importCert);
            }
            Tr.debug(tc, "certKeyFileName: " + this.certKeyFileName);
            Tr.debug(tc, "certKeyFilePath: " + this.certKeyFilePath);
            Tr.debug(tc, "certKeyFileType: " + this.certKeyFileType);
            Tr.debug(tc, "certAliasToImport: " + this.certAliasToImport);
            if (this.encryptionKeyStoreRef != null) {
                Tr.debug(tc, "encryptionKeyStoreRef: " + this.encryptionKeyStoreRef);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        ObjectName matches = null;
        AttributeList settings = new AttributeList();
        ObjectName keystoreObj = null;
        try {
            ObjectName policyObject;
            block50: {
                String msg;
                AdminCommand getUserCmd;
                block53: {
                    CommandResult cmdResult;
                    block54: {
                        block51: {
                            CommandResult cmdResult2;
                            block52: {
                                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                                matches = cs.resolve(session, "Cell=")[0];
                                audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                                if (audit == null) {
                                    String msg2 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                                    result.addWarnings(msg2);
                                    result.setResult(new Boolean(false));
                                    result.setException(new CommandException(msg2));
                                    return;
                                }
                                AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
                                policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
                                if (policyObject != null && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "policyObj: " + policyObject);
                                }
                                settings.add(new Attribute("encrypt", this.enable));
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "enable.booleanValue(): " + this.enable);
                                }
                                if (!this.enable.booleanValue()) break block50;
                                if (this.encryptionKeyStoreRef != null) {
                                    boolean found = false;
                                    ArrayList keystoreList = (ArrayList)cs.getAttribute(session, audit, "keyStores");
                                    for (int i = 0; i < keystoreList.size(); ++i) {
                                        AttributeList keystoreAttrs = (AttributeList)keystoreList.get(i);
                                        keystoreObj = ConfigServiceHelper.createObjectName(keystoreAttrs);
                                        String keystoreName = ConfigServiceHelper.getAttributeValue(keystoreAttrs, "name").toString();
                                        String keystoreRef = ConfigServiceHelper.getAttributeValue(keystoreAttrs, "_Websphere_Config_Data_Id").toString();
                                        keystoreRef = keystoreRef.split("#")[1];
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "keystoreRef: " + keystoreRef + " encryptionKeyStoreRef: " + this.encryptionKeyStoreRef);
                                        }
                                        if (!keystoreRef.equals(this.encryptionKeyStoreRef)) continue;
                                        found = true;
                                        this.encryptionKeyStoreName = keystoreName;
                                        this.keyStoreCreated = keystoreObj;
                                        break;
                                    }
                                    if (!found) {
                                        String msg3 = this.getMsg(resBundle, "security.admintask.NoKeyStore", null);
                                        result.addWarnings(msg3);
                                        result.setResult(new Boolean(false));
                                        result.setException(new CommandException(msg3));
                                        return;
                                    }
                                }
                                if (this.autogenCert == null || !this.autogenCert.booleanValue()) break block51;
                                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                                getUserCmd = commandMgr.createCommand("createAuditSelfSignedCertificate");
                                getUserCmd.setParameter("keyStoreName", this.encryptionKeyStoreName);
                                getUserCmd.setParameter("certificateAlias", this.certAlias);
                                getUserCmd.setParameter("certificateSize", new Integer(2048));
                                getUserCmd.setParameter("certificateCommonName", InetAddress.getLocalHost().getHostName());
                                getUserCmd.setParameter("certificateOrganization", "IBM");
                                getUserCmd.setConfigSession(session);
                                getUserCmd.execute();
                                cmdResult2 = getUserCmd.getCommandResult();
                                if (!cmdResult2.isSuccessful()) break block52;
                                if (((Boolean)cmdResult2.getResult()).booleanValue()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Successfully created self signed personal certificate for audit encryption");
                                    }
                                    break block53;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Was not successful creating self signed personal certificate for audit encryption");
                                    }
                                    msg = this.getMsg(resBundle, "security.admintask.AutogenCertFailure", null);
                                    if (cmdResult2.getException() != null && cmdResult2.getException().getMessage() != null) {
                                        msg = msg.concat(": ");
                                        msg = msg.concat(cmdResult2.getException().getMessage());
                                    }
                                    result.addWarnings(msg);
                                    result.setResult(new Boolean(false));
                                    result.setException(new CommandException(msg));
                                    return;
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Was not successful creating self signed personal certificate for audit encryption");
                            }
                            msg = this.getMsg(resBundle, "security.admintask.AutogenCertFailure", null);
                            if (cmdResult2.getException() != null && cmdResult2.getException().getMessage() != null) {
                                msg = msg.concat(": ");
                                msg = msg.concat(cmdResult2.getException().getMessage());
                            }
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            return;
                        }
                        if (this.importCert == null || !this.importCert.booleanValue()) break block53;
                        CommandMgr commandMgr = CommandMgr.getCommandMgr();
                        getUserCmd = commandMgr.createCommand("importAuditCertificate");
                        getUserCmd.setParameter("keyStoreName", this.encryptionKeyStoreName);
                        getUserCmd.setParameter("keyFilePath", this.certKeyFilePath);
                        getUserCmd.setParameter("keyFilePassword", this.certKeyFilePassword);
                        getUserCmd.setParameter("keyFileType", this.certKeyFileType);
                        getUserCmd.setParameter("certificateAliasFromKeyFile", this.certAliasToImport);
                        getUserCmd.setParameter("certificateAlias", this.certAlias);
                        getUserCmd.setConfigSession(session);
                        getUserCmd.execute();
                        cmdResult = getUserCmd.getCommandResult();
                        if (!cmdResult.isSuccessful()) break block54;
                        if (((Boolean)cmdResult.getResult()).booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Successfully imported self signed personal certificate for audit encryption");
                            }
                            break block53;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Was not successful importing self signed personal certificate for audit encryption");
                            }
                            msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                            if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                                msg = msg.concat(": ");
                                msg = msg.concat(cmdResult.getException().getMessage());
                            }
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            return;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Was not successful importing self signed personal certificate for audit encryption");
                    }
                    msg = this.getMsg(resBundle, "security.admintask.ImportCertFailure", null);
                    if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                        msg = msg.concat(": ");
                        msg = msg.concat(cmdResult.getException().getMessage());
                    }
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
                if (this.autogenCert != null && !this.autogenCert.booleanValue() && this.importCert != null && !this.importCert.booleanValue() && this.certAlias != null && this.certAlias.length() != 0) {
                    CommandMgr commandMgr = CommandMgr.getCommandMgr();
                    getUserCmd = commandMgr.createCommand("listCertAliases");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keyStoreName: " + this.encryptionKeyStoreName);
                    }
                    getUserCmd.setParameter("keyStoreName", this.encryptionKeyStoreName);
                    getUserCmd.setConfigSession(session);
                    getUserCmd.execute();
                    CommandResult cmdResult = getUserCmd.getCommandResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cmdResult.isSuccessful: " + cmdResult.isSuccessful());
                        Tr.debug(tc, "cmdResult.getResult: " + cmdResult.getResult().toString());
                    }
                    if (cmdResult.isSuccessful()) {
                        String a;
                        int j;
                        boolean foundCert = false;
                        ArrayList aList = (ArrayList)cmdResult.getResult();
                        for (j = 0; j < aList.size(); ++j) {
                            a = (String)aList.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "alias: " + a + " matching with certAlias: " + this.certAlias);
                            }
                            if (!a.equals(this.certAlias)) continue;
                            foundCert = true;
                        }
                        if (!foundCert) {
                            if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                                for (j = 0; j < aList.size(); ++j) {
                                    a = (String)aList.get(j);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "alias: " + a + " matching with z certAlias: " + this.origCertAlias);
                                    }
                                    if (!a.equals(this.origCertAlias)) continue;
                                    foundCert = true;
                                }
                            }
                            if (!foundCert) {
                                String msg4 = this.getMsg(resBundle, "security.admintask.CertNotInKeyStore", null);
                                result.addWarnings(msg4);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg4));
                                return;
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Was unsuccessful listing the certificate aliases in the referenced keystore");
                        }
                        msg = this.getMsg(resBundle, "security.admintask.ListCertFailure", null);
                        if (cmdResult.getException() != null && cmdResult.getException().getMessage() != null) {
                            msg = msg.concat(": ");
                            msg = msg.concat(cmdResult.getException().getMessage());
                        }
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                }
                ArrayList certList = (ArrayList)cs.getAttribute(session, audit, "certificates");
                ObjectName certObj = null;
                if (certList.size() == 0) {
                    AttributeList certObjAttrs = new AttributeList();
                    certObjAttrs.add(new Attribute("alias", this.certAlias));
                    certObjAttrs.add(new Attribute("keyStore", this.keyStoreCreated));
                    certObj = cs.createConfigData(session, audit, "certificates", "Certificate", certObjAttrs);
                    if (certObj == null) {
                        msg = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                        msg = msg.concat(": Certificate");
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                } else {
                    for (int i = 0; i < certList.size(); ++i) {
                        AttributeList certAttrs = (AttributeList)certList.get(i);
                        certObj = ConfigServiceHelper.createObjectName(certAttrs);
                        AttributeList newSettings = new AttributeList();
                        newSettings.add(new Attribute("alias", this.certAlias));
                        newSettings.add(new Attribute("keyStore", this.keyStoreCreated));
                        cs.setAttributes(session, certObj, newSettings);
                    }
                }
                settings.add(new Attribute("encryptionCert", certObj));
            }
            cs.setAttributes(session, policyObject, settings);
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.encryption.ModifyAuditEncryptionConfig.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            e.printStackTrace();
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.encryption.ModifyAuditEncryptionConfig.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            e.printStackTrace();
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

