/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmdController;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractivePrompt;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class AdminCmdInteractiveTableStepsPrompt
extends AdminCmdInteractivePrompt {
    private static TraceComponent tc = Tr.register(AdminCmdInteractiveTableStepsPrompt.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected static String add;
    protected static String delete;
    protected static String addSelection;
    protected static String addBeforeSelection;
    protected static String deleteSelection;
    private CommandStep cmdStep;
    private String defaultSelection;
    private String completeStepMsg;
    private boolean selectStepFound;
    private boolean hasRequiredData;
    private Vector selectionIndex;
    private Vector keyNames;
    private int selectRowIndex;
    private boolean addAllowed;
    private boolean _isAsyncProcess = false;

    public AdminCmdInteractiveTableStepsPrompt(AdminCmdController adminCmdController) {
        super(adminCmdController);
        this._init();
    }

    public AdminCmdInteractiveTableStepsPrompt(AdminCmdController adminCmdController, boolean isAsyncProcess) {
        super(adminCmdController);
        this._init();
        this._isAsyncProcess = isAsyncProcess;
    }

    private void _init() {
        this.completeStepMsg = "";
        add = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_ADD_HOTKEY", new Object[0], "A");
        delete = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_DELETE_HOTKEY", new Object[0], "D");
        addSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_ADD_SELECTION", new Object[0], "A (Add Row)");
        addBeforeSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_ADD_BEFORE_SELECTION", new Object[0], "A (Add Row Before)");
        deleteSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_DELETE_SELECTION", new Object[0], "D (Delete Row)");
        selectSelection = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_SELECT_ROW_SELECTION", new Object[0], "S (Select Row)");
    }

    protected void setAdminCommand(AdminCommand adminCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminCommand");
        }
        this.cmdStep = (CommandStep)adminCmd;
        this.selectStepFound = false;
        this.hasRequiredData = false;
        this.defaultSelection = select;
        this.keyNames = null;
        this.selectRowIndex = 0;
        this.addAllowed = ((CommandStepMetadata)this.cmdStep.getCommandMetadata()).isEnableAddRows();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminCommand");
        }
    }

    protected String getTitle() {
        return AdminCmdController.nl + this.getMetadataTitle(this.cmdStep.getCommandMetadata()) + " (" + this.cmdStep.getName() + ")";
    }

    protected String getDescription() throws Throwable {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription");
        }
        StringBuffer desc = new StringBuffer();
        this.keyNames = this.getKeyNamesForTable((CommandStepMetadata)this.cmdStep.getCommandMetadata());
        StringBuffer keyNamesString = new StringBuffer();
        if (!this.keyNames.isEmpty()) {
            for (i = 0; i < this.keyNames.size(); ++i) {
                if (keyNamesString.length() != 0) {
                    keyNamesString.append(", ");
                }
                String[] key = (String[])this.keyNames.get(i);
                keyNamesString.append(key[0]);
                keyNamesString.append(" (");
                keyNamesString.append(key[1]);
                keyNamesString.append(")");
            }
        } else {
            throw new ScriptingException(this._adminCmdController.getShell().getFormattedMessage("WASX8017E", new Object[]{this.cmdStep.getName()}, "Step " + this.cmdStep.getName() + " does not contain any key"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription - " + keyNamesString.toString());
        }
        desc.append("    | " + keyNamesString.toString());
        desc.append(AdminCmdController.nl);
        desc.append("    --");
        for (i = 0; i < keyNamesString.length(); ++i) {
            desc.append("-");
        }
        return desc.toString();
    }

    private Vector getKeyNamesForTable(CommandStepMetadata cmdMetadata) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyNamesForTable");
        }
        Vector<String[]> ret = new Vector<String[]>();
        EList paramList = cmdMetadata.getParameters();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of parameter: " + paramList.size());
        }
        for (int j = 0; j < paramList.size(); ++j) {
            ParameterMetadata paramMetadata = (ParameterMetadata)paramList.get(j);
            if (!paramMetadata.isKeyField()) continue;
            String[] buf = new String[]{this.getMetadataTitle(paramMetadata), paramMetadata.getName()};
            ret.addElement(buf);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyNamesForTable - " + ret.toString());
        }
        return ret;
    }

    protected boolean isLoopDone(String answer) {
        if (answer == null) {
            answer = this.defaultSelection;
        }
        if (!this._isAsyncProcess) {
            return answer != null && !answer.equalsIgnoreCase(finish);
        }
        return answer != null && !answer.equalsIgnoreCase(kontinue);
    }

    protected String getStepTitles() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepTitles");
        }
        StringBuffer existingRows = new StringBuffer();
        this.hasRequiredData = false;
        this.selectStepFound = false;
        if (this.cmdStep.getNumberOfRows() > 0) {
            for (int i = 0; i < this.cmdStep.getNumberOfRows(); ++i) {
                if (i == this.selectRowIndex) {
                    this.selectStepFound = true;
                    if (this.cmdStep.isRequired(i)) {
                        existingRows.append("-> " + "*");
                        this.hasRequiredData = true;
                    } else {
                        existingRows.append("->  ");
                    }
                } else if (this.cmdStep.isRequired(i)) {
                    existingRows.append("   " + "*");
                    this.hasRequiredData = true;
                } else {
                    existingRows.append("    ");
                }
                existingRows.append("| ");
                for (int j = 0; j < this.keyNames.size(); ++j) {
                    String[] key = (String[])this.keyNames.get(j);
                    Object value = this.cmdStep.getParameter(key[1], i);
                    String valueString = "";
                    if (value != null) {
                        existingRows.append(this._adminCmdController.getHandler().formDisplayString(value, this._adminCmdController.getShell().getLang()));
                    } else {
                        existingRows.append("\"\"");
                    }
                    if (j + 1 >= this.keyNames.size()) continue;
                    existingRows.append(", ");
                }
                existingRows.append(AdminCmdController.nl);
            }
        }
        if (!this.selectStepFound && this.cmdStep.getNumberOfRows() > 0) {
            existingRows.append("->  ");
            existingRows.append(this.completeStepMsg);
            existingRows.append(AdminCmdController.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepTitles - " + existingRows.toString());
        }
        return existingRows.toString();
    }

    protected String getSelectionMenu() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionMenu");
        }
        StringBuffer selectionBuf = new StringBuffer();
        this.selectionIndex = new Vector();
        this.defaultSelection = select;
        if (this.selectStepFound) {
            selectionBuf.append(selectSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(select);
        }
        if (this.selectRowIndex + 1 <= this.cmdStep.getNumberOfRows()) {
            selectionBuf.append(nextSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(next);
        } else if (!this.selectStepFound && this.cmdStep.getNumberOfRows() > 0) {
            this.defaultSelection = previous;
        }
        if (this.selectRowIndex > 0) {
            selectionBuf.append(previousSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(previous);
        }
        if (this.addAllowed) {
            if (!this.selectStepFound) {
                this.defaultSelection = add;
            }
            if (this.cmdStep.getNumberOfRows() == 0) {
                selectionBuf.append(addSelection);
            } else {
                selectionBuf.append(addBeforeSelection);
            }
            selectionBuf.append(nl);
            this.selectionIndex.addElement(add);
            if (this.cmdStep.getNumberOfRows() > 0 && this.selectStepFound) {
                selectionBuf.append(deleteSelection);
                selectionBuf.append(nl);
                this.selectionIndex.addElement(delete);
            }
        }
        if (!this.hasRequiredData) {
            if (!this._isAsyncProcess) {
                selectionBuf.append(finishSelection);
                selectionBuf.append(AdminCmdController.nl);
                this.selectionIndex.addElement(finish);
                if (this.cmdStep.getNumberOfRows() != 0) {
                    this.defaultSelection = finish;
                }
            } else {
                selectionBuf.append(kontinueSelection);
                selectionBuf.append(AdminCmdController.nl);
                this.selectionIndex.addElement(kontinue);
                if (this.cmdStep.getNumberOfRows() != 0) {
                    this.defaultSelection = kontinue;
                }
            }
        }
        selectionBuf.append(helpSelection);
        selectionBuf.append(AdminCmdController.nl);
        this.selectionIndex.addElement(help);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionMenu - " + selectionBuf.toString());
        }
        return selectionBuf.toString();
    }

    protected String getSelectionPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionPrompt");
        }
        StringBuffer selectionIndexBuf = new StringBuffer();
        if (!this.selectionIndex.isEmpty()) {
            Enumeration e = this.selectionIndex.elements();
            while (e.hasMoreElements()) {
                if (selectionIndexBuf.length() != 0) {
                    selectionIndexBuf.append(", ");
                }
                selectionIndexBuf.append((String)e.nextElement());
            }
        }
        String promptMsg = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{selectionIndexBuf.toString(), this.defaultSelection}, "Select [" + selectionIndexBuf.toString() + "] : [" + this.defaultSelection + "] ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionPrompt - " + promptMsg);
        }
        return promptMsg;
    }

    protected String getDefaultSelection() {
        return this.defaultSelection;
    }

    protected boolean validateAnswer(String answer) {
        if (answer == null) {
            answer = this.defaultSelection;
        }
        return answer != null && (this.selectionIndex.contains(answer.toUpperCase()) || this.selectionIndex.contains(answer.toLowerCase()));
    }

    protected boolean processSelection(String selection) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSelection", new Object[]{selection});
        }
        boolean ret = true;
        if (selection == null) {
            selection = this.defaultSelection;
        }
        if (selection != null && selection.equalsIgnoreCase(select)) {
            this._adminCmdController.promptParameters(this.cmdStep, this.cmdStep.getCommandMetadata(), true, this.selectRowIndex);
            ++this.selectRowIndex;
        } else if (selection != null && selection.equalsIgnoreCase(next)) {
            ++this.selectRowIndex;
        } else if (selection != null && selection.equalsIgnoreCase(previous)) {
            this.selectRowIndex = !this.selectStepFound ? this.cmdStep.getNumberOfRows() - 1 : --this.selectRowIndex;
        } else if (selection != null && selection.equalsIgnoreCase(add)) {
            this._adminCmdController.promptParameters(this.cmdStep, this.cmdStep.getCommandMetadata(), true, this.selectRowIndex, this.addAllowed);
            ++this.selectRowIndex;
        } else if (selection.equalsIgnoreCase(delete)) {
            this.cmdStep.deleteRow(this.selectRowIndex);
        } else if (selection.equalsIgnoreCase(help)) {
            this._adminCmdController.processStepHelp(this.cmdStep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSelection");
        }
        return ret;
    }

    public boolean processTaskSteps(AdminCommand adminCmd) throws Throwable {
        String title;
        String desc;
        String answer;
        boolean ret;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processTaskSteps");
            }
            ret = true;
            answer = null;
            desc = null;
            title = null;
            this.setAdminCommand(adminCmd);
            title = this.getTitle();
            try {
                desc = this.getDescription();
            }
            catch (ScriptingException se) {
                if (se.toString().indexOf("WASX8017E") <= 0) break block7;
                System.out.println(se.toString() + AdminCmdController.nl);
                return false;
            }
        }
        while (this.isLoopDone(answer)) {
            String steps = this.getStepTitles();
            String batchDesc = this.getBatchDescription();
            String menu = this.getSelectionMenu();
            String prompt = this.getSelectionPrompt();
            String defaultSelection = this.getDefaultSelection();
            StringBuffer stepDisplay = new StringBuffer();
            stepDisplay.append(title + AdminCmdController.nl + AdminCmdController.nl + desc + AdminCmdController.nl + steps + AdminCmdController.nl);
            if (steps.length() > 0) {
                stepDisplay.append(batchDesc + AdminCmdController.nl + AdminCmdController.nl);
            }
            stepDisplay.append(menu + AdminCmdController.nl + prompt);
            answer = this._adminCmdController.promptInput(stepDisplay.toString(), true, defaultSelection);
            while (!this.validateAnswer(answer)) {
                answer = this._adminCmdController.promptInput(AdminCmdController.nl + prompt, true, defaultSelection);
            }
            ret = this.processSelection(answer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTaskSteps");
        }
        return ret;
    }

    private String getBatchDescription() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBatchDescription");
        }
        StringBuffer buf = new StringBuffer();
        if (!this.keyNames.isEmpty()) {
            for (int i = 0; i < this.keyNames.size(); ++i) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                String[] key = (String[])this.keyNames.get(i);
                buf.append(key[0]);
            }
        }
        String ret = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_STEP_BATCH_FIELD_DESC", new Object[]{buf.toString()}, buf.toString() + " are required for batch mode");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBatchDescription - " + ret);
        }
        return ret;
    }
}

