/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.async.client.AsyncCommandClient;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.DefaultStringHandler;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import com.ibm.ws.scripting.adminCommand.AdminCmdHelp;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractiveStepsPrompt;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractiveTableStepsPrompt;
import com.ibm.ws.scripting.adminCommand.AdminCmdReadOnlyCommand;
import com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator;
import com.ibm.ws.scripting.adminCommand.AsyncCmdHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.eclipse.emf.common.util.EList;

public class AdminCmdController
extends AdminCmd {
    public static final String REQUIRED_NOTATION = "*";
    private static TraceComponent tc = Tr.register(AdminCmdController.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected LanguageUtilities _langutils;
    private static String select;
    private static String finish;
    private static String cancel;
    private static String kontinue;
    private static String edit;
    private static String selectSelection;
    private static String finishSelection;
    private static String cancelSelection;
    private static String kontinueSelection;
    private static String editSelection;
    private StringHandler _handler;
    private AbstractShell _shell;
    private AdminCmdClient _adminCmdClient;
    private AdminCmdHelp _adminCmdHelp;
    private AdminCmdScriptGenerator _adminCmdScriptGen;
    private static boolean isAsyncCommand;

    public AdminCmdController() {
    }

    public AdminCmdController(AdminCmdClient cmdClient) throws ScriptingException {
        this._adminCmdClient = cmdClient;
        this._shell = this._adminCmdClient.getShell();
        this._handler = new DefaultStringHandler(this._shell);
        this._langutils = this._shell.getLangUtils();
        this._adminCmdHelp = new AdminCmdHelp(this._adminCmdClient);
        this._adminCmdScriptGen = new AdminCmdScriptGenerator(this._adminCmdClient.getShell().getLang());
        select = this._shell.getFormattedMessage("ADMINTASK_SELECT_HOTKEY", new Object[0], "S");
        finish = this._shell.getFormattedMessage("ADMINTASK_FINISH_HOTKEY", new Object[0], "F");
        cancel = this._shell.getFormattedMessage("ADMINTASK_CANCEL_HOTKEY", new Object[0], "C");
        edit = this._shell.getFormattedMessage("ADMINTASK_EDIT_HOTKEY", new Object[0], "E");
        kontinue = this._shell.getFormattedMessage("ADMINTASK_CONTINUE_HOTKEY", new Object[0], "U");
        selectSelection = this._shell.getFormattedMessage("ADMINTASK_SELECT_SELECTION", new Object[0], "S (Select");
        finishSelection = this._shell.getFormattedMessage("ADMINTASK_FINISH_SELECTION", new Object[0], "F (Finish");
        cancelSelection = this._shell.getFormattedMessage("ADMINTASK_CANCEL_SELECTION", new Object[0], "C (Cancel)");
        editSelection = this._shell.getFormattedMessage("ADMINTASK_EDIT_SELECTION", new Object[0], "E (Edit)");
        kontinueSelection = this._shell.getFormattedMessage("ADMINTASK_CONTINUE_SELECTION", new Object[0], "U (Continue)");
    }

    public AbstractShell getShell() {
        return this._shell;
    }

    public StringHandler getHandler() {
        return this._handler;
    }

    public String processCmd(String cmdName, Object[] args) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCmd", new Object[]{cmdName, args});
        }
        AdminCommand taskCmd = null;
        boolean isExecute = true;
        String ret = null;
        isAsyncCommand = false;
        taskCmd = this._adminCmdClient.getCommandMgr().createCommand(cmdName);
        AdminConfigClient cfgClient = AdminConfigClient.getInstance();
        AsyncCommandClient asyncCmdClientHelper = null;
        if (cfgClient != null) {
            taskCmd.setConfigSession(cfgClient.getCurrentSession());
            AsyncCmdHandler cmdListener = new AsyncCmdHandler();
            asyncCmdClientHelper = new AsyncCommandClient(cfgClient.getCurrentSession(), cmdListener);
        }
        taskCmd.setLocale(Locale.getDefault());
        try {
            CommandMetadata cmdMetadata = taskCmd.getCommandMetadata();
            boolean interactive = false;
            Hashtable optionProps = new Hashtable();
            boolean readOnlyCommand = false;
            if (args != null) {
                ArgsParseResult result = this.parseArgs(cmdMetadata, args);
                String targetObject = result.targetObj;
                optionProps = result.optionTable;
                if (optionProps != null && optionProps.containsKey("interactive")) {
                    optionProps.remove("interactive");
                    interactive = true;
                }
                if (targetObject != null) {
                    this.processTargetObject(taskCmd, cmdMetadata, targetObject);
                }
                if (optionProps != null && optionProps.size() > 0) {
                    this.processOptions(taskCmd, cmdMetadata, optionProps);
                }
            }
            if (interactive) {
                isExecute = this.processInteractiveTargetParams(taskCmd, cmdMetadata);
            }
            if (taskCmd.isAsyncCommand() && taskCmd instanceof TaskCommand) {
                asyncCmdClientHelper.setStepDisplayFormat(taskCmd, "MultipleScopesPerStepFormatValue");
                asyncCmdClientHelper.processCommandParameters(taskCmd);
            }
            if (optionProps != null && !optionProps.isEmpty()) {
                if (cmdMetadata instanceof TaskCommandMetadata) {
                    this.processSteps((TaskCommand)taskCmd, optionProps, false);
                } else {
                    this._shell.setAndThrowScriptingException("WASX8009E", "Invalid parameter: " + optionProps, new Object[]{optionProps});
                }
            }
            if (taskCmd.isAsyncCommand() && taskCmd instanceof TaskCommand) {
                readOnlyCommand = AdminCmdReadOnlyCommand.isReadOnlyCommand(taskCmd);
            }
            if (interactive && !readOnlyCommand) {
                isExecute = this.processInteractiveSteps(taskCmd, cmdMetadata);
            } else if (readOnlyCommand) {
                AdminCmdReadOnlyCommand.displayCmd(taskCmd, this, false);
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "processCmd error " + th.getCause());
            this._shell.setLastException((Exception)th);
            throw new ScriptingException(th.getCause(), th.toString());
        }
        if (isExecute) {
            ret = this.executeCmd(taskCmd, asyncCmdClientHelper);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCmd - " + ret);
        }
        return ret;
    }

    private ArgsParseResult parseArgs(CommandMetadata cmdMetadata, Object[] args) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseArgs", new Object[]{cmdMetadata, args});
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String targetObject = null;
        Hashtable optionProps = null;
        Hashtable<String, String> optionPropsLog = new Hashtable<String, String>();
        String strArg = null;
        String argClassName = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "arg length: " + args.length);
        }
        if (args.length > 1) {
            targetObject = (String)args[0];
            argClassName = args[1].getClass().getName();
            strArg = !argClassName.equals("java.lang.String") ? this._langutils.objectArrayToString((Object[])args[1]) : args[1].toString();
            optionProps = this._langutils.optionsToHashtable(strArg);
            Enumeration vEnum = optionProps.keys();
            while (vEnum.hasMoreElements()) {
                String temp = (String)vEnum.nextElement();
                Object value = optionProps.get(temp);
                if (this._shell.getLang().equalsIgnoreCase("jacl") && value.toString().equals("''")) {
                    optionProps.put(temp, "");
                }
                if (temp.toLowerCase().indexOf("password") != -1 || temp.toLowerCase().indexOf("pwd") != -1 || temp.toLowerCase().indexOf("passwd") != -1) {
                    optionPropsLog.put(temp, "*****");
                    continue;
                }
                optionPropsLog.put(temp, (String)optionProps.get(temp));
            }
        } else if (args.length == 1) {
            int target = this.getTargetObjectRequired(cmdMetadata);
            argClassName = args[0].getClass().getName();
            strArg = !argClassName.equals("java.lang.String") ? this._langutils.objectArrayToString((Object[])args[0]) : args[0].toString();
            try {
                optionProps = this._langutils.optionsToHashtable(strArg);
                Enumeration vEnum = optionProps.keys();
                while (vEnum.hasMoreElements()) {
                    String temp = (String)vEnum.nextElement();
                    Object value = optionProps.get(temp);
                    if (this._shell.getLang().equalsIgnoreCase("jacl") && value.toString().equals("''")) {
                        optionProps.put(temp, "");
                    }
                    if (temp.toLowerCase().indexOf("password") != -1 || temp.toLowerCase().indexOf("pwd") != -1 || temp.toLowerCase().indexOf("passwd") != -1) {
                        optionPropsLog.put(temp, "*****");
                        continue;
                    }
                    optionPropsLog.put(temp, (String)optionProps.get(temp));
                }
            }
            catch (IllegalArgumentException iae) {
                optionProps = null;
                if (target != 2) {
                    targetObject = (String)args[0];
                }
                this._shell.setAndThrowScriptingException("WASX8009E", "Invalid argument: " + args[0], new Object[]{args[0]});
            }
        }
        ArgsParseResult result = new ArgsParseResult();
        ArgsParseResult resultLog = new ArgsParseResult();
        result.targetObj = targetObject;
        result.optionTable = optionProps;
        resultLog.targetObj = targetObject;
        resultLog.optionTable = optionPropsLog;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseArgs - " + resultLog.targetObj + " " + resultLog.optionTable);
        }
        return result;
    }

    private void processTargetObject(AdminCommand adminCmd, CommandMetadata cmdMetadata, String targetObject) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTargetObject", new Object[]{targetObject});
        }
        Object obj = this.formValidObject(cmdMetadata.getTargetObjectType(), targetObject, false);
        adminCmd.setTargetObject(obj);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTargetObject");
        }
    }

    private void processOptions(AdminCommand adminCmd, CommandMetadata cmdMetadata, Hashtable optionProps) throws Throwable {
        Hashtable<String, String> optionPropsLog = new Hashtable<String, String>();
        Enumeration vEnum = optionProps.keys();
        while (vEnum.hasMoreElements()) {
            String temp = (String)vEnum.nextElement();
            if (temp.toLowerCase().indexOf("password") != -1 || temp.toLowerCase().indexOf("pwd") != -1 || temp.toLowerCase().indexOf("passwd") != -1) {
                optionPropsLog.put(temp, "*****");
                continue;
            }
            optionPropsLog.put(temp, (String)optionProps.get(temp));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processOptions", new Object[]{optionPropsLog});
        }
        this.processParameters(adminCmd, cmdMetadata, optionProps);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "optionProps - " + optionProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processOptions");
        }
    }

    private void processParameters(AdminCommand adminCmd, CommandMetadata cmdMetadata, Hashtable optionProps) throws Throwable {
        Hashtable<String, String> optionPropsLog = new Hashtable<String, String>();
        Enumeration oEnum = optionProps.keys();
        while (oEnum.hasMoreElements()) {
            String temp = (String)oEnum.nextElement();
            if (temp.toLowerCase().indexOf("password") != -1 || temp.toLowerCase().indexOf("pwd") != -1 || temp.toLowerCase().indexOf("passwd") != -1) {
                optionPropsLog.put(temp, "*****");
                continue;
            }
            optionPropsLog.put(temp, (String)optionProps.get(temp));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processParameters", new Object[]{optionPropsLog});
        }
        boolean isBraceSupported = false;
        EList custom = cmdMetadata.getCustom();
        if (custom != null && !custom.isEmpty()) {
            for (CustomProperties cp : custom) {
                Tr.debug(tc, "custom property: " + cp.getKey());
                if (!cp.getKey().equalsIgnoreCase("SupportBracesForPropParams")) continue;
                EList valueList = cp.getValue();
                Tr.debug(tc, "Valus of custom " + cp.getKey() + " = " + valueList);
                if (valueList == null || valueList.isEmpty()) continue;
                String value = (String)valueList.iterator().next();
                isBraceSupported = value.equalsIgnoreCase("true");
                break;
            }
        }
        Vector<String> deleted = new Vector<String>();
        Enumeration vEnum = optionProps.keys();
        boolean isParameter = true;
        while (vEnum.hasMoreElements()) {
            ParameterMetadata paramMetadata = null;
            String key = (String)vEnum.nextElement();
            Object value = optionProps.get(key);
            try {
                paramMetadata = this.getParameterMetadata(cmdMetadata, key);
                if (value instanceof List) {
                    String attrListInString;
                    if (cmdMetadata instanceof TaskCommandMetadata && !paramMetadata.getType().equals("java.util.Hashtable") && !paramMetadata.getType().equals("java.util.Properties") && !paramMetadata.getType().equals("javax.management.AttributeList")) continue;
                    if (paramMetadata.getType().equals("javax.management.AttributeList")) {
                        attrListInString = this._langutils.arrayListToStringForAdminTask((ArrayList)value);
                        value = attrListInString;
                    } else if (paramMetadata.getType().equals("java.util.ArrayList") || paramMetadata.getType().equals("java.util.List")) {
                        attrListInString = this._langutils.listToStringForAdminTask((ArrayList)value);
                        value = attrListInString;
                    } else if (paramMetadata.getType().equals("java.util.Hashtable") || paramMetadata.getType().equals("java.util.Properties")) {
                        attrListInString = this._langutils.arrayListToStringForAdminTask((ArrayList)value);
                        attrListInString = this._shell.getLang().equalsIgnoreCase("jacl") ? "{" + attrListInString + "}" : "[" + attrListInString + "]";
                        value = attrListInString;
                    } else {
                        this._shell.setAndThrowScriptingException("WASX8015E", "Invalid option value for ", new Object[]{key, value});
                    }
                }
                if (paramMetadata != null && !adminCmd.isPrivateParameter(paramMetadata.getName())) {
                    isParameter = true;
                }
            }
            catch (ScriptingException se) {
                if (cmdMetadata instanceof TaskCommandMetadata) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Swallow scripting exception: " + se.toString());
                    }
                    isParameter = false;
                }
                this._shell.setLastException(se);
                throw se;
            }
            if (!isParameter) continue;
            if ((paramMetadata.getType().equals("java.lang.Boolean") || paramMetadata.getType().equals("Boolean")) && (value == null || value.toString().trim().length() == 0)) {
                value = paramMetadata.getDefaultValue();
                if (value == null) {
                    value = "true";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting " + paramMetadata.getName() + " to " + value.toString());
                }
            }
            Object obj = this.formValidObject(paramMetadata.getType(), (String)value, isBraceSupported);
            adminCmd.setParameter(key, obj);
            deleted.addElement(key);
        }
        if (!deleted.isEmpty()) {
            Enumeration e = deleted.elements();
            while (e.hasMoreElements()) {
                optionProps.remove((String)e.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processParameters");
        }
    }

    private void processSteps(TaskCommand taskCmd, Hashtable optionProps, boolean deleteOption) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSteps - " + optionProps + " " + deleteOption);
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        String[] stepNames = taskCmd.listCommandSteps();
        Enumeration vEnum = optionProps.keys();
        while (vEnum.hasMoreElements()) {
            int i;
            String str;
            CommandStep cmdStep = null;
            String key = (String)vEnum.nextElement();
            Object value = optionProps.get(key);
            if (value == null) continue;
            if (key.equals("delete")) {
                Hashtable deleteStep = this._langutils.optionsToHashtable((String)value);
                this.processSteps(taskCmd, deleteStep, true);
                continue;
            }
            if (!taskCmd.isAsyncCommand()) {
                try {
                    cmdStep = taskCmd.getCommandStep(key);
                }
                catch (CommandNotFoundException cnfe) {
                    this._shell.setLastException(cnfe);
                    throw new ScriptingException(cnfe.toString());
                }
            }
            try {
                cmdStep = taskCmd.gotoStep(key);
            }
            catch (NoSuchElementException nsee) {
                this._shell.setLastException(nsee);
                throw new ScriptingException(nsee.toString());
            }
            if (!cmdStep.isEnabled()) {
                this._shell.setAndThrowScriptingException("WASX8012E", "step " + key + " is not enabled", new Object[]{key});
            }
            boolean isBraceSupported = false;
            EList custom = cmdStep.getCommandMetadata().getCustom();
            if (custom != null && !custom.isEmpty()) {
                for (CustomProperties cp : custom) {
                    Tr.debug(tc, "custom property: " + cp.getKey());
                    if (!cp.getKey().equalsIgnoreCase("SupportBracesForPropParams")) continue;
                    EList valueList = cp.getValue();
                    Tr.debug(tc, "Valus of custom " + cp.getKey() + " = " + valueList);
                    if (valueList == null || valueList.isEmpty()) continue;
                    String cuValue = (String)valueList.iterator().next();
                    isBraceSupported = cuValue.equalsIgnoreCase("true");
                    break;
                }
            }
            EList paramList = cmdStep.getCommandMetadata().getParameters();
            boolean isTable = ((CommandStepMetadata)cmdStep.getCommandMetadata()).isTable();
            boolean isAddAllowed = ((CommandStepMetadata)cmdStep.getCommandMetadata()).isEnableAddRows();
            if (value != null && this._shell.getLang().equalsIgnoreCase("jython") && ((str = value.toString()).trim().startsWith("\"") || str.trim().startsWith("'")) && (str.trim().endsWith("\"") || str.trim().endsWith("'")) && str.trim().indexOf("-") != -1) {
                StringTokenizer strtok = new StringTokenizer(str, " ", false);
                StringBuffer ret = new StringBuffer();
                while (strtok.hasMoreTokens()) {
                    String next = strtok.nextToken();
                    next = next.substring(1, next.length() - 1) + " ";
                    ret.append(next);
                }
                value = ret.toString();
            }
            if (!(value instanceof List)) {
                if (isTable) {
                    int i2;
                    for (i2 = 0; i2 < stepNames.length && !stepNames[i2].equals(key); ++i2) {
                    }
                    if (i2 < stepNames.length) {
                        this._shell.setAndThrowScriptingException("WASX8015E", "Invalid option value for ", new Object[]{key, value});
                    } else {
                        this._shell.setAndThrowScriptingException("WASX8009E", "Invalid parameter: " + key, new Object[]{key});
                    }
                } else {
                    CommandMetadata stepMetadata = cmdStep.getCommandMetadata();
                    ArgsParseResult parseResult = this.parseArgs(stepMetadata, new Object[]{value});
                    Hashtable optTable = parseResult.optionTable;
                    if (optTable != null && optTable.size() != 0) {
                        this.processParameters(cmdStep, stepMetadata, optTable);
                        continue;
                    }
                    this._shell.setAndThrowScriptingException("WASX8015E", "Invalid option value for ", new Object[]{key, value});
                }
            }
            if (!isTable && ((List)value).size() > 1) {
                this._shell.setAndThrowScriptingException("WASX8014E", "step " + key + " is not a table", new Object[]{key});
            }
            int numOfRows = cmdStep.getNumberOfRows();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step " + key + " has " + numOfRows + " row(s)");
            }
            String[] keys = null;
            if (numOfRows > 0) {
                keys = this.buildKeyFromTableStep(cmdStep, numOfRows, paramList);
            }
            Boolean[] deleteRows = new Boolean[numOfRows];
            for (int j = 0; j < numOfRows; ++j) {
                deleteRows[j] = Boolean.FALSE;
            }
            for (i = 0; i < ((List)value).size(); ++i) {
                List row = (List)((List)value).get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "row " + i + " : " + row);
                }
                if (row.size() == 0) continue;
                StringBuffer buf = new StringBuffer();
                ArrayList<Integer> matches = new ArrayList<Integer>();
                if (numOfRows > 0) {
                    int k = 0;
                    for (int j = 0; j < paramList.size(); ++j) {
                        ParameterMetadata paramMetadata = (ParameterMetadata)paramList.get(j);
                        Tr.debug(tc, "parameter name " + paramMetadata.getName());
                        if (cmdStep.isPrivateParameter(paramMetadata.getName()) || !paramMetadata.isKeyField()) continue;
                        int index = j;
                        if (deleteOption) {
                            index = k++;
                        }
                        if (row.size() > index) {
                            buf.append(row.get(index));
                            buf.append(" ");
                            continue;
                        }
                        this._shell.setAndThrowScriptingException("WASX8019E", "Incorrect number of key fields provided for step " + key + ": " + row.toString(), new Object[]{key, row.toString()});
                    }
                    String inputKey = buf.toString().trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "input key: " + inputKey);
                    }
                    for (int j = 0; j < keys.length; ++j) {
                        if (!taskCmd.isAsyncCommand()) {
                            if (!keys[j].equals(inputKey)) continue;
                            Tr.debug(tc, "key[j] " + j + " matches input key " + inputKey);
                            matches.add(new Integer(j));
                            break;
                        }
                        if (!keys[j].matches(inputKey)) continue;
                        Tr.debug(tc, "key[j] " + j + " matches input key " + inputKey);
                        matches.add(new Integer(j));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "matching index: " + matches);
                    }
                    if (matches.size() == 0) {
                        if (!deleteOption && isAddAllowed) {
                            matches.add(new Integer(cmdStep.getNumberOfRows()));
                        } else {
                            this._shell.setAndThrowScriptingException("WASX8018E", "Cannot find a match for supplied options " + row.toString() + " for step " + key, new Object[]{row.toString(), key});
                        }
                    }
                } else if (deleteOption || !isAddAllowed) {
                    this._shell.setAndThrowScriptingException("WASX8018E", "Cannot find a match for supplied options " + row.toString() + " for step " + key, new Object[]{row.toString(), key});
                }
                if (deleteOption) {
                    for (int r = 0; r < matches.size(); ++r) {
                        deleteRows[((Integer)matches.get((int)r)).intValue()] = Boolean.TRUE;
                    }
                    continue;
                }
                AttributeList attrList = new AttributeList();
                int size = row.size() >= paramList.size() ? paramList.size() : row.size();
                Tr.debug(tc, "param list size " + paramList.size());
                Tr.debug(tc, "row size " + row.size());
                if (matches.size() == 0) {
                    matches.add(new Integer(cmdStep.getNumberOfRows()));
                }
                for (int m = 0; m < matches.size(); ++m) {
                    int match = (Integer)matches.get(m);
                    for (int j = 0; j < size; ++j) {
                        String inputValue;
                        ParameterMetadata paramMetadata = (ParameterMetadata)paramList.get(j);
                        Tr.debug(tc, "parameter name " + paramMetadata.getName());
                        if (cmdStep.isPrivateParameter(paramMetadata.getName())) continue;
                        Tr.debug(tc, "match: " + match);
                        if (numOfRows == 0 && ((String)row.get(j)).trim().length() == 0) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Skip setting " + paramMetadata.getName());
                            continue;
                        }
                        if (isTable && match >= cmdStep.getNumberOfRows()) {
                            if (((String)row.get(j)).length() <= 0) continue;
                            Attribute attr = new Attribute(paramMetadata.getName(), this.formValidObject(paramMetadata.getType(), (String)row.get(j), isBraceSupported));
                            attrList.add(attr);
                            continue;
                        }
                        if (paramMetadata.isReadonly() || (inputValue = ((String)row.get(j)).trim()).length() <= 0 || inputValue.equals(".*")) continue;
                        Object paramValue = null;
                        paramValue = this.formValidObject(paramMetadata.getType(), (String)row.get(j), isBraceSupported);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting " + paramMetadata.getName() + " to " + paramValue);
                        }
                        cmdStep.setParameter(paramMetadata.getName(), paramValue, match);
                    }
                    if (!isTable || match < cmdStep.getNumberOfRows()) continue;
                    cmdStep.addRow(attrList, match);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Adding new row " + match + ": " + attrList);
                }
            }
            if (!deleteOption) continue;
            for (i = deleteRows.length - 1; i >= 0; --i) {
                if (!deleteRows[i].booleanValue()) continue;
                cmdStep.deleteRow(i);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Deleting row " + i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSteps");
        }
    }

    private String[] buildKeyFromTableStep(CommandStep cmdStep, int numOfRows, EList paramList) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildKeyFromTableStep");
        }
        String[] keys = new String[numOfRows];
        if (numOfRows > 0) {
            keys = new String[numOfRows];
            for (int i = 0; i < numOfRows; ++i) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < paramList.size(); ++j) {
                    ParameterMetadata paramMetadata = (ParameterMetadata)paramList.get(j);
                    if (!paramMetadata.isKeyField()) continue;
                    Object paramValue = cmdStep.getParameter(paramMetadata.getName(), i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramValue: " + paramValue);
                    }
                    buf.append(this._handler.formDisplayString(paramValue, this._shell.getLang()));
                    buf.append(" ");
                }
                keys[i] = buf.toString().trim();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "row key " + i + ": " + keys[i]);
                Tr.debug(tc, "row key " + i + ": " + buf.toString().trim());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildKeyFromTableStep");
        }
        return keys;
    }

    public boolean processInteractiveTargetParams(AdminCommand adminCmd, CommandMetadata cmdMetadata) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInteractiveTargetParams", new Object[]{adminCmd, cmdMetadata});
        }
        boolean ret = true;
        int targetObjectRequired = this.getTargetObjectRequired(cmdMetadata);
        int parameterRequired = this.getParameterRequired(cmdMetadata);
        if (targetObjectRequired != 2 || parameterRequired != 2) {
            String title = this.getMetadataTitle(cmdMetadata);
            String desc = this.getMetadataDescription(cmdMetadata);
            boolean titleDisplayed = false;
            if (targetObjectRequired != 2) {
                System.out.println(title + nl);
                System.out.println(desc + nl);
                titleDisplayed = true;
                this.promptTargetObject(adminCmd, cmdMetadata, targetObjectRequired == 1);
            }
            if (parameterRequired != 2) {
                if (!titleDisplayed) {
                    System.out.println(title + nl);
                    System.out.println(desc + nl);
                }
                this.promptParameters(adminCmd, cmdMetadata, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInteractiveTargetParams - " + ret);
        }
        return ret;
    }

    public boolean processInteractiveSteps(AdminCommand adminCmd, CommandMetadata cmdMetadata) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInteractiveSteps", new Object[]{adminCmd, cmdMetadata});
        }
        boolean ret = true;
        int stepExisted = this.getStepExisted(cmdMetadata);
        if (adminCmd instanceof TaskCommand) {
            String[] steps = ((TaskCommand)adminCmd).listCommandSteps();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step length is " + steps.length);
            }
            ret = steps != null && steps.length > 0 ? this.promptSteps((TaskCommand)adminCmd) : this.promptExecution(this.getMetadataTitle(cmdMetadata));
        } else {
            ret = this.promptExecution(this.getMetadataTitle(cmdMetadata));
        }
        if (ret) {
            this.logScriptGeneration(adminCmd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInteractiveSteps - " + ret);
        }
        return ret;
    }

    private void promptTargetObject(AdminCommand adminCmd, CommandMetadata cmdMetadata, boolean isRequired) throws Throwable {
        String targetObjectInput;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptTargetObject");
        }
        StringBuffer targetTitle = new StringBuffer();
        String title = cmdMetadata.getTargetObjectTitle();
        if (isRequired) {
            targetTitle.append(REQUIRED_NOTATION);
        }
        if (title == null) {
            targetTitle.append(this._shell.getFormattedMessage("ADMINTASK_TARGET_TITLE", new Object[0], "Target object"));
        } else {
            targetTitle.append(title);
        }
        StringBuffer choicesStr = new StringBuffer();
        Object[] choices = adminCmd.getTargetObjectChoices();
        if (choices != null && choices.length != 0) {
            targetTitle.append(" [");
            for (int j = 0; j < choices.length; ++j) {
                choicesStr.append(this._handler.formDisplayString(choices[j], this._shell.getLang()));
                if (j + 1 >= choices.length) continue;
                choicesStr.append(", ");
            }
            targetTitle.append(choicesStr.toString());
            targetTitle.append("]");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target object choices: " + choicesStr.toString());
            }
        }
        targetTitle.append(": ");
        Object targetObject = adminCmd.getTargetObject();
        String targetObjectString = "";
        if (targetObject != null) {
            targetObjectString = "[" + this._handler.formDisplayString(targetObject, this._shell.getLang()) + "]";
        }
        if ((targetObjectInput = this.promptInput(targetTitle.toString() + targetObjectString, isRequired, targetObjectString)) != null) {
            this.processTargetObject(adminCmd, cmdMetadata, targetObjectInput);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptTargetObject");
        }
    }

    public String promptParameters(AdminCommand adminCmd, CommandMetadata cmdMetadata, boolean prompt) throws Throwable {
        String ret = this.promptParameters(adminCmd, cmdMetadata, prompt, 0, false);
        return ret;
    }

    public String promptParameters(AdminCommand adminCmd, CommandMetadata cmdMetadata, boolean prompt, int rowIndex) throws Throwable {
        String ret = this.promptParameters(adminCmd, cmdMetadata, prompt, rowIndex, false);
        return ret;
    }

    public String promptParameters(AdminCommand adminCmd, CommandMetadata cmdMetadata, boolean prompt, int rowIndex, boolean tableAddRow) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptParameters - " + prompt + " " + rowIndex + " " + tableAddRow);
        }
        boolean isBraceSupported = false;
        EList custom = cmdMetadata.getCustom();
        if (custom != null && !custom.isEmpty()) {
            for (CustomProperties cp : custom) {
                Tr.debug(tc, "custom property: " + cp.getKey());
                if (!cp.getKey().equalsIgnoreCase("SupportBracesForPropParams")) continue;
                EList valueList = cp.getValue();
                Tr.debug(tc, "Valus of custom " + cp.getKey() + " = " + valueList);
                if (valueList == null || valueList.isEmpty()) continue;
                String value = (String)valueList.iterator().next();
                isBraceSupported = value.equalsIgnoreCase("true");
                break;
            }
        }
        AttributeList attrList = new AttributeList();
        StringBuffer retData = new StringBuffer();
        EList paramList = cmdMetadata.getParameters();
        boolean isTable = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of parameter: " + paramList.size());
        }
        if (adminCmd instanceof CommandStep) {
            isTable = ((CommandStepMetadata)adminCmd.getCommandMetadata()).isTable();
        }
        for (int i = 0; i < paramList.size(); ++i) {
            ParameterMetadata paramMetadata = (ParameterMetadata)paramList.get(i);
            if (adminCmd.isPrivateParameter(paramMetadata.getName())) continue;
            StringBuffer buf = new StringBuffer();
            if (paramMetadata.isRequired()) {
                buf.append(REQUIRED_NOTATION);
            }
            buf.append(this.getMetadataTitle(paramMetadata));
            buf.append(" (");
            buf.append(paramMetadata.getName());
            buf.append(")");
            StringBuffer choicesStr = new StringBuffer();
            Object[] choices = adminCmd instanceof CommandStep ? ((CommandStep)adminCmd).getChoices(paramMetadata.getName(), rowIndex) : adminCmd.getChoices(paramMetadata.getName());
            if (choices != null && choices.length != 0) {
                buf.append(" [");
                for (int j = 0; j < choices.length; ++j) {
                    choicesStr.append(this._handler.formDisplayString(choices[j], this._shell.getLang()));
                    if (j + 1 >= choices.length) continue;
                    choicesStr.append(", ");
                }
                buf.append(choicesStr.toString());
                buf.append("]");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "choices: " + choicesStr.toString());
                }
            }
            buf.append(": ");
            Object value = null;
            if (adminCmd instanceof CommandStep && isTable) {
                if (!tableAddRow && rowIndex < ((CommandStep)adminCmd).getNumberOfRows()) {
                    value = ((CommandStep)adminCmd).getParameter(paramMetadata.getName(), rowIndex);
                }
            } else {
                value = adminCmd.getParameter(paramMetadata.getName());
                if (value == null) {
                    value = paramMetadata.getDefaultValue();
                }
            }
            String valueString = "";
            if (value != null) {
                valueString = this._handler.formDisplayString(value, this._shell.getLang());
                buf.append("[");
                buf.append(valueString);
                buf.append("] ");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current value is " + valueString);
                }
            } else if (paramMetadata.isRequired() && choices != null && choices.length == 1) {
                buf.append("[");
                buf.append(choicesStr.toString());
                buf.append("] ");
                valueString = choicesStr.toString().substring(0, choicesStr.toString().length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "assign choice as value: " + valueString);
                }
            }
            if (prompt) {
                if (paramMetadata.isReadonly()) {
                    System.out.println(buf.toString());
                    continue;
                }
                String paramInput = this.promptInput(buf.toString(), paramMetadata.isRequired(), valueString);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "input for " + paramMetadata.getName() + ": " + paramInput);
                }
                if (paramInput == null && value == null && paramMetadata.isRequired() && choices != null && choices.length == 1) {
                    paramInput = valueString;
                }
                if (paramInput == null) continue;
                try {
                    Object paramValue;
                    if (adminCmd instanceof CommandStep && isTable) {
                        if (!tableAddRow) {
                            paramValue = null;
                            if (paramInput.trim().length() != 0) {
                                paramValue = this.formValidObject(paramMetadata.getType(), paramInput, isBraceSupported);
                            }
                            ((CommandStep)adminCmd).setParameter(paramMetadata.getName(), paramValue, rowIndex);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Setting parameter " + paramMetadata.getName());
                            continue;
                        }
                        Attribute attr = new Attribute(paramMetadata.getName(), this.formValidObject(paramMetadata.getType(), paramInput, isBraceSupported));
                        attrList.add(attr);
                        continue;
                    }
                    paramValue = null;
                    if (paramInput.trim().length() != 0) {
                        paramValue = this.formValidObject(paramMetadata.getType(), paramInput, isBraceSupported);
                    }
                    adminCmd.setParameter(paramMetadata.getName(), paramValue);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Setting parameter " + paramMetadata.getName());
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                    --i;
                }
                continue;
            }
            retData.append(buf.toString());
            retData.append(nl);
        }
        if (prompt && !attrList.isEmpty() && isTable && tableAddRow) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding new row " + rowIndex + ": " + attrList);
            }
            ((CommandStep)adminCmd).addRow(attrList, rowIndex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptParameters");
        }
        return retData.toString();
    }

    private boolean promptSteps(TaskCommand taskCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptSteps");
        }
        boolean ret = true;
        AdminCmdInteractiveStepsPrompt taskSteps = new AdminCmdInteractiveStepsPrompt(this);
        ret = taskSteps.processTaskSteps(taskCmd);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptSteps - " + ret);
        }
        return ret;
    }

    private boolean promptExecution(String cmdTitle) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptExecution");
        }
        boolean ret = true;
        String answer = "junk";
        String msg = this._shell.getFormattedMessage("ADMINTASK_EXECUTION_PROMPT", new Object[]{cmdTitle, finishSelection + nl + cancelSelection, finish + ", " + cancel, finish}, cmdTitle + "\n\nF (Finish)\nC (Cancel)\n\nSelect [F, C]: F");
        while (answer != null && !answer.equalsIgnoreCase(finish) && !answer.equalsIgnoreCase(cancel)) {
            answer = this.promptInput(msg, true, finish);
        }
        if (answer != null && answer.equalsIgnoreCase(cancel)) {
            ret = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptExecution - " + ret);
        }
        return ret;
    }

    public String promptInput(String data, boolean isRequired, String inputValue) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promptInput", new Object[]{data, inputValue});
        }
        String answer = null;
        InputStreamReader in = null;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String inputEncoding = System.getProperty("ws.input.encoding");
            if (inputEncoding != null) {
                try {
                    in = new InputStreamReader(System.in, inputEncoding);
                }
                catch (Throwable th) {
                    this._shell.setLastException((Exception)th);
                    throw new ScriptingException(th.getCause(), th.toString());
                }
            } else {
                in = new InputStreamReader(System.in);
            }
        } else {
            in = new InputStreamReader(System.in);
        }
        BufferedReader console = new BufferedReader(in);
        while (true) {
            System.out.print(data);
            try {
                answer = console.readLine();
            }
            catch (IOException ie) {
                this._shell.setLastException(ie);
                throw ie;
            }
            if (!isRequired || !inputValue.equals("") || answer != null && (answer == null || answer.trim().length() != 0)) break;
            System.out.println(this._shell.getFormattedMessage("WASX7137I", new Object[0], "Enter a value for the required field"));
        }
        if (answer != null && (isRequired && answer.trim().length() == 0 || !isRequired && answer.length() == 0)) {
            answer = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promptInput - " + answer);
        }
        return answer;
    }

    private void logScriptGeneration(AdminCommand adminCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logScriptGeneration");
        }
        String genCmd = this._adminCmdScriptGen.generateScriptFromCmd(adminCmd);
        Tr.audit(tc, "WASX7278I", genCmd);
        System.out.println(this._shell.getFormattedMessage("WASX7278I", new Object[]{genCmd}, "Generated command is " + genCmd));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logScriptGeneration");
        }
    }

    public void processSelectStep(TaskCommand taskCmd, CommandStep cmdStep, boolean isAsyncProcess) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSelectStep");
        }
        if (((CommandStepMetadata)cmdStep.getCommandMetadata()).isTable()) {
            this.processTableStep(cmdStep, isAsyncProcess);
        } else {
            this.processNonTableStep(taskCmd, cmdStep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSelectStep");
        }
    }

    private void processTableStep(CommandStep cmdStep, boolean isAsyncProcess) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTableStep");
        }
        AdminCmdInteractiveTableStepsPrompt tableSteps = new AdminCmdInteractiveTableStepsPrompt(this, isAsyncProcess);
        tableSteps.processTaskSteps(cmdStep);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTableStep");
        }
    }

    private void processNonTableStep(TaskCommand taskCmd, CommandStep cmdStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processNonTableStep");
        }
        String msg = this.buildStepPrompt(cmdStep);
        String prompt = this._shell.getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{cancelSelection + ", " + editSelection, edit}, "Select [" + cancelSelection + ", " + editSelection + "] : [" + edit + "] ");
        String answer = "junk";
        answer = this.promptInput(msg, false, null);
        while (answer != null && answer.trim().length() != 0 && !answer.trim().equalsIgnoreCase(cancel) && !answer.trim().equalsIgnoreCase(edit)) {
            answer = this.promptInput(prompt, false, null);
        }
        if (answer == null || answer != null && answer.equalsIgnoreCase(edit)) {
            this.promptParameters(cmdStep, cmdStep.getCommandMetadata(), true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonTableStep");
        }
    }

    private String buildStepPrompt(CommandStep cmdStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStepPrompt");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(nl);
        buf.append(this.getMetadataTitle(cmdStep.getCommandMetadata()));
        buf.append(" (");
        buf.append(cmdStep.getName());
        buf.append(")");
        buf.append(nl);
        buf.append(nl);
        buf.append(this.promptParameters(cmdStep, cmdStep.getCommandMetadata(), false));
        buf.append(nl);
        buf.append(this._shell.getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{cancelSelection + ", " + editSelection, edit}, "Select [" + cancelSelection + ", " + editSelection + "] : [" + edit + "] "));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStepPrompt - " + buf.toString());
        }
        return buf.toString();
    }

    public void processStepsHelp(TaskCommand taskCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processStepsHelp");
        }
        System.out.println(nl + this._adminCmdHelp.getCommandDetailHelp(taskCmd.getName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processStepsHelp");
        }
    }

    public void processStepHelp(CommandStep cmdStep) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processStepHelp");
        }
        System.out.println(nl + this._adminCmdHelp.getCommandDetailStep((CommandStepMetadata)cmdStep.getCommandMetadata(), cmdStep.getName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processStepHelp");
        }
    }

    private String executeCmd(AdminCommand adminCmd, AsyncCommandClient asyncCmdClientHelper) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCmd");
        }
        asyncCmdClientHelper.execute(adminCmd);
        String retVal = new String();
        CommandResult result = adminCmd.getCommandResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command result: " + result);
        }
        if (result != null) {
            if (result.isSuccessful()) {
                Object val = result.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command runs successful with result: " + val);
                }
                if (val != null) {
                    Class<?> cls = val.getClass();
                    retVal = val instanceof Collection && !(val instanceof AttributeList) ? this.formCollectionDisplayString((Collection)val, this._shell.getLang()) : this._handler.formDisplayString(val, this._shell.getLang());
                }
            } else {
                Throwable t = result.getException();
                String msg = new String();
                String text = ExceptionSupport.getMessage(t, "WASX");
                if (t instanceof Exception) {
                    this._shell.setLastException((Exception)t);
                } else {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    msg = sw.toString();
                    if (text == null) {
                        text = t.toString();
                    }
                    Tr.error(tc, "WASX7120E", new Object[]{text, msg});
                }
                throw new ScriptingException(t.getCause(), text);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCmd - " + retVal);
        }
        return retVal;
    }

    private String getCmdResult(AdminCommand adminCmd, CommandResult result) throws Throwable {
        String retVal = new String();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command result: " + result);
        }
        if (result != null) {
            if (result.isSuccessful()) {
                Object val = result.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command runs successful with result: " + val);
                }
                if (val != null) {
                    Class<?> cls = val.getClass();
                    retVal = val instanceof Collection && !(val instanceof AttributeList) ? this.formCollectionDisplayString((Collection)val, this._shell.getLang()) : this._handler.formDisplayString(val, this._shell.getLang());
                }
            } else {
                String text;
                Throwable t = result.getException();
                String msg = new String();
                if (t instanceof Exception) {
                    msg = ExceptionSupport.getDiagnosticInfo((Exception)t);
                }
                if (msg.equals("")) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    msg = sw.toString();
                }
                if ((text = ExceptionSupport.getMessage(t, "WASX")) == null) {
                    text = t.toString();
                }
                Tr.error(tc, "WASX7120E", new Object[]{text, msg});
                throw new ScriptingException(t.getCause(), text);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCmd - " + retVal);
        }
        return retVal;
    }

    protected StringHandler getHandler(String classType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHandler", new Object[]{classType});
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(classType);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        StringHandler handler = null;
        if (cls != null) {
            handler = HandlerRegistry.getHandler(cls);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHandler - " + handler);
        }
        return handler;
    }

    protected Object formValidObject(String classType, String strObject, boolean isBraceSupported) throws com.ibm.websphere.scripting.ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidObject", new Object[]{classType, strObject});
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        if (classType == null || classType.trim().length() == 0) {
            this._shell.setAndThrowScriptingException("WASX8016E", "Command provider error: null object type", new Object[0]);
        }
        Class<?> cls = null;
        StringHandler handler = null;
        Object ret = null;
        try {
            cls = Class.forName(classType);
        }
        catch (ClassNotFoundException cnfe) {
            classType = "java.lang." + classType;
            try {
                cls = Class.forName(classType);
            }
            catch (ClassNotFoundException ex) {
                throw new ScriptingException(ex.toString());
            }
        }
        if (cls != null) {
            handler = HandlerRegistry.getHandler(cls);
        }
        if (handler != null) {
            if (cls == AttributeList.class) {
                if (this._shell.getLang().equalsIgnoreCase("jython")) {
                    String trial = null;
                    if (strObject.startsWith("[") && strObject.endsWith("]") && (trial = strObject.substring(1, strObject.length() - 1).trim()).startsWith("[") && trial.endsWith("]")) {
                        strObject = trial;
                    }
                } else {
                    String trial = null;
                    if (strObject.startsWith("{") && strObject.endsWith("}") && (trial = strObject.substring(1, strObject.length() - 1).trim()).startsWith("{") && trial.endsWith("}")) {
                        strObject = trial;
                    }
                }
                ret = handler.formValidObject(strObject, cls, this._adminCmdClient.getShell().getLang());
            } else if (classType.equals("javax.management.Attribute")) {
                if (this._shell.getLang().equalsIgnoreCase("jython")) {
                    String trial = null;
                    if (strObject.startsWith("[") && strObject.endsWith("]")) {
                        strObject = trial = strObject.substring(1, strObject.length() - 1).trim();
                    }
                } else {
                    String trial = null;
                    if (strObject.startsWith("{") && strObject.endsWith("}")) {
                        strObject = trial = strObject.substring(1, strObject.length() - 1).trim();
                    }
                }
                ret = handler.formValidObject(strObject, cls, this._adminCmdClient.getShell().getLang());
            } else if (cls == Hashtable.class) {
                if (this._shell.getLang().equalsIgnoreCase("jython")) {
                    String trial = null;
                    if (strObject.startsWith("[") && strObject.endsWith("]")) {
                        strObject = trial = strObject.substring(1, strObject.length() - 1).trim();
                    }
                } else {
                    String trial = null;
                    if (strObject.startsWith("{") && strObject.endsWith("}")) {
                        strObject = trial = strObject.substring(1, strObject.length() - 1).trim();
                    }
                }
                ret = handler.formValidObject(strObject, cls, this._adminCmdClient.getShell().getLang());
            } else if (this._shell.getLang().equalsIgnoreCase("jacl") || this._shell.getLang().equalsIgnoreCase("jython") && cls != Properties.class) {
                ret = handler.formValidObject(strObject, cls, this._adminCmdClient.getShell().getLang());
            } else {
                String trial = null;
                if (strObject.startsWith("[") && strObject.endsWith("]") && (trial = strObject.substring(1, strObject.length() - 1).trim()).startsWith("[") && trial.endsWith("]")) {
                    strObject = trial;
                }
                ret = this._langutils.stringToPropertiesForAdminTask(strObject, isBraceSupported);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidObject - " + ret);
        }
        return ret;
    }

    private String formCollectionDisplayString(Collection o, String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCollectionDisplayString");
        }
        if (this._langutils != this._shell.getLangUtils()) {
            this._langutils = this._shell.getLangUtils();
        }
        ArrayList<String> al = new ArrayList<String>();
        for (Object element : o) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "element", element);
            }
            if (element != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class:  - " + element.getClass().getName());
                }
                if (lang.equalsIgnoreCase("jython") || lang.equalsIgnoreCase("jacl") && !element.getClass().getName().equals("java.util.Properties")) {
                    al.add(this._handler.formDisplayString(element, lang));
                    continue;
                }
                al.add(this._langutils.propertiesToStringForAdminTask((Properties)element));
                continue;
            }
            al.add(new String());
        }
        String ret = this._langutils.setToString(al, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCollectionDisplayString", ret);
        }
        return ret;
    }

    protected Object formValidObject(String classType, Object[] paramArray) throws com.ibm.websphere.scripting.ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidObject using object array" + classType);
        }
        String strObject = this._langutils.objectArrayToString(paramArray);
        Object ret = this.formValidObject(classType, strObject, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidObject - " + ret);
        }
        return ret;
    }

    static {
        isAsyncCommand = false;
    }

    private class ParameterMetaInfo {
        public String name;
        public boolean readonly;

        private ParameterMetaInfo() {
        }
    }

    private class ArgsParseResult {
        public String targetObj;
        public Hashtable optionTable;

        private ArgsParseResult() {
        }
    }
}

