/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AttrInfo;
import com.ibm.ws.scripting.BaseAttrHelper;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.ObjectName;

public class ObjectNameArrayAttrHelper
extends BaseAttrHelper {
    private static TraceComponent tc = Tr.register(ObjectNameArrayAttrHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public ObjectNameArrayAttrHelper(ConfigHelper configHelper, ConfigNameCache nameCache, AbstractShell shell) {
        super(configHelper, nameCache, shell);
    }

    public String getStringValue(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringValue");
        }
        ObjectName on = (ObjectName)oval;
        String ret = this._configHelper.getListingName(on);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringValue - " + ret);
        }
        return ret;
    }

    public Attribute formValidAttribute(AttrInfo ai, Attribute attr) throws ScriptingException {
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidAttribute");
        }
        String s = (String)attr.getValue();
        String ref = this.correctStringReferencesToString(s);
        String objectType = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ref value is " + ref);
            }
            if (ref.length() != 0) {
                objectType = this._nameCache.getType(ref);
            }
        }
        catch (AdminException e) {
            Tr.audit(tc, "Caught exception getting type for object reference: " + ref);
            Tr.audit(tc, "Exception is " + e.toString());
        }
        catch (ConnectorException e) {
            Tr.audit(tc, "Caught exception getting type for object reference: " + ref);
            Tr.audit(tc, "Exception is " + e.toString());
        }
        if (objectType == null && ref.length() != 0) {
            this._shell.setAndThrowScriptingException("WASX7143E", "The object with reference " + ref + " does not exist.", new Object[]{ref});
        }
        ArrayList<ObjectName> aVal = new ArrayList<ObjectName>();
        StringTokenizer tok = null;
        if (ref.indexOf(" ") > 0 && ref.indexOf(")") + 1 < ref.indexOf(" ")) {
            tok = new StringTokenizer(ref, " ", false);
            while (tok.hasMoreTokens()) {
                buf = new StringBuffer();
                String next = tok.nextToken();
                buf.append(next);
                String newS = buf.toString();
                ObjectName on = this._configHelper.stringToObjectName(newS);
                aVal.add(on);
            }
        } else {
            tok = new StringTokenizer(ref, ")", false);
            while (tok.hasMoreTokens()) {
                buf = new StringBuffer();
                String next = tok.nextToken();
                buf.append(next);
                buf.append(")");
                String newS = buf.toString();
                ObjectName on = this._configHelper.stringToObjectName(newS);
                aVal.add(on);
            }
        }
        Attribute ret = new Attribute(attr.getName(), aVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidAttribute");
        }
        return ret;
    }

    public String correctStringReferencesToString(String ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "correctReferencesToString");
        }
        StringBuffer ret = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(ref, "\"'", false);
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (next.equals("\"") || next.equals("'")) continue;
            ret.append(next);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "correctReferencesToString");
        }
        return ret.toString();
    }

    public boolean isValid(String type, String attrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValid");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValid");
        }
        return true;
    }
}

