/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.management.exception.InvalidAdminClientTypeException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ReconnectSupport;
import com.ibm.ws.scripting.ScriptingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class CommonScriptingObject
implements ReconnectSupport,
NotificationListener {
    private static TraceComponent tc = Tr.register(CommonScriptingObject.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected AbstractShell _shell = null;
    protected static AdminClient _client = null;
    protected LanguageUtilities _langutils = null;
    protected static final String DOMAIN = "WebSphere";
    protected static final String nl = System.getProperty("line.separator");
    protected static ResourceBundle _bundle = null;
    protected static ObjectName connectedServer = null;
    protected static String processType = "unknown";
    protected static Properties connectionProperties = null;
    private Boolean cellMgr = null;
    private Boolean adminAgent = null;

    public abstract String help(String var1) throws ScriptingException;

    public CommonScriptingObject(AbstractShell shell, Properties connProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonScriptingObject ctor");
        }
        this._shell = shell;
        this._shell.registerForReconnect(this);
        _bundle = this._shell.getBundle();
        this._langutils = this._shell.getLangUtils();
        if (connProps != null) {
            this.connectToAdminService(connProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonScriptingObject ctor");
        }
    }

    private void connectToAdminService(Properties connProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectToAdminService");
        }
        try {
            this._shell.setLastException(null);
            _client = AdminClientFactory.createAdminClient(connProps);
            connectedServer = _client.getServerMBean();
            processType = (String)_client.getAttribute(connectedServer, "processType");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Connected to MBean: " + connectedServer);
            }
        }
        catch (InvalidAdminClientTypeException iacte) {
            this._shell.logAndIssueMessage(new Object[]{connProps.getProperty("type"), connProps.getProperty("host"), iacte}, "INVALID_CONN_TYPE", "Error creating \"" + connProps.getProperty("type") + "\" connection to server \"" + connProps.getProperty("host") + "\"; exception information: " + iacte, iacte);
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (ConnectorAuthenticationException cae) {
            _client = null;
            connectedServer = null;
            this.authenticationFailure(connProps, cae);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (ConnectorNotAvailableException cnae) {
            if (connProps != null) {
                this._shell.logAndIssueMessage(new Object[]{connProps.getProperty("type"), cnae}, "CONNECTOR_NOT_AVAIL", "Error creating \"" + connProps.getProperty("type") + "\" connection to server: server may not be running; exception information: " + cnae, cnae);
            }
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (ConnectorException ce) {
            Throwable target = ce.getCause();
            if (target == null) {
                target = ce;
            } else if (target instanceof InvocationTargetException && (target = ((InvocationTargetException)target).getTargetException()) instanceof ConnectorAuthenticationException) {
                this.authenticationFailure(connProps, target);
                _client = null;
                connectedServer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectToAdminService -- null");
                }
                return;
            }
            if (connProps != null) {
                if (connProps.getProperty("type").equals("IPC")) {
                    this._shell.logAndIssueMessage(new Object[]{connProps.getProperty("type"), connProps.getProperty("host"), target}, "INVALID_IPC_CONN_TYPE", "Error creating \"" + connProps.getProperty("type") + "\" connection to server \"" + connProps.getProperty("host") + "\"; exception information: " + target, ce);
                } else {
                    this._shell.logAndIssueMessage(new Object[]{connProps.getProperty("type"), connProps.getProperty("host"), target}, "INVALID_CONN_TYPE", "Error creating \"" + connProps.getProperty("type") + "\" connection to server \"" + connProps.getProperty("host") + "\"; exception information: " + target, ce);
                }
            } else {
                this._shell.logException(ce);
            }
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (JMException jme) {
            this._shell.logAndIssueMessage(new Object[]{jme}, "WASX7210W", "Cannot determine type of server; exception information: " + jme, jme);
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (JMRuntimeException jmre) {
            this.authenticationFailure(connProps, jmre);
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        connectionProperties = connProps;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectToAdminService");
        }
    }

    private void authenticationFailure(Properties connProps, Throwable t) {
        String host = connProps.getProperty("host");
        String type = connProps.getProperty("type");
        if (t instanceof Exception) {
            this._shell.logAndIssueMessage(new Object[]{type, host, t.getMessage()}, "WASX7246E", "Cannot establish \"" + type + "\" connection to host \"" + host + "\" because of an authentication failure.  Please ensure that user and password are correct.", (Exception)t);
        } else {
            this._shell.issueMessage(new Object[]{type, host, t.getMessage()}, "WASX7246E", "Cannot establish \"" + type + "\" connection to host \"" + host + "\" because of an authentication failure.  Please ensure that user and password are correct.");
        }
    }

    protected boolean isCellManager() throws MalformedObjectNameException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCellManager");
        }
        boolean ret = false;
        if (this.cellMgr == null) {
            this.cellMgr = "DeploymentManager".equals(processType) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.cellMgr != null) {
            ret = this.cellMgr;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCellManager", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    protected boolean isAdminAgent() throws MalformedObjectNameException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminAgent");
        }
        boolean ret = false;
        if (this.adminAgent == null) {
            this.adminAgent = "AdminAgent".equals(processType) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.adminAgent != null) {
            ret = this.adminAgent;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminAgent", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    protected void helpInfo(String methodName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "helpInfo");
        }
        String msg = this.help(methodName);
        this._shell.setAndThrowScriptingException("WASX7352E", "wrong number of args for command; help information follows:\n" + msg, new Object[]{methodName, msg});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "helpInfo");
        }
    }

    public void handleNotification(Notification notf, Object handback) {
        if (notf == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Received null notf; handback: " + handback);
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Received notf; handback: " + handback + "; data: " + notf.getUserData());
            }
        }
    }
}

