/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.mbean;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasMessageImpl2;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.cbe.CBEHelper;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class RasLoggingServiceMBean
extends RuntimeCollaborator
implements WsHandler {
    public static final String NOTIFICATION_LOG_FATAL = "websphere.ras.fatal";
    public static final String NOTIFICATION_LOG_ERROR = "websphere.ras.error";
    public static final String NOTIFICATION_LOG_WARNING = "websphere.ras.warning";
    public static final String NOTIFICATION_LOG_AUDIT = "websphere.ras.audit";
    public static final String NOTIFICATION_LOG_SERVICE = "websphere.ras.service";
    public static final String NOTIFICATION_LOG_INFO = "websphere.ras.info";
    private long ntfySeqNum = 0L;
    private static boolean registered = false;

    public void setObjectName(ObjectName name) {
        super.setObjectName(name);
        RasLoggingServiceMBean.registerWithRas(this);
    }

    public String getMessageFilterLevel() {
        return ManagerAdmin.getMessageFilterLevel();
    }

    public void setMessageFilterLevel(String newLevel) {
        ManagerAdmin.setMessageFilterLevel(newLevel);
    }

    public Level getLevel() {
        return WsLevel.DETAIL;
    }

    public Boolean containsRASHeader(String filename) {
        boolean returnVal = ManagerAdmin.containsRASHeader(filename);
        return returnVal ? Boolean.TRUE : Boolean.FALSE;
    }

    public void processEvent(LogRecord event2) {
        int level = event2.getLevel().intValue();
        if (level < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            this.sendEvent(NOTIFICATION_LOG_FATAL, event2);
        } else if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            this.sendEvent(NOTIFICATION_LOG_ERROR, event2);
        } else if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            this.sendEvent(NOTIFICATION_LOG_WARNING, event2);
        } else if (level >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            this.sendEvent(NOTIFICATION_LOG_AUDIT, event2);
        } else {
            this.sendEvent(NOTIFICATION_LOG_INFO, event2);
        }
    }

    private static synchronized void registerWithRas(RasLoggingServiceMBean obj) {
        if (registered) {
            return;
        }
        try {
            ManagerAdmin.addJmxListener(obj);
            registered = true;
        }
        catch (RasException exc) {
            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.management.RasLoggingServiceMBean.registerWithRas", "193", obj);
        }
    }

    private void sendEvent(String type, LogRecord event2) {
        try {
            RasMessageImpl2 rmi2 = RasLoggingServiceMBean.parseLogRec(event2);
            Notification notification = new Notification(type, this.getObjectName(), this.ntfySeqNum++);
            notification.setUserData(rmi2);
            this.sendNotification(notification);
        }
        catch (MBeanException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.RasLoggingServiceMBean.sendEvent", "203", this);
        }
    }

    private static RasMessageImpl2 parseLogRec(LogRecord event2) {
        CommonBaseEvent cbe;
        String threadId = Integer.toHexString(event2.getThreadID());
        String messageSeverity = RasMessageImpl2.convertSeverity(event2.getLevel().intValue());
        Locale currentLocale = Locale.getDefault();
        String localizedMsg = TraceLogFormatter.formatMessage(event2, currentLocale, 0);
        String diagnosticProviderId = null;
        if (event2 instanceof CommonBaseEventLogRecord && (cbe = ((CommonBaseEventLogRecord)event2).getCommonBaseEvent()) != null) {
            diagnosticProviderId = CBEHelper.getExtendedDataElementString(cbe, "DiagnosticProvider");
        }
        return new RasMessageImpl2(event2.getMillis(), threadId, messageSeverity, event2.getMessage(), event2.getParameters(), event2.getResourceBundleName(), event2.getLoggerName(), localizedMsg, currentLocale.toString(), diagnosticProviderId);
    }
}

