/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.component.binder.GenericJMSDestination;
import com.ibm.ws.runtime.component.binder.GenericJMSDestinationObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class GenericJMSDestinationReferenceable
implements Referenceable {
    protected String jndiName;
    protected String initCtxFactory;
    protected String providerUrl;
    protected boolean cacheable;
    protected String refClassName;
    protected Properties props;
    private Reference ref;
    static String ADDR_TYPE_JMS_GEN_DEST = "JMS_GEN_DEST";
    private static TraceComponent tc = Tr.register(GenericJMSDestinationReferenceable.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public GenericJMSDestinationReferenceable(String jndiName, String initialContextFactory, String providerUrl, boolean cacheable, String refClassName, Properties props) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "GenericJMSDestinationReferenceable", new Object[]{jndiName, initialContextFactory, providerUrl, cacheable, refClassName, props});
            }
            this.jndiName = jndiName;
            this.initCtxFactory = initialContextFactory;
            this.providerUrl = providerUrl;
            this.cacheable = cacheable;
            this.refClassName = refClassName;
            this.props = props;
            GenericJMSDestination genericDestination = new GenericJMSDestination();
            genericDestination.addRefDetails(jndiName, this.initCtxFactory, providerUrl, cacheable, refClassName, props);
            this.ref = new Reference(this.getClass().getName(), GenericJMSDestinationObjectFactory.class.getName(), null);
            try {
                this.ref.add(this.createBinaryRefAddr(genericDestination, ADDR_TYPE_JMS_GEN_DEST));
            }
            catch (Exception e) {
                if (!tc.isErrorEnabled()) break block4;
                Tr.error(tc, "Exception caught constructing referencable: " + e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GenericJMSDestinationReferenceable");
        }
    }

    public Reference getReference() throws NamingException {
        return this.ref;
    }

    private BinaryRefAddr createBinaryRefAddr(Serializable serializable, String type) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(serializable);
        oos.flush();
        return new BinaryRefAddr(type, baos.toByteArray());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("jndiName: " + this.jndiName);
        buffer.append("---");
        buffer.append("initCtxFactory: " + this.initCtxFactory);
        buffer.append("---");
        buffer.append("providerUrl: " + this.providerUrl);
        buffer.append("---");
        buffer.append("cacheable: " + this.cacheable);
        buffer.append("---");
        buffer.append("refClassName: " + this.refClassName);
        buffer.append("---");
        buffer.append("props: " + this.props);
        return buffer.toString();
    }
}

