/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PmiAttribute;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

public class ThreadPoolModule
extends PmiAbstractModule
implements ThreadPoolPerf {
    private static final long serialVersionUID = 4314008022513737052L;
    private static TraceComponent tc = Tr.register(ThreadPoolModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "threadPoolModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl threadCreates = null;
    private CountStatisticImpl threadDestroys = null;
    private BoundedRangeStatisticImpl activeThreads = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private BoundedRangeStatisticImpl percentMaxed = null;
    private CountStatisticImpl declaredThreadHung = null;
    private CountStatisticImpl declaredThreadHangCleared = null;
    private RangeStatisticImpl concurrentlyHungThreads = null;
    private TimeStatisticImpl activeTime = null;
    private boolean isThreadHangDetectionEnabled = false;
    public static final int THREAD_CREATES = 1;
    public static final int THREAD_DESTROYS = 2;
    public static final int ACTIVE_THREADS = 3;
    public static final int POOL_SIZE = 4;
    public static final int PERCENT_MAXED = 5;
    public static final int THREAD_HUNG = 6;
    public static final int HANG_CLEARED = 7;
    public static final int CONCURRENT_HUNG = 8;
    public static final int ACTIVE_TIME = 9;
    private int minPoolSize = 0;
    private int maxPoolSize = 0;

    public ThreadPoolModule(String poolName, int minPoolSize, int maxPoolSize) {
        this(poolName, minPoolSize, maxPoolSize, null);
    }

    public ThreadPoolModule(String poolName, int minPoolSize, int maxPoolSize, PmiCallback callback) {
        super(moduleID, poolName, callback);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new ThreadPoolModule, pool=" + poolName);
        }
        this.registerModule(this);
        this.maxPoolSize = maxPoolSize;
        this.minPoolSize = minPoolSize;
        if (this.poolSize != null) {
            this.poolSize.setLowerBound(minPoolSize);
            this.poolSize.setUpperBound(maxPoolSize);
        }
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.threadCreates = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 2: {
                this.threadDestroys = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 6: {
                this.declaredThreadHung = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 7: {
                this.declaredThreadHangCleared = (CountStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 3: {
                this.activeThreads = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 4: {
                this.poolSize = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 5: {
                this.percentMaxed = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 8: {
                this.concurrentlyHungThreads = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 9: {
                this.activeTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public synchronized void setInstrumentationLevel(int newLevel) {
        super.setInstrumentationLevel(newLevel);
        if (newLevel == 15 && !this.isThreadHangDetectionEnabled) {
            this.setStatisticEnabled(6, false, false);
            this.setStatisticEnabled(7, false, false);
            this.setStatisticEnabled(8, false, false);
            this.setStatisticEnabled(9, false, false);
            this.updateDataList();
            this.updateEnabledByLevel();
        }
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
        boolean ret = super.setFineGrainedInstrumentation(enabled, enableWithSync);
        if (!this.isThreadHangDetectionEnabled) {
            this.setStatisticEnabled(6, false, false);
            this.setStatisticEnabled(7, false, false);
            this.setStatisticEnabled(8, false, false);
            this.setStatisticEnabled(9, false, false);
            this.updateDataList();
        }
        return ret;
    }

    public void setThreadMonitorServiceEnabled(boolean enabled) {
        if (this.isThreadHangDetectionEnabled != enabled) {
            this.isThreadHangDetectionEnabled = enabled;
            this.setStatisticEnabled(6, enabled, false);
            this.setStatisticEnabled(7, enabled, false);
            this.setStatisticEnabled(8, enabled, false);
            this.setStatisticEnabled(9, enabled, false);
            this.updateDataList();
        }
    }

    public void threadCreated(int numThreadsInPool) {
        long curTime = 0L;
        if (this.threadCreates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadCreated: numThreadsInPool=" + numThreadsInPool);
            }
            curTime = System.currentTimeMillis();
            this.threadCreates.increment(curTime, 1L);
        }
        if (this.poolSize != null) {
            if (curTime == 0L) {
                curTime = System.currentTimeMillis();
            }
            this.poolSize.set(curTime, numThreadsInPool);
        }
    }

    public void threadDestroyed(int numThreadsInPool) {
        long curTime = 0L;
        if (this.threadDestroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadDestroyed: numThreadsInPool=" + numThreadsInPool);
            }
            curTime = System.currentTimeMillis();
            this.threadDestroys.increment(curTime, 1L);
        }
        if (this.poolSize != null) {
            if (curTime == 0L) {
                curTime = System.currentTimeMillis();
            }
            this.poolSize.set(curTime, numThreadsInPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void threadStarted(int numActiveThreads, int maxSize) {
        BoundedRangeStatisticImpl boundedRangeStatisticImpl;
        long curTime = 0L;
        if (this.activeThreads != null && this.percentMaxed != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadStarted: numActiveThreads=" + numActiveThreads + ", maxSize=" + maxSize);
            }
            curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl2 = this.activeThreads;
            synchronized (boundedRangeStatisticImpl2) {
                this.activeThreads.set(curTime, numActiveThreads);
                if (numActiveThreads >= maxSize) {
                    this.percentMaxed.set(curTime, 100L);
                }
            }
        }
        if (this.activeThreads != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadStarted: numActiveThreads=" + numActiveThreads + ", maxSize=" + maxSize);
            }
            curTime = System.currentTimeMillis();
            boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                this.activeThreads.set(curTime, numActiveThreads);
            }
        }
        if (this.percentMaxed != null && numActiveThreads >= maxSize) {
            if (curTime == 0L) {
                curTime = System.currentTimeMillis();
            }
            boundedRangeStatisticImpl = this.percentMaxed;
            synchronized (boundedRangeStatisticImpl) {
                this.percentMaxed.set(curTime, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void threadReturned(int numActiveThreads, int maxSize) {
        BoundedRangeStatisticImpl boundedRangeStatisticImpl;
        long curTime = 0L;
        if (this.activeThreads != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadReturned: numActiveThreads=" + numActiveThreads + ", maxSize=" + maxSize);
            }
            curTime = System.currentTimeMillis();
            boundedRangeStatisticImpl = this.activeThreads;
            synchronized (boundedRangeStatisticImpl) {
                this.activeThreads.set(curTime, numActiveThreads);
            }
        }
        if (this.percentMaxed != null && numActiveThreads == maxSize - 1) {
            if (curTime == 0L) {
                curTime = System.currentTimeMillis();
            }
            boundedRangeStatisticImpl = this.percentMaxed;
            synchronized (boundedRangeStatisticImpl) {
                this.percentMaxed.set(curTime, 0L);
            }
        }
    }

    public void threadCreated() {
        if (this.poolSize != null) {
            this.poolSize.increment();
        }
        if (this.threadCreates != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadCreated");
            }
            this.threadCreates.increment();
        }
    }

    public void threadDestroyed() {
        if (this.poolSize != null) {
            this.poolSize.decrement();
        }
        if (this.threadDestroys != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadDestroyed");
            }
            this.threadDestroys.increment();
        }
    }

    public final void threadStarted(int maxSize) {
        if (PMIServiceState.iStatisticSet < 2) {
            return;
        }
        long curTime = 0L;
        if (this.activeThreads != null) {
            long usedThreads;
            curTime = System.currentTimeMillis();
            this.activeThreads.increment(curTime, 1L);
            if (this.percentMaxed != null && (usedThreads = this.activeThreads.getCurrent()) >= (long)maxSize) {
                this.percentMaxed.set(curTime, 100L);
            }
        }
    }

    public final void threadReturned(int maxSize) {
        if (PMIServiceState.iStatisticSet < 2) {
            return;
        }
        long curTime = 0L;
        if (this.activeThreads != null) {
            long usedThreads;
            curTime = System.currentTimeMillis();
            this.activeThreads.decrement(curTime, 1L);
            if (this.percentMaxed != null && (usedThreads = this.activeThreads.getCurrent()) == (long)(maxSize - 1)) {
                this.percentMaxed.set(curTime, 0L);
            }
        }
    }

    protected void callbackRuntime(int newLevel) {
        Tr.debug(tc, "callbackRuntime");
        if (newLevel < 7) {
            Tr.exit(tc, "callbackRuntime - level is not high enough");
            return;
        }
        if (this.callback == null) {
            Tr.exit(tc, "callbackRuntime - callback is null");
            return;
        }
        PmiAttribute[] attrs = this.callback.getPmiAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].getName().equals("NumThreadsInPool")) continue;
            long totalThreads = attrs[i].getValue();
            if (this.poolSize == null) continue;
            this.poolSize.set(totalThreads);
        }
        Tr.exit(tc, "callbackRuntime");
    }

    public void setConfigData(String name, long minSize, long maxSize) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setConfigData, min=" + minSize + ", maxSize=" + maxSize);
        }
        if (name.equalsIgnoreCase("PoolSize")) {
            if (this.poolSize != null) {
                this.poolSize.setLowerBound(minSize);
                this.poolSize.setUpperBound(maxSize);
            }
        } else {
            Tr.warning(tc, "PMI9999E", "setConfigData: wrong config data name");
        }
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initializeMe");
        }
        long totalThreads = 0L;
        if (this.poolSize != null) {
            totalThreads = this.poolSize.getCurrent();
        }
        if (totalThreads < 0L) {
            this.poolSize.setLastValue(0L);
        }
        long usedThreads = 0L;
        if (this.activeThreads != null) {
            usedThreads = this.activeThreads.getCurrent();
        }
        if (usedThreads < 0L) {
            this.activeThreads.setLastValue(0L);
        }
        if (this.maxPoolSize > 0 && usedThreads >= (long)this.maxPoolSize && this.percentMaxed != null) {
            this.percentMaxed.set(100L);
        }
    }

    public void threadHangDetected() {
        long curTime = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadHangDetected");
        }
        if (this.declaredThreadHung != null) {
            curTime = System.currentTimeMillis();
            this.declaredThreadHung.increment(curTime, 1L);
        }
        if (this.concurrentlyHungThreads != null) {
            if (curTime != 0L) {
                curTime = System.currentTimeMillis();
            }
            this.concurrentlyHungThreads.increment(curTime, 1L);
        }
    }

    public void threadHangCleared(long timeActiveInMillis) {
        long curTime = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "threadHangCleared");
        }
        if (this.declaredThreadHung != null) {
            curTime = System.currentTimeMillis();
            this.declaredThreadHung.decrement(curTime, 1L);
        }
        if (this.declaredThreadHangCleared != null) {
            if (curTime != 0L) {
                curTime = System.currentTimeMillis();
            }
            this.declaredThreadHangCleared.increment(curTime, 1L);
        }
        if (this.concurrentlyHungThreads != null) {
            if (curTime != 0L) {
                curTime = System.currentTimeMillis();
            }
            this.concurrentlyHungThreads.decrement(curTime, 1L);
        }
        if (this.activeTime != null) {
            if (curTime != 0L) {
                curTime = System.currentTimeMillis();
            }
            this.activeTime.add(curTime, timeActiveInMillis);
        }
    }
}

