/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.JCAConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JCAConnectionStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionStatsImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.Hashtable;
import javax.management.ObjectName;

public class J2CModule
extends PmiAbstractModule
implements J2CPerf {
    private static final long serialVersionUID = -6259549258220316293L;
    private static final TraceComponent tc = Tr.register(J2CModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public String moduleID = "j2cModule";
    private static final int defaultLevel = 0;
    private CountStatisticImpl numManagedConnections = null;
    private CountStatisticImpl numConnectionHandles = null;
    private CountStatisticImpl numManagedConnectionsCreated = null;
    private CountStatisticImpl numManagedConnectionsDestroyed = null;
    private CountStatisticImpl numManagedConnectionsAllocated = null;
    private CountStatisticImpl numManagedConnectionsReleased = null;
    private CountStatisticImpl numManagedConnectionTimeouts = null;
    private BoundedRangeStatisticImpl freePoolSize = null;
    private BoundedRangeStatisticImpl poolSize = null;
    private RangeStatisticImpl concurrentWaiters = null;
    private RangeStatisticImpl percentMaxed = null;
    private TimeStatisticImpl averageWait = null;
    private TimeStatisticImpl useTime = null;
    private TimeStatisticImpl jdbcOpTimer = null;
    private CountStatisticImpl numDiscardedStmts = null;
    private Hashtable connectionToStartTime = new Hashtable();
    private Hashtable jdbcOpTimerTable = new Hashtable();
    private long localMaxPoolSize = 0L;
    private long localMinPoolSize = 0L;
    public static final int NUM_CREATES = 1;
    public static final int NUM_DESTROYS = 2;
    public static final int NUM_ALLOCATES = 3;
    public static final int NUM_FREES = 4;
    public static final int POOL_SIZE = 5;
    public static final int FREE_POOL_SIZE = 6;
    public static final int CONCURRENT_WAITERS = 7;
    public static final int NUM_FAULTS = 8;
    public static final int PERCENT_USED = 9;
    public static final int PERCENT_MAXED = 10;
    public static final int USE_TIME = 12;
    public static final int AVERAGE_WAIT = 13;
    public static final int NUM_MANAGED_CONNECTIONS = 14;
    public static final int NUM_CONNECTIONS = 15;
    public static final int PREPSTMT_DISCARDS = 21;
    public static final int JDBC_OPERATION_TIMER = 22;
    private String pName = null;
    private ObjectName providerOName = null;
    private ObjectName cfOName = null;
    private ObjectName mcfOName = null;
    private boolean nonPoolModule = false;

    public J2CModule(String modId, String eisName, ObjectName providerName, ObjectName factoryName) {
        super(modId, eisName);
        this._createModule(modId, eisName, providerName, factoryName, null);
        this.categoryName = "pool";
        this.registerModule(this);
    }

    public J2CModule(String modId, String eisName, ObjectName providerName, ObjectName factoryName, ObjectName mcf, boolean nonPool) {
        super(modId, null);
        if (nonPool) {
            this.instanceName = eisName + " (non-pool)";
            this.categoryName = "non-pool";
            this.nonPoolModule = true;
        } else {
            this.instanceName = eisName;
            this.categoryName = "pool";
            this.nonPoolModule = false;
        }
        this._createModule(modId, this.instanceName, providerName, factoryName, mcf);
        this.registerModule(this);
    }

    private void _createModule(String modId, String eisName, ObjectName providerName, ObjectName factoryName, ObjectName mcf) {
        DataDescriptor dd;
        this.moduleID = modId;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new J2CModule: " + eisName);
        }
        this.pName = providerName == null ? "jmsConnections" : providerName.getKeyProperty("name");
        if (this.pName == null) {
            this.pName = "undefined";
        }
        if (PmiRegistry.findPmiModule(dd = new DataDescriptor(new String[]{this.moduleID, this.pName})) == null) {
            new ResourcePmiModule(this.moduleID, this.pName, providerName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new J2CModule: modId=" + modId + ", eis=" + eisName + "\n  provider=" + providerName + "\n  factory=" + factoryName + "\n   pname=" + this.pName);
        }
        this.providerOName = providerName;
        this.cfOName = factoryName;
        this.mcfOName = mcf;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "provider name=" + this.pName);
        }
    }

    public String[] getPath() {
        if (this.pName != null) {
            return new String[]{this.moduleID, this.pName, this.instanceName};
        }
        return new String[]{this.moduleID, this.instanceName};
    }

    protected SpdData createOneData(PmiDataInfo info) {
        int dataId = info.getId();
        if (dataId == 9) {
            return new SpdLoadExternal(dataId, new PercentUsedData(dataId));
        }
        return super.createOneData(info);
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 14: {
                this.numManagedConnections = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 15: {
                this.numConnectionHandles = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 1: {
                this.numManagedConnectionsCreated = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 2: {
                this.numManagedConnectionsDestroyed = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 3: {
                this.numManagedConnectionsAllocated = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 4: {
                this.numManagedConnectionsReleased = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 8: {
                this.numManagedConnectionTimeouts = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 21: {
                this.numDiscardedStmts = (CountStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 6: {
                this.freePoolSize = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 5: {
                this.poolSize = (BoundedRangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 10: {
                this.percentMaxed = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 7: {
                this.concurrentWaiters = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 13: {
                this.averageWait = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 12: {
                this.useTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 22: {
                this.jdbcOpTimer = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public final void incrementManagedConnectionCount() {
        if (this.numManagedConnections != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "incrementManagedConnectionCount");
            }
            this.numManagedConnections.increment();
        }
    }

    public final void decrementManagedConnectionCount() {
        if (this.numManagedConnections != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "decrementManagedConnectionCount");
            }
            this.numManagedConnections.decrement();
        }
    }

    public final void incrementConnectionHandleCount() {
        if (this.numConnectionHandles != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "incrementConnectionHandleCount");
            }
            this.numConnectionHandles.increment();
        }
    }

    public final void decrementConnectionHandleCount() {
        if (this.numConnectionHandles != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "decrementConnectionHandleCount");
            }
            this.numConnectionHandles.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionCreated() {
        if (this.numManagedConnectionsCreated != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionCreated");
            }
            this.numManagedConnectionsCreated.increment();
        }
        this.incrementManagedConnectionCount();
        if (this.poolSize != null && this.freePoolSize != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.poolSize.incrementWithoutSync(curTime, 1L);
                this.freePoolSize.incrementWithoutSync(curTime, 1L);
            }
        } else {
            if (this.poolSize != null) {
                this.poolSize.increment();
            }
            if (this.freePoolSize != null) {
                this.freePoolSize.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionDestroyed() {
        if (this.numManagedConnectionsDestroyed != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionDestroyed");
            }
            this.numManagedConnectionsDestroyed.increment();
        }
        this.decrementManagedConnectionCount();
        if (this.poolSize != null && this.freePoolSize != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.poolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.poolSize.decrementWithoutSync(curTime, 1L);
                if (this.freePoolSize.getCurrent() > 0L) {
                    this.freePoolSize.decrementWithoutSync(curTime, 1L);
                }
            }
        } else {
            if (this.poolSize != null) {
                this.poolSize.decrement();
            }
            if (this.freePoolSize != null && this.freePoolSize.getCurrent() > 0L) {
                this.freePoolSize.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionAllocated() {
        if (this.numManagedConnectionsAllocated != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionAllocated");
            }
            this.numManagedConnectionsAllocated.increment();
        }
        if (this.freePoolSize != null && this.percentMaxed != null && this.poolSize != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.freePoolSize;
            synchronized (boundedRangeStatisticImpl) {
                if (this.freePoolSize.getCurrent() > 0L) {
                    this.freePoolSize.decrementWithoutSync(curTime, 1L);
                }
                long localNumManagedConnectionsInUse = this.poolSize.getCurrent() - this.freePoolSize.getCurrent();
                if (this.localMaxPoolSize != 0L && localNumManagedConnectionsInUse >= this.localMaxPoolSize) {
                    this.percentMaxed.set(curTime, 100L);
                }
            }
        } else if (this.freePoolSize != null) {
            this.freePoolSize.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void managedConnectionFreed() {
        if (this.numManagedConnectionsReleased != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionFreed");
            }
            this.numManagedConnectionsReleased.increment();
        }
        if (this.freePoolSize != null && this.percentMaxed != null && this.poolSize != null) {
            long curTime = System.currentTimeMillis();
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = this.freePoolSize;
            synchronized (boundedRangeStatisticImpl) {
                this.freePoolSize.incrementWithoutSync(curTime, 1L);
                long localNumManagedConnectionsInUse = this.poolSize.getCurrent() - this.freePoolSize.getCurrent();
                if (this.localMaxPoolSize != 0L && localNumManagedConnectionsInUse < this.localMaxPoolSize) {
                    this.percentMaxed.set(0L);
                }
            }
        } else if (this.freePoolSize != null) {
            this.freePoolSize.increment();
        }
    }

    public final void beginWaitForManagedConnection() {
        if (this.concurrentWaiters != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginWaitForManagedConnection");
            }
            this.concurrentWaiters.increment();
        }
    }

    public final void endWaitForManagedConnection(long waitTime) {
        if (this.concurrentWaiters != null) {
            this.concurrentWaiters.decrement();
        }
        if (this.averageWait != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endWaitForManagedConnection");
            }
            this.averageWait.add(waitTime);
        }
    }

    public void managedConnectionFault() {
        if (this.numManagedConnectionTimeouts != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedConnectionFault");
            }
            this.numManagedConnectionTimeouts.increment();
        }
    }

    public final void beginUseManagedConnection(Object connection) {
        if (this.useTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginUseManagedConnection");
            }
            this.connectionToStartTime.put(connection, new Long(System.currentTimeMillis()));
        }
    }

    public final void endUseManagedConnection(Object connection) {
        if (this.useTime != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endUseManagedConnection");
            }
            long endTime = System.currentTimeMillis();
            Long startTime = (Long)this.connectionToStartTime.remove(connection);
            if (startTime != null) {
                long lUseTime = endTime - startTime;
                this.useTime.add(lUseTime);
            }
        }
    }

    public void setMaxPoolSize(long maxPoolSize) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxPoolSize, max=" + maxPoolSize);
        }
        this.setPoolSize(0L, maxPoolSize);
    }

    public void setPoolSize(long minPoolSize, long maxPoolSize) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setPoolSize, min=" + minPoolSize + ", max=" + maxPoolSize);
        }
        this.localMaxPoolSize = maxPoolSize;
        this.localMinPoolSize = minPoolSize;
        if (this.poolSize != null) {
            this.poolSize.setLowerBound(0L);
            this.poolSize.setUpperBound(this.localMaxPoolSize);
        }
        if (this.freePoolSize != null) {
            this.freePoolSize.setLowerBound(0L);
            this.freePoolSize.setUpperBound(this.localMaxPoolSize);
        }
    }

    public final void jdbcOperationCompleted() {
        if (this.jdbcOpTimer != null) {
            Long startTime = (Long)this.jdbcOpTimerTable.get(Thread.currentThread());
            if (startTime == null) {
                return;
            }
            long operationLength = System.currentTimeMillis() - startTime;
            this.jdbcOpTimerTable.remove(Thread.currentThread());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcOperationCompleted in (ms) " + operationLength);
            }
            this.jdbcOpTimer.add(operationLength);
        }
    }

    public final void jdbcOperationStarted() {
        if (this.jdbcOpTimer != null) {
            Long currTime = new Long(System.currentTimeMillis());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jdbcOperationStarted at " + currTime);
            }
            this.jdbcOpTimerTable.put(Thread.currentThread(), currTime);
        }
    }

    public final void statementDiscardedFromCache(Object mc) {
        if (this.numDiscardedStmts != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "statementDiscardedFromCache");
            }
            this.numDiscardedStmts.increment();
        }
    }

    public StatsImpl getJSR77Stats(ModuleItem mi) {
        if (this.moduleID.equals("j2cModule")) {
            if (this.nonPoolModule) {
                JCAConnectionStatsImpl stats = new JCAConnectionStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
                stats.setConnectionFactory(this.cfOName);
                stats.setManagedConnectionFactory(this.mcfOName);
                return stats;
            }
            JCAConnectionPoolStatsImpl stats = new JCAConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
            stats.setConnectionFactory(this.cfOName);
            stats.setManagedConnectionFactory(this.mcfOName);
            return stats;
        }
        if (this.nonPoolModule) {
            JDBCConnectionStatsImpl stats = new JDBCConnectionStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
            stats.setJdbcDataSource(this.cfOName);
            return stats;
        }
        JDBCConnectionPoolStatsImpl stats = new JDBCConnectionPoolStatsImpl(this.name, this.type, this.currentLevel, this.listStatistics(), null);
        stats.setJdbcDataSource(this.cfOName);
        return stats;
    }

    public ObjectName getMyMBean() {
        return this.cfOName;
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        long connectionInUse = 0L;
        long connectionInPool = 0L;
        if (this.poolSize != null) {
            connectionInPool = this.poolSize.getCurrent();
        }
        if (connectionInPool < 0L) {
            this.poolSize.setLastValue(0L);
        }
        long freeConnectionInPool = 0L;
        if (this.freePoolSize != null) {
            freeConnectionInPool = this.freePoolSize.getCurrent();
        }
        if (freeConnectionInPool < 0L) {
            this.freePoolSize.setLastValue(0L);
            connectionInUse = connectionInPool;
        } else {
            connectionInUse = connectionInPool - freeConnectionInPool;
        }
        long numWaiters = 0L;
        if (this.concurrentWaiters != null) {
            numWaiters = this.concurrentWaiters.getCurrent();
        }
        if (numWaiters < 0L) {
            this.concurrentWaiters.setLastValue(0L);
        }
        if (this.localMaxPoolSize > 0L && this.percentMaxed != null && connectionInUse >= this.localMaxPoolSize) {
            this.percentMaxed.set(100L);
        }
    }

    final class PercentUsedData
    implements SpdLoadExternalValue {
        private RangeStatisticImpl percentUsedValue = null;

        public PercentUsedData(int dataId) {
            this.percentUsedValue = new RangeStatisticImpl(dataId);
        }

        public SPIStatistic getLoadValue() {
            return this.percentUsedValue;
        }

        public void updateStatistic() {
            if (J2CModule.this.poolSize == null || J2CModule.this.freePoolSize == null || this.percentUsedValue == null) {
                return;
            }
            if (J2CModule.this.localMaxPoolSize == 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: PercentUsedData localMaxPoolSize is 0");
                }
                this.percentUsedValue.set(0L, 0L, 0L, 0.0, this.percentUsedValue.getStartTime(), J2CModule.this.poolSize.getLastSampleTime());
            } else {
                long current = (J2CModule.this.poolSize.getCurrent() - J2CModule.this.freePoolSize.getCurrent()) * 100L / J2CModule.this.localMaxPoolSize;
                long curTime = J2CModule.this.poolSize.updateIntegral();
                J2CModule.this.poolSize.setLastSampleTime(curTime);
                J2CModule.this.freePoolSize.updateIntegral(curTime);
                J2CModule.this.freePoolSize.setLastSampleTime(curTime);
                double integral = (J2CModule.this.poolSize.getIntegral() - J2CModule.this.freePoolSize.getIntegral()) * 100.0 / (double)J2CModule.this.localMaxPoolSize;
                long lastSampleTime = J2CModule.this.poolSize.getLastSampleTime();
                long low = (J2CModule.this.localMaxPoolSize - J2CModule.this.freePoolSize.getHighWaterMark()) * 100L / J2CModule.this.localMaxPoolSize;
                long high = (J2CModule.this.localMaxPoolSize - J2CModule.this.freePoolSize.getLowWaterMark()) * 100L / J2CModule.this.localMaxPoolSize;
                this.percentUsedValue.set(low, high, current, (long)integral, this.percentUsedValue.getStartTime(), J2CModule.this.poolSize.getLastSampleTime());
            }
        }
    }
}

