/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.TemplateModule;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import java.util.HashMap;

public class CachePerfModule
extends PmiAbstractModule
implements CachePerf {
    private static final long serialVersionUID = 9205382809864908020L;
    protected static TraceComponent tc = Tr.register(CachePerfModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "cacheModule";
    private static final int defaultLevel = 0;
    public static final int cacheModule_maxInMemoryCacheSize = 1;
    public static final int cacheModule_inMemoryCacheSize = 2;
    public static final int cacheModule_totalTimeoutInvalidations = 3;
    public static final int UNSET = 0;
    public static final int DIRECT = 1;
    public static final int LRU = 2;
    public static final int TIMEOUT = 3;
    public static final int MEMORY = 1;
    public static final int REMOTE = 2;
    public static final int DISK = 3;
    public static final int NOOP = 4;
    public static final int LOCAL = 5;
    public static final int cacheModule_template = 20;
    public static final int cacheModule_template_hitsInMemory = 21;
    public static final int cacheModule_template_hitsOnDisk = 22;
    public static final int cacheModule_template_explicitInvalidations = 23;
    public static final int cacheModule_template_lruInvalidations = 24;
    public static final int cacheModule_template_timeoutInvalidations = 25;
    public static final int cacheModule_template_entries = 26;
    public static final int cacheModule_template_hitsRemote = 27;
    public static final int cacheModule_template_misses = 28;
    public static final int cacheModule_template_requestsFromClient = 29;
    public static final int cacheModule_template_requestsFromJVM = 30;
    public static final int cacheModule_template_explicitInvalidationsFromMemory = 31;
    public static final int cacheModule_template_explicitInvalidationsFromDisk = 32;
    public static final int cacheModule_template_explicitInvalidationsNoOp = 33;
    public static final int cacheModule_template_explicitInvalidationsLocal = 34;
    public static final int cacheModule_template_explicitInvalidationsRemote = 35;
    public static final int cacheModule_template_remoteCreations = 36;
    SPICountStatistic maxInMemoryCacheSize = null;
    SPICountStatistic inMemoryCacheSize = null;
    SPICountStatistic totalTimeoutInvalidations = null;
    HashMap templates = new HashMap();
    private String sCacheName;
    private String sCacheType;
    public static final String TYPE_SERVLET = "cache.servlet";
    public static final String TYPE_OBJECT = "cache.object";

    public CachePerfModule(String cacheType, String cacheName, PmiCallback callback) {
        super(moduleID, cacheName);
        DataDescriptor dd;
        this.sCacheName = cacheName;
        this.sCacheType = cacheType;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new CachePerfModule: {cacheType, cacheName} " + cacheType + ", " + cacheName);
        }
        if (PmiRegistry.findModuleItem(dd = new DataDescriptor(new String[]{moduleID, cacheType})) == null) {
            new CacheTypeModule(cacheType);
        }
        this.registerModule(this);
        if (cacheType.equals(TYPE_SERVLET)) {
            new ModuleAggregate(moduleID, cacheType, cacheName, "cacheModule.template");
        }
    }

    public String[] getPath() {
        return new String[]{moduleID, this.sCacheType, this.sCacheName};
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.maxInMemoryCacheSize = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 2: {
                this.inMemoryCacheSize = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
            case 3: {
                this.totalTimeoutInvalidations = (SPICountStatistic)((Object)data.getStatistic());
                return true;
            }
        }
        Tr.warning(tc, "PMI00008W", "cacheModule, dataID=" + data.getId());
        return false;
    }

    public boolean isPMIEnabled() {
        int level = this.getInstrumentationLevel();
        return level != 1000 && level != -1 && level != 0;
    }

    public void resetPMICounters() {
    }

    public void updateCacheSizes(long max, long current) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateCacheSize, max=" + max + ", current=" + current);
        }
        if (this.maxInMemoryCacheSize != null) {
            this.maxInMemoryCacheSize.setCount(max);
        }
        if (this.inMemoryCacheSize != null) {
            this.inMemoryCacheSize.setCount(current);
        }
    }

    public void updateDiskCacheStatistics(long objectsOnDisk, long pendingRemoval, long depidsOnDisk, long depidsBuffered, long depidsOffloaded, long depidBasedInvalidations, long templatesOnDisk, long templatesBuffered, long templatesOffloaded, long templateBasedInvalidations) {
    }

    public void onCacheHit(String template, int locality) {
        block13: {
            block12: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "onCacheHit: template=" + template + " locality=" + locality);
                }
                if (template == null) break block12;
                TemplateModule tm = (TemplateModule)this.templates.get(template);
                if (tm == null) {
                    tm = this.createTemplateModule(template);
                }
                switch (locality) {
                    case 2: {
                        if (tm.hitsRemote != null) {
                            tm.hitsRemote.increment();
                            tm.entries.increment();
                            tm.remoteCreations.increment();
                            break;
                        }
                        break block13;
                    }
                    case 1: {
                        if (tm.hitsInMemory != null) {
                            tm.hitsInMemory.increment();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (tm.hitsOnDisk != null) {
                            tm.hitsOnDisk.increment();
                            break;
                        }
                        break block13;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "onCacheHit() called with unrecognized locality " + locality);
                        }
                        return;
                    }
                }
                break block13;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template was null: " + template);
            }
        }
    }

    public void onCacheMiss(String template, int locality) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheMiss: template=" + template + " locality=" + locality);
        }
        if (template != null) {
            TemplateModule tm = (TemplateModule)this.templates.get(template);
            if (tm == null) {
                tm = this.createTemplateModule(template);
            }
            if (tm.misses != null) {
                tm.misses.increment();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheMiss: template was null");
        }
    }

    public void onEntryCreation(String template, int source) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onEntryCreation: template=" + template + " source=" + source);
        }
        if (template != null) {
            TemplateModule tm = (TemplateModule)this.templates.get(template);
            if (tm == null) {
                tm = this.createTemplateModule(template);
            }
            if (source == 2 && tm.remoteCreations != null) {
                tm.remoteCreations.increment();
            }
            if (tm.entries != null) {
                tm.entries.increment();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onEntryCreation: template was null");
        }
    }

    public void onRequest(String template, int source) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onRequest: template=" + template + "source=" + source);
        }
        if (template != null) {
            TemplateModule tm = (TemplateModule)this.templates.get(template);
            if (tm == null) {
                tm = this.createTemplateModule(template);
            }
            if (source == 5) {
                if (tm.requestsFromClient != null) {
                    tm.requestsFromClient.increment();
                }
            } else if (source == 2 && tm.requestsFromJVM != null) {
                tm.requestsFromJVM.increment();
            }
        }
    }

    public void batchOnInvalidate(String template, int cause, int locality, int source, int dels) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchOnInvalidate: " + template + ", " + cause + ", " + locality + ", " + source + ", " + dels);
        }
        if (template != null) {
            TemplateModule tm = (TemplateModule)this.templates.get(template);
            if (tm == null) {
                tm = this.createTemplateModule(template);
            }
            block0 : switch (cause) {
                case 1: {
                    if (tm.explicitInvalidations != null) {
                        tm.explicitInvalidations.increment(dels);
                    }
                    switch (locality) {
                        case 1: {
                            if (tm.explicitInvalidationsFromMemory != null) {
                                tm.explicitInvalidationsFromMemory.increment(dels);
                            }
                            if (tm.entries == null) break;
                            tm.entries.decrement(dels);
                            break;
                        }
                        case 3: {
                            if (tm.explicitInvalidationsFromDisk != null) {
                                tm.explicitInvalidationsFromDisk.increment(dels);
                            }
                            if (tm.entries == null) break;
                            tm.entries.decrement(dels);
                        }
                    }
                    switch (source) {
                        case 5: {
                            if (tm.explicitInvalidationsLocal == null) break;
                            tm.explicitInvalidationsLocal.increment(dels);
                            break block0;
                        }
                        case 2: {
                            if (tm.explicitInvalidationsRemote == null) break;
                            tm.explicitInvalidationsRemote.increment(dels);
                        }
                    }
                    break;
                }
                case 2: {
                    if (tm.lruInvalidations != null) {
                        tm.lruInvalidations.increment(dels);
                    }
                    if (locality == 3 || tm.entries == null) break;
                    tm.entries.decrement(dels);
                    break;
                }
                case 3: {
                    if (tm.timeoutInvalidations != null) {
                        tm.timeoutInvalidations.increment(dels);
                    }
                    if (this.totalTimeoutInvalidations != null) {
                        this.totalTimeoutInvalidations.increment(dels);
                    }
                    if (tm.entries == null) break;
                    tm.entries.decrement(dels);
                }
            }
        } else if (cause == 3 && locality == 3) {
            if (this.totalTimeoutInvalidations != null) {
                this.totalTimeoutInvalidations.increment(dels);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onInvalidate: template was null");
        }
    }

    public void onInvalidate(String template, int cause, int locality, int source) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onInvalidate: " + template + ", " + cause + ", " + locality + ", " + source);
        }
        this.batchOnInvalidate(template, cause, locality, source, 1);
    }

    public void onCacheClear(boolean memory, boolean disk) {
    }

    private synchronized TemplateModule createTemplateModule(String template) {
        TemplateModule tm = (TemplateModule)this.templates.get(template);
        if (tm == null) {
            tm = new TemplateModule(this.sCacheName, this.sCacheType, template);
            this.templates.put(template, tm);
        }
        return tm;
    }

    class CacheTypeModule
    extends ModuleAggregate {
        private static final long serialVersionUID = -6403912783689903806L;

        CacheTypeModule(String type) {
            super(CachePerfModule.moduleID, type);
        }
    }
}

