/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.jvmpi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.jvmpi.JvmpiInfo;
import com.ibm.ws.pmi.server.jvmpi.JvmpiJni;
import java.util.ArrayList;

public class JvmpiGroup {
    private ArrayList subGroups = new ArrayList();
    private static final int PMI_JVMPI_GC = 0;
    private static final int PMI_JVMPI_MONITOR = 1;
    private static final int PMI_JVMPI_THREAD = 2;
    private static final int PMI_JVMPI_OBJECT = 3;
    private static final String GC_NAME = "GC";
    private static final String MONITOR_NAME = "Monitor";
    private static final String THREAD_NAME = "Thread";
    private static final String OBJECT_NAME = "Object";
    private static int iJvmpiLoaded = 0;
    protected static TraceComponent tc = Tr.register(JvmpiGroup.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    static int jvmpiDebug = 0;
    private static boolean bJvmpi = false;
    private static boolean libraryLoaded = false;

    public JvmpiGroup(boolean bJvmpi) {
        JvmpiGroup.bJvmpi = bJvmpi;
        this.initialize();
    }

    public JvmpiGroup() {
        this.initialize();
    }

    private static void initLibrary() {
        if (libraryLoaded) {
            return;
        }
        try {
            if (System.getProperty("os.name").equals("OS/400")) {
                boolean os400UseJ9 = System.getProperty("os400.use.j9", "false").equals("true");
                boolean os40064bit = System.getProperty("com.ibm.vm.bitmode", "false").equals("64");
                String libName = "";
                if (bJvmpi) {
                    libName = os400UseJ9 && !os40064bit ? System.getProperty("was.install.root") + "/bin/libpmiJvmpiProfiler.so" : (os400UseJ9 && os40064bit ? System.getProperty("was.install.root") + "/bin/libpmiJvmpiProfiler64.so" : "/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/QWASJVMPI.SRVPGM");
                    Tr.debug(tc, "iSeries JVMPI loading " + libName);
                    System.load(libName);
                } else {
                    libName = os400UseJ9 && !os40064bit ? System.getProperty("was.install.root") + "/bin/libpmiJvmtiProfiler.so" : (os400UseJ9 && os40064bit ? System.getProperty("was.install.root") + "/bin/libpmiJvmtiProfiler64.so" : "/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/QWASJVMTI.SRVPGM");
                    Tr.debug(tc, "iSeries JVMTI loading " + libName);
                    System.load(libName);
                }
            } else if (bJvmpi) {
                int bitmode;
                String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
                if (CurrentBitmode == null || CurrentBitmode.length() < 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "System property com.ibm.vm.bitmode is null.Defaulting to 32 bitmode");
                    }
                    CurrentBitmode = "32";
                }
                if ((bitmode = Integer.parseInt(CurrentBitmode)) == 64 && System.getProperty("os.name").equals("z/OS")) {
                    System.loadLibrary("pmiJvmpiProfiler64");
                } else {
                    System.loadLibrary("pmiJvmpiProfiler");
                }
            } else {
                int bitmode;
                String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
                if (CurrentBitmode == null || CurrentBitmode.length() < 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "System property com.ibm.vm.bitmode is null.Defaulting to 32 bitmode");
                    }
                    CurrentBitmode = "32";
                }
                if ((bitmode = Integer.parseInt(CurrentBitmode)) == 64 && System.getProperty("os.name").equals("z/OS")) {
                    System.loadLibrary("pmiJvmtiProfiler64");
                } else {
                    System.loadLibrary("pmiJvmtiProfiler");
                }
            }
            libraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            FFDCFilter.processException(e, "com.ibm.ws.pmi.server.jvmpi.JvmpiGroup", "150");
        }
    }

    private void initialize() {
        JvmpiGroup.initLibrary();
        String[] grps = new String[]{GC_NAME, OBJECT_NAME, THREAD_NAME, MONITOR_NAME};
        try {
            iJvmpiLoaded = JvmpiJni.isJVMPIEnabled();
        }
        catch (UnsatisfiedLinkError e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.pmi.server.jvmpi.JvmpiGroup.JvmpiGroup", "160", this);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.pmi.server.jvmpi.JvmpiGroup.JvmpiGroup", "163", this);
        }
        if (iJvmpiLoaded == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JVMPI library not loaded");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            jvmpiDebug = 1;
            JvmpiJni.setDebug(1);
            Tr.debug(tc, "Enabling JVMPI native debug");
        }
        for (int i = 0; i < grps.length; ++i) {
            int grpId = -1;
            if (grps[i].equals(GC_NAME)) {
                grpId = 0;
            } else if (grps[i].equals(MONITOR_NAME)) {
                grpId = 1;
            } else if (grps[i].equals(THREAD_NAME)) {
                grpId = 2;
            } else if (grps[i].equals(OBJECT_NAME)) {
                grpId = 3;
            } else {
                System.err.println("WARNING: JvmpiGroup receives wrong group name");
            }
            if (grpId == -1) continue;
            this.subGroups.add(new JvmpiDataGroup(grps[i], grpId));
        }
    }

    public void setInstrumentationLevel(int level) {
        if (this.subGroups == null || this.subGroups.size() == 0) {
            return;
        }
        PmiModule mod = null;
        for (int i = 0; i < this.subGroups.size(); ++i) {
            mod = (PmiModule)this.subGroups.get(i);
            mod.setInstrumentationLevel(level);
        }
    }

    class JvmpiDataGroup
    extends PmiAbstractModule {
        private static final long serialVersionUID = 5416391206176569362L;
        final String moduleID = "jvmRuntimeModule";
        final int defaultLevel = 0;
        JvmpiInfo[] members;
        int groupId;

        public JvmpiDataGroup(String s, int grpId) {
            super("jvmRuntimeModule", s);
            this.moduleID = "jvmRuntimeModule";
            this.defaultLevel = 0;
            this.members = null;
            this.groupId = -1;
            this.groupId = grpId;
            this.members = this.createMembers(grpId);
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i].pmiData == null) continue;
                this.putToTable(this.members[i].pmiData);
            }
            this.submoduleName = s;
            this.type = 16;
            this.registerModule(this);
        }

        public synchronized void setInstrumentationLevel(int level) {
            JvmpiJni.setLevel(this.groupId, this.getStatID(this.groupId, level), level);
            for (int i = 0; i < this.members.length; ++i) {
                this.members[i].setLevel(level);
            }
            this.currentLevel = level;
            this.updateDataList();
        }

        public synchronized boolean setFineGrainedInstrumentation(int[] enabled, int[] enableWithSync) {
            if (enabled != null && enabled.length == 1 && enabled[0] == -3) {
                JvmpiJni.setLevel(this.groupId, this.getStatID(this.groupId, 15), -2);
            } else {
                enabled = this.getList(this.groupId, enabled, enableWithSync);
                JvmpiJni.setLevel(this.groupId, enabled, -2);
            }
            return super.setFineGrainedInstrumentation(enabled, new int[0]);
        }

        public String getModuleID() {
            return "jvmRuntimeModule";
        }

        public int getDefaultLevel() {
            return 0;
        }

        public String[] getPath() {
            return new String[]{"jvmRuntimeModule", this.instanceName};
        }

        public String getWCCMStatsType() {
            if (this.groupId == 0) {
                return "jvmRuntimeModule#GC";
            }
            if (this.groupId == 3) {
                return "jvmRuntimeModule#Object";
            }
            if (this.groupId == 2) {
                return "jvmRuntimeModule#Thread";
            }
            if (this.groupId == 1) {
                return "jvmRuntimeModule#Monitor";
            }
            return "jvmRuntimeModule";
        }

        private JvmpiInfo[] createMembers(int grpID) {
            JvmpiInfo[] members = null;
            if (grpID == 0) {
                members = new JvmpiInfo[]{new JvmpiInfo(11, 1, 11, 15), new JvmpiInfo(12, 3, 12, 15), new JvmpiInfo(13, 3, 13, 15)};
            } else if (grpID == 3) {
                members = new JvmpiInfo[]{new JvmpiInfo(14, 1, 14, 15), new JvmpiInfo(15, 1, 15, 15), new JvmpiInfo(16, 1, 16, 15)};
            } else if (grpID == 2) {
                members = new JvmpiInfo[]{new JvmpiInfo(17, 1, 17, 15), new JvmpiInfo(18, 1, 18, 15)};
            } else if (grpID == 1) {
                members = new JvmpiInfo[]{new JvmpiInfo(19, 1, 19, 15), new JvmpiInfo(20, 3, 20, 15)};
            }
            return members;
        }

        private int[] getStatID(int grpID, int level) {
            if (level != 15) {
                return new int[]{-1};
            }
            if (grpID == 0) {
                return new int[]{11, 12, 13};
            }
            if (grpID == 3) {
                return new int[]{14, 15, 16};
            }
            if (grpID == 2) {
                return new int[]{17, 18};
            }
            if (grpID == 1) {
                return new int[]{19, 20};
            }
            return new int[]{-1};
        }

        private int[] getList(int grp, int[] e, int[] es) {
            int i;
            if (e == null) {
                e = new int[]{};
            }
            if (es == null) {
                es = new int[]{};
            }
            int n = e.length + es.length;
            ArrayList<Integer> list = new ArrayList<Integer>(3);
            for (i = 0; i < e.length; ++i) {
                if (!this._isValid(grp, e[i])) continue;
                list.add(new Integer(e[i]));
            }
            for (i = 0; i < es.length; ++i) {
                if (!this._isValid(grp, es[i])) continue;
                list.add(new Integer(es[i]));
            }
            int[] r = new int[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                r[i2] = (Integer)list.get(i2);
            }
            return r;
        }

        private boolean _isValid(int grpID, int id) {
            return grpID == 0 ? id == 11 || id == 12 || id == 13 : (grpID == 3 ? id == 14 || id == 15 || id == 16 : (grpID == 2 ? id == 17 || id == 18 : grpID == 1 && (id == 19 || id == 20)));
        }
    }
}

