/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.pmi.PmiBean;
import com.ibm.websphere.pmi.PmiBeanFactory;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.BeanModule;
import java.util.HashMap;

public class PmiBeanFactoryImpl
implements PmiBeanFactory {
    HashMap allBeanModules = new HashMap();
    protected static TraceComponent tc = Tr.register(PmiBeanFactoryImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public PmiBean createPmiBean(EJBConfigData data, String containerName) {
        return this.createPmiBean(data.getEJBComponentMetaData(), containerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmiBean createPmiBean(EJBComponentMetaData data, String containerName) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String uniqueName = this.getUniqueName(data);
        String moduleName = this.getModuleName(uniqueName);
        String beanName = this.getBeanName(uniqueName);
        String beanType = this.getBeanType(data);
        DataDescriptor dd1 = new DataDescriptor(new String[]{"beanModule", moduleName});
        DataDescriptor dd2 = new DataDescriptor(new String[]{"beanModule", moduleName, beanType});
        HashMap hashMap = this.allBeanModules;
        synchronized (hashMap) {
            ModuleItem item = PmiRegistry.findModuleItem(dd1);
            if (item == null) {
                new ModuleAggregate(new String[]{"beanModule", moduleName}, moduleName, 14);
            }
            if ((item = PmiRegistry.findModuleItem(dd2)) == null) {
                new ModuleAggregate(new String[]{"beanModule", moduleName, beanType}, beanType, 19);
            }
        }
        BeanModule pmiBean = new BeanModule(moduleName, beanName, beanType, data);
        pmiBean.setFactory(this);
        HashMap hashMap2 = this.allBeanModules;
        synchronized (hashMap2) {
            this.allBeanModules.put(uniqueName, pmiBean);
        }
        return pmiBean;
    }

    public PmiBean getPmiBean(EJBComponentMetaData data, String containerName) {
        if (PmiRegistry.isBeanMethodDisabled()) {
            return null;
        }
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String uniqueName = this.getUniqueName(data);
        BeanModule pmiBean = (BeanModule)this.allBeanModules.get(uniqueName);
        return pmiBean;
    }

    public PmiBean getPmiBean(String uniqueName, String containerName) {
        if (PmiRegistry.isBeanMethodDisabled()) {
            return null;
        }
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        BeanModule pmiBean = (BeanModule)this.allBeanModules.get(uniqueName);
        return pmiBean;
    }

    private String getInstanceName(String containerName, String uniqueName) {
        return uniqueName;
    }

    private String getUniqueName(EJBComponentMetaData ejbConfigData) {
        return ((Object)ejbConfigData.getJ2EEName()).toString();
    }

    private String getModuleName(String uniqueName) {
        int index = uniqueName.lastIndexOf(35);
        return uniqueName.substring(0, index);
    }

    private String getBeanName(String uniqueName) {
        int index = uniqueName.lastIndexOf(35);
        return uniqueName.substring(index + 1);
    }

    private String getBeanType(EJBComponentMetaData ejbConfigData) {
        String beanType = null;
        if (ejbConfigData.isStatefulSessionBean()) {
            beanType = "ejb.stateful";
        } else if (ejbConfigData.isStatelessSessionBean()) {
            beanType = "ejb.stateless";
        } else if (ejbConfigData.isEntityBean()) {
            beanType = "ejb.entity";
        } else if (ejbConfigData.isMessageDrivenBean()) {
            beanType = "ejb.messageDriven";
        }
        return beanType;
    }

    public void removePmiModule(Object obj) {
        String[] path;
        if (obj == null) {
            return;
        }
        if (!(obj instanceof PmiModule)) {
            Tr.warning(tc, "removePmiModule - parameter should be PmiModule type");
            return;
        }
        PmiModule instance = (PmiModule)obj;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removePmiModule " + instance.getModuleID() + ", " + instance.getName());
        }
        if ((path = instance.getPath()).length == 4 && path[0].equals("beanModule")) {
            String uniqueName = path[1] + "#" + path[3];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PmiBeanFactoryImpl: removeModule " + uniqueName);
            }
            this.allBeanModules.remove(uniqueName);
        }
        instance.unregister();
    }
}

