/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.RtPMIModule;
import java.util.ArrayList;
import javax.management.Notification;

public class PerfPrivate
extends RuntimeCollaborator {
    private static TraceComponent tc = Tr.register(PMIImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static PerfPrivate instance;
    private static int notifySeqNum;
    public static final String NOTIFY_BEFORE_SERVANT_STOP = "websphere.pmi.beforeServantStop";
    public static final String NOTIFY_BEFORE_SERVANT_IDLE = "websphere.pmi.beforeServantIdle";
    public static final int SERVANT_STOP = 1;
    public static final int SERVANT_IDLE = 2;

    private PerfPrivate() {
    }

    public static void init() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize PerfPrivate");
        }
        if (instance == null) {
            instance = new PerfPrivate();
            MBeanFactory factory = AdminServiceFactory.getMBeanFactory();
            factory.activateMBean("PerfPrivate", instance, "PerfPrivateMBean", null);
        }
    }

    public static DataDescriptor getDataDescriptor(MBeanStatDescriptor msd) {
        return PmiRegistry.mBeanToDataDescriptor(msd);
    }

    public static WSStats getServerStats() {
        return PmiRegistry.getServerSnapshot();
    }

    public static void sendNotification(int type, String sToken) throws Exception {
        Notification n;
        if (instance == null) {
            throw new Exception("PerfPrivate is null");
        }
        if (type == 1) {
            n = new Notification(NOTIFY_BEFORE_SERVANT_STOP, instance.getObjectName(), notifySeqNum++);
        } else if (type == 2) {
            n = new Notification(NOTIFY_BEFORE_SERVANT_IDLE, instance.getObjectName(), notifySeqNum++);
        } else {
            throw new Exception("Unknown event type");
        }
        ArrayList<Object> data = new ArrayList<Object>(2);
        data.add(sToken);
        data.add(PmiRegistry.getServerSnapshot());
        n.setUserData(data);
        instance.sendNotification(n);
    }

    public static RtPMIModule getPMIConfig() {
        return PmiConfigManager.getRuntimePMISpec();
    }

    public static String getStatisticSetID() {
        return PMIImpl.getStatisticSet();
    }

    public static Boolean getSynchronizedUpdate() {
        return new Boolean(PMIImpl.getSynchronizedUpdate());
    }

    public static void setStatisticSetID(String statSet) {
        PmiRegistry.setInstrumentationLevel(statSet);
        PMIImpl.setStatisticSet(statSet);
    }

    public void setSynchronizedUpdate(Boolean flag) {
        PMIImpl.setSynchronizedUpdate(flag);
        PmiRegistry.setSynchronizedUpdate(flag);
    }

    public static void updatePMIConfig(String[] path, String type, Integer[] enabled, Integer[] enabledSync, Boolean recursive) {
        if (enabled == null || enabledSync == null) {
            return;
        }
        int[] e = new int[enabled.length];
        for (int i = 0; i < enabled.length; ++i) {
            e[i] = enabled[i];
        }
        int[] es = new int[enabledSync.length];
        for (int k = 0; k < enabledSync.length; ++k) {
            es[k] = enabledSync[k];
        }
        ModuleItem item = PmiRegistry.findModuleItem(path);
        if (item != null) {
            item.setInstanceLevel(e, new int[0], -2, recursive);
        }
    }

    public void persistPMIConfig() {
        PmiConfigManager.saveSpec();
    }

    public PMIServiceState getPMIServiceState() {
        PMIServiceState state = PMIImpl.getStateObject();
        state.setInstrumentationSpec(PmiRegistry.getInstrumentationLevelString60());
        return state;
    }

    static {
        notifySeqNum = 0;
    }
}

