/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.xml.ParserFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleConfigParser
extends DefaultHandler
implements PmiConstants {
    public static final String STATS_DTD = "/com/ibm/websphere/pmi/xml/stats.dtd";
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.pmi.validateDescriptors";
    private PmiModuleConfig oneModule = null;
    private PmiDataInfo currentData;
    private PmiDataInfo submoduleData;
    private String currentChars = null;
    private final TraceComponent tc = Tr.register(ModuleConfigParser.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private String submoduleName = null;
    private boolean isModule = true;
    private String _fileName = null;
    private boolean _validate = false;
    private boolean bExtension = false;
    private Locator locator = null;
    private static String PERF_MODULE = "PerfModule";
    private static String STATS = "Stats";
    private static String PERF_LONG = "PerfLong";
    private static String COUNT_STAT = "CountStatistic";
    private static String PERF_DOUBLE = "PerfDouble";
    private static String DOUBLE_STAT = "DoubleStatistic";
    private static String PERF_LOAD = "PerfLoad";
    private static String BOUNDED_RANGE_STAT = "BoundedRangeStatistic";
    private static String PERF_STAT = "PerfStat";
    private static String TIME_STAT = "TimeStatistic";
    private static String AVG_STAT = "AverageStatistic";
    private static String RANGE_STAT = "RangeStatistic";
    private static String PERF_SUBMODULE = "PerfSubModule";
    private static String UID = "UID";
    private static String DESCRIPTION = "description";
    private static String NAME = "name";
    private static String LEVEL = "level";
    private static String STATISTICSET = "statisticSet";
    private static String PLATFORM = "platform";
    private static String UNIT = "unit";
    private static String RESETTABLE = "resettable";
    private static String AGGREGATABLE = "aggregatable";
    private static String ZOS_AGGREGATABLE = "zosAggregatable";
    private static String ON_REQUEST = "updateOnRequest";
    private static String CATEGORY = "category";
    private static String COMMENT = "comment";
    private static String DEPENDENCY = "dependency";
    private static String MBEAN_TYPE = "mBeanType";
    private static String STATS_NLS_FILE = "resourceBundle";
    private static String TYPE = "type";
    private static String EXTENSION_TAG = "EXTENSION";
    private static AttributesImpl attrList;

    public PmiModuleConfig parse(String fileName) throws Exception {
        return this.loadDescriptor(fileName, false);
    }

    public synchronized PmiModuleConfig parse(String fileName, boolean validate) throws Exception {
        return this.loadDescriptor(fileName, validate);
    }

    public PmiModuleConfig loadDescriptor(String fileName, boolean validate) throws Exception {
        return this.loadDescriptor(fileName, validate, true);
    }

    public PmiModuleConfig loadDescriptor(String fileName, boolean validate, boolean loadFromClassPathOnly) throws Exception {
        String[] tokens;
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "loadDescriptor: parsing stats xml " + fileName + "; dtd validation: " + validate);
        }
        this.oneModule = null;
        this.currentData = null;
        this.submoduleName = null;
        this.submoduleData = null;
        this._fileName = fileName;
        this._validate = validate;
        InputStream istream = null;
        boolean usingCC = false;
        if (fileName.indexOf(61) != -1 && (tokens = fileName.split("=")).length > 1 && tokens[0].equalsIgnoreCase(EXTENSION_TAG)) {
            this.bExtension = true;
            this._fileName = tokens[1];
            try {
                this.parseFromExtension(this._fileName);
            }
            catch (Exception ex) {
                if (this.tc.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", "97", this);
                throw ex;
            }
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "loadDescriptor");
            }
            return this.oneModule;
        }
        this.bExtension = false;
        if (istream == null) {
            if (loadFromClassPathOnly) {
                istream = this.getClass().getResourceAsStream(fileName);
                usingCC = false;
                if (istream == null) {
                    istream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                    usingCC = true;
                }
                if (istream == null) {
                    istream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName.substring(1));
                    usingCC = true;
                }
                if (istream == null) {
                    Tr.error(this.tc, "PMI0010W", fileName);
                    return null;
                }
            } else {
                istream = new FileInputStream(fileName);
                if (istream == null) {
                    Tr.error(this.tc, "PMI0010W", fileName);
                    return null;
                }
            }
        }
        try {
            XMLReader parser2 = ParserFactory.createXMLReader();
            parser2.setFeature("http://xml.org/sax/features/namespaces", true);
            parser2.setFeature("http://xml.org/sax/features/validation", validate);
            parser2.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validate);
            parser2.setEntityResolver(this);
            parser2.setContentHandler(this);
            parser2.setErrorHandler(this);
            parser2.parse(new InputSource(istream));
        }
        catch (Exception ex) {
            if (this.tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", "97", this);
            throw ex;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "loadDescriptor");
        }
        if (usingCC) {
            StatsConfigHelper.translateAndCache(this.oneModule, null);
        }
        return this.oneModule;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "resolveEntity", systemId);
        }
        InputSource inputSource = null;
        try {
            if (systemId.endsWith("stats.dtd")) {
                InputStream in = this.getClass().getResourceAsStream(STATS_DTD);
                inputSource = new InputSource(in);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.server.ModuleConfigParser.resolveEntity", "126", this);
            Tr.error(this.tc, "PMI0010W", systemId);
            return null;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "resolveEntity");
        }
        return inputSource;
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "error", exception);
        }
        throw new SAXException(exception);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String localpart, String rawname, Attributes attributes) throws SAXException {
        if (rawname.equals(PERF_MODULE)) {
            this.isModule = true;
            String uid = PerfModules.getModuleUID(this._fileName);
            int index = uid.lastIndexOf(".");
            String newUID = uid.substring(index + 1);
            this.oneModule = new PmiModuleConfig(newUID);
            return;
        }
        if (rawname.equals(STATS)) {
            String moduleUID;
            this.isModule = true;
            String type = attributes.getValue(TYPE);
            if (this._validate && !(moduleUID = this.bExtension ? this._fileName : PerfModules.getModuleUID(this._fileName)).equals(type)) {
                throw new SAXException("Stats template name does not match with stat type: template = " + this._fileName + "; stats type = " + type);
            }
            this.oneModule = new PmiModuleConfig(type);
            return;
        }
        if (!rawname.equals(DESCRIPTION) && !rawname.equals(STATS_NLS_FILE)) {
            if (rawname.equals(COUNT_STAT) || rawname.equals(TIME_STAT) || rawname.equals(RANGE_STAT) || rawname.equals(BOUNDED_RANGE_STAT) || rawname.equals(AVG_STAT) || rawname.equals(DOUBLE_STAT) || rawname.equals(PERF_LONG) || rawname.equals(PERF_LOAD) || rawname.equals(PERF_STAT) || rawname.equals(PERF_DOUBLE) || rawname.equals(PERF_SUBMODULE)) {
                this.isModule = false;
                int dataId = Integer.parseInt(attributes.getValue("ID"));
                this.currentData = new PmiDataInfo(dataId);
                this.currentData.setName(attributes.getValue(NAME));
                this.currentData.setSubmoduleName(this.submoduleName);
                if (rawname.equals(COUNT_STAT) || rawname.equals(PERF_LONG)) {
                    this.currentData.setType(2);
                } else if (rawname.equals(BOUNDED_RANGE_STAT) || rawname.equals(PERF_LOAD)) {
                    this.currentData.setType(5);
                } else if (rawname.equals(RANGE_STAT)) {
                    this.currentData.setType(7);
                } else if (rawname.equals(PERF_STAT) || rawname.equals(TIME_STAT)) {
                    this.currentData.setType(4);
                } else if (rawname.equals(PERF_DOUBLE) || rawname.equals(DOUBLE_STAT)) {
                    this.currentData.setType(3);
                } else if (rawname.equals(AVG_STAT)) {
                    this.currentData.setType(6);
                } else if (rawname.equals(PERF_SUBMODULE)) {
                    this.currentData.setType(15);
                    this.submoduleName = this.currentData.getName();
                }
                this.oneModule.addData(this.currentData);
            } else if (rawname.equals(LEVEL) || rawname.equals(CATEGORY) || rawname.equals(UNIT) || rawname.equals(AGGREGATABLE) || rawname.equals(ZOS_AGGREGATABLE) || rawname.equals(RESETTABLE) || rawname.equals(COMMENT)) {
                // empty if block
            }
        }
        this.currentChars = null;
    }

    public void endElement(String uri, String localpart, String rawname) throws SAXException {
        if (!rawname.equals(PERF_MODULE) && !rawname.equals(STATS)) {
            if (rawname.equals(DESCRIPTION)) {
                if (this.isModule) {
                    this.oneModule.setDescription(this.currentChars);
                } else {
                    this.currentData.setDescription(this.currentChars);
                }
            } else if (rawname.equals(STATS_NLS_FILE)) {
                if (this.isModule) {
                    this.oneModule.setResourceBundle(this.currentChars);
                }
            } else if (!(rawname.equals(PERF_LONG) || rawname.equals(PERF_LOAD) || rawname.equals(PERF_STAT) || rawname.equals(PERF_DOUBLE) || rawname.equals(COUNT_STAT) || rawname.equals(BOUNDED_RANGE_STAT) || rawname.equals(RANGE_STAT) || rawname.equals(AVG_STAT) || rawname.equals(TIME_STAT) || rawname.equals(DOUBLE_STAT))) {
                if (rawname.equals(PERF_SUBMODULE)) {
                    this.submoduleName = null;
                } else if (rawname.equals(LEVEL)) {
                    if (this.currentChars.equals("low")) {
                        this.currentData.setLevel(1);
                    } else if (this.currentChars.equals("medium")) {
                        this.currentData.setLevel(3);
                    } else if (this.currentChars.equals("high")) {
                        this.currentData.setLevel(7);
                    } else if (this.currentChars.equals("maximum")) {
                        this.currentData.setLevel(15);
                    } else {
                        this.currentData.setLevel(1000);
                    }
                } else if (rawname.equals(CATEGORY)) {
                    this.currentData.setCategory(this.currentChars);
                } else if (rawname.equals(UNIT)) {
                    this.currentData.setUnit(this.currentChars);
                } else if (rawname.equals(STATISTICSET)) {
                    this.currentData.setStatisticSet(this.currentChars);
                } else if (rawname.equals(PLATFORM)) {
                    this.currentData.setPlatform(this.currentChars);
                } else if (rawname.equals(RESETTABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setResettable(false);
                    }
                } else if (rawname.equals(AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setAggregatable(false);
                    }
                } else if (rawname.equals(ZOS_AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setZosAggregatable(false);
                    }
                } else if (rawname.equals(COMMENT)) {
                    this.currentData.setComment(this.currentChars);
                } else if (rawname.equals(ON_REQUEST)) {
                    if (this.currentChars.equals("true")) {
                        this.currentData.setOnRequest(true);
                    }
                } else if (rawname.equals(DEPENDENCY)) {
                    try {
                        int dataId = Integer.parseInt(this.currentChars);
                        this.currentData.addDependency(dataId);
                    }
                    catch (Exception e) {}
                } else if (rawname.equals(MBEAN_TYPE)) {
                    this.oneModule.setMbeanType(this.currentChars);
                    if (this.isModule) {
                        PmiRegistry.jmxMapper.setMapping(this.oneModule.getShortName(), null, null, this.currentChars);
                    } else {
                        PmiRegistry.jmxMapper.setMapping(this.oneModule.getShortName(), null, this.currentData.getName(), this.currentChars);
                    }
                }
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length);
        this.currentChars = this.currentChars == null ? tmpStr : this.currentChars + tmpStr;
    }

    private String getXmlFileName(String moduleID) {
        String fileName = "/" + moduleID.replace('.', '/') + ".xml";
        return fileName;
    }

    private void parseFromExtension(String strExtension) {
        IExtension extension2;
        String epid;
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            Tr.error(this.tc, "Unable to get eclipse extension registry");
        }
        if ((extensionPoint = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".pmiCustomExtension")) == null) {
            Tr.error(this.tc, "Unable to get extension point - " + epid);
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "Processing extension point " + epid);
        }
        if ((extension2 = extensionPoint.getExtension(strExtension)) == null) {
            Tr.error(this.tc, "PMI0010W", strExtension);
            return;
        }
        attrList = new AttributesImpl();
        IConfigurationElement[] customElements = extension2.getConfigurationElements();
        for (int i = 0; i < customElements.length; ++i) {
            this.processExtensionElement(customElements[i]);
        }
    }

    private void processExtensionElement(IConfigurationElement element) {
        block5: {
            try {
                this.getAttributesFromExtensionElement(element);
                String name = element.getName();
                this.startElement("", "", name, attrList);
                IConfigurationElement[] children = element.getChildren();
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        this.processExtensionElement(children[i]);
                    }
                }
                this.currentChars = element.getValue();
                if (this.currentChars == null) {
                    this.currentChars = "";
                }
                this.endElement("", "", name);
            }
            catch (Exception ex) {
                if (!this.tc.isDebugEnabled()) break block5;
                ex.printStackTrace();
            }
        }
    }

    private void getAttributesFromExtensionElement(IConfigurationElement element) {
        attrList.clear();
        String[] strAttributes = element.getAttributeNames();
        if (strAttributes.length > 0) {
            for (int i = 0; i < strAttributes.length; ++i) {
                String value = element.getAttribute(strAttributes[i]);
                attrList.addAttribute(strAttributes[i], strAttributes[i], strAttributes[i], "String", value);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ModuleConfigParser mParser = new ModuleConfigParser();
        mParser.parse("/com/ibm/websphere/pmi/custom/test/PmiServletModule1.xml", true);
    }
}

