/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.InvocationHandler;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.server.PMIServiceState;
import javax.management.Attribute;
import javax.management.OperationsException;

public class PerfMBeanInvocationHandler
implements InvocationHandler {
    private static TraceComponent tc = Tr.register(PerfMBeanInvocationHandler.class, null, null);
    private InvocationSynchronizer invokeSync = new InvocationSynchronizer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvoke(String methodName, Object[] params, String[] signatures, StateObject stateObject, int correlationValue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke", "correlation # ==|" + correlationValue + "|==");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke", "methodName ==|" + methodName + "|==");
            Tr.debug(tc, "preInvoke", "stateObject ==|" + stateObject + "|==");
        }
        if (stateObject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "preInvoke", "stateObject is NULL, so exiting...");
            }
            return;
        }
        if (methodName.startsWith("set")) {
            InvocationSynchronizer invocationSynchronizer = this.invokeSync;
            synchronized (invocationSynchronizer) {
                while (this.invokeSync.getState() != null) {
                    try {
                        this.invokeSync.wait();
                    }
                    catch (InterruptedException e) {
                        Tr.event(tc, "preInvoke - EXCEPTION during invokeSync.wait()", e);
                    }
                }
                this.invokeSync.setValue(correlationValue, stateObject);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke", "this method does NOT require preInvoke processing!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke", "correlation # ==|" + correlationValue + "|==");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(String methodName, Object[] params, String[] signatures, StateObject stateObject, int correlationValue, Throwable thrownException, boolean invokeException) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", "correlation # ==|" + correlationValue + "|==");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postInvoke", "methodName ==|" + methodName + "|==");
            Tr.debug(tc, "postInvoke", "stateObject ==|" + stateObject + "|==");
            Tr.debug(tc, "postInvoke", "thrownException ==|" + thrownException + "|==");
            Tr.debug(tc, "postInvoke", "invokeException ==|" + invokeException + "|==");
        }
        if (stateObject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "postInvoke", "stateObject is NULL, so exiting...");
            }
            return;
        }
        if (methodName.startsWith("set")) {
            InvocationSynchronizer invocationSynchronizer = this.invokeSync;
            synchronized (invocationSynchronizer) {
                Attribute attribute = (Attribute)params[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "preInvoke", "changing attribute to ==|" + attribute.getValue() + "|==");
                }
                if (this.invokeSync.getCorrelationValue() != correlationValue) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "postInvoke", "correlationValue mismatch prev --|" + this.invokeSync.getCorrelationValue() + "|-- current ==|" + correlationValue + "|== exiting...");
                    }
                    throw new OperationsException("CorrelationValue mismatch prev --|" + this.invokeSync.getCorrelationValue() + "|-- current ==|" + correlationValue + "|==");
                }
                PMIServiceState state = (PMIServiceState)stateObject;
                state.update(PerfPrivateLocal.get().getPMIServiceState());
                this.invokeSync.resetValue();
                this.invokeSync.notifyAll();
                if (thrownException != null) {
                    if (invokeException) {
                        // empty if block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "postInvoke", "correlation # ==|" + correlationValue + "|==");
                    }
                    return;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postInvoke", "this method does NOT require postInvoke processing!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke", "correlation # ==|" + correlationValue + "|==");
        }
    }

    private class InvocationSynchronizer {
        int correlationValue = -1;
        Object state = null;

        private InvocationSynchronizer() {
        }

        private int getCorrelationValue() {
            return this.correlationValue;
        }

        private Object getState() {
            return this.state;
        }

        private synchronized void setValue(int newCorrelationValue, Object prevState) {
            this.correlationValue = newCorrelationValue;
            this.state = prevState;
        }

        private synchronized void resetValue() {
            this.correlationValue = -1;
            this.state = null;
        }
    }
}

