/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.HostnameNormalizer;
import com.ibm.ws.naming.util.RasUtil;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.naming.NamingException;

public class DefaultHostnameNormalizer
implements HostnameNormalizer {
    private static final TraceComponent _tc = Tr.register(DefaultHostnameNormalizer.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static Hashtable _cachedNormalizedHostname;

    public DefaultHostnameNormalizer() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>");
        }
    }

    public String normalizeHostname(boolean escapeDots) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "normalizeHostname", "escapeDots=" + escapeDots);
        }
        return this.normalizeHostname(escapeDots, "localhost");
    }

    public String normalizeHostname(boolean escapeDots, String hostname) throws NamingException {
        String returnHostname;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", new String[]{"escapeDots=" + escapeDots, "hostname=" + hostname});
        }
        if ((returnHostname = (String)_cachedNormalizedHostname.get(hostname)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "normalizeHostname", "Got cached host name: " + returnHostname);
            }
            if (escapeDots) {
                returnHostname = this.doEscapeDots(returnHostname);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeHostname", returnHostname);
            }
            return returnHostname;
        }
        InetAddress ipAddr = null;
        try {
            ipAddr = hostname.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "normalizeHostname", "150", this);
            NamingException ne = new NamingException("The normalizeHostname operation failed.  Please get the root cause contained in this NamingException for more information.");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeHostname", ne);
            }
            throw ne;
        }
        returnHostname = this.normalizeHostname(escapeDots, ipAddr, hostname);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", returnHostname);
        }
        return returnHostname;
    }

    public String normalizeHostname(boolean escapeDots, InetAddress ipAddress) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "normalizeHostname", new String[]{"escapeDots=" + escapeDots, "ipAddress=" + ipAddress});
        }
        return this.normalizeHostname(escapeDots, ipAddress, null);
    }

    private String normalizeHostname(boolean escapeDots, InetAddress ipAddress, String hostname) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", new String[]{"escapeDots=" + escapeDots, "ipAddress=" + ipAddress, "hostname=" + hostname});
        }
        String originalHostname = hostname;
        String returnHostname = (String)_cachedNormalizedHostname.get(ipAddress);
        if (returnHostname == null) {
            try {
                String tmp = ipAddress.getHostAddress();
                hostname = InetAddress.getByName(tmp).getHostName();
            }
            catch (Exception e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "normalizeHostname", "230", this);
                NamingException ne = new NamingException("The normalizeHostname operation failed. Please get the root cause contained in this NamingException for more information.");
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "normalizeHostname", ne);
                }
                throw ne;
            }
            returnHostname = hostname.toLowerCase();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "normalizeHostname", "Caching hostname: ipAddress=" + ipAddress + ", returnHostname=" + returnHostname);
            }
            _cachedNormalizedHostname.put(ipAddress, returnHostname);
            if (originalHostname != null) {
                _cachedNormalizedHostname.put(originalHostname, returnHostname);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "normalizeHostname", "Got cached host name: " + returnHostname);
        }
        if (escapeDots) {
            returnHostname = this.doEscapeDots(returnHostname);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", returnHostname);
        }
        return returnHostname;
    }

    private String doEscapeDots(String hostname) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doEscapeDots", "hostname=" + hostname);
        }
        String returnHostname = "";
        int start = 0;
        int dotPosition = -1;
        while ((dotPosition = hostname.indexOf(46, start)) != -1) {
            returnHostname = returnHostname + hostname.substring(start, dotPosition) + "\\.";
            start = dotPosition + 1;
        }
        if (start < hostname.length()) {
            returnHostname = returnHostname + hostname.substring(start);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doEscapeDots", returnHostname);
        }
        return returnHostname;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/DefaultHostnameNormalizer.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.15");
        }
        CLASS_NAME = DefaultHostnameNormalizer.class.getName();
        _cachedNormalizedHostname = new Hashtable();
    }
}

