/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.urlbase;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.RasUtil;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public abstract class UrlContextFactory
implements ObjectFactory {
    private static final TraceComponent _tc = Tr.register(UrlContextFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    public UrlContextFactory() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getObjectInstance", new String[]{"obj=" + obj, "name=" + name, "nameCtx=" + nameCtx, "env=" + env});
        }
        if (this.isNameSpaceAccessable()) {
            if (obj == null) {
                Context retObj = this.createURLContextRoot(env);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getObjectInstance", retObj);
                }
                return retObj;
            }
            if (obj instanceof String) {
                Context urlCtx = this.createURLContextRoot(env);
                try {
                    Object retObj = urlCtx.lookup((String)obj);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getObjectInstance", retObj);
                    }
                    Object object = retObj;
                    return object;
                }
                finally {
                    urlCtx.close();
                }
            }
            if (obj instanceof String[]) {
                NamingException ne;
                Context urlCtx;
                block22: {
                    String[] urls = (String[])obj;
                    if (urls.length == 0) {
                        ConfigurationException ne2 = new ConfigurationException("UrlContextFactory: empty URL array");
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getObjectInstance", ne2);
                        }
                        throw ne2;
                    }
                    urlCtx = this.createURLContextRoot(env);
                    ne = null;
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            Object retObj = urlCtx.lookup(urls[i]);
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "getObjectInstance", retObj);
                            }
                            Object object = retObj;
                            return object;
                        }
                        catch (NamingException e) {
                            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getObjectInstance", "159", this);
                            ne = e;
                            continue;
                        }
                    }
                    if (!_tc.isEntryEnabled()) break block22;
                    Tr.exit(_tc, "getObjectInstance", ne);
                }
                throw ne;
                finally {
                    urlCtx.close();
                }
            }
            String className = obj == null ? "<null>" : obj.getClass().getName();
            IllegalArgumentException e = new IllegalArgumentException("Argument must be a URL string or an array of them.  Argument type: " + className);
            NamingException ne = new NamingException("Illegal Object parameter value passed to " + this.getClass().getName() + ".getObjectInstance(Object, Name, Context, Hashtable).");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getObjectInstance", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getObjectInstance");
        }
        return null;
    }

    protected abstract boolean isNameSpaceAccessable() throws NamingException;

    protected abstract Context createURLContextRoot(Hashtable var1) throws NamingException;

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/urlbase/UrlContextFactory.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.12");
        }
        CLASS_NAME = UrlContextFactory.class.getName();
    }
}

