/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.RasUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class WsnLdapHelpers {
    private static final TraceComponent _tc = Tr.register(WsnLdapHelpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    public static final String PROPERTY_KEY_LDAP_TRACE = "com.sun.jndi.ldap.trace.ber";

    private WsnLdapHelpers() {
    }

    protected static String getStringFromAttribute(Attributes attributes, String attributeName, boolean required) throws NamingException {
        Object value;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getStringFromAttribute", new String[]{"attributes=" + attributes, "attributeName=" + attributeName, "required=" + required});
        }
        String string = null;
        Attribute attribute = attributes.get(attributeName);
        if (attribute != null && (value = attribute.get()) instanceof String) {
            string = (String)value;
        }
        if (string == null && required) {
            NamingException ne = new NamingException("Required attribute " + attributeName + " does not exist or is not a String");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getStringFromAttribute", ne.toString());
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getStringFromAttribute", string);
        }
        return string;
    }

    protected static String singleEscapeEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(string, "\\", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("\\")) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(token);
        }
        return stringBuffer.toString();
    }

    protected static String doubleEscapeEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(string, "\\", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("\\")) {
                stringBuffer.append("\\\\");
            }
            stringBuffer.append(token);
        }
        return stringBuffer.toString();
    }

    protected static String tripleEscapeEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(string, "\\", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("\\")) {
                stringBuffer.append("\\\\\\");
            }
            stringBuffer.append(token);
        }
        return stringBuffer.toString();
    }

    public static void setupLdapProtocolTracing(Hashtable env) {
        Object ldapTrace;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupLdapProtocolTracing", "env=" + env);
        }
        if ((ldapTrace = env.get("com.ibm.websphere.naming.ldapprotocoltrace")) instanceof String) {
            if (Boolean.parseBoolean((String)ldapTrace)) {
                OutputStream outputStream = null;
                Object ldapTraceFile = env.get("com.ibm.websphere.naming.ldapprotocoltracefile");
                if (ldapTraceFile instanceof String) {
                    String fileName = (String)ldapTraceFile;
                    try {
                        outputStream = new FileOutputStream(fileName, true);
                    }
                    catch (Exception e) {
                        RasUtil.logException(e, _tc, CLASS_NAME, "setupLdapProtocolTracing", "244");
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "setupLdapProtocolTracing", "Error opening ldap trace file " + fileName);
                        }
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setupLdapProtocolTracing", "Environment property com.ibm.websphere.naming.ldapprotocoltracefile is not set or is not a String");
                }
                if (outputStream == null) {
                    outputStream = System.out;
                }
                env.put(PROPERTY_KEY_LDAP_TRACE, System.out);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setupLdapProtocolTracing", "no LDAP trace requested");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setupLdapProtocolTracing", "Environment property com.ibm.websphere.naming.ldapprotocoltrace is not set or is not a String");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setupLdapProtocolTracing");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ldap/WsnLdapHelpers.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.14");
        }
        CLASS_NAME = WsnLdapHelpers.class.getName();
    }
}

